/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.InternalInstantiator;
import org.apache.geode.internal.cache.EnumListenerEvent;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.CacheServerHelper;
import org.apache.geode.internal.cache.tier.sockets.ClientInstantiatorMessage;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.security.SecurityService;

public class RegisterInstantiators
extends BaseCommand {
    @Immutable
    private static final RegisterInstantiators singleton = new RegisterInstantiators();

    public static Command getCommand() {
        return singleton;
    }

    private RegisterInstantiators() {
    }

    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, SecurityService securityService, long start) throws IOException, ClassNotFoundException {
        int noOfParts;
        serverConnection.setAsTrue(2);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received register instantiator request ({} parts) from {}", (Object)serverConnection.getName(), (Object)clientMessage.getNumberOfParts(), (Object)serverConnection.getSocketString());
        }
        Assert.assertTrue(((noOfParts = clientMessage.getNumberOfParts()) - 1) % 3 == 0);
        int noOfInstantiators = (noOfParts - 1) / 3;
        ByteBuffer eventIdPartsBuffer = ByteBuffer.wrap(clientMessage.getPart(noOfParts - 1).getSerializedForm());
        long threadId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
        long sequenceId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
        EventID eventId = new EventID(serverConnection.getEventMemberIDByteArray(), threadId, sequenceId);
        byte[][] serializedInstantiators = new byte[noOfInstantiators * 3][];
        boolean caughtCNFE = false;
        ClassNotFoundException cnfe = null;
        try {
            for (int i = 0; i < noOfParts - 1; i += 3) {
                Part instantiatorPart = clientMessage.getPart(i);
                serializedInstantiators[i] = instantiatorPart.getSerializedForm();
                String instantiatorClassName = (String)CacheServerHelper.deserialize(serializedInstantiators[i]);
                Part instantiatedPart = clientMessage.getPart(i + 1);
                serializedInstantiators[i + 1] = instantiatedPart.getSerializedForm();
                String instantiatedClassName = (String)CacheServerHelper.deserialize(serializedInstantiators[i + 1]);
                Part idPart = clientMessage.getPart(i + 2);
                serializedInstantiators[i + 2] = idPart.getSerializedForm();
                int id = idPart.getInt();
                Class<?> instantiatorClass = null;
                Class<?> instantiatedClass = null;
                try {
                    instantiatorClass = InternalDataSerializer.getCachedClass(instantiatorClassName);
                    instantiatedClass = InternalDataSerializer.getCachedClass(instantiatedClassName);
                    InternalInstantiator.register(instantiatorClass, instantiatedClass, id, true, eventId, serverConnection.getProxyID());
                    continue;
                }
                catch (ClassNotFoundException e) {
                    caughtCNFE = true;
                    cnfe = e;
                }
            }
        }
        catch (Exception e) {
            logger.warn("Client {} failed to register instantiators: {}", new Object[]{serverConnection.getMembershipID(), e.getLocalizedMessage()});
            RegisterInstantiators.writeException(clientMessage, e, false, serverConnection);
            serverConnection.setAsTrue(1);
        }
        if (caughtCNFE) {
            RegisterInstantiators.writeException(clientMessage, cnfe, false, serverConnection);
            serverConnection.setAsTrue(1);
            ClientInstantiatorMessage clientInstantiatorMessage = new ClientInstantiatorMessage(EnumListenerEvent.AFTER_REGISTER_INSTANTIATOR, serializedInstantiators, serverConnection.getProxyID(), eventId);
            CacheClientNotifier.routeClientMessage(clientInstantiatorMessage);
        }
        if (!serverConnection.getTransientFlag(1)) {
            this.writeReply(clientMessage, serverConnection);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Registered instantiators for MembershipId = {}", (Object)serverConnection.getMembershipID());
        }
    }
}

