/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.cache.BucketServerLocation66;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.security.SecurityService;

public class GetClientPRMetadataCommand66
extends BaseCommand {
    @Immutable
    private static final GetClientPRMetadataCommand66 singleton = new GetClientPRMetadataCommand66();

    public static Command getCommand() {
        return singleton;
    }

    private GetClientPRMetadataCommand66() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, SecurityService securityService, long start) throws IOException, ClassNotFoundException, InterruptedException {
        String regionFullPath = null;
        CachedRegionHelper crHelper = serverConnection.getCachedRegionHelper();
        regionFullPath = clientMessage.getPart(0).getString();
        String errMessage = "";
        if (regionFullPath == null) {
            logger.warn("The input region path for the GetClientPRMetadata request is null");
            errMessage = "The input region path for the GetClientPRMetadata request is null";
            GetClientPRMetadataCommand66.writeErrorResponse(clientMessage, 75, errMessage.toString(), serverConnection);
            serverConnection.setAsTrue(1);
        } else {
            Region region = crHelper.getRegion(regionFullPath);
            if (region == null) {
                logger.warn("Region was not found during GetClientPRMetadata request for region path : {}", (Object)regionFullPath);
                errMessage = "Region was not found during GetClientPRMetadata request for region path : " + regionFullPath;
                GetClientPRMetadataCommand66.writeErrorResponse(clientMessage, 75, errMessage.toString(), serverConnection);
                serverConnection.setAsTrue(1);
            } else {
                try {
                    Message responseMsg = serverConnection.getResponseMessage();
                    responseMsg.setTransactionId(clientMessage.getTransactionId());
                    responseMsg.setMessageType(72);
                    PartitionedRegion prRgion = (PartitionedRegion)region;
                    Map<Integer, List<BucketServerLocation66>> bucketToServerLocations = prRgion.getRegionAdvisor().getAllClientBucketProfiles();
                    responseMsg.setNumberOfParts(bucketToServerLocations.size());
                    for (List<BucketServerLocation66> serverLocations : bucketToServerLocations.values()) {
                        responseMsg.addObjPart(serverLocations);
                    }
                    responseMsg.send();
                    clientMessage.clearParts();
                }
                catch (Exception e) {
                    GetClientPRMetadataCommand66.writeException(clientMessage, e, false, serverConnection);
                }
                finally {
                    serverConnection.setAsTrue(1);
                }
            }
        }
    }
}

