/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.geode.CancelException;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.wan.GatewayReceiver;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.EventIDHolder;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.MessageType;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.cache.wan.BatchException70;
import org.apache.geode.internal.cache.wan.GatewayReceiverStats;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.internal.util.BlobHelper;
import org.apache.geode.pdx.PdxConfigurationException;
import org.apache.geode.pdx.PdxRegistryMismatchException;
import org.apache.geode.pdx.internal.EnumId;
import org.apache.geode.pdx.internal.EnumInfo;
import org.apache.geode.pdx.internal.PdxType;

public class GatewayReceiverCommand
extends BaseCommand {
    @Immutable
    private static final GatewayReceiverCommand singleton = new GatewayReceiverCommand();

    public static Command getCommand() {
        return singleton;
    }

    private GatewayReceiverCommand() {
    }

    private void handleRegionNull(ServerConnection servConn, String regionName, int batchId) {
        InternalCache cache = servConn.getCachedRegionHelper().getCacheForGatewayCommand();
        if (cache != null && cache.isCacheAtShutdownAll()) {
            throw cache.getCacheClosedException("Shutdown occurred during message processing");
        }
        String reason = String.format("Region %s was not found during batch create request %s", regionName, batchId);
        throw new RegionDestroyedException(reason, regionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, SecurityService securityService, long start) throws IOException, InterruptedException {
        regionNamePart = null;
        keyPart = null;
        valuePart = null;
        callbackArgPart = null;
        regionName = null;
        callbackArg = null;
        key = null;
        partNumber = 0;
        crHelper = serverConnection.getCachedRegionHelper();
        stats = (GatewayReceiverStats)serverConnection.getCacheServerStats();
        eventId = null;
        region = null;
        exceptions = new ArrayList<BatchException70>();
        fatalException = null;
        oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incReadProcessBatchRequestTime(start - oldStart);
        stats.incBatchSize(clientMessage.getPayloadLength());
        numberOfEventsPart = clientMessage.getPart(0);
        numberOfEvents = numberOfEventsPart.getInt();
        stats.incEventsReceived(numberOfEvents);
        batchIdPart = clientMessage.getPart(1);
        batchId = batchIdPart.getInt();
        if (batchId <= serverConnection.getLatestBatchIdReplied()) {
            if (!GatewayReceiver.APPLY_RETRIES) {
                GatewayReceiverCommand.logger.warn("Received process batch request {} that has already been or is being processed. This process batch request is being ignored.", (Object)batchId);
                this.writeReply(clientMessage, serverConnection, batchId, numberOfEvents);
                return;
            }
            GatewayReceiverCommand.logger.warn("Received process batch request {} that has already been or is being processed. gemfire.gateway.ApplyRetries is set, so this batch will be processed anyway.", (Object)batchId);
            stats.incDuplicateBatchesReceived();
        }
        if (batchId != serverConnection.getLatestBatchIdReplied() + 1) {
            GatewayReceiverCommand.logger.warn("Received process batch request {} out of order. The id of the last batch processed was {}. This batch request will be processed, but some messages may have been lost.", new Object[]{batchId, serverConnection.getLatestBatchIdReplied()});
            stats.incOutoforderBatchesReceived();
        }
        if (GatewayReceiverCommand.logger.isDebugEnabled()) {
            GatewayReceiverCommand.logger.debug("Received process batch request {} that will be processed.", (Object)batchId);
        }
        if (GatewayReceiverCommand.logger.isDebugEnabled()) {
            GatewayReceiverCommand.logger.debug("{}: Received process batch request {} containing {} events ({} bytes) with {} acknowledgement on {}", (Object)serverConnection.getName(), (Object)batchId, (Object)numberOfEvents, (Object)clientMessage.getPayloadLength(), (Object)"normal", (Object)serverConnection.getSocketString());
        }
        partNumber = 2;
        dsid = clientMessage.getPart(partNumber++).getInt();
        removeOnException = clientMessage.getPart(partNumber++).getSerializedForm()[0] == 1;
        indexWithoutPDXEvent = -1;
        block38: for (i = 0; i < numberOfEvents; ++i) {
            retry = true;
            isPdxEvent = false;
            ++indexWithoutPDXEvent;
            actionTypePart = clientMessage.getPart(partNumber);
            actionType = actionTypePart.getInt();
            versionTimeStamp = -9223372036854775808L;
            clientEvent = null;
            callbackArgExists = false;
            try {
                block39: do {
                    if (isPdxEvent) {
                        ++indexWithoutPDXEvent;
                    }
                    isPdxEvent = false;
                    possibleDuplicatePart = clientMessage.getPart(partNumber + 1);
                    try {
                        possibleDuplicatePartBytes = (byte[])possibleDuplicatePart.getObject();
                    }
                    catch (Exception e) {
                        GatewayReceiverCommand.logger.warn(String.format("%s: Caught exception processing batch request %s containing %s events", new Object[]{serverConnection.getName(), batchId, numberOfEvents}), (Throwable)e);
                        this.handleException(removeOnException, stats, e);
                        continue block38;
                    }
                    possibleDuplicate = possibleDuplicatePartBytes[0] == 1;
                    regionName = null;
                    key = null;
                    callbackArg = null;
                    regionNamePart = clientMessage.getPart(partNumber + 2);
                    regionName = regionNamePart.getString();
                    if (regionName.equals("/PdxTypes")) {
                        --indexWithoutPDXEvent;
                        isPdxEvent = true;
                    }
                    eventIdPart = clientMessage.getPart(partNumber + 3);
                    eventIdPart.setVersion(serverConnection.getClientVersion());
                    try {
                        eventId = (EventID)eventIdPart.getObject();
                    }
                    catch (Exception e) {
                        GatewayReceiverCommand.logger.warn(String.format("%s: Caught exception processing batch request %s containing %s events", new Object[]{serverConnection.getName(), batchId, numberOfEvents}), (Throwable)e);
                        this.handleException(removeOnException, stats, e);
                        continue block38;
                    }
                    keyPart = clientMessage.getPart(partNumber + 4);
                    try {
                        key = keyPart.getStringOrObject();
                    }
                    catch (Exception e) {
                        GatewayReceiverCommand.logger.warn(String.format("%s: Caught exception processing batch request %s containing %s events", new Object[]{serverConnection.getName(), batchId, numberOfEvents}), (Throwable)e);
                        this.handleException(removeOnException, stats, e);
                        continue block38;
                    }
                    index = -1;
                    switch (actionType) {
                        case 0: {
                            try {
                                valuePart = clientMessage.getPart(partNumber + 5);
                                index = partNumber + 6;
                                callbackArgExistsPart = clientMessage.getPart(index++);
                                partBytes = (byte[])callbackArgExistsPart.getObject();
                                v0 = callbackArgExists = partBytes[0] == 1;
                                if (callbackArgExists) {
                                    callbackArgPart = clientMessage.getPart(index++);
                                    try {
                                        callbackArg = callbackArgPart.getObject();
                                    }
                                    catch (Exception e) {
                                        GatewayReceiverCommand.logger.warn(String.format("%s: Caught exception processing batch create request %s for %s events", new Object[]{serverConnection.getName(), batchId, numberOfEvents}), (Throwable)e);
                                        throw e;
                                    }
                                }
                                if (GatewayReceiverCommand.logger.isDebugEnabled()) {
                                    GatewayReceiverCommand.logger.debug("{}: Processing batch create request {} on {} for region {} key {} value {} callbackArg {}, eventId={}", (Object)serverConnection.getName(), (Object)batchId, (Object)serverConnection.getSocketString(), (Object)regionName, key, (Object)valuePart, callbackArg, (Object)eventId);
                                }
                                versionTimeStamp = clientMessage.getPart(index++).getLong();
                                if (key == null || regionName == null) {
                                    message = null;
                                    messageArgs = new Object[]{serverConnection.getName(), batchId};
                                    if (key == null) {
                                        message = "%s: The input region name for the batch create request %s is null";
                                    }
                                    if (regionName == null) {
                                        message = "%s: The input region name for the batch create request %s is null";
                                    }
                                    s = String.format(message, messageArgs);
                                    GatewayReceiverCommand.logger.warn(s);
                                    throw new Exception(s);
                                }
                                region = (LocalRegion)crHelper.getCacheForGatewayCommand().getRegion(regionName);
                                if (region == null) {
                                    this.handleRegionNull(serverConnection, regionName, batchId);
                                    ** break;
                                }
                                clientEvent = new EventIDHolder(eventId);
                                if (versionTimeStamp > 0L) {
                                    tag = VersionTag.create(region.getVersionMember());
                                    tag.setIsGatewayTag(true);
                                    tag.setVersionTimeStamp(versionTimeStamp);
                                    tag.setDistributedSystemId(dsid);
                                    clientEvent.setVersionTag(tag);
                                }
                                clientEvent.setPossibleDuplicate(possibleDuplicate);
                                this.handleMessageRetry(region, clientEvent);
                                value = valuePart.getSerializedForm();
                                isObject = valuePart.isObject();
                                authzRequest = serverConnection.getAuthzRequest();
                                if (authzRequest != null) {
                                    putContext = authzRequest.putAuthorize(regionName, key, value, isObject, callbackArg);
                                    value = putContext.getSerializedValue();
                                    isObject = putContext.isObject();
                                }
                                result = false;
                                if (isPdxEvent) {
                                    result = this.addPdxType(crHelper, key, value);
                                } else {
                                    result = region.basicBridgeCreate(key, value, isObject, callbackArg, serverConnection.getProxyID(), false, clientEvent, false);
                                    if (!result) {
                                        result = region.basicBridgePut(key, value, null, isObject, callbackArg, serverConnection.getProxyID(), false, clientEvent);
                                    }
                                }
                                if (result || clientEvent.isConcurrencyConflict()) {
                                    serverConnection.setModificationInfo(true, regionName, key);
                                    stats.incCreateRequest();
                                    retry = false;
                                    ** break;
                                }
                                throw new Exception(String.format("%s: Failed to create or update entry for region %s key %s value %s callbackArg %s", new Object[]{serverConnection.getName(), regionName, key, valuePart, callbackArg}));
lbl153:
                                // 2 sources

                            }
                            catch (Exception e) {
                                GatewayReceiverCommand.logger.warn(String.format("%s: Caught exception processing batch create request %s for %s events", new Object[]{serverConnection.getName(), batchId, numberOfEvents}), (Throwable)e);
                                this.handleException(removeOnException, stats, e);
                            }
                            continue block39;
                        }
                        case 1: {
                            try {
                                valuePart = clientMessage.getPart(partNumber + 5);
                                index = partNumber + 6;
                                callbackArgExistsPart = clientMessage.getPart(index++);
                                partBytes = (byte[])callbackArgExistsPart.getObject();
                                v1 = callbackArgExists = partBytes[0] == 1;
                                if (callbackArgExists) {
                                    callbackArgPart = clientMessage.getPart(index++);
                                    try {
                                        callbackArg = callbackArgPart.getObject();
                                    }
                                    catch (Exception e) {
                                        GatewayReceiverCommand.logger.warn(String.format("%s: Caught exception processing batch update request %s containing %s events", new Object[]{serverConnection.getName(), batchId, numberOfEvents}), (Throwable)e);
                                        throw e;
                                    }
                                }
                                versionTimeStamp = clientMessage.getPart(index++).getLong();
                                if (GatewayReceiverCommand.logger.isDebugEnabled()) {
                                    GatewayReceiverCommand.logger.debug("{}: Processing batch update request {} on {} for region {} key {} value {} callbackArg {}", (Object)serverConnection.getName(), (Object)batchId, (Object)serverConnection.getSocketString(), (Object)regionName, key, (Object)valuePart, callbackArg);
                                }
                                if (key == null || regionName == null) {
                                    message = null;
                                    messageArgs = new Object[]{serverConnection.getName(), batchId};
                                    if (key == null) {
                                        message = "%s: The input key for the batch update request %s is null";
                                    }
                                    if (regionName == null) {
                                        message = "%s: The input region name for the batch update request %s is null";
                                    }
                                    s = String.format(message, messageArgs);
                                    GatewayReceiverCommand.logger.warn(s);
                                    throw new Exception(s);
                                }
                                region = (LocalRegion)crHelper.getCacheForGatewayCommand().getRegion(regionName);
                                if (region == null) {
                                    this.handleRegionNull(serverConnection, regionName, batchId);
                                    ** break;
                                }
                                clientEvent = new EventIDHolder(eventId);
                                if (versionTimeStamp > 0L) {
                                    tag = VersionTag.create(region.getVersionMember());
                                    tag.setIsGatewayTag(true);
                                    tag.setVersionTimeStamp(versionTimeStamp);
                                    tag.setDistributedSystemId(dsid);
                                    clientEvent.setVersionTag(tag);
                                }
                                clientEvent.setPossibleDuplicate(possibleDuplicate);
                                this.handleMessageRetry(region, clientEvent);
                                value = valuePart.getSerializedForm();
                                isObject = valuePart.isObject();
                                authzRequest = serverConnection.getAuthzRequest();
                                if (authzRequest != null) {
                                    putContext = authzRequest.putAuthorize(regionName, key, value, isObject, callbackArg, (byte)2);
                                    value = putContext.getSerializedValue();
                                    isObject = putContext.isObject();
                                }
                                result = false;
                                result = isPdxEvent != false ? this.addPdxType(crHelper, key, value) : region.basicBridgePut(key, value, null, isObject, callbackArg, serverConnection.getProxyID(), false, clientEvent);
                                if (result || clientEvent.isConcurrencyConflict()) {
                                    serverConnection.setModificationInfo(true, regionName, key);
                                    stats.incUpdateRequest();
                                    retry = false;
                                    ** break;
                                }
                                msgArgs = new Object[]{serverConnection.getName(), regionName, key, valuePart, callbackArg};
                                message = "%s: Failed to update entry for region %s, key %s, value %s, and callbackArg %s";
                                s = String.format("%s: Failed to update entry for region %s, key %s, value %s, and callbackArg %s", msgArgs);
                                GatewayReceiverCommand.logger.info(s);
                                throw new Exception(s);
lbl218:
                                // 2 sources

                            }
                            catch (Exception e) {
                                GatewayReceiverCommand.logger.warn(String.format("%s: Caught exception processing batch update request %s containing %s events", new Object[]{serverConnection.getName(), batchId, numberOfEvents}), (Throwable)e);
                                this.handleException(removeOnException, stats, e);
                            }
                            continue block39;
                        }
                        case 2: {
                            try {
                                index = partNumber + 5;
                                callbackArgExistsPart = clientMessage.getPart(index++);
                                partBytes = (byte[])callbackArgExistsPart.getObject();
                                v2 = callbackArgExists = partBytes[0] == 1;
                                if (callbackArgExists) {
                                    callbackArgPart = clientMessage.getPart(index++);
                                    try {
                                        callbackArg = callbackArgPart.getObject();
                                    }
                                    catch (Exception e) {
                                        GatewayReceiverCommand.logger.warn(String.format("%s: Caught exception processing batch destroy request %s containing %s events", new Object[]{serverConnection.getName(), batchId, numberOfEvents}), (Throwable)e);
                                        throw e;
                                    }
                                }
                                versionTimeStamp = clientMessage.getPart(index++).getLong();
                                if (GatewayReceiverCommand.logger.isDebugEnabled()) {
                                    GatewayReceiverCommand.logger.debug("{}: Processing batch destroy request {} on {} for region {} key {}", (Object)serverConnection.getName(), (Object)batchId, (Object)serverConnection.getSocketString(), (Object)regionName, key);
                                }
                                if (key == null || regionName == null) {
                                    message = null;
                                    if (key == null) {
                                        message = "%s: The input key for the batch destroy request %s is null";
                                    }
                                    if (regionName == null) {
                                        message = "%s: The input region name for the batch destroy request %s is null";
                                    }
                                    messageArgs = new Object[]{serverConnection.getName(), batchId};
                                    s = String.format(message, messageArgs);
                                    GatewayReceiverCommand.logger.warn(s);
                                    throw new Exception(s);
                                }
                                region = (LocalRegion)crHelper.getCacheForGatewayCommand().getRegion(regionName);
                                if (region == null) {
                                    this.handleRegionNull(serverConnection, regionName, batchId);
                                    break;
                                }
                                clientEvent = new EventIDHolder(eventId);
                                if (versionTimeStamp > 0L) {
                                    tag = VersionTag.create(region.getVersionMember());
                                    tag.setIsGatewayTag(true);
                                    tag.setVersionTimeStamp(versionTimeStamp);
                                    tag.setDistributedSystemId(dsid);
                                    clientEvent.setVersionTag(tag);
                                }
                                this.handleMessageRetry(region, clientEvent);
                                authzRequest = serverConnection.getAuthzRequest();
                                if (authzRequest != null) {
                                    destroyContext = authzRequest.destroyAuthorize(regionName, key, callbackArg);
                                    callbackArg = destroyContext.getCallbackArg();
                                }
                                try {
                                    region.basicBridgeDestroy(key, callbackArg, serverConnection.getProxyID(), false, clientEvent);
                                    serverConnection.setModificationInfo(true, regionName, key);
                                }
                                catch (EntryNotFoundException e) {
                                    GatewayReceiverCommand.logger.info("{}: during batch destroy no entry was found for key {}", new Object[]{serverConnection.getName(), key});
                                }
                                stats.incDestroyRequest();
                                retry = false;
                            }
                            catch (Exception e) {
                                GatewayReceiverCommand.logger.warn(String.format("%s: Caught exception processing batch destroy request %s containing %s events", new Object[]{serverConnection.getName(), batchId, numberOfEvents}), (Throwable)e);
                                this.handleException(removeOnException, stats, e);
                            }
                            continue block39;
                        }
                        case 3: {
                            try {
                                regionNamePart = clientMessage.getPart(partNumber + 2);
                                regionName = regionNamePart.getString();
                                eventIdPart = clientMessage.getPart(partNumber + 3);
                                eventId = (EventID)eventIdPart.getObject();
                                keyPart = clientMessage.getPart(partNumber + 4);
                                key = keyPart.getStringOrObject();
                                index = partNumber + 5;
                                callbackArgExistsPart = clientMessage.getPart(index++);
                                partBytes = (byte[])callbackArgExistsPart.getObject();
                                v3 = callbackArgExists = partBytes[0] == 1;
                                if (callbackArgExists) {
                                    callbackArgPart = clientMessage.getPart(index++);
                                    callbackArg = callbackArgPart.getObject();
                                }
                                versionTimeStamp = clientMessage.getPart(index++).getLong();
                                if (GatewayReceiverCommand.logger.isDebugEnabled()) {
                                    GatewayReceiverCommand.logger.debug("{}: Processing batch update-version request {} on {} for region {} key {} value {} callbackArg {}", (Object)serverConnection.getName(), (Object)batchId, (Object)serverConnection.getSocketString(), (Object)regionName, key, (Object)valuePart, callbackArg);
                                }
                                if (key == null || regionName == null) {
                                    message = "%s: Caught exception processing batch update version request request %s containing %s events";
                                    messageArgs = new Object[]{serverConnection.getName(), batchId, numberOfEvents};
                                    s = String.format(message, messageArgs);
                                    GatewayReceiverCommand.logger.warn(s);
                                    throw new Exception(s);
                                }
                                region = (LocalRegion)crHelper.getCacheForGatewayCommand().getRegion(regionName);
                                if (region == null) {
                                    this.handleRegionNull(serverConnection, regionName, batchId);
                                    break;
                                }
                                clientEvent = new EventIDHolder(eventId);
                                if (versionTimeStamp > 0L) {
                                    tag = VersionTag.create(region.getVersionMember());
                                    tag.setIsGatewayTag(true);
                                    tag.setVersionTimeStamp(versionTimeStamp);
                                    tag.setDistributedSystemId(dsid);
                                    clientEvent.setVersionTag(tag);
                                }
                                try {
                                    region.basicBridgeUpdateVersionStamp(key, callbackArg, serverConnection.getProxyID(), false, clientEvent);
                                }
                                catch (EntryNotFoundException e) {
                                    GatewayReceiverCommand.logger.info("Entry for key {} was not found in Region {} during ProcessBatch for Update Entry Version", new Object[]{serverConnection.getName(), key});
                                }
                                retry = false;
                            }
                            catch (Exception e) {
                                GatewayReceiverCommand.logger.warn(String.format("%s: Caught exception processing batch update version request request %s containing %s events", new Object[]{serverConnection.getName(), batchId, numberOfEvents}), (Throwable)e);
                                this.handleException(removeOnException, stats, e);
                            }
                            continue block39;
                        }
                        default: {
                            GatewayReceiverCommand.logger.fatal("{}: Unknown action type ({}) for batch from {}", new Object[]{serverConnection.getName(), actionType, serverConnection.getSocketString()});
                            stats.incUnknowsOperationsReceived();
                        }
                    }
                } while (retry);
                continue;
            }
            catch (CancelException e) {
                if (GatewayReceiverCommand.logger.isDebugEnabled()) {
                    GatewayReceiverCommand.logger.debug("{} ignoring message of type {} from client {} because shutdown occurred during message processing.", (Object)serverConnection.getName(), (Object)MessageType.getString(clientMessage.getMessageType()), (Object)serverConnection.getProxyID());
                }
                serverConnection.setFlagProcessMessagesAsFalse();
                serverConnection.setClientDisconnectedException(e);
                return;
            }
            catch (Exception e) {
                GatewayReceiverCommand.checkForInterrupt(serverConnection, e);
                if (e.getCause() instanceof PdxRegistryMismatchException) {
                    fatalException = e.getCause();
                    GatewayReceiverCommand.logger.fatal(String.format("This gateway receiver has received a PDX type from %s that does match the existing PDX type. This gateway receiver will not process any more events, in order to prevent receiving objects which may not be deserializable.", new Object[]{serverConnection.getMembershipID()}), e.getCause());
                    break;
                }
                ds = crHelper.getCacheForGatewayCommand().getDistributedSystem();
                exceptionMessage = String.format("Exception occurred while processing a batch on the receiver running on DistributedSystem with Id: %s, DistributedMember on which the receiver is running: %s", new Object[]{((InternalDistributedSystem)ds).getDistributionManager().getDistributedSystemId(), ds.getDistributedMember()});
                be = new BatchException70(exceptionMessage, (Throwable)e, indexWithoutPDXEvent, batchId);
                exceptions.add(be);
                continue;
            }
            finally {
                if (actionType == 0 || actionType == 1) {
                    partNumber = callbackArgExists ? (partNumber += 9) : (partNumber += 8);
                } else if (actionType == 2) {
                    partNumber = callbackArgExists ? (partNumber += 8) : (partNumber += 7);
                } else if (actionType == 3) {
                    partNumber = callbackArgExists ? (partNumber += 8) : (partNumber += 7);
                }
            }
        }
        oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incProcessBatchTime(start - oldStart);
        if (fatalException != null) {
            serverConnection.incrementLatestBatchIdReplied(batchId);
            GatewayReceiverCommand.writeFatalException(clientMessage, fatalException, serverConnection, batchId);
            serverConnection.setAsTrue(1);
        } else if (!exceptions.isEmpty()) {
            serverConnection.incrementLatestBatchIdReplied(batchId);
            GatewayReceiverCommand.writeBatchException(clientMessage, exceptions, serverConnection, batchId);
            serverConnection.setAsTrue(1);
        } else {
            serverConnection.incrementLatestBatchIdReplied(batchId);
            this.writeReply(clientMessage, serverConnection, batchId, numberOfEvents);
            serverConnection.setAsTrue(1);
            stats.incWriteProcessBatchResponseTime(DistributionStats.getStatTime() - start);
            if (GatewayReceiverCommand.logger.isDebugEnabled()) {
                GatewayReceiverCommand.logger.debug("{}: Sent process batch normal response for batch {} containing {} events ({} bytes) with {} acknowledgement on {}", (Object)serverConnection.getName(), (Object)batchId, (Object)numberOfEvents, (Object)clientMessage.getPayloadLength(), (Object)"normal", (Object)serverConnection.getSocketString());
            }
        }
    }

    private boolean addPdxType(CachedRegionHelper crHelper, Object key, Object value) throws Exception {
        if (key instanceof EnumId) {
            EnumId enumId = (EnumId)key;
            value = BlobHelper.deserializeBlob((byte[])value);
            crHelper.getCacheForGatewayCommand().getPdxRegistry().addRemoteEnum(enumId.intValue(), (EnumInfo)value);
        } else {
            value = BlobHelper.deserializeBlob((byte[])value);
            crHelper.getCacheForGatewayCommand().getPdxRegistry().addRemoteType((Integer)key, (PdxType)value);
        }
        return true;
    }

    private void handleException(boolean removeOnException, GatewayReceiverStats stats, Exception e) throws Exception {
        if (this.shouldThrowException(removeOnException, e)) {
            throw e;
        }
        stats.incEventsRetried();
        Thread.sleep(500L);
    }

    private boolean shouldThrowException(boolean removeOnException, Exception e) {
        return removeOnException;
    }

    private void handleMessageRetry(LocalRegion region, EntryEventImpl clientEvent) {
        if (clientEvent.isPossibleDuplicate() && region.getAttributes().getConcurrencyChecksEnabled()) {
            clientEvent.setRegion(region);
            if (!this.recoverVersionTagForRetriedOperation(clientEvent)) {
                clientEvent.setPossibleDuplicate(false);
            }
        }
    }

    private void writeReply(Message msg, ServerConnection servConn, int batchId, int numberOfEvents) throws IOException {
        Message replyMsg = servConn.getResponseMessage();
        replyMsg.setMessageType(6);
        replyMsg.setTransactionId(msg.getTransactionId());
        replyMsg.setNumberOfParts(2);
        replyMsg.addIntPart(batchId);
        replyMsg.addIntPart(numberOfEvents);
        replyMsg.setTransactionId(msg.getTransactionId());
        replyMsg.send(servConn);
        servConn.setAsTrue(1);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: rpl tx: {} batchId {} numberOfEvents: {}", (Object)servConn.getName(), (Object)msg.getTransactionId(), (Object)batchId, (Object)numberOfEvents);
        }
    }

    private static void writeBatchException(Message origMsg, List<BatchException70> exceptions, ServerConnection servConn, int batchId) throws IOException {
        Message errorMsg = servConn.getErrorResponseMessage();
        errorMsg.setMessageType(2);
        errorMsg.setNumberOfParts(2);
        errorMsg.setTransactionId(origMsg.getTransactionId());
        errorMsg.addObjPart(exceptions);
        errorMsg.send(servConn);
        for (Exception exception : exceptions) {
            ((GatewayReceiverStats)servConn.getCacheServerStats()).incExceptionsOccurred();
        }
        for (Exception exception : exceptions) {
            if (!logger.isWarnEnabled()) continue;
            logger.warn(servConn.getName() + ": Wrote batch exception: ", (Throwable)exception);
        }
    }

    private static void writeFatalException(Message origMsg, Throwable exception, ServerConnection servConn, int batchId) throws IOException {
        Message errorMsg = servConn.getErrorResponseMessage();
        errorMsg.setMessageType(2);
        errorMsg.setNumberOfParts(2);
        errorMsg.setTransactionId(origMsg.getTransactionId());
        if ((servConn.getClientVersion() == null || servConn.getClientVersion().compareTo(Version.GFE_80) < 0) && exception instanceof PdxRegistryMismatchException) {
            PdxConfigurationException newException = new PdxConfigurationException(exception.getMessage());
            newException.setStackTrace(exception.getStackTrace());
            exception = newException;
        }
        errorMsg.addObjPart(exception);
        errorMsg.send(servConn);
        logger.warn(servConn.getName() + ": Wrote batch exception: ", exception);
    }
}

