/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.ResultSender;
import org.apache.geode.cache.operations.ExecuteFunctionOperationContext;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.execute.FunctionContextImpl;
import org.apache.geode.internal.cache.execute.FunctionStats;
import org.apache.geode.internal.cache.execute.InternalFunctionExecutionService;
import org.apache.geode.internal.cache.execute.InternalFunctionInvocationTargetException;
import org.apache.geode.internal.cache.execute.InternalFunctionService;
import org.apache.geode.internal.cache.execute.MemberMappedArgument;
import org.apache.geode.internal.cache.execute.ServerToClientFunctionResultSender;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.ServerSideHandshake;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.ChunkedMessage;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.internal.security.SecurityService;

public class ExecuteFunction
extends BaseCommand {
    @Immutable
    private static final ExecuteFunction singleton = new ExecuteFunction();
    private final InternalFunctionExecutionService internalFunctionExecutionService;
    private final ServerToClientFunctionResultSenderFactory serverToClientFunctionResultSenderFactory;
    private final FunctionContextImplFactory functionContextImplFactory;

    public static Command getCommand() {
        return singleton;
    }

    private ExecuteFunction() {
        this(InternalFunctionService.getInternalFunctionExecutionService(), new DefaultServerToClientFunctionResultSenderFactory(), new DefaultFunctionContextImplFactory());
    }

    @VisibleForTesting
    ExecuteFunction(InternalFunctionExecutionService internalFunctionExecutionService, ServerToClientFunctionResultSenderFactory serverToClientFunctionResultSenderFactory, FunctionContextImplFactory functionContextImplFactory) {
        this.internalFunctionExecutionService = internalFunctionExecutionService;
        this.serverToClientFunctionResultSenderFactory = serverToClientFunctionResultSenderFactory;
        this.functionContextImplFactory = functionContextImplFactory;
    }

    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, SecurityService securityService, long start) throws IOException {
        byte hasResult;
        MemberMappedArgument memberMappedArg;
        Object args;
        Object function;
        block21: {
            function = null;
            args = null;
            memberMappedArg = null;
            hasResult = 0;
            try {
                hasResult = clientMessage.getPart(0).getSerializedForm()[0];
                if (hasResult == 1) {
                    serverConnection.setAsTrue(2);
                    serverConnection.setAsTrue(3);
                }
                function = clientMessage.getPart(1).getStringOrObject();
                args = clientMessage.getPart(2).getObject();
                Part part = clientMessage.getPart(3);
                if (part != null) {
                    memberMappedArg = (MemberMappedArgument)part.getObject();
                }
            }
            catch (ClassNotFoundException e) {
                logger.warn("Exception on server while executing function: {}", function, (Object)e);
                if (hasResult != 1) break block21;
                ExecuteFunction.writeChunkedException(clientMessage, e, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
        }
        if (function == null) {
            String message = "The input function for the execute function request is null";
            logger.warn("{}: {}", (Object)serverConnection.getName(), (Object)message);
            this.sendError(hasResult, clientMessage, message, serverConnection);
            return;
        }
        try {
            Function functionObject;
            if (function instanceof String) {
                functionObject = this.internalFunctionExecutionService.getFunction((String)function);
                if (functionObject == null) {
                    String message = String.format("Function named %s is not registered to FunctionService", function);
                    logger.warn("{}: {}", (Object)serverConnection.getName(), (Object)message);
                    this.sendError(hasResult, clientMessage, message, serverConnection);
                    return;
                }
            } else {
                functionObject = (Function)function;
            }
            FunctionStats stats = FunctionStats.getFunctionStats(functionObject.getId());
            functionObject.getRequiredPermissions(null, args).forEach(securityService::authorize);
            AuthorizeRequest authzRequest = serverConnection.getAuthzRequest();
            ExecuteFunctionOperationContext executeContext = null;
            if (authzRequest != null) {
                executeContext = authzRequest.executeFunctionAuthorize(functionObject.getId(), null, null, args, functionObject.optimizeForWrite());
            }
            ChunkedMessage chunkedMessage = serverConnection.getFunctionResponseMessage();
            chunkedMessage.setTransactionId(clientMessage.getTransactionId());
            ServerToClientFunctionResultSender resultSender = this.serverToClientFunctionResultSenderFactory.create(chunkedMessage, 63, serverConnection, functionObject, executeContext);
            InternalCache cache = serverConnection.getCache();
            InternalDistributedMember localVM = (InternalDistributedMember)cache.getDistributedSystem().getDistributedMember();
            FunctionContextImpl context = memberMappedArg != null ? this.functionContextImplFactory.create(cache, functionObject.getId(), memberMappedArg.getArgumentsForMember(localVM.getId()), resultSender) : this.functionContextImplFactory.create(cache, functionObject.getId(), args, resultSender);
            ServerSideHandshake handshake = serverConnection.getHandshake();
            int earlierClientReadTimeout = handshake.getClientReadTimeout();
            handshake.setClientReadTimeout(0);
            try {
                long startExecution = stats.startTime();
                stats.startFunctionExecution(functionObject.hasResult());
                if (logger.isDebugEnabled()) {
                    logger.debug("Executing Function on Server: {} with context: {}", (Object)serverConnection, (Object)context);
                }
                cache.getInternalResourceManager().getHeapMonitor().checkForLowMemory(functionObject, cache.getMyId());
                functionObject.execute(context);
                stats.endFunctionExecution(startExecution, functionObject.hasResult());
            }
            catch (FunctionException e) {
                stats.endFunctionExecutionWithException(functionObject.hasResult());
                throw e;
            }
            catch (Exception e) {
                stats.endFunctionExecutionWithException(functionObject.hasResult());
                throw new FunctionException(e);
            }
            finally {
                handshake.setClientReadTimeout(earlierClientReadTimeout);
            }
        }
        catch (IOException e) {
            logger.warn("Exception on server while executing function: {}", function, (Object)e);
            String message = "Server could not send the reply";
            this.sendException(hasResult, clientMessage, message, serverConnection, e);
        }
        catch (InternalFunctionInvocationTargetException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Exception on server while executing function: {}", function, (Object)e);
            }
            this.sendException(hasResult, clientMessage, e.getMessage(), serverConnection, e);
        }
        catch (Exception e) {
            logger.warn("Exception on server while executing function: {}", function, (Object)e);
            this.sendException(hasResult, clientMessage, e.getMessage(), serverConnection, e);
        }
    }

    private void sendException(byte hasResult, Message msg, String message, ServerConnection serverConnection, Throwable e) throws IOException {
        if (hasResult == 1) {
            ExecuteFunction.writeFunctionResponseException(msg, 2, serverConnection, e);
            serverConnection.setAsTrue(1);
        }
    }

    private void sendError(byte hasResult, Message msg, String message, ServerConnection serverConnection) throws IOException {
        if (hasResult == 1) {
            ExecuteFunction.writeFunctionResponseError(msg, 64, message, serverConnection);
            serverConnection.setAsTrue(1);
        }
    }

    private static class DefaultFunctionContextImplFactory
    implements FunctionContextImplFactory {
        private DefaultFunctionContextImplFactory() {
        }

        @Override
        public FunctionContextImpl create(Cache cache, String functionId, Object args, ResultSender resultSender) {
            return new FunctionContextImpl(cache, functionId, args, resultSender);
        }
    }

    private static class DefaultServerToClientFunctionResultSenderFactory
    implements ServerToClientFunctionResultSenderFactory {
        private DefaultServerToClientFunctionResultSenderFactory() {
        }

        @Override
        public ServerToClientFunctionResultSender create(ChunkedMessage msg, int messageType2, ServerConnection sc, Function function, ExecuteFunctionOperationContext authzContext) {
            return new ServerToClientFunctionResultSender(msg, messageType2, sc, function, authzContext);
        }
    }

    static interface FunctionContextImplFactory {
        public FunctionContextImpl create(Cache var1, String var2, Object var3, ResultSender var4);
    }

    static interface ServerToClientFunctionResultSenderFactory {
        public ServerToClientFunctionResultSender create(ChunkedMessage var1, int var2, ServerConnection var3, Function var4, ExecuteFunctionOperationContext var5);
    }
}

