/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.DynamicRegionFactory;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.operations.DestroyOperationContext;
import org.apache.geode.cache.operations.RegionDestroyOperationContext;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.EventIDHolder;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.internal.util.Breadcrumbs;
import org.apache.geode.security.GemFireSecurityException;
import org.apache.geode.security.ResourcePermission;

public class Destroy65
extends BaseCommand {
    @Immutable
    private static final Destroy65 singleton = new Destroy65();

    public static Command getCommand() {
        return singleton;
    }

    @Override
    protected void writeReplyWithRefreshMetadata(Message origMsg, ServerConnection serverConnection, PartitionedRegion pr, byte nwHop) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected void writeReplyWithRefreshMetadata(Message origMsg, ServerConnection servConn, PartitionedRegion pr, boolean entryNotFoundForRemove, byte nwHop, VersionTag tag) throws IOException {
        Message replyMsg = servConn.getReplyMessage();
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        replyMsg.setMessageType(6);
        replyMsg.setNumberOfParts(2);
        replyMsg.setTransactionId(origMsg.getTransactionId());
        replyMsg.addBytesPart(new byte[]{pr.getMetadataVersion(), nwHop});
        pr.getPrStats().incPRMetaDataSentCount();
        replyMsg.addIntPart(entryNotFoundForRemove ? 1 : 0);
        replyMsg.send(servConn);
        if (logger.isTraceEnabled()) {
            logger.trace("{}: rpl with REFRESH_METADATA tx: {}", (Object)servConn.getName(), (Object)origMsg.getTransactionId());
        }
    }

    protected void writeReply(Message origMsg, ServerConnection servConn, boolean entryNotFound, VersionTag tag) throws IOException {
        Message replyMsg = servConn.getReplyMessage();
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        replyMsg.setMessageType(6);
        replyMsg.setNumberOfParts(2);
        replyMsg.setTransactionId(origMsg.getTransactionId());
        replyMsg.addBytesPart(Destroy65.okBytes());
        replyMsg.addIntPart(entryNotFound ? 1 : 0);
        replyMsg.send(servConn);
        if (logger.isTraceEnabled()) {
            logger.trace("{}: rpl tx: {} parts={}", (Object)servConn.getName(), (Object)origMsg.getTransactionId(), (Object)replyMsg.getNumberOfParts());
        }
    }

    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, SecurityService securityService, long start) throws IOException, InterruptedException {
        Object key;
        Operation operation;
        StringBuilder errMessage = new StringBuilder();
        CacheServerStats stats = serverConnection.getCacheServerStats();
        serverConnection.setAsTrue(2);
        long now = DistributionStats.getStatTime();
        stats.incReadDestroyRequestTime(now - start);
        Part regionNamePart = clientMessage.getPart(0);
        Part keyPart = clientMessage.getPart(1);
        Part expectedOldValuePart = clientMessage.getPart(2);
        try {
            Object operationObject;
            byte[] bytes;
            Part operationPart = clientMessage.getPart(3);
            operation = operationPart.isBytes() ? (null == (bytes = operationPart.getSerializedForm()) || 0 == bytes.length ? Operation.DESTROY : Operation.fromOrdinal(bytes[0])) : ((operationObject = operationPart.getObject()) == null ? Operation.DESTROY : (operationObject instanceof Byte && (Byte)operationObject == 8 ? Operation.REMOVE : (Operation)operationObject));
        }
        catch (Exception e) {
            Destroy65.writeException(clientMessage, e, false, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        Object expectedOldValue = null;
        if (operation == Operation.REMOVE) {
            try {
                expectedOldValue = expectedOldValuePart.getObject();
            }
            catch (Exception e) {
                Destroy65.writeException(clientMessage, e, false, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
        }
        Part eventPart = clientMessage.getPart(4);
        Object callbackArg = null;
        if (clientMessage.getNumberOfParts() > 5) {
            Part callbackArgPart = clientMessage.getPart(5);
            try {
                callbackArg = callbackArgPart.getObject();
            }
            catch (Exception e) {
                Destroy65.writeException(clientMessage, e, false, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
        }
        try {
            key = keyPart.getStringOrObject();
        }
        catch (Exception e) {
            Destroy65.writeException(clientMessage, e, false, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        String regionName = regionNamePart.getString();
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received destroy65 request ({} bytes; op={}) from {} for region {} key {}{} txId {}", (Object)serverConnection.getName(), (Object)clientMessage.getPayloadLength(), (Object)operation, (Object)serverConnection.getSocketString(), (Object)regionName, key, (Object)(operation == Operation.REMOVE ? " value=" + expectedOldValue : ""), (Object)clientMessage.getTransactionId());
        }
        boolean entryNotFoundForRemove = false;
        if (key == null || regionName == null) {
            if (key == null) {
                logger.warn("{}: The input key for the destroy request is null", (Object)serverConnection.getName());
                errMessage.append("The input key for the destroy request is null");
            }
            if (regionName == null) {
                logger.warn("{}: The input region name for the destroy request is null", (Object)serverConnection.getName());
                errMessage.append("The input region name for the destroy request is null");
            }
            Destroy65.writeErrorResponse(clientMessage, 10, errMessage.toString(), serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        LocalRegion region = (LocalRegion)serverConnection.getCache().getRegion(regionName);
        if (region == null) {
            String reason = String.format("%s was not found during destroy request", regionName);
            Destroy65.writeRegionDestroyedEx(clientMessage, regionName, reason, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        ByteBuffer eventIdPartsBuffer = ByteBuffer.wrap(eventPart.getSerializedForm());
        long threadId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
        long sequenceId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
        EventID eventId = new EventID(serverConnection.getEventMemberIDByteArray(), threadId, sequenceId);
        EventIDHolder clientEvent = new EventIDHolder(eventId);
        Breadcrumbs.setEventId(eventId);
        if (clientMessage.isRetry()) {
            clientEvent.setPossibleDuplicate(true);
            if (region.getAttributes().getConcurrencyChecksEnabled()) {
                clientEvent.setRegion(region);
                if (!this.recoverVersionTagForRetriedOperation(clientEvent)) {
                    clientEvent.setPossibleDuplicate(false);
                }
            }
        }
        try {
            securityService.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.WRITE, regionName, key.toString());
            AuthorizeRequest authzRequest = serverConnection.getAuthzRequest();
            if (authzRequest != null) {
                if (DynamicRegionFactory.regionIsDynamicRegionList(regionName)) {
                    RegionDestroyOperationContext destroyContext = authzRequest.destroyRegionAuthorize((String)key, callbackArg);
                    callbackArg = destroyContext.getCallbackArg();
                } else {
                    DestroyOperationContext destroyContext = authzRequest.destroyAuthorize(regionName, key, callbackArg);
                    callbackArg = destroyContext.getCallbackArg();
                }
            }
            if (operation == null || operation == Operation.DESTROY) {
                region.basicBridgeDestroy(key, callbackArg, serverConnection.getProxyID(), true, clientEvent);
            } else {
                try {
                    if (expectedOldValue == null) {
                        expectedOldValue = Token.INVALID;
                    }
                    if (operation == Operation.REMOVE && clientMessage.isRetry() && clientEvent.getVersionTag() != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("remove(k,v) operation was successful last time with version {}", (Object)clientEvent.getVersionTag());
                        }
                        try {
                            region.basicBridgeRemove(key, expectedOldValue, callbackArg, serverConnection.getProxyID(), true, clientEvent);
                        }
                        catch (EntryNotFoundException destroyContext) {}
                    } else {
                        region.basicBridgeRemove(key, expectedOldValue, callbackArg, serverConnection.getProxyID(), true, clientEvent);
                        if (logger.isDebugEnabled()) {
                            logger.debug("region.remove succeeded");
                        }
                    }
                }
                catch (EntryNotFoundException e) {
                    serverConnection.setModificationInfo(true, regionName, key);
                    if (logger.isDebugEnabled()) {
                        logger.debug("writing entryNotFound response");
                    }
                    entryNotFoundForRemove = true;
                }
            }
            serverConnection.setModificationInfo(true, regionName, key);
        }
        catch (EntryNotFoundException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("{}: during entry destroy no entry was found for key {}", (Object)serverConnection.getName(), key);
            }
            entryNotFoundForRemove = true;
        }
        catch (RegionDestroyedException rde) {
            Destroy65.writeException(clientMessage, rde, false, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        catch (Exception e) {
            Destroy65.checkForInterrupt(serverConnection, e);
            Destroy65.writeException(clientMessage, e, false, serverConnection);
            serverConnection.setAsTrue(1);
            if (e instanceof GemFireSecurityException) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Unexpected Security exception", (Object)serverConnection.getName(), (Object)e);
                }
            } else {
                logger.warn(String.format("%s: Unexpected Exception", serverConnection.getName()), (Throwable)e);
            }
            return;
        }
        now = DistributionStats.getStatTime();
        stats.incProcessDestroyTime(now - start);
        if (region instanceof PartitionedRegion) {
            PartitionedRegion pr = (PartitionedRegion)region;
            if (pr.getNetworkHopType() != 0) {
                this.writeReplyWithRefreshMetadata(clientMessage, serverConnection, pr, entryNotFoundForRemove, pr.getNetworkHopType(), clientEvent.getVersionTag());
                pr.clearNetworkHopData();
            } else {
                this.writeReply(clientMessage, serverConnection, entryNotFoundForRemove | clientEvent.getIsRedestroyedEntry(), clientEvent.getVersionTag());
            }
        } else {
            this.writeReply(clientMessage, serverConnection, entryNotFoundForRemove | clientEvent.getIsRedestroyedEntry(), clientEvent.getVersionTag());
        }
        serverConnection.setAsTrue(1);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sent destroy response for region {} key {}", (Object)serverConnection.getName(), (Object)regionName, key);
        }
        stats.incWriteDestroyResponseTime(DistributionStats.getStatTime() - start);
    }
}

