/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketAddress;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.IncompatibleVersionException;
import org.apache.geode.cache.UnsupportedVersionException;
import org.apache.geode.cache.VersionException;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.tier.CommunicationMode;
import org.apache.geode.internal.cache.tier.ServerSideHandshake;
import org.apache.geode.internal.cache.tier.sockets.ServerSideHandshakeImpl;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.security.SecurityService;
import org.apache.logging.log4j.Logger;

class ServerSideHandshakeFactory {
    private static final Logger logger = LogService.getLogger();
    @Immutable
    static final Version currentServerVersion = Version.CURRENT;

    ServerSideHandshakeFactory() {
    }

    ServerSideHandshake readHandshake(Socket socket, int timeout, CommunicationMode communicationMode, DistributedSystem system, SecurityService securityService) throws Exception {
        Version clientVersion = this.readClientVersion(socket, timeout, communicationMode.isWAN());
        if (logger.isDebugEnabled()) {
            logger.debug("Client version: {}", (Object)clientVersion);
        }
        if (clientVersion.compareTo(Version.GFE_57) < 0) {
            throw new UnsupportedVersionException("Unsupported version " + clientVersion + "Server's current version " + currentServerVersion);
        }
        return new ServerSideHandshakeImpl(socket, timeout, system, clientVersion, communicationMode, securityService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Version readClientVersion(Socket socket, int timeout, boolean isWan) throws IOException, VersionException {
        int soTimeout = -1;
        try {
            soTimeout = socket.getSoTimeout();
            socket.setSoTimeout(timeout);
            InputStream is = socket.getInputStream();
            short clientVersionOrdinal = Version.readOrdinalFromInputStream(is);
            if (clientVersionOrdinal == -1) {
                throw new EOFException("HandShakeReader: EOF reached before client version could be read");
            }
            Version clientVersion = null;
            try {
                clientVersion = Version.fromOrdinal(clientVersionOrdinal, true);
            }
            catch (UnsupportedVersionException uve) {
                if (isWan) {
                    Version version = currentServerVersion;
                    if (soTimeout != -1) {
                        try {
                            socket.setSoTimeout(soTimeout);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return version;
                }
                SocketAddress sa = socket.getRemoteSocketAddress();
                String sInfo = "";
                if (sa != null) {
                    sInfo = " Client: " + sa.toString() + ".";
                }
                throw new UnsupportedVersionException(uve.getMessage() + sInfo);
            }
            if (!clientVersion.compatibleWith(currentServerVersion)) {
                throw new IncompatibleVersionException(clientVersion, currentServerVersion);
            }
            Version version = clientVersion;
            return version;
        }
        finally {
            if (soTimeout != -1) {
                try {
                    socket.setSoTimeout(soTimeout);
                }
                catch (IOException iOException) {}
            }
        }
    }
}

