/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.io.IOException;
import java.net.Socket;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.tier.Acceptor;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.security.SecurityService;

public class OriginalServerConnection
extends ServerConnection {
    private boolean doHandshake = true;

    public OriginalServerConnection(Socket socket, InternalCache internalCache, CachedRegionHelper helper, CacheServerStats stats, int hsTimeout, int socketBufferSize, String communicationModeStr, byte communicationMode, Acceptor acceptor, SecurityService securityService) {
        super(socket, internalCache, helper, stats, hsTimeout, socketBufferSize, communicationModeStr, communicationMode, acceptor, securityService);
        this.initStreams(socket, socketBufferSize, stats);
    }

    @Override
    protected boolean doHandShake(byte endpointType, int queueSize) {
        try {
            this.handshake.handshakeWithClient(this.theSocket.getOutputStream(), this.theSocket.getInputStream(), endpointType, queueSize, this.communicationMode, this.principal);
        }
        catch (IOException ioe) {
            if (!this.crHelper.isShutdown() && !this.isTerminated()) {
                logger.warn("{}: Handshake accept failed on socket {}: {}", (Object)this.name, (Object)this.theSocket, (Object)ioe);
            }
            this.cleanup();
            return false;
        }
        return true;
    }

    @Override
    protected void doOneMessage() {
        if (this.doHandshake) {
            this.doHandshake();
            this.doHandshake = false;
        } else {
            this.resetTransientData();
            this.doNormalMessage();
        }
    }
}

