/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.BindException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.SystemFailure;
import org.apache.geode.ToDataException;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.wan.GatewayTransportFilter;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.LonerDistributionManager;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.SystemTimer;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.BucketAdvisor;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.partitioned.AllBucketProfilesUpdateMessage;
import org.apache.geode.internal.cache.tier.Acceptor;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.CommunicationMode;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.ClientHealthMonitor;
import org.apache.geode.internal.cache.tier.sockets.CommBufferPool;
import org.apache.geode.internal.cache.tier.sockets.ConnectionListener;
import org.apache.geode.internal.cache.tier.sockets.ConnectionListenerAdapter;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.tier.sockets.ServerConnectionFactory;
import org.apache.geode.internal.cache.wan.GatewayReceiverStats;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.LoggingExecutors;
import org.apache.geode.internal.logging.LoggingThread;
import org.apache.geode.internal.logging.LoggingThreadFactory;
import org.apache.geode.internal.monitoring.ThreadsMonitoring;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.internal.net.SocketCreatorFactory;
import org.apache.geode.internal.security.SecurableCommunicationChannel;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.internal.tcp.ConnectionTable;
import org.apache.geode.internal.util.ArrayUtils;
import org.apache.logging.log4j.Logger;

public class AcceptorImpl
implements Acceptor,
Runnable,
CommBufferPool {
    private static final Logger logger = LogService.getLogger();
    private static final boolean isJRockit = System.getProperty("java.vm.name").contains("JRockit");
    private static final int HANDSHAKER_DEFAULT_POOL_SIZE = 4;
    public static final int CLIENT_QUEUE_INITIALIZATION_POOL_SIZE = 16;
    protected final CacheServerStats stats;
    private final int maxConnections;
    private final int maxThreads;
    private final ExecutorService pool;
    private final ExecutorService hsPool;
    private final ExecutorService clientQueueInitPool;
    private final int localPort;
    private ServerSocket serverSock;
    protected final InternalCache cache;
    private final CachedRegionHelper crHelper;
    private final Object syncLock;
    private final Selector selector;
    private final LinkedBlockingQueue commBufferQueue;
    private final SystemTimer hsTimer;
    private final LinkedBlockingQueue selectorQueue;
    private final HashSet selectorRegistrations;
    private final boolean tcpNoDelay;
    public static final String HANDSHAKE_TIMEOUT_PROPERTY_NAME = "BridgeServer.handShakeTimeout";
    public static final int DEFAULT_HANDSHAKE_TIMEOUT_MS = 59000;
    protected static final int handshakeTimeout = Integer.getInteger("BridgeServer.handShakeTimeout", 59000);
    public static final String ACCEPT_TIMEOUT_PROPERTY_NAME = "BridgeServer.acceptTimeout";
    public static final int DEFAULT_ACCEPT_TIMEOUT_MS = 9900;
    private final int acceptTimeout;
    public static final int MINIMUM_MAX_CONNECTIONS = 16;
    private final int socketBufferSize;
    private CacheClientNotifier clientNotifier;
    private static final int DEFAULT_BACKLOG = 1280;
    public static final String BACKLOG_PROPERTY_NAME = "BridgeServer.backlog";
    public static final String CHECK_REGISTERED_KEYS_INTERVAL_NAME = "check-registered-keys-interval-ns";
    public static final int DEFAULT_CHECK_REGISTERED_KEYS_INTERVAL_NS = 0;
    private final long checkRegisteredKeysInterval;
    public final AtomicInteger clientServerCnxCount;
    private volatile boolean shutdownStarted;
    private Thread thread;
    private Thread selectorThread;
    private final Object allSCsLock;
    private final HashSet allSCs;
    private volatile ServerConnection[] allSCList;
    private final String bindHostName;
    private final ConnectionListener connectionListener;
    private final ClientHealthMonitor healthMonitor;
    private final boolean notifyBySubscription;
    private long acceptorId;
    @MakeNotStatic
    private static boolean isAuthenticationRequired;
    @MakeNotStatic
    private static boolean isPostAuthzCallbackPresent;
    private boolean isGatewayReceiver;
    private List<GatewayTransportFilter> gatewayTransportFilters;
    private final SocketCreator socketCreator;
    private final SecurityService securityService;
    private final ServerConnectionFactory serverConnectionFactory;
    @Deprecated
    private static final boolean DEPRECATED_SELECTOR;
    @Deprecated
    private final int DEPRECATED_SELECTOR_POOL_SIZE;
    private final int HANDSHAKE_POOL_SIZE;
    @MakeNotStatic
    private static volatile boolean emergencyClassesLoaded;
    private static final boolean WORKAROUND_SELECTOR_BUG;
    private Selector tmpSel;
    private int registeredKeys;
    protected boolean loggedAcceptError;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AcceptorImpl(int port, String bindHostName, boolean notifyBySubscription, int socketBufferSize, int maximumTimeBetweenPings, InternalCache internalCache, int maxConnections, int maxThreads, int maximumMessageCount, int messageTimeToLive, ConnectionListener listener, List overflowAttributesList, boolean isGatewayReceiver, List<GatewayTransportFilter> transportFilter, boolean tcpNoDelay, ServerConnectionFactory serverConnectionFactory, long timeLimitMillis) throws IOException {
        DistributionManager dm;
        InternalDistributedSystem ds;
        int backLog;
        block34: {
            this.serverSock = null;
            this.syncLock = new Object();
            this.acceptTimeout = Integer.getInteger(ACCEPT_TIMEOUT_PROPERTY_NAME, 9900);
            this.checkRegisteredKeysInterval = Long.getLong(CHECK_REGISTERED_KEYS_INTERVAL_NAME, 0L);
            this.clientServerCnxCount = new AtomicInteger();
            this.shutdownStarted = false;
            this.thread = null;
            this.selectorThread = null;
            this.allSCsLock = new Object();
            this.allSCs = new HashSet();
            this.allSCList = new ServerConnection[0];
            this.DEPRECATED_SELECTOR_POOL_SIZE = Integer.getInteger("BridgeServer.SELECTOR_POOL_SIZE", 16);
            this.HANDSHAKE_POOL_SIZE = Integer.getInteger("BridgeServer.HANDSHAKE_POOL_SIZE", 4);
            this.registeredKeys = 0;
            this.loggedAcceptError = false;
            this.securityService = internalCache.getSecurityService();
            this.bindHostName = AcceptorImpl.calcBindHostName(internalCache, bindHostName);
            this.connectionListener = listener == null ? new ConnectionListenerAdapter() : listener;
            this.notifyBySubscription = notifyBySubscription;
            this.isGatewayReceiver = isGatewayReceiver;
            this.gatewayTransportFilters = transportFilter;
            this.serverConnectionFactory = serverConnectionFactory;
            int tmp_maxConnections = maxConnections;
            if (tmp_maxConnections < 16) {
                tmp_maxConnections = 16;
            }
            this.maxConnections = tmp_maxConnections;
            int tmp_maxThreads = maxThreads;
            if (maxThreads == 0 && DEPRECATED_SELECTOR) {
                tmp_maxThreads = this.DEPRECATED_SELECTOR_POOL_SIZE;
            }
            if (tmp_maxThreads < 0) {
                tmp_maxThreads = 0;
            } else if (tmp_maxThreads > this.maxConnections) {
                tmp_maxThreads = this.maxConnections;
            }
            boolean isWindows = false;
            String os = System.getProperty("os.name");
            if (os != null && os.indexOf("Windows") != -1) {
                isWindows = true;
            }
            if (tmp_maxThreads > 0 && isWindows) {
                if (this.getBindAddress() instanceof Inet6Address) {
                    logger.warn("Ignoring max-threads setting and using zero instead due to JRockit NIO bugs.  See GemFire bug #40198");
                    tmp_maxThreads = 0;
                }
                if (isJRockit) {
                    logger.warn("Ignoring max-threads setting and using zero instead due to Java bug 6230761: NIO does not work with IPv6 on Windows.  See GemFire bug #40472");
                    tmp_maxThreads = 0;
                }
            }
            this.maxThreads = tmp_maxThreads;
            Selector tmp_s = null;
            LinkedBlockingQueue tmp_q = null;
            LinkedBlockingQueue tmp_commQ = null;
            HashSet tmp_hs = null;
            SystemTimer tmp_timer = null;
            if (this.isSelector()) {
                tmp_s = Selector.open();
                tmp_q = new LinkedBlockingQueue();
                tmp_commQ = new LinkedBlockingQueue();
                tmp_hs = new HashSet(512);
                tmp_timer = new SystemTimer(internalCache.getDistributedSystem(), true);
            }
            this.selector = tmp_s;
            this.selectorQueue = tmp_q;
            this.commBufferQueue = tmp_commQ;
            this.selectorRegistrations = tmp_hs;
            this.hsTimer = tmp_timer;
            this.tcpNoDelay = tcpNoDelay;
            this.socketCreator = !isGatewayReceiver ? SocketCreatorFactory.getSocketCreatorForComponent(SecurableCommunicationChannel.SERVER) : SocketCreatorFactory.getSocketCreatorForComponent(SecurableCommunicationChannel.GATEWAY);
            InternalCache gc = this.getCachedRegionHelper() != null ? this.getCachedRegionHelper().getCache() : null;
            backLog = Integer.getInteger(BACKLOG_PROPERTY_NAME, 1280);
            long tilt = System.currentTimeMillis() + timeLimitMillis;
            if (this.isSelector()) {
                if (this.socketCreator.useSSL()) {
                    throw new IllegalArgumentException("Selector thread pooling can not be used with client/server SSL. The selector can be disabled by setting max-threads=0.");
                }
                ServerSocketChannel channel = ServerSocketChannel.open();
                this.serverSock = channel.socket();
                this.serverSock.setReuseAddress(true);
                this.serverSock.setReceiveBufferSize(socketBufferSize);
                while (true) {
                    try {
                        this.serverSock.bind(new InetSocketAddress(this.getBindAddress(), port), backLog);
                        break block34;
                    }
                    catch (SocketException b) {
                        if (!AcceptorImpl.treatAsBindException(b) || System.currentTimeMillis() > tilt) {
                            throw b;
                        }
                        boolean interrupted = Thread.interrupted();
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                        }
                        finally {
                            if (interrupted) {
                                Thread.currentThread().interrupt();
                            }
                        }
                        if (gc == null) continue;
                        gc.getCancelCriterion().checkCancelInProgress(null);
                        continue;
                    }
                    break;
                }
            }
            while (true) {
                try {
                    this.serverSock = this.socketCreator.createServerSocket(port, backLog, this.getBindAddress(), this.gatewayTransportFilters, socketBufferSize);
                }
                catch (SocketException e) {
                    if (!AcceptorImpl.treatAsBindException(e) || System.currentTimeMillis() > tilt) {
                        throw e;
                    }
                    boolean interrupted = Thread.interrupted();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e2) {
                        interrupted = true;
                    }
                    finally {
                        if (interrupted) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    if (gc == null) continue;
                    gc.getCancelCriterion().checkCancelInProgress(null);
                    continue;
                }
                break;
            }
        }
        if (port == 0) {
            port = this.serverSock.getLocalPort();
        }
        if ((ds = InternalDistributedSystem.getConnectedInstance()) != null && (dm = ds.getDistributionManager()) != null && dm.getDistributionManagerId().getPort() == 0 && dm instanceof LonerDistributionManager) {
            ((LonerDistributionManager)dm).updateLonerPort(port);
        }
        this.localPort = port;
        String sockName = this.getServerName();
        logger.info("Cache server connection listener bound to address {} with backlog {}.", new Object[]{sockName, backLog});
        this.stats = isGatewayReceiver ? GatewayReceiverStats.createGatewayReceiverStats(sockName) : new CacheServerStats(sockName);
        this.cache = internalCache;
        this.crHelper = new CachedRegionHelper(this.cache);
        this.clientNotifier = CacheClientNotifier.getInstance(this.cache, this.stats, maximumMessageCount, messageTimeToLive, this.connectionListener, overflowAttributesList, isGatewayReceiver);
        this.socketBufferSize = socketBufferSize;
        this.healthMonitor = ClientHealthMonitor.getInstance(internalCache, maximumTimeBetweenPings, this.clientNotifier.getStats());
        this.pool = this.initializeServerConnectionThreadPool();
        this.hsPool = this.initializeHandshakerThreadPool();
        this.clientQueueInitPool = this.initializeClientQueueInitializerThreadPool();
        isAuthenticationRequired = this.securityService.isClientSecurityRequired();
        String postAuthzFactoryName = this.cache.getDistributedSystem().getProperties().getProperty("security-client-accessor-pp");
        isPostAuthzCallbackPresent = postAuthzFactoryName != null && postAuthzFactoryName.length() > 0;
    }

    private ExecutorService initializeHandshakerThreadPool() throws IOException {
        String threadName = "Handshaker " + this.serverSock.getInetAddress() + ":" + this.localPort + " Thread ";
        try {
            logger.warn("Handshaker max Pool size: " + this.HANDSHAKE_POOL_SIZE);
            return LoggingExecutors.newThreadPoolWithSynchronousFeedThatHandlesRejection(threadName, thread -> this.getStats().incAcceptThreadsCreated(), null, 1, this.HANDSHAKE_POOL_SIZE, 60L);
        }
        catch (IllegalArgumentException poolInitException) {
            this.stats.close();
            this.serverSock.close();
            this.pool.shutdown();
            throw poolInitException;
        }
    }

    private ExecutorService initializeClientQueueInitializerThreadPool() throws IOException {
        return LoggingExecutors.newThreadPoolWithSynchronousFeed("Client Queue Initialization Thread ", command -> {
            try {
                command.run();
            }
            catch (CancelException e) {
                logger.debug("Client Queue Initialization was canceled.", (Throwable)e);
            }
        }, 16, this.getStats().getCnxPoolHelper(), 60000, this.getThreadMonitorObj());
    }

    private ExecutorService initializeServerConnectionThreadPool() throws IOException {
        String threadName = "ServerConnection on port " + this.localPort + " Thread ";
        LoggingThreadFactory.ThreadInitializer threadInitializer = thread -> this.getStats().incConnectionThreadsCreated();
        LoggingThreadFactory.CommandWrapper commandWrapper = command -> {
            try {
                command.run();
            }
            catch (CancelException cancelException) {
            }
            finally {
                ConnectionTable.releaseThreadsSockets();
            }
        };
        try {
            if (this.isSelector()) {
                return LoggingExecutors.newThreadPoolWithUnlimitedFeed(threadName, threadInitializer, commandWrapper, this.maxThreads, this.getStats().getCnxPoolHelper(), Integer.MAX_VALUE, this.getThreadMonitorObj());
            }
            return LoggingExecutors.newThreadPoolWithSynchronousFeed(threadName, threadInitializer, commandWrapper, 16, this.maxConnections, 0L);
        }
        catch (IllegalArgumentException poolInitException) {
            this.stats.close();
            this.serverSock.close();
            throw poolInitException;
        }
    }

    private ThreadsMonitoring getThreadMonitorObj() {
        DistributionManager distributionManager = this.cache.getDistributionManager();
        if (distributionManager != null) {
            return distributionManager.getThreadMonitoring();
        }
        return null;
    }

    public long getAcceptorId() {
        return this.acceptorId;
    }

    public CacheServerStats getStats() {
        return this.stats;
    }

    public boolean isSelector() {
        return this.maxThreads > 0;
    }

    @Override
    public void start() throws IOException {
        this.thread = new LoggingThread("Cache Server Acceptor " + this.serverSock.getInetAddress() + ":" + this.localPort + " local port: " + this.serverSock.getLocalPort(), false, this);
        this.acceptorId = this.thread.getId();
        this.thread.start();
        if (this.isSelector()) {
            this.selectorThread = new LoggingThread("Cache Server Selector " + this.serverSock.getInetAddress() + ":" + this.localPort + " local port: " + this.serverSock.getLocalPort(), false, this::runSelectorLoop);
            this.selectorThread.start();
        }
        Set<PartitionedRegion> prs = this.cache.getPartitionedRegions();
        for (PartitionedRegion pr : prs) {
            HashMap<Integer, BucketAdvisor.BucketProfile> profiles = new HashMap<Integer, BucketAdvisor.BucketProfile>();
            Map<Integer, BucketAdvisor> advisors = pr.getRegionAdvisor().getAllBucketAdvisors();
            for (Map.Entry<Integer, BucketAdvisor> entry : advisors.entrySet()) {
                BucketAdvisor advisor = entry.getValue();
                BucketAdvisor.BucketProfile bp = (BucketAdvisor.BucketProfile)advisor.createProfile();
                advisor.updateServerBucketProfile(bp);
                profiles.put(entry.getKey(), bp);
            }
            Set receipients = new HashSet();
            receipients = pr.getRegionAdvisor().adviseAllPRNodes();
            ReplyProcessor21 reply = AllBucketProfilesUpdateMessage.send(receipients, pr.getDistributionManager(), pr.getPRId(), profiles);
            if (reply == null) continue;
            reply.waitForRepliesUninterruptibly();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSC(ServerConnection sc) {
        Object object = this.syncLock;
        synchronized (object) {
            if (!this.isRunning()) {
                this.finishCon(sc);
                return;
            }
        }
        this.getSelectorQueue().offer(sc);
        this.wakeupSelector();
    }

    private void wakeupSelector() {
        Selector s = this.getSelector();
        if (s != null && s.isOpen()) {
            this.selector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterSC(ServerConnection sc) {
        Object object = this.allSCsLock;
        synchronized (object) {
            this.allSCs.remove(sc);
            Iterator it = this.allSCs.iterator();
            ServerConnection[] again = new ServerConnection[this.allSCs.size()];
            for (int i = 0; i < again.length; ++i) {
                again[i] = (ServerConnection)it.next();
            }
            this.allSCList = again;
        }
        if (!this.isRunning()) {
            return;
        }
        this.wakeupSelector();
    }

    private void finishCon(ServerConnection sc) {
        if (sc != null) {
            sc.handleTermination();
        }
    }

    private void drainSelectorQueue() {
        ServerConnection sc = (ServerConnection)this.selectorQueue.poll();
        CancelException cce = null;
        while (sc != null) {
            block7: {
                try {
                    this.finishCon(sc);
                }
                catch (CancelException e) {
                    if (cce != null) break block7;
                    cce = e;
                }
            }
            sc = (ServerConnection)this.selectorQueue.poll();
        }
        Iterator it = this.selectorRegistrations.iterator();
        while (it.hasNext()) {
            try {
                this.finishCon((ServerConnection)it.next());
            }
            catch (CancelException e) {
                if (cce != null) continue;
                cce = e;
            }
        }
        if (cce != null) {
            throw cce;
        }
    }

    public static void loadEmergencyClasses() {
        if (emergencyClassesLoaded) {
            return;
        }
        emergencyClassesLoaded = true;
        CachedRegionHelper.loadEmergencyClasses();
        ServerConnection.loadEmergencyClasses();
    }

    public void emergencyClose() {
        ServerSocket ss = this.serverSock;
        if (ss != null) {
            try {
                ss.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.crHelper.setShutdown(true);
        ServerConnection[] snap = this.allSCList;
        for (int i = 0; i < snap.length; ++i) {
            snap[i].emergencyClose();
        }
    }

    private boolean isRegisteredObjectClosed(ServerConnection sc) {
        return sc.isClosed();
    }

    private int checkRegisteredKeys(int count) {
        int result = count;
        CancelException cce = null;
        if (count > 0) {
            Iterator it = this.selectorRegistrations.iterator();
            while (it.hasNext()) {
                ServerConnection sc = (ServerConnection)it.next();
                if (!this.isRegisteredObjectClosed(sc)) continue;
                --result;
                it.remove();
                try {
                    this.finishCon(sc);
                }
                catch (CancelException e) {
                    if (cce != null) continue;
                    cce = e;
                }
            }
        }
        if (cce != null) {
            throw cce;
        }
        return result;
    }

    private void checkForStuckKeys() {
        if (!WORKAROUND_SELECTOR_BUG) {
            return;
        }
        if (this.tmpSel == null) {
            try {
                this.tmpSel = Selector.open();
            }
            catch (IOException ignore) {
                logger.warn("Could not check for stuck keys.", (Throwable)ignore);
                return;
            }
        }
        for (SelectionKey sk : new ArrayList<SelectionKey>(this.selector.keys())) {
            ServerConnection sc = (ServerConnection)sk.attachment();
            if (sc == null) continue;
            try {
                sk.cancel();
                this.selector.selectNow();
                SelectionKey tmpsk = sc.getSelectableChannel().register(this.tmpSel, 5);
                try {
                    int events = this.tmpSel.selectNow();
                    if (events == 0) {
                        logger.info("stuck selection key detected on {}", (Object)sc);
                        tmpsk.cancel();
                        this.tmpSel.selectNow();
                        sc.registerWithSelector2(this.selector);
                        continue;
                    }
                    if (tmpsk.isValid() && tmpsk.isReadable()) {
                        try {
                            tmpsk.cancel();
                            this.tmpSel.selectNow();
                            this.selectorRegistrations.remove(sc);
                            --this.registeredKeys;
                            sc.makeBlocking();
                            sc.setProcessingMessage();
                        }
                        catch (ClosedChannelException ignore) {
                            this.finishCon(sc);
                            continue;
                        }
                        catch (IOException ex) {
                            this.finishCon(sc);
                            if (!this.isRunning()) continue;
                            logger.warn("Unexpected Exception:", (Throwable)ex);
                            continue;
                        }
                        try {
                            this.stats.incThreadQueueSize();
                            this.pool.execute(sc);
                        }
                        catch (RejectedExecutionException rejected) {
                            this.finishCon(sc);
                            this.stats.decThreadQueueSize();
                            if (!this.isRunning()) break;
                            logger.warn("Unexpected Exception:", (Throwable)rejected);
                        }
                        continue;
                    }
                    if (tmpsk.isValid() && tmpsk.isWritable()) {
                        tmpsk.cancel();
                        this.tmpSel.selectNow();
                        sc.registerWithSelector2(this.selector);
                        continue;
                    }
                    if (tmpsk.isValid()) continue;
                    tmpsk.cancel();
                    this.tmpSel.selectNow();
                    sc.registerWithSelector2(this.selector);
                }
                catch (IOException ex) {
                    if (!this.isRunning() || !this.selector.isOpen() || !this.tmpSel.isOpen()) continue;
                    logger.warn("Unexpected Exception:", (Throwable)ex);
                    try {
                        tmpsk.cancel();
                        this.tmpSel.selectNow();
                    }
                    catch (IOException ex2) {
                        if (!this.isRunning() || !this.selector.isOpen() || !this.tmpSel.isOpen()) continue;
                        logger.warn("Unexpected Exception:", (Throwable)ex2);
                    }
                }
            }
            catch (ClosedChannelException ignore) {
                this.finishCon(sc);
            }
            catch (IOException ex) {
                if (!this.isRunning() || !this.selector.isOpen() || !this.tmpSel.isOpen()) continue;
                logger.warn("Unexpected Exception:", (Throwable)ex);
            }
            catch (NullPointerException npe) {
                if (!this.isRunning() || !this.selector.isOpen() || !this.tmpSel.isOpen()) continue;
                logger.warn("Unexpected Exception:", (Throwable)npe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runSelectorLoop() {
        try {
            long lastCheckedTime = System.nanoTime();
            logger.info("SELECTOR enabled");
            block31: while (this.selector.isOpen() && !Thread.currentThread().isInterrupted()) {
                SystemFailure.checkFailure();
                if (this.cache.isClosed()) {
                    break;
                }
                if (this.cache.getCancelCriterion().isCancelInProgress()) {
                    break;
                }
                long delta = System.nanoTime() - lastCheckedTime;
                if (this.checkRegisteredKeysInterval == 0L || delta >= this.checkRegisteredKeysInterval) {
                    this.registeredKeys = this.checkRegisteredKeys(this.registeredKeys);
                    lastCheckedTime = System.nanoTime();
                }
                ServerConnection sc = this.registeredKeys == 0 ? (ServerConnection)this.selectorQueue.take() : (ServerConnection)this.selectorQueue.poll();
                while (sc != null) {
                    try {
                        sc.registerWithSelector2(this.selector);
                        ++this.registeredKeys;
                        this.selectorRegistrations.add(sc);
                    }
                    catch (ClosedChannelException cce) {
                        this.finishCon(sc);
                    }
                    catch (IOException ex) {
                        this.finishCon(sc);
                        logger.warn("ignoring", (Throwable)ex);
                    }
                    catch (RuntimeException ex) {
                        this.finishCon(sc);
                        logger.warn("ignoring", (Throwable)ex);
                    }
                    sc = (ServerConnection)this.selectorQueue.poll();
                }
                if (this.registeredKeys == 0) continue;
                int events = this.selector.select();
                if (this.cache.getCancelCriterion().isCancelInProgress()) {
                    break;
                }
                if (events == 0) {
                    this.checkForStuckKeys();
                }
                while (events > 0) {
                    int cancelCount = 0;
                    Set<SelectionKey> sk = this.selector.selectedKeys();
                    if (sk == null) {
                        events = 0;
                        continue block31;
                    }
                    Iterator<SelectionKey> keysIterator = sk.iterator();
                    while (keysIterator.hasNext()) {
                        SelectionKey key = keysIterator.next();
                        keysIterator.remove();
                        ServerConnection sc2 = (ServerConnection)key.attachment();
                        try {
                            if (key.isValid() && key.isReadable()) {
                                try {
                                    key.cancel();
                                    this.selectorRegistrations.remove(sc2);
                                    --this.registeredKeys;
                                    ++cancelCount;
                                    sc2.makeBlocking();
                                    sc2.setProcessingMessage();
                                }
                                catch (ClosedChannelException ignore) {
                                    this.finishCon(sc2);
                                    continue;
                                }
                                catch (IOException ex) {
                                    this.finishCon(sc2);
                                    if (!this.isRunning()) continue;
                                    logger.warn("unexpected", (Throwable)ex);
                                    continue;
                                }
                                try {
                                    this.stats.incThreadQueueSize();
                                    this.pool.execute(sc2);
                                }
                                catch (RejectedExecutionException rejected) {
                                    this.finishCon(sc2);
                                    this.stats.decThreadQueueSize();
                                    if (!this.isRunning()) break;
                                    logger.warn("unexpected", (Throwable)rejected);
                                }
                                continue;
                            }
                            this.finishCon(sc2);
                            if (!key.isValid()) continue;
                            logger.warn("ignoring event on selector key {}", (Object)key);
                        }
                        catch (CancelledKeyException ex) {
                            this.finishCon(sc2);
                        }
                    }
                    if (cancelCount > 0 && this.selector.isOpen()) {
                        events = this.selector.selectNow();
                        continue;
                    }
                    events = 0;
                }
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (ClosedSelectorException ex) {
            try {
                this.drainSelectorQueue();
            }
            finally {
                this.close();
            }
        }
        catch (IOException ex) {
            logger.warn("unexpected", (Throwable)ex);
        }
        finally {
            try {
                this.drainSelectorQueue();
            }
            finally {
                this.close();
            }
        }
    }

    @Override
    public int getPort() {
        return this.localPort;
    }

    @Override
    public String getServerName() {
        String name = this.serverSock.getLocalSocketAddress().toString();
        try {
            name = SocketCreator.getLocalHost().getCanonicalHostName() + "-" + name;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return name;
    }

    public InetAddress getServerInetAddr() {
        return this.serverSock.getInetAddress();
    }

    @Override
    public void run() {
        try {
            this.accept();
        }
        catch (CancelException cancelException) {
        }
        finally {
            try {
                if (this.serverSock != null) {
                    this.serverSock.close();
                }
            }
            catch (IOException iOException) {}
            if (this.stats != null) {
                this.stats.close();
            }
        }
    }

    public Selector getSelector() {
        return this.selector;
    }

    public BlockingQueue getSelectorQueue() {
        return this.selectorQueue;
    }

    protected static void closeSocket(Socket s) {
        if (s != null) {
            try {
                s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept() {
        while (this.isRunning()) {
            if (SystemFailure.getFailure() != null) {
                ServerSocket s = this.serverSock;
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                SystemFailure.checkFailure();
            }
            this.crHelper.checkCancelInProgress(null);
            Socket socket = null;
            try {
                socket = this.serverSock.accept();
                this.crHelper.checkCancelInProgress(null);
                socket.setKeepAlive(SocketCreator.ENABLE_TCP_KEEP_ALIVE);
                Object object = this.syncLock;
                synchronized (object) {
                    if (!this.isRunning()) {
                        AcceptorImpl.closeSocket(socket);
                        break;
                    }
                }
                this.loggedAcceptError = false;
                this.handOffNewClientConnection(socket, this.serverConnectionFactory);
            }
            catch (InterruptedIOException e) {
                AcceptorImpl.closeSocket(socket);
                if (!this.isRunning() || !logger.isDebugEnabled()) continue;
                logger.debug("Aborted due to interrupt: {}", (Throwable)e);
            }
            catch (IOException e) {
                AcceptorImpl.closeSocket(socket);
                if (!this.isRunning() || this.loggedAcceptError) continue;
                this.loggedAcceptError = true;
                logger.error("Cache server: Unexpected IOException from accept", (Throwable)e);
            }
            catch (CancelException e) {
                AcceptorImpl.closeSocket(socket);
                throw e;
            }
            catch (Exception e) {
                AcceptorImpl.closeSocket(socket);
                if (!this.isRunning()) continue;
                logger.fatal("Cache server: Unexpected Exception", (Throwable)e);
            }
        }
    }

    private void handOffNewClientConnection(final Socket socket, final ServerConnectionFactory serverConnectionFactory) {
        block2: {
            try {
                this.stats.incAcceptsInProgress();
                this.hsPool.execute(new Runnable(){

                    @Override
                    public void run() {
                        boolean finished = false;
                        try {
                            AcceptorImpl.this.handleNewClientConnection(socket, serverConnectionFactory);
                            finished = true;
                        }
                        catch (RegionDestroyedException rde) {
                            if (rde.getMessage().indexOf("HARegion") == -1) {
                                throw rde;
                            }
                        }
                        catch (CancelException rde) {
                        }
                        catch (AsynchronousCloseException rde) {
                        }
                        catch (IOException | ToDataException ex) {
                            if (AcceptorImpl.this.isRunning() && !AcceptorImpl.this.loggedAcceptError) {
                                AcceptorImpl.this.loggedAcceptError = true;
                                if (ex instanceof SocketTimeoutException) {
                                    logger.warn("Cache server: failed accepting client connection due to socket timeout.");
                                } else {
                                    logger.warn("Cache server: failed accepting client connection " + ex, (Throwable)ex);
                                }
                            }
                        }
                        finally {
                            if (!finished) {
                                AcceptorImpl.closeSocket(socket);
                            }
                            if (AcceptorImpl.this.isRunning()) {
                                AcceptorImpl.this.stats.decAcceptsInProgress();
                            }
                        }
                    }
                });
            }
            catch (RejectedExecutionException rejected) {
                AcceptorImpl.closeSocket(socket);
                if (!this.isRunning()) break block2;
                this.stats.decAcceptsInProgress();
                logger.warn("unexpected", (Throwable)rejected);
            }
        }
    }

    private ByteBuffer takeCommBuffer() {
        ByteBuffer result = (ByteBuffer)this.commBufferQueue.poll();
        if (result == null) {
            result = ByteBuffer.allocateDirect(this.socketBufferSize);
        }
        return result;
    }

    private void releaseCommBuffer(ByteBuffer bb) {
        if (bb == null) {
            return;
        }
        if (this.isRunning()) {
            this.commBufferQueue.offer(bb);
        }
    }

    public void incClientServerCnxCount() {
        this.clientServerCnxCount.incrementAndGet();
    }

    public void decClientServerCnxCount() {
        this.clientServerCnxCount.decrementAndGet();
    }

    public int getClientServerCnxCount() {
        return this.clientServerCnxCount.get();
    }

    public boolean isNotifyBySubscription() {
        return this.notifyBySubscription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleNewClientConnection(Socket socket, ServerConnectionFactory serverConnectionFactory) throws IOException {
        int curCnt;
        boolean notForQueue;
        CommunicationMode communicationMode;
        try {
            communicationMode = this.isSelector() ? this.getCommunicationModeForSelector(socket) : this.getCommunicationModeForNonSelector(socket);
            socket.setTcpNoDelay(this.tcpNoDelay);
        }
        catch (IllegalArgumentException e) {
            logger.warn("Error processing client connection", (Throwable)e);
            throw new EOFException();
        }
        if (this.handOffQueueInitialization(socket, communicationMode)) {
            return;
        }
        logger.debug("cache server: Initializing {} communication socket: {}", (Object)communicationMode, (Object)socket);
        boolean bl = notForQueue = communicationMode != CommunicationMode.ClientToServerForQueue;
        if (notForQueue && (curCnt = this.getClientServerCnxCount()) >= this.maxConnections) {
            logger.warn("Rejected connection from {} because current connection count of {} is greater than or equal to the configured max of {}", new Object[]{socket.getInetAddress(), curCnt, this.maxConnections});
            if (communicationMode.expectsConnectionRefusalMessage()) {
                try {
                    this.refuseHandshake(socket.getOutputStream(), String.format("exceeded max-connections %s", this.maxConnections), (byte)60);
                }
                catch (Exception ex) {
                    logger.debug("rejection message failed", (Throwable)ex);
                }
            }
            AcceptorImpl.closeSocket(socket);
            return;
        }
        ServerConnection serverConn = serverConnectionFactory.makeServerConnection(socket, this.cache, this.crHelper, this.stats, handshakeTimeout, this.socketBufferSize, communicationMode.toString(), communicationMode.getModeNumber(), this, this.securityService);
        Object ex = this.allSCsLock;
        synchronized (ex) {
            this.allSCs.add(serverConn);
            Object[] snap = this.allSCList;
            this.allSCList = (ServerConnection[])ArrayUtils.insert(snap, snap.length, serverConn);
        }
        if (notForQueue) {
            this.incClientServerCnxCount();
        }
        if (this.isSelector()) {
            serverConn.registerWithSelector();
        } else {
            try {
                this.pool.execute(serverConn);
            }
            catch (RejectedExecutionException rejected) {
                if (!this.isRunning()) {
                    return;
                }
                logger.warn("Rejected connection from {} because incoming request was rejected by pool possibly due to thread exhaustion", (Object)serverConn);
                try {
                    this.refuseHandshake(socket.getOutputStream(), String.format("exceeded max-connections %s", this.maxConnections), (byte)60);
                }
                catch (Exception ex2) {
                    logger.debug("rejection message failed", (Throwable)ex2);
                }
                serverConn.cleanup();
            }
        }
    }

    void refuseHandshake(OutputStream out, String message, byte exception) throws IOException {
        HeapDataOutputStream hdos = new HeapDataOutputStream(32, Version.CURRENT);
        DataOutputStream dos = new DataOutputStream(hdos);
        dos.writeByte(exception);
        dos.writeByte(0);
        dos.writeInt(0);
        InternalDistributedMember member = InternalDistributedSystem.getAnyInstance().getDistributedMember();
        HeapDataOutputStream memberDos = new HeapDataOutputStream(Version.CURRENT);
        DataSerializer.writeObject(member, memberDos);
        DataSerializer.writeByteArray(memberDos.toByteArray(), dos);
        memberDos.close();
        if (message == null) {
            message = "";
        }
        dos.writeUTF(message);
        dos.writeBoolean(Boolean.TRUE);
        out.write(hdos.toByteArray());
        out.flush();
    }

    private boolean handOffQueueInitialization(Socket socket, CommunicationMode communicationMode) {
        if (communicationMode.isSubscriptionFeed()) {
            boolean isPrimaryServerToClient = communicationMode == CommunicationMode.PrimaryServerToClient;
            this.clientQueueInitPool.execute(new ClientQueueInitializerTask(socket, isPrimaryServerToClient, this));
            return true;
        }
        return false;
    }

    private CommunicationMode getCommunicationModeForNonSelector(Socket socket) throws IOException {
        socket.setSoTimeout(0);
        this.socketCreator.handshakeIfSocketIsSSL(socket, this.acceptTimeout);
        byte communicationModeByte = (byte)socket.getInputStream().read();
        if (communicationModeByte == -1) {
            throw new EOFException();
        }
        return CommunicationMode.fromModeNumber(communicationModeByte);
    }

    private CommunicationMode getCommunicationModeForSelector(final Socket socket) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(1);
        SocketChannel socketChannel = socket.getChannel();
        socketChannel.configureBlocking(false);
        int res = socketChannel.read(byteBuffer);
        socketChannel.configureBlocking(true);
        if (res < 0) {
            throw new EOFException();
        }
        if (res == 0) {
            SystemTimer.SystemTimerTask timerTask = new SystemTimer.SystemTimerTask(){

                @Override
                public void run2() {
                    logger.warn("Cache server: timed out waiting for handshake from {}", (Object)socket.getRemoteSocketAddress());
                    AcceptorImpl.closeSocket(socket);
                }
            };
            this.hsTimer.schedule(timerTask, this.acceptTimeout);
            res = socketChannel.read(byteBuffer);
            if (!timerTask.cancel() || res <= 0) {
                throw new EOFException();
            }
        }
        return CommunicationMode.fromModeNumber(byteBuffer.get(0));
    }

    @Override
    public boolean isRunning() {
        return !this.shutdownStarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            Object object = this.syncLock;
            synchronized (object) {
                if (!this.isRunning()) {
                    return;
                }
                this.shutdownStarted = true;
                logger.info("Cache server on port {} is shutting down.", (Object)this.localPort);
                if (this.thread != null) {
                    this.thread.interrupt();
                }
                try {
                    this.serverSock.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.crHelper.setShutdown(true);
                this.shutdownSelectorIfIsSelector();
                ClientHealthMonitor.shutdownInstance();
                this.shutdownSCs();
                this.clientNotifier.shutdown(this.acceptorId);
                this.shutdownPools();
                this.stats.close();
                if (!this.cache.isClosed()) {
                    this.notifyCacheMembersOfClose();
                }
            }
        }
        catch (RuntimeException e) {
            logger.warn("unexpected", (Throwable)e);
        }
    }

    void notifyCacheMembersOfClose() {
        if (logger.isDebugEnabled()) {
            logger.debug("sending messages to all peers for removing this server..");
        }
        for (PartitionedRegion pr : this.cache.getPartitionedRegions()) {
            HashMap<Integer, BucketAdvisor.BucketProfile> profiles = new HashMap<Integer, BucketAdvisor.BucketProfile>();
            Map<Integer, BucketAdvisor> advisors = pr.getRegionAdvisor().getAllBucketAdvisors();
            for (Map.Entry<Integer, BucketAdvisor> entry : advisors.entrySet()) {
                BucketAdvisor advisor = entry.getValue();
                BucketAdvisor.BucketProfile bp = (BucketAdvisor.BucketProfile)advisor.createProfile();
                advisor.updateServerBucketProfile(bp);
                profiles.put(entry.getKey(), bp);
            }
            Set recipients = pr.getRegionAdvisor().adviseAllPRNodes();
            ReplyProcessor21 reply = AllBucketProfilesUpdateMessage.send(recipients, pr.getDistributionManager(), pr.getPRId(), profiles);
            if (reply == null) continue;
            reply.waitForRepliesUninterruptibly();
        }
    }

    private void shutdownSelectorIfIsSelector() {
        if (this.isSelector()) {
            this.hsTimer.cancel();
            if (this.tmpSel != null) {
                try {
                    this.tmpSel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            try {
                this.wakeupSelector();
                this.selector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.selectorThread != null) {
                this.selectorThread.interrupt();
            }
            this.commBufferQueue.clear();
        }
    }

    private void shutdownPools() {
        this.pool.shutdown();
        try {
            if (!this.pool.awaitTermination(PoolImpl.SHUTDOWN_TIMEOUT, TimeUnit.MILLISECONDS)) {
                logger.warn("Timeout waiting for background tasks to complete.");
                this.pool.shutdownNow();
            }
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
            this.pool.shutdownNow();
        }
        this.clientQueueInitPool.shutdown();
        this.hsPool.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownSCs() {
        Object object = this.allSCsLock;
        synchronized (object) {
            ServerConnection[] snap = this.allSCList;
            for (int i = 0; i < snap.length; ++i) {
                snap[i].cleanup();
            }
        }
    }

    public boolean isShutdownProperly() {
        return !(this.isRunning() || this.thread.isAlive() || this.selectorThread != null && this.selectorThread.isAlive() || this.pool != null && !this.pool.isShutdown() || this.hsPool != null && !this.hsPool.isShutdown() || this.clientQueueInitPool != null && !this.clientQueueInitPool.isShutdown() || this.selector != null && this.selector.isOpen() || this.tmpSel != null && this.tmpSel.isOpen());
    }

    private static String calcBindHostName(Cache cache, String bindName) {
        if (bindName != null && !bindName.equals("")) {
            return bindName;
        }
        InternalDistributedSystem system = (InternalDistributedSystem)cache.getDistributedSystem();
        DistributionConfig config = system.getConfig();
        String hostName = null;
        String serverBindAddress = config.getServerBindAddress();
        if (serverBindAddress != null && serverBindAddress.length() > 0) {
            hostName = serverBindAddress;
        } else {
            String bindAddress = config.getBindAddress();
            if (bindAddress != null && bindAddress.length() > 0) {
                hostName = bindAddress;
            }
        }
        return hostName;
    }

    private InetAddress getBindAddress() throws IOException {
        if (this.bindHostName == null || "".equals(this.bindHostName)) {
            return null;
        }
        return InetAddress.getByName(this.bindHostName);
    }

    public String getExternalAddress() {
        String result = this.bindHostName;
        boolean needCanonicalHostName = false;
        if (result == null || "".equals(result)) {
            needCanonicalHostName = true;
        } else {
            InetSocketAddress isa;
            InetAddress ssAddr;
            ServerSocket ss = this.serverSock;
            if (ss != null && ss.getLocalSocketAddress() instanceof InetSocketAddress && (ssAddr = (isa = (InetSocketAddress)ss.getLocalSocketAddress()).getAddress()) != null && ssAddr.isAnyLocalAddress()) {
                needCanonicalHostName = true;
            }
        }
        if (needCanonicalHostName) {
            try {
                result = SocketCreator.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException ex) {
                throw new IllegalStateException("getLocalHost failed with " + ex);
            }
        }
        return result;
    }

    @Override
    public CacheClientNotifier getCacheClientNotifier() {
        return this.clientNotifier;
    }

    public CachedRegionHelper getCachedRegionHelper() {
        return this.crHelper;
    }

    public ClientHealthMonitor getClientHealthMonitor() {
        return this.healthMonitor;
    }

    public ConnectionListener getConnectionListener() {
        return this.connectionListener;
    }

    public boolean isGatewayReceiver() {
        return this.isGatewayReceiver;
    }

    public List<GatewayTransportFilter> getGatewayTransportFilters() {
        return this.gatewayTransportFilters;
    }

    public static boolean treatAsBindException(SocketException se) {
        if (se instanceof BindException) {
            return true;
        }
        String msg = se.getMessage();
        return msg != null && msg.contains("Invalid argument: listen failed");
    }

    public static boolean isAuthenticationRequired() {
        return isAuthenticationRequired;
    }

    public static boolean isPostAuthzCallbackPresent() {
        return isPostAuthzCallbackPresent;
    }

    public Set<ServerConnection> getAllServerConnections() {
        return Collections.unmodifiableSet(this.allSCs);
    }

    public ServerConnection[] getAllServerConnectionList() {
        return this.allSCList;
    }

    @Override
    public void setTLCommBuffer() {
        if (!this.isSelector()) {
            return;
        }
        Message.setTLCommBuffer(this.takeCommBuffer());
    }

    @Override
    public void releaseTLCommBuffer() {
        if (!this.isSelector()) {
            return;
        }
        this.releaseCommBuffer(Message.setTLCommBuffer(null));
    }

    static {
        DEPRECATED_SELECTOR = Boolean.getBoolean("BridgeServer.SELECTOR");
        emergencyClassesLoaded = false;
        WORKAROUND_SELECTOR_BUG = Boolean.getBoolean("CacheServer.NIO_SELECTOR_WORKAROUND");
    }

    private static class ClientQueueInitializerTask
    implements Runnable {
        private final Socket socket;
        private final boolean isPrimaryServerToClient;
        private final AcceptorImpl acceptor;

        public ClientQueueInitializerTask(Socket socket, boolean isPrimaryServerToClient, AcceptorImpl acceptor) {
            this.socket = socket;
            this.acceptor = acceptor;
            this.isPrimaryServerToClient = isPrimaryServerToClient;
        }

        @Override
        public void run() {
            block3: {
                logger.info(":Cache server: Initializing {} server-to-client communication socket: {}", (Object)(this.isPrimaryServerToClient ? "primary" : "secondary"), (Object)this.socket);
                try {
                    this.acceptor.getCacheClientNotifier().registerClient(this.socket, this.isPrimaryServerToClient, this.acceptor.getAcceptorId(), this.acceptor.isNotifyBySubscription());
                }
                catch (IOException ex) {
                    AcceptorImpl.closeSocket(this.socket);
                    if (!this.acceptor.isRunning() || this.acceptor.loggedAcceptError) break block3;
                    this.acceptor.loggedAcceptError = true;
                    if (ex instanceof SocketTimeoutException) {
                        logger.warn("Cache server: failed accepting client connection due to socket timeout.");
                    }
                    logger.warn("Cache server: failed accepting client connection " + ex, (Throwable)ex);
                }
            }
        }
    }
}

