/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned.rebalance.model;

import java.util.Set;
import java.util.TreeSet;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.partitioned.rebalance.model.AddressComparor;
import org.apache.geode.internal.cache.partitioned.rebalance.model.Bucket;
import org.apache.geode.internal.cache.partitioned.rebalance.model.RefusalReason;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class Member
implements Comparable<Member> {
    private static final Logger logger = LogService.getLogger();
    private final AddressComparor addressComparor;
    private final InternalDistributedMember memberId;
    protected float weight;
    private float totalLoad;
    private float totalPrimaryLoad;
    private long totalBytes;
    private long localMaxMemory;
    private final Set<Bucket> buckets = new TreeSet<Bucket>();
    private final Set<Bucket> primaryBuckets = new TreeSet<Bucket>();
    private final boolean isCritical;
    private final boolean enforceLocalMaxMemory;

    Member(AddressComparor addressComparor, InternalDistributedMember memberId, boolean isCritical, boolean enforceLocalMaxMemory) {
        this.addressComparor = addressComparor;
        this.memberId = memberId;
        this.isCritical = isCritical;
        this.enforceLocalMaxMemory = enforceLocalMaxMemory;
    }

    Member(AddressComparor addressComparor, InternalDistributedMember memberId, float weight, long localMaxMemory, boolean isCritical, boolean enforceLocalMaxMemory) {
        this(addressComparor, memberId, isCritical, enforceLocalMaxMemory);
        this.weight = weight;
        this.localMaxMemory = localMaxMemory;
    }

    public RefusalReason willAcceptBucket(Bucket bucket, Member sourceMember, boolean checkZone) {
        if (this.getBuckets().contains(bucket)) {
            return RefusalReason.ALREADY_HOSTING;
        }
        if (checkZone) {
            boolean sourceIsEquivalent;
            boolean bl = sourceIsEquivalent = sourceMember != null && this.addressComparor.areSameZone(this.getMemberId(), sourceMember.getDistributedMember());
            if (sourceMember == null || !sourceIsEquivalent) {
                for (Member hostingMember : bucket.getMembersHosting()) {
                    if (hostingMember.equals(sourceMember) && !this.addressComparor.enforceUniqueZones() || !this.addressComparor.areSameZone(this.getMemberId(), hostingMember.getDistributedMember())) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Member {} would prefer not to host {} because it is already on another member with the same redundancy zone", (Object)this, (Object)bucket);
                    }
                    return RefusalReason.SAME_ZONE;
                }
            }
        }
        if (this.enforceLocalMaxMemory && this.totalBytes + bucket.getBytes() > this.localMaxMemory) {
            if (logger.isDebugEnabled()) {
                logger.debug("Member {} won't host bucket {} because it doesn't have enough space", (Object)this, (Object)bucket);
            }
            return RefusalReason.LOCAL_MAX_MEMORY_FULL;
        }
        if (this.isCritical) {
            if (logger.isDebugEnabled()) {
                logger.debug("Member {} won't host bucket {} because it's heap is critical", (Object)this, (Object)bucket);
            }
            return RefusalReason.CRITICAL_HEAP;
        }
        return RefusalReason.NONE;
    }

    public boolean addBucket(Bucket bucket) {
        if (this.getBuckets().add(bucket)) {
            bucket.addMember(this);
            this.totalBytes += bucket.getBytes();
            this.totalLoad += bucket.getLoad();
            return true;
        }
        return false;
    }

    public boolean removeBucket(Bucket bucket) {
        if (this.getBuckets().remove(bucket)) {
            bucket.removeMember(this);
            this.totalBytes -= bucket.getBytes();
            this.totalLoad -= bucket.getLoad();
            return true;
        }
        return false;
    }

    public boolean removePrimary(Bucket bucket) {
        if (this.getPrimaryBuckets().remove(bucket)) {
            this.totalPrimaryLoad -= bucket.getPrimaryLoad();
            return true;
        }
        return false;
    }

    public boolean addPrimary(Bucket bucket) {
        if (this.getPrimaryBuckets().add(bucket)) {
            this.totalPrimaryLoad += bucket.getPrimaryLoad();
            return true;
        }
        return false;
    }

    public int getBucketCount() {
        return this.getBuckets().size();
    }

    public long getConfiguredMaxMemory() {
        return this.localMaxMemory;
    }

    public InternalDistributedMember getDistributedMember() {
        return this.getMemberId();
    }

    public int getPrimaryCount() {
        int primaryCount = 0;
        for (Bucket bucket : this.getBuckets()) {
            if (!this.equals(bucket.getPrimary())) continue;
            ++primaryCount;
        }
        return primaryCount;
    }

    public long getSize() {
        return this.totalBytes;
    }

    public float getTotalLoad() {
        return this.totalLoad;
    }

    public float getWeight() {
        return this.weight;
    }

    public String toString() {
        return "Member(id=" + this.getMemberId() + ")";
    }

    public float getPrimaryLoad() {
        return this.totalPrimaryLoad;
    }

    public Set<Bucket> getBuckets() {
        return this.buckets;
    }

    InternalDistributedMember getMemberId() {
        return this.memberId;
    }

    Set<Bucket> getPrimaryBuckets() {
        return this.primaryBuckets;
    }

    void changeLocalMaxMemory(long change) {
        this.localMaxMemory += change;
    }

    void changeTotalLoad(float change) {
        this.totalLoad += change;
    }

    void changePrimaryLoad(float change) {
        this.totalPrimaryLoad += change;
    }

    void changeTotalBytes(float change) {
        this.totalBytes += (long)Math.round(change);
    }

    public int hashCode() {
        return this.memberId.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Member)) {
            return false;
        }
        Member o = (Member)other;
        return this.memberId.equals(o.memberId);
    }

    @Override
    public int compareTo(Member other) {
        return this.memberId.compareTo(other.memberId);
    }
}

