/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.partitioned.PRLocallyDestroyedException;
import org.apache.geode.internal.cache.partitioned.PartitionMessage;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;

public class DumpB2NRegion
extends PartitionMessage {
    private static final Logger logger = LogService.getLogger();
    private int bucketId;
    private boolean onlyReturnPrimaryInfo;

    public DumpB2NRegion() {
    }

    private DumpB2NRegion(Set recipients, int regionId, ReplyProcessor21 processor, int bId, boolean justPrimaryInfo) {
        super(recipients, regionId, processor);
        this.bucketId = bId;
        this.onlyReturnPrimaryInfo = justPrimaryInfo;
    }

    public static DumpB2NResponse send(Set recipients, PartitionedRegion r, int bId, boolean justPrimaryInfo) {
        DumpB2NResponse p = new DumpB2NResponse(r.getSystem(), recipients);
        DumpB2NRegion m = new DumpB2NRegion(recipients, r.getPRId(), p, bId, justPrimaryInfo);
        m.setTransactionDistributed(r.getCache().getTxManager().isDistributed());
        r.getDistributionManager().putOutgoing(m);
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void process(ClusterDistributionManager dm) {
        pr = null;
        finish = System.currentTimeMillis() + 10000L;
        try {
            while (true) lbl-1000:
            // 4 sources

            {
                dm.getCancelCriterion().checkCancelInProgress(null);
                pr = PartitionedRegion.getPRFromId(this.regionId);
                if (pr != null) ** break;
                if (System.currentTimeMillis() > finish) {
                    rex = new ReplyException(new TimeoutException("Waited too long for region to initialize"));
                    this.sendReply(this.getSender(), this.processorId, dm, rex, null, 0L);
                    return;
                }
                interrupted = Thread.interrupted();
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
                finally {
                    if (!interrupted) continue;
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            pr.waitForData();
            super.process(dm);
        }
        catch (CancelException e) {
            this.sendReply(this.sender, this.processorId, dm, new ReplyException(e), pr, 0L);
        }
        catch (PRLocallyDestroyedException e) {
            this.sendReply(this.sender, this.processorId, dm, new ReplyException(e), pr, 0L);
            return;
        }
        catch (RegionDestroyedException rde) {
            this.sendReply(this.sender, this.processorId, dm, new ReplyException(rde), pr, 0L);
            return;
        }
    }

    @Override
    protected boolean operateOnPartitionedRegion(ClusterDistributionManager dm, PartitionedRegion pr, long startTime) throws CacheException {
        PrimaryInfo pinfo = null;
        if (this.onlyReturnPrimaryInfo) {
            pinfo = new PrimaryInfo(pr.getRegionAdvisor().getBucket(this.bucketId).isHosting(), pr.getRegionAdvisor().isPrimaryForBucket(this.bucketId), "");
        } else {
            pr.dumpB2NForBucket(this.bucketId);
        }
        DumpB2NReplyMessage.send(this.getSender(), this.getProcessorId(), dm, pinfo);
        return false;
    }

    @Override
    public int getDSFID() {
        return -98;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.bucketId = in.readInt();
        this.onlyReturnPrimaryInfo = in.readBoolean();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.bucketId);
        out.writeBoolean(this.onlyReturnPrimaryInfo);
    }

    @Override
    protected void appendFields(StringBuilder buff) {
        super.appendFields(buff);
        buff.append(" bucketId=").append(this.bucketId).append(" primaryInfoOnly=").append(this.onlyReturnPrimaryInfo);
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private static class PrimaryInfo
    implements Serializable {
        private static final long serialVersionUID = 6334695270795306178L;
        public final boolean isHosting;
        public final boolean isPrimary;
        public final String hostToken;

        PrimaryInfo(boolean isHosting, boolean isPrimary, String hToken) {
            this.isHosting = isHosting;
            this.isPrimary = isPrimary;
            this.hostToken = hToken;
            if (this.isPrimary) {
                Assert.assertTrue(this.isHosting);
            }
        }
    }

    public static class DumpB2NResponse
    extends PartitionMessage.PartitionResponse {
        public final ArrayList primaryInfos = new ArrayList();

        public DumpB2NResponse(InternalDistributedSystem dm, Set initMembers) {
            super(dm, initMembers);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(DistributionMessage msg) {
            if (msg instanceof DumpB2NReplyMessage) {
                DumpB2NReplyMessage reply = (DumpB2NReplyMessage)msg;
                if (reply.getPrimaryInfo() != null && reply.getPrimaryInfo().isHosting) {
                    Object[] newBucketHost = new Object[]{reply.getSender(), reply.getPrimaryInfo().isPrimary, reply.getPrimaryInfo().hostToken};
                    ArrayList arrayList = this.primaryInfos;
                    synchronized (arrayList) {
                        this.primaryInfos.add(newBucketHost);
                    }
                }
                if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                    logger.trace(LogMarker.DM_VERBOSE, "DumpB2NResponse got a primaryInfo {} from {}", (Object)reply.getPrimaryInfo(), (Object)reply.getSender());
                }
            }
            super.process(msg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List waitForPrimaryInfos() throws ForceReattemptException {
            try {
                this.waitForCacheException();
            }
            catch (ForceReattemptException e) {
                logger.debug("B2NResponse got ForceReattemptException; rethrowing {}", (Object)e.getMessage(), (Object)e);
                throw e;
            }
            catch (CacheException e) {
                logger.debug("B2NResponse got remote CacheException, throwing ForceReattemptException. {}", (Object)e.getMessage(), (Object)e);
                throw new ForceReattemptException("B2NResponse got remote CacheException, throwing ForceReattemptException.", e);
            }
            ArrayList arrayList = this.primaryInfos;
            synchronized (arrayList) {
                return this.primaryInfos;
            }
        }
    }

    public static class DumpB2NReplyMessage
    extends ReplyMessage {
        private PrimaryInfo primaryInfo;

        public DumpB2NReplyMessage() {
        }

        private DumpB2NReplyMessage(int procid, PrimaryInfo pinfo) {
            this.setProcessorId(procid);
            this.primaryInfo = pinfo;
        }

        public static void send(InternalDistributedMember recipient, int processorId, DistributionManager dm, PrimaryInfo pinfo) {
            DumpB2NReplyMessage m = new DumpB2NReplyMessage(processorId, pinfo);
            m.setRecipient(recipient);
            dm.putOutgoing(m);
        }

        @Override
        public void process(DistributionManager dm, ReplyProcessor21 processor) {
            long startTime = this.getTimestamp();
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "DumpB2NReplyMessage process invoking reply processor with processorId: {}", (Object)this.processorId);
            }
            if (processor == null) {
                if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                    logger.trace(LogMarker.DM_VERBOSE, "DumpB2NReplyMessage processor not found");
                }
                return;
            }
            processor.process(this);
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "{} processed {}", (Object)processor, (Object)this);
            }
            dm.getStats().incReplyMessageTime(DistributionStats.getStatTime() - startTime);
        }

        public PrimaryInfo getPrimaryInfo() {
            return this.primaryInfo;
        }

        @Override
        public int getDSFID() {
            return -97;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.primaryInfo = (PrimaryInfo)DataSerializer.readObject(in);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeObject(this.primaryInfo, out);
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("DumpB2NReplyMessage ");
            sb.append(this.processorId);
            sb.append(" from ");
            sb.append(this.getSender());
            ReplyException ex = this.getException();
            if (ex != null) {
                sb.append(" with exception ");
                sb.append(ex);
            }
            return sb.toString();
        }
    }
}

