/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.map;

import java.util.Set;
import org.apache.geode.cache.CacheWriter;
import org.apache.geode.cache.DiskAccessException;
import org.apache.geode.cache.Operation;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EntryEventSerialization;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.RegionClearedException;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.ValueComparisonHelper;
import org.apache.geode.internal.cache.entries.AbstractRegionEntry;
import org.apache.geode.internal.cache.map.AbstractRegionMapPut;
import org.apache.geode.internal.cache.map.CacheModificationLock;
import org.apache.geode.internal.cache.map.FocusedRegionMap;
import org.apache.geode.internal.cache.versions.ConcurrentCacheModificationException;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.cache.wan.GatewaySenderEventImpl;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.offheap.OffHeapHelper;
import org.apache.geode.internal.offheap.ReferenceCountHelper;
import org.apache.geode.internal.sequencelog.EntryLogger;
import org.apache.logging.log4j.Logger;

public class RegionMapPut
extends AbstractRegionMapPut {
    protected static final Logger logger = LogService.getLogger();
    private final CacheModificationLock cacheModificationLock;
    private final EntryEventSerialization entryEventSerialization;
    private final boolean ifNew;
    private final boolean ifOld;
    private final boolean overwriteDestroyed;
    private boolean overwritePutIfAbsent;
    private final boolean requireOldValue;
    private final boolean retrieveOldValueForDelta;
    private final boolean replaceOnClient;
    private final boolean onlyExisting;
    private final boolean cacheWrite;
    private final CacheWriter cacheWriter;
    private final Set netWriteRecipients;
    private final Object expectedOldValue;
    private Object oldValueForDelta;

    public RegionMapPut(FocusedRegionMap focusedRegionMap, InternalRegion owner, CacheModificationLock cacheModificationLock, EntryEventSerialization entryEventSerialization, EntryEventImpl event, boolean ifNew, boolean ifOld, boolean overwriteDestroyed, boolean requireOldValue, Object expectedOldValue) {
        super(focusedRegionMap, owner, event);
        this.cacheModificationLock = cacheModificationLock;
        this.entryEventSerialization = entryEventSerialization;
        this.ifNew = ifNew;
        this.ifOld = ifOld;
        this.overwriteDestroyed = overwriteDestroyed;
        this.requireOldValue = requireOldValue;
        this.retrieveOldValueForDelta = event.getDeltaBytes() != null && event.getRawNewValue() == null;
        this.replaceOnClient = event.getOperation() == Operation.REPLACE && owner.hasServerProxy();
        this.onlyExisting = ifOld && !this.isReplaceOnClient();
        this.cacheWriter = owner.basicGetWriter();
        this.cacheWrite = !event.isOriginRemote() && !event.isNetSearch() && event.isGenerateCallbacks() && (this.getCacheWriter() != null || owner.hasServerProxy() || owner.getScope().isDistributed());
        this.expectedOldValue = expectedOldValue;
        this.netWriteRecipients = this.isCacheWrite() && this.getCacheWriter() == null ? owner.adviseNetWrite() : null;
    }

    private boolean isIfNew() {
        return this.ifNew;
    }

    private boolean isIfOld() {
        return this.ifOld;
    }

    private boolean isOverwriteDestroyed() {
        return this.overwriteDestroyed;
    }

    private boolean isRequireOldValue() {
        return this.requireOldValue;
    }

    boolean isRetrieveOldValueForDelta() {
        return this.retrieveOldValueForDelta;
    }

    boolean isReplaceOnClient() {
        return this.replaceOnClient;
    }

    boolean isOverwritePutIfAbsent() {
        return this.overwritePutIfAbsent;
    }

    boolean isCacheWrite() {
        return this.cacheWrite;
    }

    private CacheWriter getCacheWriter() {
        return this.cacheWriter;
    }

    private Set getNetWriteRecipients() {
        return this.netWriteRecipients;
    }

    private Object getExpectedOldValue() {
        return this.expectedOldValue;
    }

    private Object getOldValueForDelta() {
        return this.oldValueForDelta;
    }

    private void setOldValueForDelta(Object value) {
        this.oldValueForDelta = value;
    }

    @Override
    protected boolean isOnlyExisting() {
        return this.onlyExisting;
    }

    @Override
    protected boolean entryExists(RegionEntry regionEntry) {
        return regionEntry != null && !regionEntry.isTombstone();
    }

    @Override
    protected void serializeNewValueIfNeeded() {
        this.entryEventSerialization.serializeNewValueIfNeeded(this.getOwner(), this.getEvent());
    }

    @Override
    protected void runWhileLockedForCacheModification(Runnable r) {
        this.cacheModificationLock.lockForCacheModification(this.getOwner(), this.getEvent());
        try {
            super.runWhileLockedForCacheModification(r);
        }
        finally {
            this.cacheModificationLock.releaseCacheModificationLock(this.getOwner(), this.getEvent());
        }
    }

    @Override
    protected void setOldValueForDelta() {
        if (this.isRetrieveOldValueForDelta()) {
            this.getRegionMap().runWhileEvictionDisabled(() -> this.setOldValueForDelta(this.getRegionEntry().getValue(this.getOwner())));
        }
    }

    @Override
    protected void setOldValueInEvent() {
        EntryEventImpl event = this.getEvent();
        RegionEntry re = this.getRegionEntry();
        event.setRegionEntry(re);
        if (event.getOperation().guaranteesOldValue()) {
            this.setOldValueEvenIfFaultedOut();
        } else if (this.isCacheWrite() || this.isRequireOldValue()) {
            this.setOldValueIfNotFaultedOut();
        } else {
            Object existingValue = re.getValue();
            if (existingValue instanceof GatewaySenderEventImpl) {
                event.setOldValue(existingValue, true);
            }
        }
    }

    private void setOldValueIfNotFaultedOut() {
        EntryEventImpl event = this.getEvent();
        ReferenceCountHelper.skipRefCountTracking();
        Object oldValueInVM = this.getRegionEntry().getValueRetain(event.getRegion(), true);
        if (oldValueInVM == null) {
            oldValueInVM = Token.NOT_AVAILABLE;
        }
        ReferenceCountHelper.unskipRefCountTracking();
        try {
            event.setOldValue(oldValueInVM);
        }
        finally {
            OffHeapHelper.releaseWithNoTracking(oldValueInVM);
        }
    }

    private void setOldValueEvenIfFaultedOut() {
        EntryEventImpl event = this.getEvent();
        ReferenceCountHelper.skipRefCountTracking();
        Object oldValueInVMOrDisk = this.getRegionEntry().getValueOffHeapOrDiskWithoutFaultIn(event.getRegion());
        ReferenceCountHelper.unskipRefCountTracking();
        try {
            event.setOldValue(oldValueInVMOrDisk, true);
        }
        finally {
            OffHeapHelper.releaseWithNoTracking(oldValueInVMOrDisk);
        }
    }

    @Override
    protected void unsetOldValueForDelta() {
        OffHeapHelper.release(this.getOldValueForDelta());
        this.setOldValueForDelta(null);
        if (this.isOverwritePutIfAbsent()) {
            this.getEvent().setOldValue(null);
        }
    }

    @Override
    protected void invokeCacheWriter() {
        EntryEventImpl event = this.getEvent();
        if (this.getOwner().isInitialized() && this.isCacheWrite()) {
            if (!this.isReplaceOnClient()) {
                if (this.getRegionEntry().isDestroyedOrRemoved()) {
                    event.makeCreate();
                } else {
                    event.makeUpdate();
                }
            }
            this.getOwner().cacheWriteBeforePut(event, this.getNetWriteRecipients(), this.getCacheWriter(), this.isRequireOldValue(), this.getExpectedOldValue());
        }
        if (!this.getOwner().isInitialized() && !this.isCacheWrite()) {
            event.oldValueNotAvailable();
        }
    }

    @Override
    protected void createOrUpdateEntry() {
        try {
            if (this.isUpdate()) {
                this.updateEntry();
            } else {
                this.createEntry();
            }
        }
        catch (RegionClearedException rce) {
            this.setClearOccurred(true);
        }
        catch (ConcurrentCacheModificationException ccme) {
            EntryEventImpl event = this.getEvent();
            VersionTag tag = event.getVersionTag();
            if (tag != null && tag.isTimeStampUpdated()) {
                this.getOwner().notifyTimestampsToGateways(event);
            }
            throw ccme;
        }
    }

    @Override
    protected void doBeforeCompletionActions() {
        EntryEventImpl event = this.getEvent();
        this.getOwner().recordEvent(event);
        if (!this.isOwnerInitialized()) {
            event.inhibitCacheListenerNotification(true);
        }
        this.updateLru();
        RegionEntry re = this.getRegionEntry();
        long lastModTime = this.getOwner().basicPutPart2(event, re, this.isOwnerInitialized(), this.getLastModifiedTime(), this.isClearOccurred());
        this.setLastModifiedTime(lastModTime);
    }

    private void updateLru() {
        if (!this.isClearOccurred()) {
            if (this.getEvent().getOperation().isCreate()) {
                this.getRegionMap().lruEntryCreate(this.getRegionEntry());
            } else {
                this.getRegionMap().lruEntryUpdate(this.getRegionEntry());
            }
        }
    }

    @Override
    protected boolean shouldCreatedEntryBeRemoved() {
        return this.getRegionEntry().getValueAsToken() == Token.REMOVED_PHASE1;
    }

    @Override
    protected void doAfterCompletionActions(boolean disabledEviction) {
        try {
            if (this.isCompleted()) {
                boolean invokeListeners = this.getEvent().basicGetNewValue() != Token.TOMBSTONE;
                this.getOwner().basicPutPart3(this.getEvent(), this.getRegionEntry(), this.isOwnerInitialized(), this.getLastModifiedTime(), invokeListeners, this.isIfNew(), this.isIfOld(), this.getExpectedOldValue(), this.isRequireOldValue());
            }
        }
        finally {
            this.finishEviction(disabledEviction);
        }
    }

    private void finishEviction(boolean disabledEviction) {
        if (disabledEviction) {
            this.getRegionMap().enableLruUpdateCallback();
            if (this.isCompleted()) {
                this.lruUpdateCallbackIfNotCleared();
            } else {
                this.getRegionMap().resetThreadLocals();
            }
        }
    }

    private void lruUpdateCallbackIfNotCleared() {
        if (!this.isClearOccurred()) {
            try {
                this.getRegionMap().lruUpdateCallback();
            }
            catch (DiskAccessException dae) {
                this.getOwner().handleDiskAccessException(dae);
                throw dae;
            }
        }
    }

    private boolean isUpdate() {
        if (this.isCacheWrite() && this.getEvent().getOperation().isUpdate()) {
            return true;
        }
        if (this.isReplaceOnClient()) {
            return true;
        }
        return !this.getRegionEntry().isRemoved();
    }

    @Override
    protected boolean checkPreconditions() {
        if (!this.checkUpdatePreconditions()) {
            return false;
        }
        if (!this.checkUninitializedRegionPreconditions()) {
            return false;
        }
        if (!this.checkCreatePreconditions()) {
            return false;
        }
        return this.checkExpectedOldValuePrecondition();
    }

    private boolean checkUpdatePreconditions() {
        if (this.isIfOld()) {
            EntryEventImpl event = this.getEvent();
            RegionEntry re = this.getRegionEntry();
            if (re.isTombstone() && event.getVersionTag() != null) {
                this.getRegionMap().processVersionTag(re, event);
                try {
                    re.setValue(this.getOwner(), Token.TOMBSTONE);
                }
                catch (RegionClearedException regionClearedException) {
                    // empty catch block
                }
                this.getOwner().rescheduleTombstone(re, re.getVersionStamp().asVersionTag());
                return false;
            }
            if (re.isRemoved() && !this.isReplaceOnClient()) {
                return false;
            }
        }
        return true;
    }

    private boolean checkUninitializedRegionPreconditions() {
        Token oldValueInVM;
        if (!(this.getOwner().isInitialized() || this.isOverwriteDestroyed() || (oldValueInVM = this.getRegionEntry().getValueAsToken()) != Token.DESTROYED && oldValueInVM != Token.TOMBSTONE)) {
            this.getEvent().setOldValueDestroyedToken();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkCreatePreconditions() {
        if (this.isIfNew() && !this.getRegionEntry().isDestroyedOrRemoved()) {
            EntryEventImpl event = this.getEvent();
            if (this.getOwner().getConcurrencyChecksEnabled() && event.getOperation() == Operation.PUT_IF_ABSENT && !event.hasValidVersionTag() && event.isPossibleDuplicate()) {
                Object retainedValue = this.getRegionEntry().getValueRetain(this.getOwner());
                try {
                    if (ValueComparisonHelper.checkEquals(retainedValue, this.getEvent().getRawNewValue(), this.isCompressedOffHeap(event), (InternalCache)this.getOwner().getCache())) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("retried putIfAbsent found same value already in cache - allowing the operation.  entry={}; event={}", (Object)this.getRegionEntry(), (Object)this.getEvent());
                        }
                        this.overwritePutIfAbsent = true;
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    OffHeapHelper.release(retainedValue);
                }
            }
            return false;
        }
        return true;
    }

    private boolean isCompressedOffHeap(EntryEventImpl event) {
        return event.getRegion().getAttributes().getOffHeap() && event.getRegion().getAttributes().getCompressor() != null;
    }

    private boolean checkExpectedOldValuePrecondition() {
        EntryEventImpl event = this.getEvent();
        if (this.getExpectedOldValue() != null && !this.isReplaceOnClient()) {
            assert (event.getOperation().guaranteesOldValue());
            Object v = event.getRawOldValue();
            if (!AbstractRegionEntry.checkExpectedOldValue(this.getExpectedOldValue(), v, event.getRegion())) {
                return false;
            }
        }
        return true;
    }

    private void createEntry() throws RegionClearedException {
        EntryEventImpl event = this.getEvent();
        RegionEntry re = this.getRegionEntry();
        boolean wasTombstone = re.isTombstone();
        this.getRegionMap().processVersionTag(re, event);
        event.putNewEntry(this.getOwner(), re);
        this.updateSize(0, false, wasTombstone);
        if (!event.getRegion().isInitialized()) {
            this.getOwner().getImageState().removeDestroyedEntry(event.getKey());
        }
    }

    private void updateEntry() throws RegionClearedException {
        EntryEventImpl event = this.getEvent();
        RegionEntry re = this.getRegionEntry();
        boolean wasTombstone = re.isTombstone();
        int oldSize = event.getRegion().calculateRegionEntryValueSize(re);
        this.getRegionMap().processVersionTag(re, event);
        event.putExistingEntry(event.getRegion(), re, this.isRequireOldValue(), this.getOldValueForDelta());
        EntryLogger.logPut(event);
        this.updateSize(oldSize, true, wasTombstone);
    }

    private void updateSize(int oldSize, boolean isUpdate, boolean wasTombstone) {
        EntryEventImpl event = this.getEvent();
        Object key = event.getKey();
        int newBucketSize = event.getNewValueBucketSize();
        if (isUpdate && !wasTombstone) {
            this.getOwner().updateSizeOnPut(key, oldSize, newBucketSize);
        } else {
            this.getOwner().updateSizeOnCreate(key, newBucketSize);
            if (!wasTombstone) {
                this.getOwner().getCachePerfStats().incEntryCount(1);
            }
        }
    }
}

