/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.locks;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.distributed.internal.locks.LockGrantorId;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.DataSerializableFixedID;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.locks.TXLockId;

public class TXLockIdImpl
implements TXLockId,
DataSerializableFixedID {
    private static final long serialVersionUID = 8579214625084490134L;
    private InternalDistributedMember memberId;
    @MakeNotStatic
    private static int txCount = 0;
    private int id;
    private transient LockGrantorId grantedBy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TXLockIdImpl(InternalDistributedMember memberId) {
        this.memberId = memberId;
        Class<TXLockIdImpl> clazz = TXLockIdImpl.class;
        synchronized (TXLockIdImpl.class) {
            this.id = txCount++;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public int getCount() {
        return this.id;
    }

    @Override
    public InternalDistributedMember getMemberId() {
        return this.memberId;
    }

    @Override
    public void setLockGrantorId(LockGrantorId lockGrantorId) {
        this.grantedBy = lockGrantorId;
    }

    @Override
    public LockGrantorId getLockGrantorId() {
        return this.grantedBy;
    }

    public int hashCode() {
        int result = 17;
        int mult = 37;
        result = 37 * result + (this.memberId == null ? 0 : this.memberId.hashCode());
        result = 37 * result + this.id;
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof TXLockIdImpl)) {
            return false;
        }
        TXLockIdImpl that = (TXLockIdImpl)other;
        if (!(this.memberId == that.memberId || this.memberId != null && this.memberId.equals(that.memberId))) {
            return false;
        }
        return this.id == that.id;
    }

    public String toString() {
        return "TXLockId: " + this.memberId + "-" + this.id;
    }

    public TXLockIdImpl() {
    }

    @Override
    public int getDSFID() {
        return 121;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.memberId = (InternalDistributedMember)DataSerializer.readObject(in);
        this.id = in.readInt();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeObject(this.memberId, out);
        out.writeInt(this.id);
    }

    public static TXLockIdImpl createFromData(DataInput in) throws IOException, ClassNotFoundException {
        TXLockIdImpl result = new TXLockIdImpl();
        result.fromData(in);
        return result;
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }
}

