/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.execute;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.geode.cache.TransactionDataNotColocatedException;
import org.apache.geode.cache.TransactionException;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.execute.AbstractExecution;
import org.apache.geode.internal.cache.execute.DefaultResultCollector;
import org.apache.geode.internal.cache.execute.FunctionContextImpl;
import org.apache.geode.internal.cache.execute.InternalExecution;
import org.apache.geode.internal.cache.execute.LocalResultCollector;
import org.apache.geode.internal.cache.execute.MemberFunctionResultSender;
import org.apache.geode.internal.cache.execute.MemberFunctionResultWaiter;
import org.apache.geode.internal.cache.execute.MemberMappedArgument;
import org.apache.geode.internal.cache.execute.NoResult;
import org.apache.geode.internal.cache.execute.ServerToClientFunctionResultSender;

public class MemberFunctionExecutor
extends AbstractExecution {
    protected InternalDistributedSystem ds;
    protected Set members;
    private ServerToClientFunctionResultSender sender;

    public MemberFunctionExecutor(DistributedSystem s) {
        this.ds = (InternalDistributedSystem)s;
        this.members = this.ds.getDistributionManager().getNormalDistributionManagerIds();
    }

    public MemberFunctionExecutor(DistributedSystem s, DistributedMember m) {
        this.ds = (InternalDistributedSystem)s;
        this.members = Collections.singleton(m);
    }

    public MemberFunctionExecutor(DistributedSystem s, Set m) {
        this.ds = (InternalDistributedSystem)s;
        this.members = m;
    }

    public MemberFunctionExecutor(DistributedSystem s, Set m, ServerToClientFunctionResultSender sender) {
        this(s, m);
        this.sender = sender;
    }

    private MemberFunctionExecutor(MemberFunctionExecutor memFunctionExecutor) {
        super(memFunctionExecutor);
        this.ds = memFunctionExecutor.ds;
        this.members = new HashSet();
        this.members.addAll(memFunctionExecutor.members);
        this.sender = memFunctionExecutor.sender;
    }

    private MemberFunctionExecutor(MemberFunctionExecutor memberFunctionExecutor, MemberMappedArgument argument) {
        this(memberFunctionExecutor);
        this.memberMappedArg = argument;
        this.isMemberMappedArgument = true;
    }

    private MemberFunctionExecutor(MemberFunctionExecutor memberFunctionExecutor, ResultCollector rs) {
        this(memberFunctionExecutor);
        this.rc = rs;
    }

    private MemberFunctionExecutor(MemberFunctionExecutor memberFunctionExecutor, Object arguments) {
        this(memberFunctionExecutor);
        this.args = arguments;
    }

    private ResultCollector executeFunction(Function function, ResultCollector resultCollector) {
        DistributionManager dm = this.ds.getDistributionManager();
        HashSet<InternalDistributedMember> dest = new HashSet<InternalDistributedMember>(this.members);
        if (dest.isEmpty()) {
            throw new FunctionException(String.format("No member found for executing function : %s.", function.getId()));
        }
        this.validateExecution(function, dest);
        this.setExecutionNodes(dest);
        InternalDistributedMember localVM = this.ds.getDistributionManager().getDistributionManagerId();
        LocalResultCollector<?, ?> localRC = this.getLocalResultCollector(function, resultCollector);
        boolean remoteOnly = false;
        boolean localOnly = false;
        if (!dest.contains(localVM)) {
            remoteOnly = true;
        }
        if (dest.size() == 1 && dest.contains(localVM)) {
            localOnly = true;
        }
        MemberFunctionResultSender resultSender = new MemberFunctionResultSender(dm, localRC, function, localOnly, remoteOnly, this.sender);
        if (dest.contains(localVM)) {
            dest.remove(localVM);
            boolean isTx = false;
            GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
            if (cache != null) {
                isTx = cache.getTxManager().getTXState() != null;
            }
            FunctionContextImpl context = new FunctionContextImpl(cache, function.getId(), this.getArgumentsForMember(localVM.getId()), resultSender);
            this.executeFunctionOnLocalNode(function, context, resultSender, dm, isTx);
        }
        if (!dest.isEmpty()) {
            HashMap<InternalDistributedMember, Object> memberArgs = new HashMap<InternalDistributedMember, Object>();
            for (InternalDistributedMember recip : dest) {
                memberArgs.put(recip, this.getArgumentsForMember(recip.getId()));
            }
            Assert.assertTrue(memberArgs.size() == dest.size());
            MemberFunctionResultWaiter resultReceiver = new MemberFunctionResultWaiter(this.ds, localRC, function, memberArgs, dest, resultSender);
            ResultCollector reply = resultReceiver.getFunctionResultFrom(dest, function, this);
            return reply;
        }
        return localRC;
    }

    @Override
    public void validateExecution(Function function, Set dest) {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache == null) {
            return;
        }
        if (cache.getTxManager().getTXState() != null) {
            if (dest.size() > 1) {
                throw new TransactionException("Function inside a transaction cannot execute on more than one node");
            }
            assert (dest.size() == 1);
            if (cache.isClient()) {
                throw new UnsupportedOperationException("Client function execution on members is not supported with transaction");
            }
            DistributedMember funcTarget = (DistributedMember)dest.iterator().next();
            DistributedMember target = cache.getTxManager().getTXState().getTarget();
            if (target == null) {
                cache.getTxManager().getTXState().setTarget(funcTarget);
            } else if (!target.equals(funcTarget)) {
                throw new TransactionDataNotColocatedException("Function execution is not colocated with transaction");
            }
        }
        cache.getInternalResourceManager().getHeapMonitor().checkForLowMemory(function, dest);
    }

    @Override
    protected ResultCollector executeFunction(Function function) {
        if (function.hasResult()) {
            ResultCollector rc = this.rc;
            if (rc == null) {
                rc = new DefaultResultCollector();
            }
            return this.executeFunction(function, rc);
        }
        this.executeFunction(function, null);
        return new NoResult();
    }

    public Execution setArguments(Object args) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("The input %s for the execute function request is null", "args"));
        }
        return new MemberFunctionExecutor(this, args);
    }

    public Execution withArgs(Object args) {
        return this.setArguments(args);
    }

    public Execution withCollector(ResultCollector rs) {
        if (rs == null) {
            throw new IllegalArgumentException(String.format("The input %s for the execute function request is null", "Result Collector"));
        }
        return new MemberFunctionExecutor(this, rs);
    }

    public Execution withFilter(Set filter) {
        throw new FunctionException(String.format("Cannot specify %s for data independent functions", "filter"));
    }

    @Override
    public InternalExecution withBucketFilter(Set<Integer> bucketIDs) {
        throw new FunctionException(String.format("Cannot specify %s for data independent functions", "bucket as filter"));
    }

    @Override
    public InternalExecution withMemberMappedArgument(MemberMappedArgument argument) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("The input %s for the execute function request is null", "MemberMappedArgs"));
        }
        return new MemberFunctionExecutor(this, argument);
    }

    @Override
    public boolean isMemberMappedArgument() {
        return this.isMemberMappedArgument;
    }

    @Override
    public Object getArgumentsForMember(String memberId) {
        if (!this.isMemberMappedArgument) {
            return this.args;
        }
        return this.memberMappedArg.getArgumentsForMember(memberId);
    }

    @Override
    public MemberMappedArgument getMemberMappedArgument() {
        return this.memberMappedArg;
    }

    public ServerToClientFunctionResultSender getServerResultSender() {
        return this.sender;
    }
}

