/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.eviction;

import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.distributed.internal.QueueStatHelper;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.control.HeapMemoryMonitor;
import org.apache.geode.internal.cache.control.InternalResourceManager;
import org.apache.geode.internal.cache.control.MemoryEvent;
import org.apache.geode.internal.cache.control.ResourceListener;
import org.apache.geode.internal.cache.eviction.RegionEvictorTask;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.LoggingExecutors;
import org.apache.logging.log4j.Logger;

public class HeapEvictor
implements ResourceListener<MemoryEvent> {
    private static final Logger logger = LogService.getLogger();
    public static final int MAX_EVICTOR_THREADS = Integer.getInteger("gemfire.HeapLRUCapacityController.MAX_EVICTOR_THREADS", Runtime.getRuntime().availableProcessors() * 4) + 1;
    public static final boolean EVICT_HIGH_ENTRY_COUNT_BUCKETS_FIRST = Boolean.valueOf(System.getProperty("gemfire.HeapLRUCapacityController.evictHighEntryCountBucketsFirst", "true"));
    public static final int MINIMUM_ENTRIES_PER_BUCKET = Integer.getInteger("gemfire.HeapLRUCapacityController.inlineEvictionThreshold", 0);
    public static final int BUCKET_SORTING_INTERVAL = Integer.getInteger("gemfire.HeapLRUCapacityController.higherEntryCountBucketCalculationInterval", 100);
    private static final boolean DISABLE_HEAP_EVICTOR_THREAD_POOL = Boolean.getBoolean("gemfire.HeapLRUCapacityController.DISABLE_HEAP_EVICTOR_THREAD_POOL");
    private static final long TOTAL_BYTES_TO_EVICT_FROM_HEAP = HeapEvictor.setTotalBytesToEvictFromHeap();
    private static final String EVICTOR_THREAD_NAME = "EvictorThread";
    private final Object evictionLock = new Object();
    private final AtomicBoolean mustEvict = new AtomicBoolean(false);
    private final List<Integer> testTaskSetSizes = new ArrayList<Integer>();
    private final ExecutorService evictorThreadPool;
    private final InternalCache cache;
    private final AtomicBoolean isRunning = new AtomicBoolean(true);
    private volatile int testAbortAfterLoopCount = Integer.MAX_VALUE;
    private volatile int numEvictionLoopsCompleted = 0;
    private volatile int numFastLoops;

    public HeapEvictor(InternalCache cache) {
        this(cache, EVICTOR_THREAD_NAME);
    }

    public HeapEvictor(InternalCache cache, String threadName) {
        this.cache = cache;
        if (!DISABLE_HEAP_EVICTOR_THREAD_POOL) {
            QueueStatHelper poolStats = this.cache.getCachePerfStats().getEvictionQueueStatHelper();
            this.evictorThreadPool = LoggingExecutors.newFixedThreadPoolWithTimeout(threadName, MAX_EVICTOR_THREADS, 15, poolStats);
        } else {
            this.evictorThreadPool = null;
        }
    }

    protected InternalCache cache() {
        return this.cache;
    }

    protected boolean includePartitionedRegion(PartitionedRegion region) {
        return region.getEvictionAttributes().getAlgorithm().isLRUHeap() && region.getDataStore() != null && !region.getAttributes().getOffHeap();
    }

    protected boolean includeLocalRegion(LocalRegion region) {
        return region.getEvictionAttributes().getAlgorithm().isLRUHeap() && !region.getAttributes().getOffHeap();
    }

    private List<LocalRegion> getAllRegionList() {
        ArrayList<LocalRegion> allRegionsList = new ArrayList<LocalRegion>();
        InternalResourceManager resourceManager = (InternalResourceManager)this.cache.getResourceManager();
        for (ResourceListener listener : resourceManager.getResourceListeners(this.getResourceType())) {
            LocalRegion lr;
            if (listener instanceof PartitionedRegion) {
                PartitionedRegion partitionedRegion = (PartitionedRegion)listener;
                if (!this.includePartitionedRegion(partitionedRegion)) continue;
                allRegionsList.addAll(partitionedRegion.getDataStore().getAllLocalBucketRegions());
                continue;
            }
            if (!(listener instanceof LocalRegion) || !this.includeLocalRegion(lr = (LocalRegion)listener)) continue;
            allRegionsList.add(lr);
        }
        if (MINIMUM_ENTRIES_PER_BUCKET > 0) {
            Iterator iterator = allRegionsList.iterator();
            while (iterator.hasNext()) {
                LocalRegion region = (LocalRegion)iterator.next();
                if (!(region instanceof BucketRegion) || ((BucketRegion)region).getNumEntriesInVM() > (long)MINIMUM_ENTRIES_PER_BUCKET) continue;
                iterator.remove();
            }
        }
        return allRegionsList;
    }

    private List<LocalRegion> getAllSortedRegionList() {
        List<LocalRegion> allRegionList = this.getAllRegionList();
        Object2LongOpenHashMap sizes = new Object2LongOpenHashMap(allRegionList.size());
        for (LocalRegion region : allRegionList) {
            long size = region instanceof BucketRegion ? (long)((BucketRegion)region).getSizeForEviction() : (long)region.size();
            sizes.put((Object)region, size);
        }
        allRegionList.sort((region1, region2) -> {
            long numEntries2;
            long numEntries1 = sizes.get(region1);
            if (numEntries1 > (numEntries2 = sizes.get(region2).longValue())) {
                return -1;
            }
            if (numEntries1 < numEntries2) {
                return 1;
            }
            return 0;
        });
        return allRegionList;
    }

    private void executeInThreadPool(Runnable task) {
        block2: {
            try {
                this.evictorThreadPool.execute(task);
            }
            catch (RejectedExecutionException e) {
                if (!this.isRunning()) break block2;
                throw e;
            }
        }
    }

    public ExecutorService getEvictorThreadPool() {
        if (this.isRunning()) {
            return this.evictorThreadPool;
        }
        return null;
    }

    private void createAndSubmitWeightedRegionEvictionTasks() {
        List<LocalRegion> allRegionList = this.getAllSortedRegionList();
        float numEntriesInVM = 0.0f;
        for (LocalRegion region : allRegionList) {
            if (region instanceof BucketRegion) {
                numEntriesInVM += (float)((BucketRegion)region).getSizeForEviction();
                continue;
            }
            numEntriesInVM += (float)region.getRegionMap().sizeInVM();
        }
        for (LocalRegion region : allRegionList) {
            float regionEntryCount = region instanceof BucketRegion ? (float)((BucketRegion)region).getSizeForEviction() : (float)region.getRegionMap().sizeInVM();
            float percentage = regionEntryCount / numEntriesInVM;
            long bytesToEvictPerTask = (long)((float)this.getTotalBytesToEvict() * percentage);
            ArrayList<LocalRegion> regionsForSingleTask = new ArrayList<LocalRegion>(1);
            regionsForSingleTask.add(region);
            if (!this.mustEvict()) break;
            this.executeInThreadPool(new RegionEvictorTask(this.cache.getCachePerfStats(), regionsForSingleTask, this, bytesToEvictPerTask));
        }
    }

    private Set<RegionEvictorTask> createRegionEvictionTasks() {
        if (this.getEvictorThreadPool() == null) {
            return Collections.emptySet();
        }
        int threadsAvailable = MAX_EVICTOR_THREADS;
        long bytesToEvictPerTask = this.getTotalBytesToEvict() / (long)threadsAvailable;
        List<LocalRegion> allRegionList = this.getAllRegionList();
        if (allRegionList.isEmpty()) {
            return Collections.emptySet();
        }
        Collections.shuffle(allRegionList);
        int allRegionSetSize = allRegionList.size();
        HashSet<RegionEvictorTask> evictorTaskSet = new HashSet<RegionEvictorTask>();
        if (allRegionSetSize <= threadsAvailable) {
            for (LocalRegion region : allRegionList) {
                ArrayList<LocalRegion> regionList = new ArrayList<LocalRegion>(1);
                regionList.add(region);
                RegionEvictorTask task = new RegionEvictorTask(this.cache.getCachePerfStats(), regionList, this, bytesToEvictPerTask);
                evictorTaskSet.add(task);
            }
            for (RegionEvictorTask regionEvictorTask : evictorTaskSet) {
                this.testTaskSetSizes.add(regionEvictorTask.getRegionList().size());
            }
            return evictorTaskSet;
        }
        int numRegionsInTask = allRegionSetSize / threadsAvailable;
        ArrayList<LocalRegion> regionsForSingleTask = null;
        Iterator<LocalRegion> regionIterator = allRegionList.iterator();
        for (int i = 0; i < threadsAvailable; ++i) {
            regionsForSingleTask = new ArrayList<LocalRegion>(numRegionsInTask);
            for (int count = 1; count <= numRegionsInTask; ++count) {
                if (!regionIterator.hasNext()) continue;
                regionsForSingleTask.add(regionIterator.next());
            }
            evictorTaskSet.add(new RegionEvictorTask(this.cache.getCachePerfStats(), regionsForSingleTask, this, bytesToEvictPerTask));
        }
        while (regionIterator.hasNext()) {
            regionsForSingleTask.add(regionIterator.next());
        }
        for (RegionEvictorTask regionEvictorTask : evictorTaskSet) {
            this.testTaskSetSizes.add(regionEvictorTask.getRegionList().size());
        }
        return evictorTaskSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEvent(MemoryEvent event) {
        if (DISABLE_HEAP_EVICTOR_THREAD_POOL) {
            return;
        }
        if (this.isRunning() && event.isLocal()) {
            if (event.getState().isEviction()) {
                if (this.mustEvict.get()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Updating eviction in response to memory event: {}", (Object)event);
                    }
                    Object object = this.evictionLock;
                    synchronized (object) {
                        this.numEvictionLoopsCompleted = 0;
                        this.numFastLoops = (int)((event.getBytesUsed() - event.getThresholds().getEvictionThresholdClearBytes() + this.getTotalBytesToEvict()) / this.getTotalBytesToEvict());
                        this.evictionLock.notifyAll();
                    }
                    return;
                }
                if (!this.mustEvict.compareAndSet(false, true)) {
                    return;
                }
                this.numEvictionLoopsCompleted = 0;
                this.numFastLoops = (int)((event.getBytesUsed() - event.getThresholds().getEvictionThresholdClearBytes() + this.getTotalBytesToEvict()) / this.getTotalBytesToEvict());
                if (logger.isDebugEnabled()) {
                    logger.debug("Starting eviction in response to memory event: {}", (Object)event);
                }
                Runnable evictionManagerTask = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block13: {
                            if (HeapEvictor.this.numEvictionLoopsCompleted < HeapEvictor.this.getTestAbortAfterLoopCount()) {
                                try {
                                    if (EVICT_HIGH_ENTRY_COUNT_BUCKETS_FIRST) {
                                        HeapEvictor.this.createAndSubmitWeightedRegionEvictionTasks();
                                    } else {
                                        for (RegionEvictorTask task : HeapEvictor.this.createRegionEvictionTasks()) {
                                            HeapEvictor.this.executeInThreadPool(task);
                                        }
                                    }
                                    Object object = HeapEvictor.this.evictionLock;
                                    synchronized (object) {
                                        int delayTime = HeapEvictor.this.getEvictionLoopDelayTime();
                                        if (logger.isDebugEnabled()) {
                                            logger.debug("Eviction loop delay time calculated to be {} milliseconds. Fast Loops={}, Loop #={}", (Object)delayTime, (Object)HeapEvictor.this.numFastLoops, (Object)(HeapEvictor.this.numEvictionLoopsCompleted + 1));
                                        }
                                        HeapEvictor.this.numEvictionLoopsCompleted++;
                                        try {
                                            HeapEvictor.this.evictionLock.wait(delayTime);
                                        }
                                        catch (InterruptedException interruptedException) {
                                            // empty catch block
                                        }
                                    }
                                    if (HeapEvictor.this.mustEvict.get()) {
                                        HeapEvictor.this.executeInThreadPool(this);
                                    }
                                }
                                catch (RegionDestroyedException ignored) {
                                    if (!HeapEvictor.this.mustEvict.get()) break block13;
                                    HeapEvictor.this.executeInThreadPool(this);
                                }
                            }
                        }
                    }
                };
                this.executeInThreadPool(evictionManagerTask);
            } else {
                this.mustEvict.set(false);
            }
        }
    }

    protected int getEvictionLoopDelayTime() {
        int delayTime = 850;
        if (this.numEvictionLoopsCompleted - this.numFastLoops > 2) {
            delayTime = 3000;
        } else if (this.numEvictionLoopsCompleted >= this.numFastLoops) {
            delayTime = (this.numEvictionLoopsCompleted - this.numFastLoops + 3) * 500;
        }
        return delayTime;
    }

    boolean mustEvict() {
        return this.mustEvict.get();
    }

    public void close() {
        if (this.isRunning.compareAndSet(true, false)) {
            this.evictorThreadPool.shutdownNow();
        }
    }

    private boolean isRunning() {
        return this.isRunning.get();
    }

    public List<Integer> testOnlyGetSizeOfTasks() {
        if (this.isRunning()) {
            return this.testTaskSetSizes;
        }
        return null;
    }

    public long getTotalBytesToEvict() {
        return TOTAL_BYTES_TO_EVICT_FROM_HEAP;
    }

    protected InternalResourceManager.ResourceType getResourceType() {
        return InternalResourceManager.ResourceType.HEAP_MEMORY;
    }

    private int getTestAbortAfterLoopCount() {
        return this.testAbortAfterLoopCount;
    }

    public void setTestAbortAfterLoopCount(int testAbortAfterLoopCount) {
        this.testAbortAfterLoopCount = testAbortAfterLoopCount;
    }

    int numEvictionLoopsCompleted() {
        return this.numEvictionLoopsCompleted;
    }

    int numFastLoops() {
        return this.numFastLoops;
    }

    private static long setTotalBytesToEvictFromHeap() {
        float evictionBurstPercentage = Float.parseFloat(System.getProperty("gemfire.HeapLRUCapacityController.evictionBurstPercentage", "0.4"));
        long maxTenuredBytes = HeapMemoryMonitor.getTenuredPoolMaxMemory();
        return (long)((double)maxTenuredBytes * 0.01 * (double)evictionBurstPercentage);
    }
}

