/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.eviction;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.eviction.EvictionController;
import org.apache.geode.internal.cache.eviction.EvictionCounters;
import org.apache.geode.internal.cache.eviction.EvictionList;
import org.apache.geode.internal.cache.eviction.EvictionNode;
import org.apache.geode.internal.cache.eviction.GuardNode;
import org.apache.geode.internal.cache.versions.RegionVersionVector;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;

abstract class AbstractEvictionList
implements EvictionList {
    private static final Logger logger = LogService.getLogger();
    protected final EvictionNode tail = new GuardNode();
    protected final EvictionNode head = new GuardNode();
    private final AtomicInteger size = new AtomicInteger();
    private final EvictionController controller;

    protected AbstractEvictionList(EvictionController controller) {
        this.controller = controller;
        this.initEmptyList();
    }

    @Override
    public int size() {
        return this.size.get();
    }

    private void incrementSize() {
        this.size.incrementAndGet();
    }

    void decrementSize() {
        this.size.decrementAndGet();
    }

    @Override
    public void closeStats() {
        this.getStatistics().close();
    }

    @Override
    public EvictionCounters getStatistics() {
        return this.controller.getCounters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear(RegionVersionVector regionVersionVector, BucketRegion bucketRegion) {
        if (regionVersionVector != null) {
            return;
        }
        AbstractEvictionList abstractEvictionList = this;
        synchronized (abstractEvictionList) {
            if (bucketRegion != null) {
                this.getStatistics().decrementCounter(bucketRegion.getCounter());
                bucketRegion.resetCounter();
            } else {
                this.getStatistics().resetCounter();
            }
            this.initEmptyList();
        }
    }

    private synchronized void initEmptyList() {
        this.size.set(0);
        this.head.setNext(this.tail);
        this.tail.setPrevious(this.head);
    }

    @Override
    public synchronized void appendEntry(EvictionNode evictionNode) {
        if (evictionNode.next() != null) {
            return;
        }
        if (logger.isTraceEnabled(LogMarker.LRU_CLOCK_VERBOSE)) {
            logger.trace(LogMarker.LRU_CLOCK_VERBOSE, "adding a Node to lru list: {}", (Object)evictionNode);
        }
        evictionNode.setNext(this.tail);
        this.tail.previous().setNext(evictionNode);
        evictionNode.setPrevious(this.tail.previous());
        this.tail.setPrevious(evictionNode);
        this.incrementSize();
    }

    @Override
    public synchronized void destroyEntry(EvictionNode evictionNode) {
        if (logger.isTraceEnabled(LogMarker.LRU_CLOCK_VERBOSE)) {
            logger.trace(LogMarker.LRU_CLOCK_VERBOSE, "destroyEntry called for {}", (Object)evictionNode);
        }
        if (this.removeEntry(evictionNode)) {
            this.getStatistics().incDestroys();
        }
    }

    protected synchronized boolean removeEntry(EvictionNode evictionNode) {
        if (evictionNode.next() == null) {
            return false;
        }
        this.unlinkEntry(evictionNode);
        return true;
    }

    protected synchronized void unlinkEntry(EvictionNode evictionNode) {
        EvictionNode next = evictionNode.next();
        EvictionNode previous = evictionNode.previous();
        next.setPrevious(previous);
        previous.setNext(next);
        evictionNode.setNext(null);
        evictionNode.setPrevious(null);
        this.decrementSize();
    }

    protected synchronized EvictionNode unlinkTailEntry() {
        EvictionNode evictionNode = this.tail.previous();
        if (evictionNode == this.head) {
            return null;
        }
        this.unlinkEntry(evictionNode);
        return evictionNode;
    }

    protected synchronized EvictionNode unlinkHeadEntry() {
        EvictionNode evictionNode = this.head.next();
        if (evictionNode == this.tail) {
            return null;
        }
        this.unlinkEntry(evictionNode);
        return evictionNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isEvictable(EvictionNode evictionNode) {
        if (evictionNode.isEvicted()) {
            if (logger.isTraceEnabled(LogMarker.LRU_CLOCK_VERBOSE)) {
                logger.trace(LogMarker.LRU_CLOCK_VERBOSE, "discarding evicted entry");
            }
            return false;
        }
        EvictionNode evictionNode2 = evictionNode;
        synchronized (evictionNode2) {
            if (evictionNode.isInUseByTransaction()) {
                if (logger.isTraceEnabled(LogMarker.LRU_CLOCK_VERBOSE)) {
                    logger.trace(LogMarker.LRU_CLOCK_VERBOSE, "removing transactional entry from consideration");
                }
                return false;
            }
        }
        return true;
    }
}

