/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.control;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import org.apache.geode.CancelException;
import org.apache.geode.Statistics;
import org.apache.geode.SystemFailure;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.internal.MutableForTesting;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.LowMemoryException;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.control.InternalResourceManager;
import org.apache.geode.internal.cache.control.MemoryEvent;
import org.apache.geode.internal.cache.control.MemoryMonitor;
import org.apache.geode.internal.cache.control.MemoryThresholds;
import org.apache.geode.internal.cache.control.ResourceAdvisor;
import org.apache.geode.internal.cache.control.ResourceEvent;
import org.apache.geode.internal.cache.control.ResourceListener;
import org.apache.geode.internal.cache.control.ResourceManagerStats;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.LoggingExecutors;
import org.apache.geode.internal.statistics.GemFireStatSampler;
import org.apache.geode.internal.statistics.LocalStatListener;
import org.apache.geode.internal.statistics.StatisticsManager;
import org.apache.logging.log4j.Logger;

public class HeapMemoryMonitor
implements NotificationListener,
MemoryMonitor {
    private static final Logger logger = LogService.getLogger();
    private static final String HEAP_POOL = System.getProperty("gemfire.ResourceManager.HEAP_POOL");
    public static final String POLLER_INTERVAL_PROP = "gemfire.heapPollerInterval";
    private static final int POLLER_INTERVAL = Integer.getInteger("gemfire.heapPollerInterval", 500);
    private ThreadLocal<MemoryEvent> upcomingEvent = new ThreadLocal();
    private ScheduledExecutorService pollerExecutor;
    private final LocalStatListener statListener = new LocalHeapStatListener();
    @Immutable
    private static final MemoryPoolMXBean tenuredMemoryPoolMXBean;
    private static final long tenuredPoolMaxMemory;
    private volatile MemoryThresholds thresholds = new MemoryThresholds(tenuredPoolMaxMemory);
    private volatile MemoryEvent mostRecentEvent = new MemoryEvent(InternalResourceManager.ResourceType.HEAP_MEMORY, MemoryThresholds.MemoryState.DISABLED, MemoryThresholds.MemoryState.DISABLED, null, 0L, true, this.thresholds);
    private volatile MemoryThresholds.MemoryState currentState = MemoryThresholds.MemoryState.DISABLED;
    boolean started = false;
    private boolean hasEvictionThreshold = false;
    private final InternalResourceManager resourceManager;
    private final ResourceAdvisor resourceAdvisor;
    private final InternalCache cache;
    private final ResourceManagerStats stats;
    @MutableForTesting
    private static boolean testDisableMemoryUpdates;
    @MutableForTesting
    private static long testBytesUsedForThresholdSet;

    static boolean isTenured(MemoryPoolMXBean memoryPoolMXBean) {
        if (memoryPoolMXBean.getType() != MemoryType.HEAP) {
            return false;
        }
        String name = memoryPoolMXBean.getName();
        return name.equals("CMS Old Gen") || name.equals("PS Old Gen") || name.equals("G1 Old Gen") || name.equals("Old Space") || name.equals("Tenured Gen") || name.equals("Java heap") || name.equals("GenPauseless Old Gen") || HEAP_POOL != null && name.equals(HEAP_POOL);
    }

    HeapMemoryMonitor(InternalResourceManager resourceManager, InternalCache cache, ResourceManagerStats stats) {
        this.resourceManager = resourceManager;
        this.resourceAdvisor = (ResourceAdvisor)cache.getDistributionAdvisor();
        this.cache = cache;
        this.stats = stats;
    }

    public static MemoryPoolMXBean getTenuredMemoryPoolMXBean() {
        if (tenuredMemoryPoolMXBean != null) {
            return tenuredMemoryPoolMXBean;
        }
        throw new IllegalStateException(String.format("No tenured pools found.  Known pools are: %s", HeapMemoryMonitor.getAllMemoryPoolNames()));
    }

    private static String getAllMemoryPoolNames() {
        StringBuilder builder = new StringBuilder("[");
        for (MemoryPoolMXBean memoryPoolBean : ManagementFactory.getMemoryPoolMXBeans()) {
            builder.append("(Name=").append(memoryPoolBean.getName()).append(";Type=").append((Object)memoryPoolBean.getType()).append(";UsageThresholdSupported=").append(memoryPoolBean.isUsageThresholdSupported()).append("), ");
        }
        if (builder.length() > 1) {
            builder.setLength(builder.length() - 2);
        }
        builder.append("]");
        return builder.toString();
    }

    public void setMemoryStateChangeTolerance(int memoryStateChangeTolerance) {
        this.thresholds.setMemoryStateChangeTolerance(memoryStateChangeTolerance);
    }

    public int getMemoryStateChangeTolerance() {
        return this.thresholds.getMemoryStateChangeTolerance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startMonitoring() {
        HeapMemoryMonitor heapMemoryMonitor = this;
        synchronized (heapMemoryMonitor) {
            if (this.started) {
                return;
            }
            boolean statListenerStarted = this.startCacheStatListener();
            if (!statListenerStarted) {
                this.startMemoryPoolPoller();
            }
            this.startJVMThresholdListener();
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopMonitoring() {
        HeapMemoryMonitor heapMemoryMonitor = this;
        synchronized (heapMemoryMonitor) {
            block8: {
                if (!this.started) {
                    return;
                }
                this.resourceManager.stopExecutor(this.pollerExecutor);
                NotificationEmitter emitter = (NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean());
                try {
                    emitter.removeNotificationListener(this, null, null);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Removed Memory MXBean notification listener" + this);
                    }
                }
                catch (ListenerNotFoundException ignore) {
                    if (!logger.isDebugEnabled()) break block8;
                    logger.debug("This instance '{}' was not registered as a Memory MXBean listener", (Object)this);
                }
            }
            GemFireStatSampler sampler = this.cache.getInternalDistributedSystem().getStatSampler();
            if (sampler != null) {
                sampler.removeLocalStatListener(this.statListener);
            }
            this.started = false;
        }
    }

    public static Statistics getTenuredPoolStatistics(StatisticsManager statisticsManager) {
        String tenuredPoolName = HeapMemoryMonitor.getTenuredMemoryPoolMXBean().getName();
        String tenuredPoolType = "PoolStats";
        for (Statistics si : statisticsManager.getStatsList()) {
            if (!si.getTextId().contains(tenuredPoolName) || !si.getType().getName().contains(tenuredPoolType)) continue;
            return si;
        }
        return null;
    }

    private boolean startCacheStatListener() {
        GemFireStatSampler sampler = this.cache.getInternalDistributedSystem().getStatSampler();
        if (sampler == null) {
            return false;
        }
        try {
            sampler.waitForInitialization();
            Statistics si = HeapMemoryMonitor.getTenuredPoolStatistics(this.cache.getInternalDistributedSystem().getStatisticsManager());
            if (si != null) {
                sampler.addLocalStatListener(this.statListener, si, "currentUsedMemory");
                if (logger.isDebugEnabled()) {
                    logger.debug("Registered stat listener for " + si.getTextId());
                }
                return true;
            }
        }
        catch (InterruptedException iex) {
            Thread.currentThread().interrupt();
            this.cache.getCancelCriterion().checkCancelInProgress(iex);
        }
        return false;
    }

    private void startMemoryPoolPoller() {
        if (tenuredMemoryPoolMXBean == null) {
            return;
        }
        this.pollerExecutor = LoggingExecutors.newScheduledThreadPool("GemfireHeapPoller", 1);
        this.pollerExecutor.scheduleAtFixedRate(new HeapPoller(), POLLER_INTERVAL, POLLER_INTERVAL, TimeUnit.MILLISECONDS);
        if (logger.isDebugEnabled()) {
            logger.debug("Started GemfireHeapPoller to poll the heap every " + POLLER_INTERVAL + " milliseconds");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCriticalThreshold(float criticalThreshold) {
        HeapMemoryMonitor heapMemoryMonitor = this;
        synchronized (heapMemoryMonitor) {
            if (criticalThreshold == this.thresholds.getCriticalThreshold()) {
                return;
            }
            if (criticalThreshold > 100.0f || criticalThreshold < 0.0f) {
                throw new IllegalArgumentException("Critical percentage must be greater than 0.0 and less than or equal to 100.0.");
            }
            if (HeapMemoryMonitor.getTenuredMemoryPoolMXBean() == null) {
                throw new IllegalStateException(String.format("No tenured pools found.  Known pools are: %s", HeapMemoryMonitor.getAllMemoryPoolNames()));
            }
            if (criticalThreshold != 0.0f && this.thresholds.isEvictionThresholdEnabled() && criticalThreshold <= this.thresholds.getEvictionThreshold()) {
                throw new IllegalArgumentException("Critical percentage must be greater than the eviction percentage.");
            }
            this.cache.setQueryMonitorRequiredForResourceManager(criticalThreshold != 0.0f);
            this.thresholds = new MemoryThresholds(this.thresholds.getMaxMemoryBytes(), criticalThreshold, this.thresholds.getEvictionThreshold());
            this.updateStateAndSendEvent();
            if (this.thresholds.isEvictionThresholdEnabled() || this.thresholds.isCriticalThresholdEnabled()) {
                this.startMonitoring();
            } else if (!this.thresholds.isEvictionThresholdEnabled() && !this.thresholds.isCriticalThresholdEnabled()) {
                this.stopMonitoring();
            }
            this.stats.changeCriticalThreshold(this.thresholds.getCriticalThresholdBytes());
        }
    }

    @Override
    public boolean hasEvictionThreshold() {
        return this.hasEvictionThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setEvictionThreshold(float evictionThreshold) {
        this.hasEvictionThreshold = true;
        HeapMemoryMonitor heapMemoryMonitor = this;
        synchronized (heapMemoryMonitor) {
            if (evictionThreshold == this.thresholds.getEvictionThreshold()) {
                return;
            }
            if (evictionThreshold > 100.0f || evictionThreshold < 0.0f) {
                throw new IllegalArgumentException("Eviction percentage must be greater than 0.0 and less than or equal to 100.0.");
            }
            if (HeapMemoryMonitor.getTenuredMemoryPoolMXBean() == null) {
                throw new IllegalStateException(String.format("No tenured pools found.  Known pools are: %s", HeapMemoryMonitor.getAllMemoryPoolNames()));
            }
            if (evictionThreshold != 0.0f && this.thresholds.isCriticalThresholdEnabled() && evictionThreshold >= this.thresholds.getCriticalThreshold()) {
                throw new IllegalArgumentException("Eviction percentage must be less than the critical percentage.");
            }
            this.thresholds = new MemoryThresholds(this.thresholds.getMaxMemoryBytes(), this.thresholds.getCriticalThreshold(), evictionThreshold);
            this.updateStateAndSendEvent();
            if (this.thresholds.isEvictionThresholdEnabled() || this.thresholds.isCriticalThresholdEnabled()) {
                this.startMonitoring();
            } else if (!this.thresholds.isEvictionThresholdEnabled() && !this.thresholds.isCriticalThresholdEnabled()) {
                this.stopMonitoring();
            }
            this.stats.changeEvictionThreshold(this.thresholds.getEvictionThresholdBytes());
        }
    }

    public void updateStateAndSendEvent() {
        this.updateStateAndSendEvent(testBytesUsedForThresholdSet != -1L ? testBytesUsedForThresholdSet : this.getBytesUsed(), "notification");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStateAndSendEvent(long bytesUsed, String eventOrigin) {
        this.stats.changeTenuredHeapUsed(bytesUsed);
        HeapMemoryMonitor heapMemoryMonitor = this;
        synchronized (heapMemoryMonitor) {
            MemoryThresholds.MemoryState oldState = this.mostRecentEvent.getState();
            MemoryThresholds.MemoryState newState = this.thresholds.computeNextState(oldState, bytesUsed);
            if (oldState != newState) {
                this.setUsageThresholdOnMXBean(bytesUsed);
                this.currentState = newState;
                MemoryEvent event = new MemoryEvent(InternalResourceManager.ResourceType.HEAP_MEMORY, oldState, newState, this.cache.getMyId(), bytesUsed, true, this.thresholds);
                this.upcomingEvent.set(event);
                this.processLocalEvent(event, eventOrigin);
                this.updateStatsFromEvent(event);
            } else if (!oldState.isNormal() && bytesUsed != this.mostRecentEvent.getBytesUsed()) {
                MemoryEvent event = new MemoryEvent(InternalResourceManager.ResourceType.HEAP_MEMORY, oldState, newState, this.cache.getMyId(), bytesUsed, true, this.thresholds);
                this.upcomingEvent.set(event);
                this.processLocalEvent(event, eventOrigin);
            }
        }
    }

    private void updateStatsFromEvent(MemoryEvent event) {
        if (event.isLocal()) {
            if (event.getState().isCritical() && !event.getPreviousState().isCritical()) {
                this.stats.incHeapCriticalEvents();
            } else if (!event.getState().isCritical() && event.getPreviousState().isCritical()) {
                this.stats.incHeapSafeEvents();
            }
            if (event.getState().isEviction() && !event.getPreviousState().isEviction()) {
                this.stats.incEvictionStartEvents();
            } else if (!event.getState().isEviction() && event.getPreviousState().isEviction()) {
                this.stats.incEvictionStopEvents();
            }
        }
    }

    @Override
    public void fillInProfile(ResourceAdvisor.ResourceManagerProfile profile) {
        MemoryEvent tempEvent = this.upcomingEvent.get();
        if (tempEvent != null) {
            this.mostRecentEvent = tempEvent;
            this.upcomingEvent.set(null);
        }
        MemoryEvent eventToPopulate = this.mostRecentEvent;
        profile.setHeapData(eventToPopulate.getBytesUsed(), eventToPopulate.getState(), eventToPopulate.getThresholds());
    }

    @Override
    public MemoryThresholds.MemoryState getState() {
        return this.currentState;
    }

    @Override
    public MemoryThresholds getThresholds() {
        MemoryThresholds saveThresholds = this.thresholds;
        return new MemoryThresholds(saveThresholds.getMaxMemoryBytes(), saveThresholds.getCriticalThreshold(), saveThresholds.getEvictionThreshold());
    }

    private void setUsageThresholdOnMXBean(long bytesUsed) {
    }

    void startJVMThresholdListener() {
        MemoryPoolMXBean memoryPoolMXBean = HeapMemoryMonitor.getTenuredMemoryPoolMXBean();
        if (!testDisableMemoryUpdates) {
            memoryPoolMXBean.setCollectionUsageThreshold(1L);
        }
        long usageThreshold = memoryPoolMXBean.getUsageThreshold();
        this.cache.getLogger().info(String.format("Overridding MemoryPoolMXBean heap threshold bytes %s on pool %s", usageThreshold, memoryPoolMXBean.getName()));
        MemoryMXBean mbean = ManagementFactory.getMemoryMXBean();
        NotificationEmitter emitter = (NotificationEmitter)((Object)mbean);
        emitter.addNotificationListener(this, null, null);
    }

    @Override
    public long getBytesUsed() {
        return HeapMemoryMonitor.getTenuredMemoryPoolMXBean().getUsage().getUsed();
    }

    public static long getTenuredPoolMaxMemory() {
        return tenuredPoolMaxMemory;
    }

    synchronized void processLocalEvent(MemoryEvent event, String eventOrigin) {
        assert (event.isLocal());
        if (logger.isDebugEnabled()) {
            logger.debug("Handling new local event " + event);
        }
        if (event.getState().isCritical() && !event.getPreviousState().isCritical()) {
            this.cache.getLogger().error(this.createCriticalThresholdLogMessage(event, eventOrigin, true));
            if (!this.cache.isQueryMonitorDisabledForLowMemory()) {
                this.cache.getQueryMonitor().setLowMemory(true, event.getBytesUsed());
            }
        } else if (!event.getState().isCritical() && event.getPreviousState().isCritical()) {
            this.cache.getLogger().error(this.createCriticalThresholdLogMessage(event, eventOrigin, false));
            if (!this.cache.isQueryMonitorDisabledForLowMemory()) {
                this.cache.getQueryMonitor().setLowMemory(false, event.getBytesUsed());
            }
        }
        if (event.getState().isEviction() && !event.getPreviousState().isEviction()) {
            this.cache.getLogger().info(String.format("Member: %s above %s eviction threshold", event.getMember(), "heap"));
        } else if (!event.getState().isEviction() && event.getPreviousState().isEviction()) {
            this.cache.getLogger().info(String.format("Member: %s below %s eviction threshold", event.getMember(), "heap"));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Informing remote members of event " + event);
        }
        this.resourceAdvisor.updateRemoteProfile();
        this.resourceManager.deliverLocalEvent(event);
    }

    @Override
    public void notifyListeners(Set<ResourceListener> listeners, ResourceEvent event) {
        for (ResourceListener listener : listeners) {
            try {
                listener.onEvent(event);
            }
            catch (CancelException cancelException) {
            }
            catch (Throwable t) {
                Error err;
                if (t instanceof Error && SystemFailure.isJVMFailureError(err = (Error)t)) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                SystemFailure.checkFailure();
                this.cache.getLogger().error("Exception occurred when notifying listeners ", t);
            }
        }
    }

    @Override
    public void handleNotification(Notification notification, Object callback) {
        this.resourceManager.runWithNotifyExecutor(new Runnable(){

            @Override
            public void run() {
                if (!testDisableMemoryUpdates) {
                    HeapMemoryMonitor.this.updateStateAndSendEvent();
                }
            }
        });
    }

    protected Set<DistributedMember> getHeapCriticalMembersFrom(Set<DistributedMember> members) {
        Set<DistributedMember> criticalMembers = this.getCriticalMembers();
        criticalMembers.retainAll(members);
        return criticalMembers;
    }

    private Set<DistributedMember> getCriticalMembers() {
        HashSet<DistributedMember> criticalMembers = new HashSet<DistributedMember>(this.resourceAdvisor.adviseCriticalMembers());
        if (this.mostRecentEvent.getState().isCritical()) {
            criticalMembers.add(this.cache.getMyId());
        }
        return criticalMembers;
    }

    public void checkForLowMemory(Function function, DistributedMember targetMember) {
        Set<DistributedMember> targetMembers = Collections.singleton(targetMember);
        this.checkForLowMemory(function, targetMembers);
    }

    public void checkForLowMemory(Function function, Set<DistributedMember> dest) {
        LowMemoryException exception = this.createLowMemoryIfNeeded(function, dest);
        if (exception != null) {
            throw exception;
        }
    }

    public LowMemoryException createLowMemoryIfNeeded(Function function, DistributedMember targetMember) {
        Set<DistributedMember> targetMembers = Collections.singleton(targetMember);
        return this.createLowMemoryIfNeeded(function, targetMembers);
    }

    public LowMemoryException createLowMemoryIfNeeded(Function function, Set<DistributedMember> memberSet) {
        Set<DistributedMember> criticalMembersFrom;
        if (function.optimizeForWrite() && !MemoryThresholds.isLowMemoryExceptionDisabled() && !(criticalMembersFrom = this.getHeapCriticalMembersFrom(memberSet)).isEmpty()) {
            return new LowMemoryException(String.format("Function: %s cannot be executed because the members %s are running low on memory", function.getId(), criticalMembersFrom), criticalMembersFrom);
        }
        return null;
    }

    public boolean isMemberHeapCritical(InternalDistributedMember member) {
        if (member.equals(this.cache.getMyId())) {
            return this.mostRecentEvent.getState().isCritical();
        }
        return this.resourceAdvisor.isHeapCritical(member);
    }

    protected MemoryEvent getMostRecentEvent() {
        return this.mostRecentEvent;
    }

    protected HeapMemoryMonitor setMostRecentEvent(MemoryEvent mostRecentEvent) {
        this.mostRecentEvent = mostRecentEvent;
        return this;
    }

    public String toString() {
        return "HeapMemoryMonitor [thresholds=" + this.thresholds + ", mostRecentEvent=" + this.mostRecentEvent + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTestMaxMemoryBytes(long testMaxMemoryBytes) {
        HeapMemoryMonitor heapMemoryMonitor = this;
        synchronized (heapMemoryMonitor) {
            MemoryThresholds newThresholds = testMaxMemoryBytes == 0L ? new MemoryThresholds(HeapMemoryMonitor.getTenuredPoolMaxMemory()) : new MemoryThresholds(testMaxMemoryBytes, this.thresholds.getCriticalThreshold(), this.thresholds.getEvictionThreshold());
            this.thresholds = newThresholds;
            StringBuilder builder = new StringBuilder("In testing, the following values were set");
            builder.append(" maxMemoryBytes:").append(newThresholds.getMaxMemoryBytes());
            builder.append(" criticalThresholdBytes:").append(newThresholds.getCriticalThresholdBytes());
            builder.append(" evictionThresholdBytes:").append(newThresholds.getEvictionThresholdBytes());
            logger.debug(builder.toString());
        }
    }

    public static void setTestDisableMemoryUpdates(boolean newTestDisableMemoryUpdates) {
        testDisableMemoryUpdates = newTestDisableMemoryUpdates;
    }

    public static void setTestBytesUsedForThresholdSet(long newTestBytesUsedForThresholdSet) {
        testBytesUsedForThresholdSet = newTestBytesUsedForThresholdSet;
    }

    private String createCriticalThresholdLogMessage(MemoryEvent event, String eventOrigin, boolean above) {
        return "Member: " + event.getMember() + " " + (above ? "above" : "below") + " heap critical threshold. Event generated via " + eventOrigin + ". Used bytes: " + event.getBytesUsed() + ". Memory thresholds: " + this.thresholds;
    }

    static {
        MemoryPoolMXBean matchingMemoryPoolMXBean = null;
        for (MemoryPoolMXBean memoryPoolMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
            if (!memoryPoolMXBean.isUsageThresholdSupported() || !HeapMemoryMonitor.isTenured(memoryPoolMXBean)) continue;
            matchingMemoryPoolMXBean = memoryPoolMXBean;
            break;
        }
        if ((tenuredMemoryPoolMXBean = matchingMemoryPoolMXBean) == null) {
            logger.error("No tenured pools found.  Known pools are: {}", (Object)HeapMemoryMonitor.getAllMemoryPoolNames());
        }
        if (tenuredMemoryPoolMXBean != null && tenuredMemoryPoolMXBean.getUsage().getMax() != -1L) {
            tenuredPoolMaxMemory = tenuredMemoryPoolMXBean.getUsage().getMax();
        } else {
            long calculatedMaxMemory = Runtime.getRuntime().maxMemory();
            List<MemoryPoolMXBean> pools = ManagementFactory.getMemoryPoolMXBeans();
            for (MemoryPoolMXBean p : pools) {
                if (p.getType() != MemoryType.HEAP || p.getUsage().getMax() == -1L) continue;
                calculatedMaxMemory -= p.getUsage().getMax();
            }
            tenuredPoolMaxMemory = calculatedMaxMemory;
        }
        testDisableMemoryUpdates = false;
        testBytesUsedForThresholdSet = -1L;
    }

    class HeapPoller
    implements Runnable {
        HeapPoller() {
        }

        @Override
        public void run() {
            if (testDisableMemoryUpdates) {
                return;
            }
            try {
                HeapMemoryMonitor.this.updateStateAndSendEvent(HeapMemoryMonitor.this.getBytesUsed(), "polling");
            }
            catch (Exception e) {
                logger.debug("Poller Thread caught exception:", (Throwable)e);
            }
        }
    }

    class LocalHeapStatListener
    implements LocalStatListener {
        LocalHeapStatListener() {
        }

        @Override
        public void statValueChanged(double value) {
            final long usedBytes = (long)value;
            try {
                HeapMemoryMonitor.this.resourceManager.runWithNotifyExecutor(new Runnable(){

                    @Override
                    public void run() {
                        if (!testDisableMemoryUpdates) {
                            HeapMemoryMonitor.this.updateStateAndSendEvent(usedBytes, "polling");
                        }
                    }
                });
                if (logger.isDebugEnabled()) {
                    logger.debug("StatSampler scheduled a handleNotification call with " + usedBytes + " bytes");
                }
            }
            catch (RejectedExecutionException ignore) {
                if (!HeapMemoryMonitor.this.resourceManager.isClosed()) {
                    logger.warn("No memory events will be delivered because of RejectedExecutionException");
                }
            }
            catch (CacheClosedException cacheClosedException) {
                // empty catch block
            }
        }
    }
}

