/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CacheEvent;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DirectReplyProcessor;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.DistributedCacheOperation;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.InternalCacheEvent;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.versions.ConcurrentCacheModificationException;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class UpdateEntryVersionOperation
extends DistributedCacheOperation {
    private static final Logger logger = LogService.getLogger();

    public UpdateEntryVersionOperation(CacheEvent event) {
        super(event);
    }

    @Override
    protected DistributedCacheOperation.CacheOperationMessage createMessage() {
        return new UpdateEntryVersionMessage(this.event);
    }

    @Override
    protected void initMessage(DistributedCacheOperation.CacheOperationMessage msg, DirectReplyProcessor p) {
        super.initMessage(msg, p);
        UpdateEntryVersionMessage imsg = (UpdateEntryVersionMessage)msg;
        EntryEventImpl eei = this.getEvent();
        imsg.key = eei.getKey();
        imsg.eventId = eei.getEventId();
        imsg.versionTag = eei.getVersionTag();
    }

    public static class UpdateEntryVersionMessage
    extends DistributedCacheOperation.CacheOperationMessage {
        protected Object key;
        protected EventID eventId = null;
        protected EntryEventImpl event = null;
        private Long tailKey = 0L;

        public UpdateEntryVersionMessage() {
        }

        public UpdateEntryVersionMessage(InternalCacheEvent ev) {
            this.event = (EntryEventImpl)ev;
        }

        @Override
        public int getDSFID() {
            return 158;
        }

        @Override
        protected InternalCacheEvent createEvent(DistributedRegion rgn) throws EntryNotFoundException {
            EntryEventImpl ev = EntryEventImpl.create(rgn, this.getOperation(), this.key, null, this.callbackArg, true, this.getSender(), false);
            ev.setEventId(this.eventId);
            ev.setVersionTag(this.versionTag);
            ev.setTailKey(this.tailKey);
            return ev;
        }

        @Override
        protected void appendFields(StringBuilder buff) {
            super.appendFields(buff);
            buff.append("; key=");
            buff.append(this.key);
            if (this.eventId != null) {
                buff.append("; eventId=").append(this.eventId);
            }
        }

        @Override
        protected boolean operateOnRegion(CacheEvent event, ClusterDistributionManager dm) throws EntryNotFoundException {
            EntryEventImpl ev = (EntryEventImpl)event;
            DistributedRegion rgn = (DistributedRegion)ev.getRegion();
            try {
                if (!rgn.isCacheContentProxy()) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("UpdateEntryVersionMessage.operationOnRegion; key={}", ev.getKey());
                    }
                    if (rgn.getConcurrencyChecksEnabled()) {
                        rgn.basicUpdateEntryVersion(ev);
                    }
                }
                this.appliedOperation = true;
                return true;
            }
            catch (ConcurrentCacheModificationException e) {
                if (logger.isTraceEnabled()) {
                    logger.trace("UpdateEntryVersionMessage.operationOnRegion; ConcurrentCacheModificationException occurred for key={}", ev.getKey());
                }
                return true;
            }
            catch (CacheWriterException e) {
                throw new Error("CacheWriter should not be called", e);
            }
            catch (TimeoutException e) {
                throw new Error("DistributedLock should not be acquired", e);
            }
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.eventId = (EventID)DataSerializer.readObject(in);
            this.key = DataSerializer.readObject(in);
            Boolean hasTailKey = DataSerializer.readBoolean(in);
            if (hasTailKey.booleanValue()) {
                this.tailKey = DataSerializer.readLong(in);
            }
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeObject(this.eventId, out);
            DataSerializer.writeObject(this.key, out);
            DistributedRegion region = (DistributedRegion)this.event.getRegion();
            if (region instanceof BucketRegion) {
                PartitionedRegion pr = region.getPartitionedRegion();
                if (pr.isParallelWanEnabled()) {
                    DataSerializer.writeBoolean(Boolean.TRUE, out);
                    DataSerializer.writeLong(this.event.getTailKey(), out);
                } else {
                    DataSerializer.writeBoolean(Boolean.FALSE, out);
                }
            } else if (region.isUsedForSerialGatewaySenderQueue()) {
                DataSerializer.writeBoolean(Boolean.TRUE, out);
                DataSerializer.writeLong(this.event.getTailKey(), out);
            } else {
                DataSerializer.writeBoolean(Boolean.FALSE, out);
            }
        }
    }
}

