/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.cache.CommitConflictException;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.UnsupportedOperationInTransactionException;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.TXCommitMessage;
import org.apache.geode.internal.cache.TXEntryState;
import org.apache.geode.internal.cache.TXEntryUserAttrState;
import org.apache.geode.internal.cache.TXLockRequest;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.TXRegionLockRequestImpl;
import org.apache.geode.internal.cache.TXState;
import org.apache.geode.internal.cache.TXStateInterface;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class TXRegionState {
    private static final Logger logger = LogService.getLogger();
    private final HashMap<Object, TXEntryState> entryMods;
    private HashMap uaMods;
    private Set<InternalDistributedMember> otherMembers = null;
    private TXState txState;
    private InternalRegion region;
    private final boolean needsRefCounts;
    private boolean cleanedUp;
    private boolean createdDuringCommit;

    public TXRegionState(InternalRegion r, TXState txState) {
        if (r.getPersistBackup() && !r.isMetaRegionWithTransactions() && !TXManagerImpl.ALLOW_PERSISTENT_TRANSACTIONS) {
            throw new UnsupportedOperationException("Operations on persist-backup regions are not allowed because this thread has an active transaction");
        }
        if (r.getScope().isGlobal()) {
            throw new UnsupportedOperationException("Operations on global regions are not allowed because this thread has an active transaction");
        }
        this.entryMods = new HashMap();
        this.uaMods = null;
        this.region = r;
        this.txState = txState;
        this.needsRefCounts = r.isEntryEvictionPossible() || r.isEntryExpiryPossible();
        r.setInUseByTransaction(true);
    }

    public InternalRegion getRegion() {
        return this.region;
    }

    public boolean needsRefCounts() {
        return this.needsRefCounts;
    }

    public Set getEntryKeys() {
        return Collections.unmodifiableSet(this.entryMods.keySet());
    }

    public TXEntryState readEntry(Object entryKey) {
        return this.entryMods.get(entryKey);
    }

    public TXEntryState createReadEntry(LocalRegion r, Object entryKey, RegionEntry re, Object vId, Object pendingValue) {
        InternalCache cache = r.getCache();
        boolean isDistributed = false;
        isDistributed = cache.getTxManager().getTXState() != null ? cache.getTxManager().getTXState().isDistTx() : cache.getTxManager().isDistributed();
        TXEntryState result = cache.getTXEntryStateFactory().createEntry(re, vId, pendingValue, entryKey, this, isDistributed);
        this.entryMods.put(entryKey, result);
        return result;
    }

    public TXEntryUserAttrState readEntryUserAttr(Object entryKey) {
        TXEntryUserAttrState result = null;
        if (this.uaMods != null) {
            result = (TXEntryUserAttrState)this.uaMods.get(entryKey);
        }
        return result;
    }

    public TXEntryUserAttrState writeEntryUserAttr(Object entryKey, LocalRegion r) {
        TXEntryUserAttrState result;
        if (this.uaMods == null) {
            this.uaMods = new HashMap();
        }
        if ((result = (TXEntryUserAttrState)this.uaMods.get(entryKey)) == null) {
            result = new TXEntryUserAttrState(r.basicGetEntryUserAttribute(entryKey));
            this.uaMods.put(entryKey, result);
        }
        return result;
    }

    public void rmEntryUserAttr(Object entryKey) {
        if (this.uaMods != null && this.uaMods.remove(entryKey) != null && this.uaMods.size() == 0) {
            this.uaMods = null;
        }
    }

    int entryCountMod() {
        int result = 0;
        for (TXEntryState es : this.entryMods.values()) {
            result += es.entryCountMod();
        }
        return result;
    }

    TXEntryState getTXEntryState(Object key) {
        return this.entryMods.get(key);
    }

    void fillInCreatedEntryKeys(HashSet ret) {
        for (Map.Entry<Object, TXEntryState> me : this.entryMods.entrySet()) {
            TXEntryState txes = me.getValue();
            if (!txes.wasCreatedByTX()) continue;
            ret.add(me.getKey());
        }
    }

    void createLockRequest(InternalRegion r, TXLockRequest req) {
        TXRegionLockRequestImpl rlr;
        boolean distributedTX;
        if (this.uaMods == null && this.entryMods.isEmpty()) {
            return;
        }
        if (TXState.logger.isDebugEnabled()) {
            TXState.logger.debug("TXRegionState.createLockRequest 1 " + r.getClass().getSimpleName() + " region-state=" + this);
        }
        if (r.getScope().isDistributed()) {
            if (this.isCreatedDuringCommit()) {
                return;
            }
            DistributedRegion dr = (DistributedRegion)r;
            Set<InternalDistributedMember> advice = dr.getCacheDistributionAdvisor().adviseTX();
            if (!advice.isEmpty()) {
                this.otherMembers = advice;
            }
        }
        if (TXState.logger.isDebugEnabled()) {
            TXState.logger.debug("TXRegionState.createLockRequest 2");
        }
        boolean byPassDLock = false;
        if (r instanceof BucketRegion) {
            byPassDLock = true;
        }
        boolean bl = distributedTX = !byPassDLock && r.getScope().isDistributedAck();
        if (this.uaMods != null || !distributedTX && this.entryMods.size() > 0) {
            rlr = new TXRegionLockRequestImpl((InternalCache)r.getCache(), r);
            if (this.uaMods != null) {
                rlr.addEntryKeys(this.uaMods.keySet());
            }
            if (!distributedTX && this.entryMods.size() > 0) {
                rlr.addEntryKeys(this.getLockRequestEntryKeys());
            }
            if (!rlr.isEmpty()) {
                req.addLocalRequest(rlr);
            }
        }
        if (distributedTX && this.entryMods.size() > 0) {
            rlr = new TXRegionLockRequestImpl((InternalCache)r.getCache(), r);
            rlr.addEntryKeys(this.getLockRequestEntryKeys());
            if (!rlr.isEmpty()) {
                req.setOtherMembers(this.otherMembers);
                req.addDistributedRequest(rlr);
            }
        }
    }

    private Set getLockRequestEntryKeys() {
        HashSet<Object> result = null;
        for (Map.Entry<Object, TXEntryState> me : this.entryMods.entrySet()) {
            TXEntryState txes = me.getValue();
            if (!txes.isDirty() || txes.isOpSearch()) continue;
            if (result == null) {
                result = new HashSet<Object>();
            }
            result.add(me.getKey());
        }
        return result;
    }

    void checkForConflicts(InternalRegion r) throws CommitConflictException {
        Object txes;
        Object eKey;
        if (this.isCreatedDuringCommit()) {
            return;
        }
        for (Map.Entry<Object, TXEntryState> entry : this.entryMods.entrySet()) {
            eKey = entry.getKey();
            txes = entry.getValue();
            ((TXEntryState)txes).checkForConflict(r, eKey);
        }
        if (this.uaMods != null) {
            r.checkReadiness();
            for (Map.Entry<Object, TXEntryState> entry : this.uaMods.entrySet()) {
                eKey = entry.getKey();
                txes = (TXEntryUserAttrState)((Object)entry.getValue());
                ((TXEntryUserAttrState)txes).checkForConflict(r, eKey);
            }
        }
    }

    void cleanupNonDirtyEntries(InternalRegion r) {
        if (!this.entryMods.isEmpty()) {
            Iterator<Map.Entry<Object, TXEntryState>> it = this.entryMods.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Object, TXEntryState> me = it.next();
                TXEntryState txes = me.getValue();
                if (!txes.cleanupNonDirty(r)) continue;
                it.remove();
            }
        }
    }

    void buildMessage(InternalRegion r, TXCommitMessage msg) {
        try {
            if (!r.getScope().isLocal() && !this.entryMods.isEmpty()) {
                msg.startRegion(r, this.entryMods.size());
                Iterator<Map.Entry<Object, TXEntryState>> it = this.entryMods.entrySet().iterator();
                HashSet<InternalDistributedMember> newMemberSet = new HashSet<InternalDistributedMember>();
                if (r.getScope().isDistributed()) {
                    DistributedRegion dr = (DistributedRegion)r;
                    msg.addViewVersion(dr, dr.getDistributionAdvisor().startOperation());
                    newMemberSet.addAll(dr.getCacheDistributionAdvisor().adviseTX());
                }
                while (it.hasNext()) {
                    Map.Entry<Object, TXEntryState> me = it.next();
                    Object eKey = me.getKey();
                    TXEntryState txes = me.getValue();
                    txes.buildMessage(r, eKey, msg, this.otherMembers);
                    if (txes.getFilterRoutingInfo() != null) {
                        newMemberSet.addAll(txes.getFilterRoutingInfo().getMembers());
                    }
                    if (txes.getAdjunctRecipients() == null) continue;
                    newMemberSet.addAll(txes.getAdjunctRecipients());
                }
                if (!newMemberSet.equals(this.otherMembers)) {
                    msg.setUpdateLockMembers();
                    this.otherMembers = newMemberSet;
                }
                msg.finishRegion(this.otherMembers);
            }
        }
        catch (RegionDestroyedException regionDestroyedException) {
        }
        catch (CancelException cancelException) {
            // empty catch block
        }
    }

    void buildMessageForAdjunctReceivers(InternalRegion r, TXCommitMessage msg) {
        try {
            if (!r.getScope().isLocal() && !this.entryMods.isEmpty()) {
                msg.startRegion(r, this.entryMods.size());
                Iterator<Map.Entry<Object, TXEntryState>> it = this.entryMods.entrySet().iterator();
                HashSet<InternalDistributedMember> newMemberSet = new HashSet<InternalDistributedMember>();
                while (it.hasNext()) {
                    Map.Entry<Object, TXEntryState> me = it.next();
                    Object eKey = me.getKey();
                    TXEntryState txes = me.getValue();
                    txes.buildMessage(r, eKey, msg, this.otherMembers);
                    if (txes.getFilterRoutingInfo() != null) {
                        newMemberSet.addAll(txes.getFilterRoutingInfo().getMembers());
                    }
                    if (txes.getAdjunctRecipients() == null) continue;
                    Set<InternalDistributedMember> adjunctRecipients = txes.getAdjunctRecipients();
                    newMemberSet.addAll(adjunctRecipients);
                }
                if (!newMemberSet.equals(this.otherMembers)) {
                    msg.setUpdateLockMembers();
                    this.otherMembers = newMemberSet;
                }
                msg.finishRegion(this.otherMembers);
            }
        }
        catch (RegionDestroyedException regionDestroyedException) {
        }
        catch (CancelException cancelException) {
            // empty catch block
        }
    }

    void buildCompleteMessage(InternalRegion r, TXCommitMessage msg) {
        try {
            if (!this.entryMods.isEmpty()) {
                msg.startRegion(r, this.entryMods.size());
                for (Map.Entry<Object, TXEntryState> me : this.entryMods.entrySet()) {
                    Object eKey = me.getKey();
                    TXEntryState txes = me.getValue();
                    txes.buildCompleteMessage(r, eKey, msg, this.otherMembers);
                }
                msg.finishRegionComplete();
            }
        }
        catch (RegionDestroyedException regionDestroyedException) {
        }
        catch (CancelException cancelException) {
            // empty catch block
        }
    }

    void applyChangesStart(InternalRegion r, TXStateInterface txState) {
        try {
            r.txLRUStart();
        }
        catch (RegionDestroyedException regionDestroyedException) {
        }
        catch (CancelException cancelException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void applyChangesEnd(InternalRegion r, TXStateInterface txState) {
        try {
            try {
                if (this.uaMods != null) {
                    for (Map.Entry me : this.uaMods.entrySet()) {
                        Object eKey = me.getKey();
                        TXEntryUserAttrState txes = (TXEntryUserAttrState)me.getValue();
                        txes.applyChanges(r, eKey);
                    }
                }
            }
            finally {
                r.txLRUEnd();
            }
        }
        catch (RegionDestroyedException regionDestroyedException) {
        }
        catch (CancelException cancelException) {
            // empty catch block
        }
    }

    void getEvents(InternalRegion r, ArrayList events, TXState txs) {
        for (Map.Entry<Object, TXEntryState> me : this.entryMods.entrySet()) {
            Object eKey = me.getKey();
            TXEntryState txes = me.getValue();
            if (!txes.isDirty() || !txes.isOpAnyEvent(r)) continue;
            events.add(txes.getEvent(r, eKey, txs));
        }
    }

    void getEntries(ArrayList entries, InternalRegion r) {
        for (Map.Entry<Object, TXEntryState> me : this.entryMods.entrySet()) {
            Object eKey = me.getKey();
            TXEntryState txes = me.getValue();
            entries.add(new TXState.TXEntryStateWithRegionAndKey(txes, r, eKey));
        }
    }

    void cleanup(InternalRegion r) {
        if (this.cleanedUp) {
            return;
        }
        this.cleanedUp = true;
        for (TXEntryState es : this.entryMods.values()) {
            es.cleanup(r);
        }
        this.region.setInUseByTransaction(false);
    }

    int getChanges() {
        int changes = 0;
        for (Map.Entry<Object, TXEntryState> me : this.entryMods.entrySet()) {
            TXEntryState txes = me.getValue();
            if (!txes.isDirty()) continue;
            ++changes;
        }
        if (this.uaMods != null) {
            changes += this.uaMods.size();
        }
        return changes;
    }

    public TXState getTXState() {
        return this.txState;
    }

    public void close() {
        for (TXEntryState e : this.entryMods.values()) {
            e.close();
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("{").append(super.toString()).append(" ");
        str.append(" ,entryMods=").append(this.entryMods);
        str.append(" ,isCreatedDuringCommit=").append(this.isCreatedDuringCommit());
        str.append("}");
        return str.toString();
    }

    public boolean isCreatedDuringCommit() {
        return this.createdDuringCommit;
    }

    public void setCreatedDuringCommit(boolean createdDuringCommit) {
        this.createdDuringCommit = createdDuringCommit;
    }

    public boolean populateDistTxEntryStateList(ArrayList<TXEntryState.DistTxThinEntryState> entryStateList) {
        String regionFullPath = this.getRegion().getFullPath();
        try {
            if (!this.entryMods.isEmpty()) {
                for (Map.Entry<Object, TXEntryState> em : this.entryMods.entrySet()) {
                    Object mKey = em.getKey();
                    TXEntryState txes = em.getValue();
                    TXEntryState.DistTxThinEntryState thinEntryState = txes.getDistTxEntryStates();
                    entryStateList.add(thinEntryState);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("TXRegionState.populateDistTxEntryStateList Added " + thinEntryState + " for key=" + mKey + " ,op=" + txes.opToString() + " ,region=" + regionFullPath);
                }
            }
            return true;
        }
        catch (RegionDestroyedException regionDestroyedException) {
        }
        catch (CancelException cancelException) {
            // empty catch block
        }
        if (logger.isDebugEnabled()) {
            logger.debug("TXRegionState.populateDistTxEntryStateList Got exception for region " + regionFullPath);
        }
        return false;
    }

    public void setDistTxEntryStates(ArrayList<TXEntryState.DistTxThinEntryState> entryEventList) {
        int entryEventListSize;
        String regionFullPath = this.getRegion().getFullPath();
        int entryModsSize = this.entryMods.size();
        if (entryModsSize != (entryEventListSize = entryEventList.size())) {
            throw new UnsupportedOperationInTransactionException(String.format("Expected %s during a distributed transaction but got %s", "entry size of " + entryModsSize + " for region " + regionFullPath, entryEventListSize));
        }
        int index = 0;
        for (Map.Entry<Object, TXEntryState> em : this.entryMods.entrySet()) {
            Object mKey = em.getKey();
            TXEntryState txes = em.getValue();
            TXEntryState.DistTxThinEntryState thinEntryState = entryEventList.get(index++);
            txes.setDistTxEntryStates(thinEntryState);
            if (!logger.isDebugEnabled()) continue;
            logger.debug("TxRegionState.setDistTxEntryStates Added " + thinEntryState + " for key=" + mKey + " ,op=" + txes.opToString() + " ,region=" + regionFullPath);
        }
    }
}

