/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.SystemFailure;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.CacheRuntimeException;
import org.apache.geode.cache.CommitDistributionException;
import org.apache.geode.cache.CommitIncompleteException;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.RegionDistributionException;
import org.apache.geode.cache.TransactionId;
import org.apache.geode.cache.TransactionListener;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.MembershipListener;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.PooledDistributionMessage;
import org.apache.geode.distributed.internal.ReliableReplyProcessor21;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.ReplySender;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.CacheDistributionAdvisee;
import org.apache.geode.internal.cache.CachedDeserializableFactory;
import org.apache.geode.internal.cache.CommitReplyException;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EnumListenerEvent;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.FilterRoutingInfo;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.TXEntryState;
import org.apache.geode.internal.cache.TXFarSideCMTracker;
import org.apache.geode.internal.cache.TXId;
import org.apache.geode.internal.cache.TXRmtEvent;
import org.apache.geode.internal.cache.TXState;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.TxCallbackEventFactory;
import org.apache.geode.internal.cache.TxCallbackEventFactoryImpl;
import org.apache.geode.internal.cache.locks.TXLockId;
import org.apache.geode.internal.cache.locks.TXLockIdImpl;
import org.apache.geode.internal.cache.locks.TXLockService;
import org.apache.geode.internal.cache.partitioned.Bucket;
import org.apache.geode.internal.cache.persistence.PersistentMemberID;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.versions.VersionSource;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.LoggingThread;
import org.apache.logging.log4j.Logger;

public class TXCommitMessage
extends PooledDistributionMessage
implements MembershipListener,
MessageWithReply {
    private static final Logger logger = LogService.getLogger();
    @MakeNotStatic
    protected static final TXFarSideCMTracker txTracker = new TXFarSideCMTracker(65520);
    private ArrayList<RegionCommit> regions;
    protected TXId txIdent;
    protected int processorId;
    protected TXLockIdImpl lockId;
    protected HashSet farSiders;
    protected transient DistributionManager dm;
    private transient int sequenceNum = 0;
    private transient HashMap<InternalDistributedMember, RegionCommitList> msgMap = null;
    private transient RegionCommit currentRegion;
    protected transient TXState txState = null;
    private transient boolean wasProcessed;
    private transient boolean isProcessing;
    private transient boolean dontProcess;
    private transient boolean departureNoticed = false;
    private transient boolean lockNeedsUpdate = false;
    private transient boolean ackRequired = true;
    protected transient ArrayList farSideEntryOps;
    private byte[] farsideBaseMembershipId;
    private long farsideBaseThreadId;
    private long farsideBaseSequenceId;
    private transient boolean hasReliableRegions = false;
    private transient Set processingExceptions = Collections.emptySet();
    private ClientProxyMembershipID bridgeContext = null;
    private transient Version clientVersion;
    @Immutable
    public static final TXCommitMessage CMT_CONFLICT_MSG = new TXCommitMessage();
    @Immutable
    public static final TXCommitMessage REBALANCE_MSG = new TXCommitMessage();
    @Immutable
    public static final TXCommitMessage EXCEPTION_MSG = new TXCommitMessage();
    @Immutable
    public static final TXCommitMessage ROLLBACK_MSG = new TXCommitMessage();
    Map viewVersions = new HashMap();
    private Boolean needsLargeModCount;
    private transient boolean disableListeners = false;

    public TXCommitMessage(TXId txIdent, DistributionManager dm, TXState txState) {
        this.dm = dm;
        this.txIdent = txIdent;
        this.lockId = null;
        this.regions = null;
        this.txState = txState;
        this.wasProcessed = false;
        this.isProcessing = false;
        this.dontProcess = false;
        this.farSiders = null;
        this.bridgeContext = txState.bridgeContext;
    }

    public TXCommitMessage() {
    }

    public static TXFarSideCMTracker getTracker() {
        return txTracker;
    }

    protected EventID getEventId(int eventOffset) {
        return new EventID(this.farsideBaseMembershipId, this.farsideBaseThreadId, this.farsideBaseSequenceId + (long)eventOffset);
    }

    public static TXCommitMessage waitForMessage(Object id, DistributionManager dm) {
        TXFarSideCMTracker map = TXCommitMessage.getTracker();
        return map.waitForMessage(id, dm);
    }

    void startRegion(InternalRegion r, int maxSize) {
        this.currentRegion = new RegionCommit(this, r, maxSize);
        if (r.requiresReliabilityCheck()) {
            this.hasReliableRegions = true;
        }
    }

    void finishRegion(Set<InternalDistributedMember> s) {
        if (!this.currentRegion.isEmpty() && s != null && !s.isEmpty()) {
            this.currentRegion.persistentIds = this.getPersistentIds(this.currentRegion.internalRegion);
            if (this.msgMap == null) {
                this.msgMap = new HashMap();
            }
            RegionCommitList newRCL = null;
            for (InternalDistributedMember recipient : s) {
                if (!this.dm.getDistributionManagerIds().contains(recipient)) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Skipping member {} due to dist list absence", (Object)recipient);
                    continue;
                }
                RegionCommitList rcl = this.msgMap.get(recipient);
                if (rcl == null) {
                    if (newRCL == null) {
                        rcl = new RegionCommitList();
                        rcl.add(this.currentRegion);
                        newRCL = rcl;
                    } else {
                        rcl = newRCL;
                    }
                    this.msgMap.put(recipient, rcl);
                    continue;
                }
                if (rcl.get(rcl.size() - 1) == this.currentRegion) continue;
                rcl.add(this.currentRegion);
            }
            for (Map.Entry<InternalDistributedMember, RegionCommitList> me : this.msgMap.entrySet()) {
                RegionCommitList rcl;
                RegionCommitList trimmedRcl;
                if (s.contains(me.getKey()) || (trimmedRcl = (rcl = me.getValue()).trim(this.currentRegion)) == rcl) continue;
                me.setValue(trimmedRcl);
            }
        }
        this.currentRegion = null;
    }

    private Map<InternalDistributedMember, PersistentMemberID> getPersistentIds(InternalRegion r) {
        if (r instanceof DistributedRegion) {
            return ((CacheDistributionAdvisee)((Object)r)).getCacheDistributionAdvisor().advisePersistentMembers();
        }
        return Collections.emptyMap();
    }

    void finishRegionComplete() {
        if (!this.currentRegion.isEmpty()) {
            if (this.regions == null) {
                this.regions = new RegionCommitList();
            }
            this.regions.add(this.currentRegion);
        }
        this.currentRegion = null;
    }

    protected void addViewVersion(DistributedRegion dr, long version) {
        this.viewVersions.put(dr, version);
    }

    protected void releaseViewVersions() {
        RuntimeException rte = null;
        for (Map.Entry e : this.viewVersions.entrySet()) {
            DistributedRegion dr = (DistributedRegion)e.getKey();
            Long viewVersion = (Long)e.getValue();
            try {
                dr.getDistributionAdvisor().endOperation(viewVersion);
            }
            catch (RuntimeException ex) {
                rte = ex;
            }
        }
        if (rte != null) {
            throw rte;
        }
    }

    private boolean isEmpty() {
        return this.msgMap == null || this.msgMap.isEmpty();
    }

    void addOp(InternalRegion r, Object key, TXEntryState entry, Set otherRecipients) {
        this.currentRegion.addOp(key, entry);
    }

    void send(TXLockId lockId) {
        if (this.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("empty transaction - nothing to distribute");
            }
            return;
        }
        Assert.assertTrue(this.txState != null, "Send must have transaction state.");
        this.lockId = (TXLockIdImpl)lockId;
        this.updateLockMembers();
        IdentityHashMap<RegionCommitList, HashSet<InternalDistributedMember>> distMap = new IdentityHashMap<RegionCommitList, HashSet<InternalDistributedMember>>();
        HashSet<InternalDistributedMember> ackReceivers = null;
        for (Map.Entry<InternalDistributedMember, RegionCommitList> me : this.msgMap.entrySet()) {
            HashSet<InternalDistributedMember> receivers;
            RegionCommitList rcl = me.getValue();
            if (rcl.getNeedsAck()) {
                if (ackReceivers == null) {
                    ackReceivers = new HashSet<InternalDistributedMember>();
                }
                ackReceivers.add(me.getKey());
            }
            if ((receivers = (HashSet<InternalDistributedMember>)distMap.get(rcl)) == null) {
                receivers = new HashSet<InternalDistributedMember>();
                distMap.put(rcl, receivers);
            }
            receivers.add(me.getKey());
        }
        CommitReplyProcessor processor = null;
        if (ackReceivers != null) {
            processor = new CommitReplyProcessor(this.dm, ackReceivers, this.msgMap);
            if (ackReceivers.size() > 1) {
                this.farSiders = ackReceivers;
            }
            processor.enableSevereAlertProcessing();
        }
        for (Map.Entry me : distMap.entrySet()) {
            RegionCommitList rcl = (RegionCommitList)me.getKey();
            HashSet recipients = (HashSet)me.getValue();
            recipients.retainAll(this.dm.getDistributionManagerIds());
            if (recipients.isEmpty()) continue;
            if (this.txState.internalDuringIndividualSend != null) {
                Iterator indivRecip = recipients.iterator();
                while (indivRecip.hasNext()) {
                    this.txState.internalDuringIndividualSend.run();
                    this.setRecipientsSendData(Collections.singleton(indivRecip.next()), processor, rcl);
                }
                continue;
            }
            this.setRecipientsSendData(recipients, processor, rcl);
        }
        if (this.txState.internalAfterIndividualSend != null) {
            this.txState.internalAfterIndividualSend.run();
        }
        if (processor != null) {
            CommitProcessMessage cpMsg = this.lockId != null ? new CommitProcessForLockIdMessage(this.lockId) : new CommitProcessForTXIdMessage(this.txIdent);
            if (this.txState.internalDuringIndividualCommitProcess != null) {
                Iterator indivRecip = ackReceivers.iterator();
                while (indivRecip.hasNext()) {
                    this.txState.internalDuringIndividualCommitProcess.run();
                    cpMsg.setRecipients(Collections.singleton(indivRecip.next()));
                    this.dm.putOutgoing(cpMsg);
                    cpMsg.resetRecipients();
                }
            } else {
                cpMsg.setRecipients(ackReceivers);
                this.dm.putOutgoing(cpMsg);
            }
            if (this.txState.internalAfterIndividualCommitProcess != null) {
                this.txState.internalAfterIndividualCommitProcess.run();
            }
            this.dm.getCancelCriterion().checkCancelInProgress(null);
            processor.waitForCommitCompletion();
            this.dm.getStats().incCommitWaits();
        }
        if (this.hasReliableRegions) {
            this.checkDistributionReliability(distMap, processor);
        }
    }

    @Override
    public boolean containsRegionContentChange() {
        return true;
    }

    private void checkDistributionReliability(Map distMap, CommitReplyProcessor processor) {
        IdentityHashMap regionToRecipients = new IdentityHashMap();
        for (Map.Entry me : distMap.entrySet()) {
            RegionCommitList rcl = (RegionCommitList)me.getKey();
            Set recipients = (Set)me.getValue();
            for (RegionCommit rc : rcl) {
                if (!rc.internalRegion.requiresReliabilityCheck()) continue;
                HashSet recipientsForRegion = (HashSet)regionToRecipients.get(rc);
                if (recipientsForRegion == null) {
                    recipientsForRegion = new HashSet();
                    regionToRecipients.put(rc, recipientsForRegion);
                }
                if (recipients == null) continue;
                recipientsForRegion.addAll(recipients);
            }
        }
        Set cacheClosedMembers = processor == null ? Collections.emptySet() : processor.getCacheClosedMembers();
        Set departedMembers = processor == null ? Collections.emptySet() : processor.getDepartedMembers();
        Set regionDistributionExceptions = Collections.emptySet();
        Set failedRegionNames = Collections.emptySet();
        for (Map.Entry me : regionToRecipients.entrySet()) {
            RegionCommit rc = (RegionCommit)me.getKey();
            HashSet<InternalDistributedMember> successfulRecipients = new HashSet<InternalDistributedMember>(this.msgMap.keySet());
            successfulRecipients.removeAll(departedMembers);
            Set regionDestroyedMembers = processor == null ? Collections.emptySet() : processor.getRegionDestroyedMembers(rc.internalRegion.getFullPath());
            successfulRecipients.removeAll(cacheClosedMembers);
            successfulRecipients.removeAll(regionDestroyedMembers);
            try {
                rc.internalRegion.handleReliableDistribution(successfulRecipients);
            }
            catch (RegionDistributionException e) {
                if (regionDistributionExceptions == Collections.emptySet()) {
                    regionDistributionExceptions = new HashSet();
                    failedRegionNames = new HashSet();
                }
                regionDistributionExceptions.add(e);
                failedRegionNames.add(rc.internalRegion.getFullPath());
            }
        }
        if (!regionDistributionExceptions.isEmpty()) {
            throw new CommitDistributionException(String.format("These regions experienced reliability failure during distribution of the operation: %s", failedRegionNames), regionDistributionExceptions);
        }
    }

    private void setRecipientsSendData(Set recipients, ReplyProcessor21 processor, RegionCommitList rcl) {
        this.setRecipients(recipients);
        this.regions = rcl;
        this.processorId = rcl.getNeedsAck() ? processor.getProcessorId() : 0;
        this.dm.getStats().incSentCommitMessages(1L);
        ++this.sequenceNum;
        this.dm.putOutgoing(this);
        this.resetRecipients();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(ClusterDistributionManager dm) {
        this.dm = dm;
        if (this.farSiders != null) {
            this.farSiders.remove(dm.getId());
        }
        if (this.processorId != 0) {
            TXLockService.createDTLS(this.dm.getSystem());
            TXCommitMessage tXCommitMessage = this;
            synchronized (tXCommitMessage) {
                this.dm.addMembershipListener(this);
                if (logger.isDebugEnabled()) {
                    Object key = this.getTrackerKey();
                    logger.debug("Adding key:{} class{} to tracker list", key, (Object)key.getClass().getName());
                }
                txTracker.add(this);
            }
            if (!this.dm.getDistributionManagerIds().contains(this.getSender())) {
                this.memberDeparted(this.dm, this.getSender(), false);
            }
        } else {
            this.basicProcess();
        }
    }

    void addFarSideEntryOp(RegionCommit.FarSideEntryOp entryOp) {
        this.farSideEntryOps.add(entryOp);
    }

    protected void addProcessingException(Exception e) {
        if (this.processingExceptions == Collections.emptySet() || e instanceof CancelException) {
            this.processingExceptions = new HashSet();
        }
        this.processingExceptions.add(e);
    }

    public void setDM(DistributionManager dm) {
        this.dm = dm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void basicProcess() {
        DistributionManager dm = this.dm;
        TXCommitMessage tXCommitMessage = this;
        synchronized (tXCommitMessage) {
            if (this.isProcessing()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("TXCommitMessage {} is already in process, returning", (Object)this);
                }
                return;
            }
            this.setIsProcessing(true);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("begin processing TXCommitMessage for {}", (Object)this.txIdent);
        }
        int oldLevel = LocalRegion.setThreadInitLevelRequirement(1);
        boolean forceListener = false;
        try {
            TXRmtEvent txEvent = null;
            InternalCache cache = dm.getExistingCache();
            if (cache == null) {
                this.addProcessingException(new CacheClosedException());
                return;
            }
            TransactionListener[] tls = cache.getCacheTransactionManager().getListeners();
            if (tls.length > 0) {
                txEvent = new TXRmtEvent(this.txIdent, cache);
            }
            try {
                boolean internalEvent;
                Iterator<RegionCommit> it;
                try {
                    it = this.regions.iterator();
                    while (it.hasNext()) {
                        boolean failedBeginProcess = true;
                        RegionCommit rc = it.next();
                        try {
                            failedBeginProcess = !rc.beginProcess(dm, this.txIdent, txEvent);
                        }
                        catch (CacheRuntimeException problem) {
                            this.processCacheRuntimeException(problem);
                        }
                        finally {
                            if (!failedBeginProcess) continue;
                            rc.internalRegion = null;
                            it.remove();
                        }
                    }
                    this.basicProcessOps();
                }
                finally {
                    it = this.regions.iterator();
                    while (it.hasNext()) {
                        try {
                            RegionCommit rc = it.next();
                            rc.endProcess();
                            if (!rc.isForceFireEvent(dm)) continue;
                            forceListener = true;
                        }
                        catch (CacheRuntimeException problem) {
                            this.processCacheRuntimeException(problem);
                        }
                    }
                }
                boolean bl = internalEvent = txEvent != null && txEvent.hasOnlyInternalEvents();
                if (!this.disableListeners && !internalEvent && (forceListener || txEvent != null && !txEvent.isEmpty())) {
                    for (int i = 0; i < tls.length; ++i) {
                        try {
                            tls[i].afterCommit(txEvent);
                            continue;
                        }
                        catch (VirtualMachineError err) {
                            SystemFailure.initiateFailure(err);
                            throw err;
                        }
                        catch (Throwable t) {
                            SystemFailure.checkFailure();
                            logger.error("Exception occurred in TransactionListener", t);
                        }
                    }
                }
            }
            catch (CancelException e) {
                this.processCacheRuntimeException(e);
            }
            finally {
                if (txEvent != null) {
                    txEvent.freeOffHeapResources();
                }
            }
        }
        finally {
            LocalRegion.setThreadInitLevelRequirement(oldLevel);
            if (this.isAckRequired()) {
                this.ack();
            }
            if (!dm.getExistingCache().isClient() && this.bridgeContext != null) {
                TXCommitMessage.getTracker().saveTXForClientFailover(this.txIdent, this);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("completed processing TXCommitMessage for {}", (Object)this.txIdent);
            }
        }
    }

    public void basicProcessOps() {
        ArrayList<EntryEventImpl> pendingCallbacks = new ArrayList<EntryEventImpl>(this.farSideEntryOps.size());
        Collections.sort(this.farSideEntryOps);
        Iterator it = this.farSideEntryOps.iterator();
        while (it.hasNext()) {
            try {
                RegionCommit.FarSideEntryOp entryOp = (RegionCommit.FarSideEntryOp)it.next();
                entryOp.process(pendingCallbacks);
            }
            catch (CacheRuntimeException problem) {
                this.processCacheRuntimeException(problem);
            }
            catch (Exception e) {
                this.addProcessingException(e);
            }
        }
        this.firePendingCallbacks(pendingCallbacks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePendingCallbacks(List<EntryEventImpl> callbacks) {
        for (EntryEventImpl ee : callbacks) {
            try {
                if (ee.getOperation().isDestroy()) {
                    ee.getRegion().invokeTXCallbacks(EnumListenerEvent.AFTER_DESTROY, ee, true);
                    continue;
                }
                if (ee.getOperation().isInvalidate()) {
                    ee.getRegion().invokeTXCallbacks(EnumListenerEvent.AFTER_INVALIDATE, ee, true);
                    continue;
                }
                if (ee.getOperation().isCreate()) {
                    ee.getRegion().invokeTXCallbacks(EnumListenerEvent.AFTER_CREATE, ee, true);
                    continue;
                }
                ee.getRegion().invokeTXCallbacks(EnumListenerEvent.AFTER_UPDATE, ee, true);
            }
            finally {
                ee.release();
            }
        }
    }

    protected void processCacheRuntimeException(CacheRuntimeException problem) {
        if (problem instanceof RegionDestroyedException) {
            this.addProcessingException(problem);
        } else {
            if (problem instanceof CancelException) {
                this.addProcessingException(problem);
                throw problem;
            }
            this.addProcessingException(problem);
            logger.error("Transaction message {} from sender {} failed processing, unknown transaction state: {}", new Object[]{this, this.getSender(), problem});
        }
    }

    private void ack() {
        if (this.processorId != 0) {
            CommitReplyException replyEx = null;
            if (!this.processingExceptions.isEmpty()) {
                replyEx = new CommitReplyException(String.format("Commit operation generated one or more exceptions from %s", this.getSender()), this.processingExceptions);
            }
            ReplyMessage.send(this.getSender(), this.processorId, replyEx, (ReplySender)this.dm);
        }
    }

    @Override
    public int getDSFID() {
        return 110;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        int pId = in.readInt();
        if (this.isAckRequired()) {
            this.processorId = pId;
            ReplyProcessor21.setMessageRPId(this.processorId);
        } else {
            this.processorId = -1;
        }
        this.txIdent = TXId.createFromData(in);
        if (in.readBoolean()) {
            this.lockId = TXLockIdImpl.createFromData(in);
        }
        int totalMaxSize = in.readInt();
        this.farsideBaseMembershipId = DataSerializer.readByteArray(in);
        this.farsideBaseThreadId = in.readLong();
        this.farsideBaseSequenceId = in.readLong();
        this.needsLargeModCount = in.readBoolean();
        boolean hasShadowKeys = this.hasFlagsField(in) ? in.readBoolean() : this.useShadowKey();
        int regionsSize = in.readInt();
        this.regions = new ArrayList(regionsSize);
        this.farSideEntryOps = new ArrayList(totalMaxSize);
        for (int i = 0; i < regionsSize; ++i) {
            RegionCommit rc = new RegionCommit(this);
            try {
                rc.fromData(in, hasShadowKeys);
            }
            catch (CacheClosedException cce) {
                this.addProcessingException(cce);
                return;
            }
            this.regions.add(rc);
        }
        this.bridgeContext = ClientProxyMembershipID.readCanonicalized(in);
        this.farSiders = DataSerializer.readHashSet(in);
    }

    private boolean isAckRequired() {
        return this.ackRequired;
    }

    public void setAckRequired(boolean a) {
        this.ackRequired = a;
        if (!a) {
            this.processorId = -1;
        }
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        RegionCommit rc;
        int i;
        out.writeInt(this.processorId);
        InternalDataSerializer.invokeToData(this.txIdent, out);
        boolean hasLockId = this.lockId != null;
        out.writeBoolean(hasLockId);
        if (hasLockId) {
            InternalDataSerializer.invokeToData(this.lockId, out);
        }
        int regionsSize = 0;
        int totalMaxSize = 0;
        if (this.regions != null) {
            regionsSize = this.regions.size();
            for (i = 0; i < this.regions.size(); ++i) {
                rc = this.regions.get(i);
                totalMaxSize += rc.maxSize;
            }
        }
        out.writeInt(totalMaxSize);
        if (this.txState != null) {
            DataSerializer.writeByteArray(this.txState.getBaseMembershipId(), out);
            out.writeLong(this.txState.getBaseThreadId());
            out.writeLong(this.txState.getBaseSequenceId());
        } else {
            DataSerializer.writeByteArray(this.farsideBaseMembershipId, out);
            out.writeLong(this.farsideBaseThreadId);
            out.writeLong(this.farsideBaseSequenceId);
        }
        if (this.txState != null) {
            DataSerializer.writeBoolean(this.txState.needsLargeModCount(), out);
        } else {
            DataSerializer.writeBoolean(this.needsLargeModCount, out);
        }
        boolean useShadowKey = this.useShadowKey();
        if (this.hasFlagsField(out)) {
            out.writeBoolean(useShadowKey);
        }
        out.writeInt(regionsSize);
        if (regionsSize > 0) {
            for (i = 0; i < this.regions.size(); ++i) {
                rc = this.regions.get(i);
                rc.toData(out, useShadowKey);
            }
        }
        DataSerializer.writeObject(this.bridgeContext, out);
        DataSerializer.writeHashSet(this.farSiders, out);
    }

    private boolean hasFlagsField(DataOutput out) {
        return this.hasFlagsField(InternalDataSerializer.getVersionForDataStream(out));
    }

    private boolean hasFlagsField(DataInput in) {
        return this.hasFlagsField(InternalDataSerializer.getVersionForDataStream(in));
    }

    private boolean hasFlagsField(Version version) {
        return version.compareTo(Version.GEODE_1_7_0) >= 0;
    }

    private boolean useShadowKey() {
        return null == this.clientVersion;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder(256);
        result.append("TXCommitMessage@").append(System.identityHashCode(this)).append("#").append(this.sequenceNum).append(" processorId=").append(this.processorId).append(" txId=").append(this.txIdent);
        if (this.farSiders != null) {
            Iterator fs = this.farSiders.iterator();
            result.append(" farSiders=");
            while (fs.hasNext()) {
                result.append(fs.next());
                if (!fs.hasNext()) continue;
                result.append(' ');
            }
        } else {
            result.append(" farSiders=<null>");
        }
        if (this.regions != null) {
            Iterator<RegionCommit> it = this.regions.iterator();
            while (it.hasNext()) {
                result.append(' ').append(it.next());
            }
        }
        return result.toString();
    }

    public static TXCommitMessage combine(Set<TXCommitMessage> msgSet) {
        assert (msgSet != null);
        TXCommitMessage firstPart = null;
        Iterator<TXCommitMessage> it = msgSet.iterator();
        while (it.hasNext()) {
            if (firstPart == null) {
                firstPart = it.next();
                continue;
            }
            firstPart.combine(it.next());
        }
        return firstPart;
    }

    public void combine(TXCommitMessage other) {
        assert (other != null);
        Iterator<RegionCommit> it = other.regions.iterator();
        HashMap<String, RegionCommit> regionCommits = new HashMap<String, RegionCommit>();
        for (RegionCommit commit : this.regions) {
            regionCommits.put(commit.getRegionPath(), commit);
        }
        for (RegionCommit commit : other.regions) {
            if (regionCommits.containsKey(commit.getRegionPath())) continue;
            commit.msg = this;
            this.regions.add(commit);
            regionCommits.put(commit.getRegionPath(), commit);
        }
    }

    Object getTrackerKey() {
        if (this.lockId != null) {
            return this.lockId;
        }
        return this.txIdent;
    }

    boolean dontProcess() {
        return this.dontProcess;
    }

    void setDontProcess() {
        this.dontProcess = true;
    }

    boolean isProcessing() {
        return this.isProcessing;
    }

    private void setIsProcessing(boolean isProcessing) {
        this.isProcessing = isProcessing;
    }

    boolean wasProcessed() {
        return this.wasProcessed;
    }

    void setProcessed(boolean wasProcessed) {
        this.wasProcessed = wasProcessed;
    }

    @Override
    public void memberJoined(DistributionManager distributionManager, InternalDistributedMember id) {
    }

    @Override
    public void memberSuspect(DistributionManager distributionManager, InternalDistributedMember id, InternalDistributedMember whoSuspected, String reason) {
    }

    @Override
    public void quorumLost(DistributionManager distributionManager, Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
    }

    public boolean isDepartureNoticed() {
        return this.departureNoticed;
    }

    private void doOriginDepartedCommit() {
        try {
            this.processorId = 0;
            this.basicProcess();
        }
        finally {
            txTracker.processed(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void memberDeparted(DistributionManager distributionManager, InternalDistributedMember id, boolean crashed) {
        if (!this.getSender().equals(id)) {
            return;
        }
        distributionManager.removeMembershipListener(this);
        TXCommitMessage tXCommitMessage = this;
        synchronized (tXCommitMessage) {
            if (this.isProcessing() || this.departureNoticed) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Member departed: Commit data is already being processed for lockid: {}", (Object)this.lockId);
                }
                return;
            }
            this.departureNoticed = true;
        }
        if (this.getFarSiders() != null && !this.getFarSiders().isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Member departed: {} sending query for CommitProcess message to other recipients.", (Object)id);
            }
            LoggingThread fellowFarSidersQuery = new LoggingThread("CommitProcessQuery Thread", () -> this.doCommitProcessQuery(id));
            fellowFarSidersQuery.start();
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("Member departed: {}. Processing commit data.", (Object)this.getSender());
            }
            LoggingThread originDepartedCommit = new LoggingThread("Origin Departed Commit", this::doOriginDepartedCommit);
            originDepartedCommit.start();
        }
    }

    HashSet getFarSiders() {
        return this.farSiders;
    }

    DistributionManager getDistributionManager() {
        return this.dm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doCommitProcessQuery(InternalDistributedMember id) {
        CommitProcessQueryReplyProcessor replyProcessor = this.createReplyProcessor();
        CommitProcessQueryMessage queryMessage = this.createQueryMessage(replyProcessor);
        queryMessage.setRecipients(this.farSiders);
        this.getDistributionManager().putOutgoing(queryMessage);
        this.getDistributionManager().getCancelCriterion().checkCancelInProgress(null);
        try {
            replyProcessor.waitForRepliesUninterruptibly();
        }
        catch (ReplyException e) {
            e.handleCause();
        }
        if (replyProcessor.receivedACommitProcessMessage()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Transaction associated with lockID: {} from orign {} is processing due to a received \"commit process\" message", (Object)this.lockId, (Object)id);
            }
            try {
                this.processorId = 0;
                this.basicProcess();
            }
            finally {
                txTracker.processed(this);
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("Transaction associated with lockID: {} from origin {} ignored.  No other recipients received \"commit process\" message", (Object)this.lockId, (Object)id);
            }
            txTracker.removeMessage(this);
        }
    }

    CommitProcessQueryReplyProcessor createReplyProcessor() {
        return new CommitProcessQueryReplyProcessor(this.dm, this.farSiders);
    }

    CommitProcessQueryMessage createQueryMessage(CommitProcessQueryReplyProcessor replyProcessor) {
        return new CommitProcessQueryMessage(this.getTrackerKey(), replyProcessor.getProcessorId());
    }

    private DistributedMember getMemberFromTrackerKey(Object trackerKey) {
        if (trackerKey instanceof TXId) {
            TXId id1 = (TXId)trackerKey;
            return id1.getMemberId();
        }
        if (trackerKey instanceof TXLockId) {
            TXLockId id2 = (TXLockId)trackerKey;
            return id2.getMemberId();
        }
        return null;
    }

    void setUpdateLockMembers() {
        this.lockNeedsUpdate = true;
    }

    private void updateLockMembers() {
        if (this.lockNeedsUpdate && this.lockId != null) {
            TXLockService.createDTLS(this.dm.getSystem()).updateParticipants(this.lockId, this.msgMap.keySet());
        }
    }

    public void hookupRegions(DistributionManager dm) {
        if (this.regions != null) {
            for (RegionCommit rc : this.regions) {
                rc.hookupRegion(dm);
            }
        }
    }

    public void setDisableListeners(boolean b) {
        this.disableListeners = true;
    }

    public Version getClientVersion() {
        return this.clientVersion;
    }

    public void setClientVersion(Version clientVersion) {
        this.clientVersion = clientVersion;
    }

    public static class CommitExceptionCollectingException
    extends ReplyException {
        private static final long serialVersionUID = 589384721273797822L;
        private final Set<InternalDistributedMember> cacheExceptions = new HashSet<InternalDistributedMember>();
        private final Map<String, Set<InternalDistributedMember>> regionExceptions = new HashMap<String, Set<InternalDistributedMember>>();
        private final Map fatalExceptions = new HashMap();
        private final TXId id;

        public CommitExceptionCollectingException(TXId txIdent) {
            this.id = txIdent;
        }

        public void handlePotentialCommitFailure(HashMap<InternalDistributedMember, RegionCommitList> msgMap) {
            if (this.fatalExceptions.size() > 0) {
                StringBuilder errorMessage = new StringBuilder("Incomplete commit of transaction ").append(this.id).append(".  Caused by the following exceptions: ");
                for (Map.Entry me : this.fatalExceptions.entrySet()) {
                    DistributedMember mem = (DistributedMember)me.getKey();
                    errorMessage.append(" From member: ").append(mem).append(" ");
                    List exceptions = (List)me.getValue();
                    Iterator ei = exceptions.iterator();
                    while (ei.hasNext()) {
                        Exception e = (Exception)ei.next();
                        errorMessage.append(e);
                        for (StackTraceElement ste : e.getStackTrace()) {
                            errorMessage.append("\n\tat ").append(ste);
                        }
                        if (!ei.hasNext()) continue;
                        errorMessage.append("\nAND\n");
                    }
                    errorMessage.append(".");
                }
                throw new CommitIncompleteException(errorMessage.toString());
            }
            this.handleClosedMembers(msgMap);
            this.handleRegionDestroyed(msgMap);
        }

        private void handleRegionDestroyed(HashMap<InternalDistributedMember, RegionCommitList> msgMap) {
            if (this.regionExceptions == null || this.regionExceptions.isEmpty()) {
                return;
            }
            for (Map.Entry<InternalDistributedMember, RegionCommitList> memberMap : msgMap.entrySet()) {
                InternalDistributedMember member = memberMap.getKey();
                RegionCommitList rcl = memberMap.getValue();
                for (RegionCommit region : rcl) {
                    Set<InternalDistributedMember> failedMembers = this.regionExceptions.get(region.internalRegion.getFullPath());
                    if (failedMembers == null || !failedMembers.contains(member)) continue;
                    this.markMemberOffline(member, region);
                }
            }
        }

        private void handleClosedMembers(HashMap<InternalDistributedMember, RegionCommitList> msgMap) {
            for (InternalDistributedMember member : this.getCacheClosedMembers()) {
                RegionCommitList rcl = msgMap.get(member);
                for (RegionCommit region : rcl) {
                    this.markMemberOffline(member, region);
                }
            }
        }

        private void markMemberOffline(InternalDistributedMember member, RegionCommit region) {
            if (region.persistentIds == null) {
                return;
            }
            PersistentMemberID persistentId = region.persistentIds.get(member);
            if (persistentId != null) {
                region.internalRegion.getCancelCriterion().checkCancelInProgress(null);
                ((DistributedRegion)region.internalRegion).getPersistenceAdvisor().markMemberOffline(member, persistentId);
            }
        }

        public Set<InternalDistributedMember> getCacheClosedMembers() {
            return this.cacheExceptions;
        }

        public Set getRegionDestroyedMembers(String regionFullPath) {
            Set<InternalDistributedMember> members = this.regionExceptions.get(regionFullPath);
            if (members == null) {
                members = Collections.emptySet();
            }
            return members;
        }

        public void addExceptionsFromMember(InternalDistributedMember member, Set exceptions) {
            for (Exception ex : exceptions) {
                if (ex instanceof CancelException) {
                    this.cacheExceptions.add(member);
                    continue;
                }
                if (ex instanceof RegionDestroyedException) {
                    String r = ((RegionDestroyedException)ex).getRegionFullPath();
                    Set<InternalDistributedMember> members = this.regionExceptions.get(r);
                    if (members == null) {
                        members = new HashSet<InternalDistributedMember>();
                        this.regionExceptions.put(r, members);
                    }
                    members.add(member);
                    continue;
                }
                ArrayList<Exception> el = (ArrayList<Exception>)this.fatalExceptions.get(member);
                if (el == null) {
                    el = new ArrayList<Exception>(2);
                    this.fatalExceptions.put(member, el);
                }
                el.add(ex);
            }
        }
    }

    private class CommitReplyProcessor
    extends ReliableReplyProcessor21 {
        private HashMap msgMap;

        public CommitReplyProcessor(DistributionManager dm, Set initMembers, HashMap msgMap) {
            super(dm, (Collection)initMembers);
            this.msgMap = msgMap;
        }

        public void waitForCommitCompletion() {
            try {
                this.waitForRepliesUninterruptibly();
            }
            catch (CommitExceptionCollectingException e) {
                e.handlePotentialCommitFailure(this.msgMap);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processException(DistributionMessage msg, ReplyException ex) {
            if (msg instanceof ReplyMessage) {
                CommitReplyProcessor commitReplyProcessor = this;
                synchronized (commitReplyProcessor) {
                    if (this.exception == null) {
                        this.exception = new CommitExceptionCollectingException(TXCommitMessage.this.txIdent);
                    }
                    CommitExceptionCollectingException cce = (CommitExceptionCollectingException)this.exception;
                    if (ex instanceof CommitReplyException) {
                        CommitReplyException cre = (CommitReplyException)ex;
                        cce.addExceptionsFromMember(msg.getSender(), cre.getExceptions());
                    } else {
                        cce.addExceptionsFromMember(msg.getSender(), Collections.singleton(ex));
                    }
                }
            }
        }

        @Override
        protected boolean stopBecauseOfExceptions() {
            return false;
        }

        public Set getCacheClosedMembers() {
            if (this.exception != null) {
                CommitExceptionCollectingException cce = (CommitExceptionCollectingException)this.exception;
                return cce.getCacheClosedMembers();
            }
            return Collections.emptySet();
        }

        public Set getRegionDestroyedMembers(String regionFullPath) {
            if (this.exception != null) {
                CommitExceptionCollectingException cce = (CommitExceptionCollectingException)this.exception;
                return cce.getRegionDestroyedMembers(regionFullPath);
            }
            return Collections.emptySet();
        }
    }

    public static class CommitProcessQueryReplyProcessor
    extends ReplyProcessor21 {
        public boolean receivedOnePositive = false;

        CommitProcessQueryReplyProcessor(DistributionManager dm, Set members) {
            super(dm, (Collection)members);
        }

        @Override
        public void process(DistributionMessage msg) {
            CommitProcessQueryReplyMessage ccMess = (CommitProcessQueryReplyMessage)msg;
            if (ccMess.wasReceived()) {
                this.receivedOnePositive = true;
            }
            super.process(msg);
        }

        @Override
        protected boolean canStopWaiting() {
            return this.receivedOnePositive;
        }

        public boolean receivedACommitProcessMessage() {
            return this.receivedOnePositive;
        }
    }

    public static class CommitProcessQueryReplyMessage
    extends ReplyMessage {
        private boolean wasReceived;

        public CommitProcessQueryReplyMessage(boolean wasReceived) {
            this.wasReceived = wasReceived;
        }

        public CommitProcessQueryReplyMessage() {
        }

        public boolean wasReceived() {
            return this.wasReceived;
        }

        @Override
        public int getDSFID() {
            return -86;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.wasReceived = in.readBoolean();
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeBoolean(this.wasReceived);
        }

        @Override
        public String toString() {
            StringBuilder result = new StringBuilder(128);
            result.append("CommitProcessQueryReplyMessage@").append(System.identityHashCode(this)).append(" wasReceived=").append(this.wasReceived).append(" processorId=").append(this.processorId).append(" from ").append(this.getSender());
            return result.toString();
        }
    }

    public static class CommitProcessQueryMessage
    extends PooledDistributionMessage {
        private Object trackerKey;
        private int processorId;

        public CommitProcessQueryMessage() {
        }

        public CommitProcessQueryMessage(Object trackerKey, int processorId) {
            this.trackerKey = trackerKey;
            this.processorId = processorId;
        }

        @Override
        protected void process(ClusterDistributionManager dm) {
            boolean processMsgReceived = txTracker.commitProcessReceived(this.trackerKey);
            if (!processMsgReceived && logger.isDebugEnabled()) {
                logger.debug("CommitProcessQuery did not find {} in the history", this.trackerKey);
            }
            CommitProcessQueryReplyMessage resp = new CommitProcessQueryReplyMessage(processMsgReceived);
            resp.setProcessorId(this.processorId);
            resp.setRecipient(this.getSender());
            dm.putOutgoing(resp);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            DataSerializer.writeObject(this.trackerKey, out);
            out.writeInt(this.processorId);
        }

        @Override
        public int getDSFID() {
            return -87;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            this.trackerKey = DataSerializer.readObject(in);
            this.processorId = in.readInt();
        }

        @Override
        public String toString() {
            StringBuilder result = new StringBuilder(128);
            result.append("CommitProcessQueryMessage@").append(System.identityHashCode(this)).append(" trackerKeyClass=").append(this.trackerKey.getClass().getName()).append(" trackerKey=").append(this.trackerKey).append(" processorId=").append(this.processorId);
            return result.toString();
        }
    }

    public static abstract class CommitProcessMessage
    extends PooledDistributionMessage {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void basicProcess(TXCommitMessage mess, ClusterDistributionManager dm) {
            dm.removeMembershipListener(mess);
            TXCommitMessage tXCommitMessage = mess;
            synchronized (tXCommitMessage) {
                if (mess.dontProcess()) {
                    return;
                }
            }
            try {
                mess.basicProcess();
            }
            finally {
                txTracker.processed(mess);
            }
        }
    }

    public static class CommitProcessForTXIdMessage
    extends CommitProcessMessage {
        private TXId txId;

        public CommitProcessForTXIdMessage() {
        }

        public CommitProcessForTXIdMessage(TXId txId) {
            this.txId = txId;
            Assert.assertTrue(this.txId != null, "CommitProcessMessageForTXId must have a non-null txid!");
        }

        @Override
        protected void process(ClusterDistributionManager dm) {
            TXCommitMessage mess = TXCommitMessage.waitForMessage(this.txId, dm);
            Assert.assertTrue(mess != null, "Commit data for TXId: " + this.txId + " not found");
            this.basicProcess(mess, dm);
        }

        @Override
        public int getDSFID() {
            return 118;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            InternalDataSerializer.invokeToData(this.txId, out);
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            this.txId = TXId.createFromData(in);
            Assert.assertTrue(this.txId != null, "CommitProcessMessageForTXId must have a non-null txid!");
        }

        @Override
        public String toString() {
            StringBuilder result = new StringBuilder(128);
            result.append("CommitProcessForTXIdMessage@").append(System.identityHashCode(this)).append(" txId=").append(this.txId);
            return result.toString();
        }
    }

    public static class CommitProcessForLockIdMessage
    extends CommitProcessMessage {
        private TXLockId lockId;

        public CommitProcessForLockIdMessage() {
        }

        public CommitProcessForLockIdMessage(TXLockId lockId) {
            this.lockId = lockId;
            Assert.assertTrue(this.lockId != null, "CommitProcessForLockIdMessage must have a non-null lockid!");
        }

        @Override
        protected void process(ClusterDistributionManager dm) {
            TXCommitMessage mess = TXCommitMessage.waitForMessage(this.lockId, dm);
            Assert.assertTrue(mess != null, "Commit data for TXLockId: " + this.lockId + " not found");
            this.basicProcess(mess, dm);
        }

        @Override
        public int getDSFID() {
            return 122;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            InternalDataSerializer.invokeToData(this.lockId, out);
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            this.lockId = TXLockIdImpl.createFromData(in);
            Assert.assertTrue(this.lockId != null, "CommitProcessForLockIdMessage must have a non-null lockid!");
        }

        @Override
        public String toString() {
            StringBuilder result = new StringBuilder(128);
            result.append("CommitProcessForLockIdMessage@").append(System.identityHashCode(this)).append(" lockId=").append(this.lockId);
            return result.toString();
        }
    }

    public static class RegionCommit {
        private final TxCallbackEventFactory txCallbackEventFactory = new TxCallbackEventFactoryImpl();
        protected transient InternalRegion internalRegion;
        private String regionPath;
        private String parentRegionPath;
        private transient TXCommitMessage msg;
        private transient int refCount = 0;
        private transient HeapDataOutputStream preserializedBuffer = null;
        transient int maxSize;
        private transient ArrayList opKeys;
        private transient ArrayList opEntries;
        private transient VersionSource memberId;
        public Map<InternalDistributedMember, PersistentMemberID> persistentIds;
        private boolean needsUnlock;
        private boolean needsLRUEnd;
        private TXRmtEvent txEvent;

        RegionCommit(TXCommitMessage msg, InternalRegion r, int maxSize) {
            this.msg = msg;
            this.internalRegion = r;
            this.maxSize = maxSize;
        }

        RegionCommit(TXCommitMessage msg) {
            this.msg = msg;
        }

        public String getRegionPath() {
            return this.regionPath;
        }

        public void incRefCount() {
            ++this.refCount;
        }

        boolean beginProcess(DistributionManager dm, TransactionId txIdent, TXRmtEvent txEvent) throws CacheClosedException {
            if (logger.isDebugEnabled()) {
                logger.debug("begin processing TXCommitMessage {} for region {}", (Object)txIdent, (Object)this.regionPath);
            }
            try {
                if (!this.hookupRegion(dm)) {
                    return false;
                }
                if (this.msg.isAckRequired() && (this.internalRegion == null || !this.internalRegion.getScope().isDistributed())) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Received unneeded commit data for region {}", (Object)this.regionPath);
                    }
                    this.msg.addProcessingException(new RegionDestroyedException("Region not found", this.regionPath));
                    this.internalRegion = null;
                    return false;
                }
                this.needsUnlock = this.internalRegion.lockGII();
                this.internalRegion.txLRUStart();
                this.needsLRUEnd = true;
                if (this.internalRegion.isInitialized()) {
                    this.txEvent = txEvent;
                }
            }
            catch (RegionDestroyedException e) {
                this.msg.addProcessingException(e);
                if (logger.isDebugEnabled()) {
                    logger.debug("Received unneeded commit data for region {} because the region was destroyed.", (Object)this.regionPath, (Object)e);
                }
                this.internalRegion = null;
            }
            return this.internalRegion != null;
        }

        private boolean hookupRegion(DistributionManager dm) {
            this.internalRegion = this.getRegionByPath(dm, this.regionPath);
            if (this.internalRegion == null && this.parentRegionPath != null) {
                this.internalRegion = this.getRegionByPath(dm, this.parentRegionPath);
                this.regionPath = this.parentRegionPath;
            }
            return this.internalRegion != null || !dm.getSystem().isLoner();
        }

        LocalRegion getRegionByPath(DistributionManager dm, String regionPath) {
            InternalCache cache = dm.getCache();
            return cache == null ? null : (LocalRegion)cache.getRegionByPath(regionPath);
        }

        void endProcess() {
            if (this.internalRegion != null) {
                try {
                    if (this.needsLRUEnd) {
                        this.needsLRUEnd = false;
                        this.internalRegion.txLRUEnd();
                    }
                }
                finally {
                    if (this.needsUnlock) {
                        this.needsUnlock = false;
                        this.internalRegion.unlockGII();
                    }
                }
            }
        }

        private EventID getEventId(FarSideEntryOp entryOp) {
            return this.msg.getEventId(entryOp.eventOffset);
        }

        protected void txApplyEntryOp(FarSideEntryOp entryOp, List<EntryEventImpl> pendingCallbacks) {
            boolean callbacksOnly;
            if (this.internalRegion == null) {
                return;
            }
            EventID eventID = this.getEventId(entryOp);
            boolean isDuplicate = this.internalRegion.hasSeenEvent(eventID);
            boolean bl = callbacksOnly = this.internalRegion.getDataPolicy() == DataPolicy.PARTITION || isDuplicate;
            if (this.internalRegion instanceof PartitionedRegion) {
                EntryEventImpl eei = this.txCallbackEventFactory.createCallbackEvent(this.internalRegion, entryOp.op, entryOp.key, entryOp.value, this.msg.txIdent, this.txEvent, this.getEventId(entryOp), entryOp.callbackArg, entryOp.filterRoutingInfo, this.msg.bridgeContext, null, entryOp.versionTag, entryOp.tailKey);
                if (entryOp.filterRoutingInfo != null) {
                    eei.setLocalFilterInfo(entryOp.filterRoutingInfo.getFilterInfo(this.internalRegion.getCache().getMyId()));
                }
                if (isDuplicate) {
                    eei.setPossibleDuplicate(true);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("invoking transactional callbacks for {} key={} needsUnlock={} event={}", (Object)entryOp.op, entryOp.key, (Object)this.needsUnlock, (Object)eei);
                }
                boolean skipListeners = !isDuplicate;
                eei.setInvokePRCallbacks(!skipListeners);
                pendingCallbacks.add(eei);
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("applying transactional {} key={} needsUnlock={} eventId {} with routing {}", (Object)entryOp.op, entryOp.key, (Object)this.needsUnlock, (Object)this.getEventId(entryOp), (Object)entryOp.filterRoutingInfo);
            }
            if (entryOp.versionTag != null) {
                entryOp.versionTag.replaceNullIDs(this.msg.getSender());
            }
            if (entryOp.op.isDestroy()) {
                this.internalRegion.txApplyDestroy(entryOp.key, this.msg.txIdent, this.txEvent, this.needsUnlock, entryOp.op, this.getEventId(entryOp), entryOp.callbackArg, pendingCallbacks, entryOp.filterRoutingInfo, this.msg.bridgeContext, false, null, entryOp.versionTag, entryOp.tailKey);
            } else if (entryOp.op.isInvalidate()) {
                this.internalRegion.txApplyInvalidate(entryOp.key, Token.INVALID, entryOp.didDestroy, this.msg.txIdent, this.txEvent, false, this.getEventId(entryOp), entryOp.callbackArg, pendingCallbacks, entryOp.filterRoutingInfo, this.msg.bridgeContext, null, entryOp.versionTag, entryOp.tailKey);
            } else {
                this.internalRegion.txApplyPut(entryOp.op, entryOp.key, entryOp.value, entryOp.didDestroy, this.msg.txIdent, this.txEvent, this.getEventId(entryOp), entryOp.callbackArg, pendingCallbacks, entryOp.filterRoutingInfo, this.msg.bridgeContext, null, entryOp.versionTag, entryOp.tailKey);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void txApplyEntryOpAdjunctOnly(FarSideEntryOp entryOp) {
            boolean callbacksOnly;
            if (this.internalRegion == null) {
                return;
            }
            EventID eventID = this.getEventId(entryOp);
            boolean isDuplicate = this.internalRegion.hasSeenEvent(eventID);
            boolean bl = callbacksOnly = this.internalRegion.getDataPolicy() == DataPolicy.PARTITION || isDuplicate;
            if (this.internalRegion instanceof PartitionedRegion) {
                InternalDistributedMember thisMember;
                PartitionedRegion pr = (PartitionedRegion)this.internalRegion;
                BucketRegion br = pr.getBucketRegion(entryOp.key);
                Set bucketOwners = br.getBucketOwners();
                if (bucketOwners.contains(thisMember = this.internalRegion.getDistributionManager().getId())) {
                    return;
                }
                EntryEventImpl eei = this.txCallbackEventFactory.createCallbackEvent(this.internalRegion, entryOp.op, entryOp.key, entryOp.value, this.msg.txIdent, this.txEvent, this.getEventId(entryOp), entryOp.callbackArg, entryOp.filterRoutingInfo, this.msg.bridgeContext, null, entryOp.versionTag, entryOp.tailKey);
                try {
                    if (entryOp.filterRoutingInfo != null) {
                        eei.setLocalFilterInfo(entryOp.filterRoutingInfo.getFilterInfo(this.internalRegion.getCache().getMyId()));
                    }
                    if (isDuplicate) {
                        eei.setPossibleDuplicate(true);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("invoking transactional callbacks for {} key={} needsUnlock={} event={}", (Object)entryOp.op, entryOp.key, (Object)this.needsUnlock, (Object)eei);
                    }
                    boolean skipListeners = !isDuplicate;
                    eei.invokeCallbacks(this.internalRegion, skipListeners, true);
                }
                finally {
                    eei.release();
                }
                return;
            }
        }

        boolean isEmpty() {
            return this.opKeys == null;
        }

        boolean needsAck() {
            return this.internalRegion.getScope().isDistributedAck();
        }

        void addOp(Object key, TXEntryState entry) {
            if (this.opKeys == null) {
                this.opKeys = new ArrayList(this.maxSize);
                this.opEntries = new ArrayList(this.maxSize);
            }
            this.opKeys.add(key);
            this.opEntries.add(entry);
        }

        public boolean isForceFireEvent(DistributionManager dm) {
            LocalRegion r = this.getRegionByPath(dm, this.regionPath);
            return !(r instanceof PartitionedRegion) && (r == null || !r.isUsedForPartitionedRegionBucket());
        }

        public void fromData(DataInput in, boolean hasShadowKey) throws IOException, ClassNotFoundException {
            this.regionPath = DataSerializer.readString(in);
            this.parentRegionPath = DataSerializer.readString(in);
            int size = in.readInt();
            if (size > 0) {
                this.opKeys = new ArrayList(size);
                this.opEntries = new ArrayList(size);
                boolean largeModCount = in.readBoolean();
                this.memberId = (VersionSource)DataSerializer.readObject(in);
                for (int i = 0; i < size; ++i) {
                    FarSideEntryOp entryOp = new FarSideEntryOp();
                    entryOp.fromData(in, largeModCount, hasShadowKey);
                    if (entryOp.versionTag != null && this.memberId != null) {
                        entryOp.versionTag.setMemberID(this.memberId);
                    }
                    this.msg.addFarSideEntryOp(entryOp);
                    this.opKeys.add(entryOp.key);
                    this.opEntries.add(entryOp);
                }
            }
        }

        public String toString() {
            StringBuilder result = new StringBuilder(64);
            if (this.regionPath != null) {
                result.append(this.regionPath);
            } else {
                result.append(this.internalRegion.getFullPath());
            }
            if (this.refCount > 0) {
                result.append(" refCount=").append(this.refCount);
            }
            return result.toString();
        }

        private void basicToData(DataOutput out, boolean useShadowKey) throws IOException {
            if (this.internalRegion != null) {
                DataSerializer.writeString(this.internalRegion.getFullPath(), out);
                if (this.internalRegion instanceof BucketRegion) {
                    DataSerializer.writeString(((Bucket)((Object)this.internalRegion)).getPartitionedRegion().getFullPath(), out);
                } else {
                    DataSerializer.writeString(null, out);
                }
            } else {
                DataSerializer.writeString(this.regionPath, out);
                DataSerializer.writeString(this.parentRegionPath, out);
            }
            if (this.isEmpty() || this.opKeys.size() == 0) {
                out.writeInt(0);
            } else {
                boolean sendVersionTags;
                int size = this.opKeys.size();
                out.writeInt(size);
                boolean largeModCount = this.msg.txState != null ? this.msg.txState.needsLargeModCount() : this.msg.needsLargeModCount.booleanValue();
                out.writeBoolean(largeModCount);
                boolean bl = sendVersionTags = this.msg.clientVersion == null || Version.GFE_70.compareTo(this.msg.clientVersion) <= 0;
                if (sendVersionTags) {
                    VersionSource member = this.memberId;
                    if (member == null) {
                        if (this.internalRegion == null) {
                            Assert.assertTrue(this.msg.txState == null);
                        } else {
                            member = this.internalRegion.getVersionMember();
                        }
                    }
                    DataSerializer.writeObject(member, out);
                }
                for (int i = 0; i < size; ++i) {
                    DataSerializer.writeObject(this.opKeys.get(i), out);
                    if (this.msg.txState != null) {
                        ((TXEntryState)this.opEntries.get(i)).toFarSideData(out, largeModCount, sendVersionTags, useShadowKey);
                        continue;
                    }
                    ((FarSideEntryOp)this.opEntries.get(i)).toData(out, largeModCount, sendVersionTags, useShadowKey);
                }
            }
        }

        public void toData(DataOutput out, boolean useShadowKey) throws IOException {
            if (this.preserializedBuffer != null) {
                this.preserializedBuffer.rewind();
                this.preserializedBuffer.sendTo(out);
            } else if (this.refCount > 1) {
                Version v = InternalDataSerializer.getVersionForDataStream(out);
                HeapDataOutputStream hdos = new HeapDataOutputStream(1024, v);
                this.basicToData(hdos, useShadowKey);
                this.preserializedBuffer = hdos;
                this.preserializedBuffer.sendTo(out);
            } else {
                this.basicToData(out, useShadowKey);
            }
        }

        public class FarSideEntryOp
        implements Comparable {
            public Operation op;
            public int modSerialNum;
            public int eventOffset;
            public Object key;
            public Object value;
            public boolean didDestroy;
            public Object callbackArg;
            private FilterRoutingInfo filterRoutingInfo;
            private VersionTag versionTag;
            private long tailKey;

            public void fromData(DataInput in, boolean largeModCount, boolean readShadowKey) throws IOException, ClassNotFoundException {
                this.key = DataSerializer.readObject(in);
                this.op = Operation.fromOrdinal(in.readByte());
                this.modSerialNum = largeModCount ? in.readInt() : (int)in.readByte();
                this.callbackArg = DataSerializer.readObject(in);
                this.filterRoutingInfo = (FilterRoutingInfo)DataSerializer.readObject(in);
                this.versionTag = (VersionTag)DataSerializer.readObject(in);
                if (readShadowKey) {
                    this.tailKey = in.readLong();
                }
                this.eventOffset = in.readInt();
                if (!this.op.isDestroy()) {
                    this.didDestroy = in.readBoolean();
                    if (!this.op.isInvalidate()) {
                        boolean isTokenOrByteArray = in.readBoolean();
                        this.value = isTokenOrByteArray ? DataSerializer.readObject(in) : CachedDeserializableFactory.create(DataSerializer.readByteArray(in), GemFireCacheImpl.getInstance());
                    }
                }
            }

            public void toData(DataOutput out, boolean largeModCount, boolean sendVersionTag, boolean sendShadowKey) throws IOException {
                out.writeByte(this.op.ordinal);
                if (largeModCount) {
                    out.writeInt(this.modSerialNum);
                } else {
                    out.writeByte(this.modSerialNum);
                }
                DataSerializer.writeObject(this.callbackArg, out);
                DataSerializer.writeObject(this.filterRoutingInfo, out);
                if (sendVersionTag) {
                    DataSerializer.writeObject(this.versionTag, out);
                }
                if (sendShadowKey) {
                    out.writeLong(this.tailKey);
                }
                out.writeInt(this.eventOffset);
                if (!this.op.isDestroy()) {
                    out.writeBoolean(this.didDestroy);
                    if (!this.op.isInvalidate()) {
                        boolean sendObject = Token.isInvalidOrRemoved(this.value);
                        sendObject = sendObject || this.value instanceof byte[];
                        out.writeBoolean(sendObject);
                        if (sendObject) {
                            DataSerializer.writeObject(this.value, out);
                        } else {
                            DataSerializer.writeObjectAsByteArray(this.value, out);
                        }
                    }
                }
            }

            public void process(List<EntryEventImpl> pendingCallbacks) {
                RegionCommit.this.txApplyEntryOp(this, pendingCallbacks);
            }

            public void processAdjunctOnly() {
                RegionCommit.this.txApplyEntryOpAdjunctOnly(this);
            }

            public RegionCommit getRegionCommit() {
                return RegionCommit.this;
            }

            private int getSortValue() {
                return this.modSerialNum;
            }

            public int compareTo(Object o) {
                FarSideEntryOp other = (FarSideEntryOp)o;
                return this.getSortValue() - other.getSortValue();
            }

            public boolean equals(Object o) {
                if (o == null || !(o instanceof FarSideEntryOp)) {
                    return false;
                }
                return this.compareTo(o) == 0;
            }

            public int hashCode() {
                return this.getSortValue();
            }
        }
    }

    public static class RegionCommitList
    extends ArrayList<RegionCommit> {
        private static final long serialVersionUID = -8910813949027683641L;
        private transient boolean needsAck = false;
        private transient RegionCommit trimRC = null;
        private transient RegionCommitList trimChild = null;

        public RegionCommitList() {
        }

        public RegionCommitList(RegionCommitList c) {
            super(c);
        }

        public boolean getNeedsAck() {
            return this.needsAck;
        }

        @Override
        public boolean add(RegionCommit o) {
            RegionCommit rc = o;
            rc.incRefCount();
            if (!this.needsAck && rc.needsAck()) {
                this.needsAck = true;
            }
            return super.add(o);
        }

        public RegionCommitList trim(RegionCommit rc) {
            if (this.get(this.size() - 1) != rc) {
                return this;
            }
            if (this.trimRC == rc) {
                return this.trimChild;
            }
            RegionCommitList result = new RegionCommitList(this);
            this.trimRC = rc;
            this.trimChild = result;
            result.remove(result.size() - 1);
            for (RegionCommit itrc : result) {
                itrc.incRefCount();
                if (!itrc.needsAck()) continue;
                result.needsAck = true;
            }
            return result;
        }

        @Override
        public String toString() {
            StringBuilder result = new StringBuilder(256);
            result.append('@').append(System.identityHashCode(this)).append(' ').append(super.toString());
            return result.toString();
        }
    }
}

