/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.concurrent.Executor;
import org.apache.geode.CancelCriterion;
import org.apache.geode.internal.cache.AfterCompletion;
import org.apache.geode.internal.cache.BeforeCompletion;
import org.apache.geode.internal.cache.TXState;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class SingleThreadJTAExecutor {
    private static final Logger logger = LogService.getLogger();
    private final BeforeCompletion beforeCompletion;
    private final AfterCompletion afterCompletion;

    public SingleThreadJTAExecutor() {
        this(new BeforeCompletion(), new AfterCompletion());
    }

    public SingleThreadJTAExecutor(BeforeCompletion beforeCompletion, AfterCompletion afterCompletion) {
        this.beforeCompletion = beforeCompletion;
        this.afterCompletion = afterCompletion;
    }

    void doOps(TXState txState, CancelCriterion cancelCriterion) {
        try {
            this.beforeCompletion.doOp(txState);
        }
        finally {
            this.afterCompletion.doOp(txState, cancelCriterion);
        }
    }

    public void executeBeforeCompletion(TXState txState, Executor executor, CancelCriterion cancelCriterion) {
        executor.execute(() -> this.doOps(txState, cancelCriterion));
        this.beforeCompletion.execute(cancelCriterion);
    }

    public void executeAfterCompletionCommit() {
        this.afterCompletion.executeCommit();
    }

    public void executeAfterCompletionRollback() {
        this.afterCompletion.executeRollback();
    }

    public void cleanup() {
        this.afterCompletion.cancel();
    }

    public boolean shouldDoCleanup() {
        return this.beforeCompletion.isFinished() && !this.afterCompletion.isStarted();
    }
}

