/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.QueryException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.RegionEventImpl;
import org.apache.geode.internal.cache.partitioned.PartitionMessage;

public class InvalidatePartitionedRegionMessage
extends PartitionMessage {
    private Object callbackArg;
    private EventID eventID;

    @Override
    public EventID getEventID() {
        return this.eventID;
    }

    public InvalidatePartitionedRegionMessage() {
    }

    public InvalidatePartitionedRegionMessage(Set recipients, Object callbackArg, PartitionedRegion r, ReplyProcessor21 processor, EventID eventID) {
        super(recipients, r.getPRId(), processor);
        this.callbackArg = callbackArg;
        this.eventID = eventID;
    }

    public static ReplyProcessor21 send(Set recipients, PartitionedRegion r, RegionEventImpl event) {
        ReplyProcessor21 response = new ReplyProcessor21(r.getSystem(), (Collection)recipients);
        InvalidatePartitionedRegionMessage msg = new InvalidatePartitionedRegionMessage(recipients, event.getCallbackArgument(), r, response, event.getEventId());
        msg.setTransactionDistributed(r.getCache().getTxManager().isDistributed());
        r.getSystem().getDistributionManager().putOutgoing(msg);
        return response;
    }

    @Override
    protected boolean operateOnPartitionedRegion(ClusterDistributionManager dm, PartitionedRegion pr, long startTime) throws CacheException, QueryException, ForceReattemptException, InterruptedException {
        RegionEventImpl event = new RegionEventImpl((Region)pr, Operation.REGION_INVALIDATE, this.callbackArg, !dm.getId().equals(this.getSender()), (DistributedMember)this.getSender(), this.getEventID());
        pr.basicInvalidateRegion(event);
        return true;
    }

    @Override
    public int getDSFID() {
        return -113;
    }

    public void fromDataPre_GEODE_1_9_0_0(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.callbackArg = DataSerializer.readObject(in);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.fromDataPre_GEODE_1_9_0_0(in);
        this.eventID = (EventID)DataSerializer.readObject(in);
    }

    public void toDataPre_GEODE_1_9_0_0(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.callbackArg, out);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        this.toDataPre_GEODE_1_9_0_0(out);
        DataSerializer.writeObject(this.eventID, out);
    }

    @Override
    public Version[] getSerializationVersions() {
        return new Version[]{Version.GEODE_1_9_0};
    }
}

