/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CommitIncompleteException;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.UnsupportedOperationInTransactionException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.ReplySender;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.DataSerializableFixedID;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.CommitReplyException;
import org.apache.geode.internal.cache.DistTXCoordinatorInterface;
import org.apache.geode.internal.cache.DistTXStateProxyImplOnDatanode;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.RemoteOperationException;
import org.apache.geode.internal.cache.TXEntryState;
import org.apache.geode.internal.cache.TXId;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.TXMessage;
import org.apache.geode.internal.cache.TXStateProxy;
import org.apache.geode.internal.cache.locks.TXLockService;
import org.apache.geode.internal.cache.tx.DistTxEntryEvent;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;

public class DistTXPrecommitMessage
extends TXMessage {
    private static final Logger logger = LogService.getLogger();
    ArrayList<DistTxEntryEvent> secondaryTransactionalOperations;

    public DistTXPrecommitMessage() {
    }

    public DistTXPrecommitMessage(TXId txUniqId, InternalDistributedMember onBehalfOfClientMember, ReplyProcessor21 processor) {
        super(txUniqId.getUniqId(), onBehalfOfClientMember, processor);
    }

    @Override
    public int getDSFID() {
        return -3;
    }

    @Override
    protected boolean operateOnTx(TXId txId, ClusterDistributionManager dm) throws RemoteOperationException {
        InternalCache cache = dm.getCache();
        TXManagerImpl txMgr = cache.getTXMgr();
        if (logger.isDebugEnabled()) {
            logger.debug("DistTXPrecommitMessage.operateOnTx: Tx {} with Secondaries List {}", (Object)txId, this.secondaryTransactionalOperations);
        }
        assert (!txMgr.isHostedTxRecentlyCompleted(txId));
        TXLockService.createDTLS(cache.getInternalDistributedSystem());
        TXStateProxy txStateProxy = txMgr.getTXState();
        boolean precommitSuccess = true;
        TreeMap<String, ArrayList<TXEntryState.DistTxThinEntryState>> entryStateSortedMap = new TreeMap<String, ArrayList<TXEntryState.DistTxThinEntryState>>();
        if (txStateProxy != null) {
            if (!txStateProxy.isDistTx() || !txStateProxy.isTxStateProxy() || txStateProxy.isCreatedOnDistTxCoordinator()) {
                throw new UnsupportedOperationInTransactionException(String.format("Expected %s during a distributed transaction but got %s", "DistTXStateProxyImplOnDatanode", txStateProxy.getClass().getSimpleName()));
            }
            ((DistTXStateProxyImplOnDatanode)txStateProxy).setPreCommitMessage(this);
            txMgr.precommit();
            precommitSuccess = ((DistTXStateProxyImplOnDatanode)txStateProxy).getPreCommitResponse();
            if (precommitSuccess) {
                precommitSuccess = ((DistTXStateProxyImplOnDatanode)txStateProxy).populateDistTxEntryStateList(entryStateSortedMap);
                if (!precommitSuccess) {
                    entryStateSortedMap.clear();
                    if (logger.isDebugEnabled()) {
                        logger.debug("DistTXPrecommitMessage.operateOnTx: Tx {} Failed while creating response", (Object)txId);
                    }
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug("DistTXPrecommitMessage.operateOnTx: Tx {} Failed while applying changes for replicates", (Object)txId);
            }
        }
        DistTxPrecommitResponse finalResponse = new DistTxPrecommitResponse(precommitSuccess, new ArrayList<ArrayList<TXEntryState.DistTxThinEntryState>>(entryStateSortedMap.values()));
        DistTXPrecommitReplyMessage.send(this.getSender(), this.getProcessorId(), finalResponse, this.getReplySender(dm));
        return false;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeArrayList(this.secondaryTransactionalOperations, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.secondaryTransactionalOperations = DataSerializer.readArrayList(in);
    }

    @Override
    public boolean isTransactionDistributed() {
        return true;
    }

    @Override
    public boolean canStartRemoteTransaction() {
        return true;
    }

    public ArrayList<DistTxEntryEvent> getSecondaryTransactionalOperations() {
        return this.secondaryTransactionalOperations;
    }

    public void setSecondaryTransactionalOperations(ArrayList<DistTxEntryEvent> secondaryTransactionalOperations) {
        this.secondaryTransactionalOperations = secondaryTransactionalOperations;
    }

    public static class DistTxPrecommitResponse
    implements DataSerializableFixedID {
        private transient Boolean commitState;
        private transient ArrayList<ArrayList<TXEntryState.DistTxThinEntryState>> distTxEventList;

        public DistTxPrecommitResponse() {
        }

        public DistTxPrecommitResponse(boolean precommitSuccess, ArrayList<ArrayList<TXEntryState.DistTxThinEntryState>> eventList) {
            this.commitState = precommitSuccess;
            this.distTxEventList = eventList;
        }

        @Override
        public Version[] getSerializationVersions() {
            return null;
        }

        @Override
        public int getDSFID() {
            return 2167;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            DataSerializer.writeBoolean(this.commitState, out);
            DataSerializer.writeArrayList(this.distTxEventList, out);
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            this.commitState = DataSerializer.readBoolean(in);
            this.distTxEventList = DataSerializer.readArrayList(in);
        }

        public Boolean getCommitState() {
            return this.commitState;
        }

        public ArrayList<ArrayList<TXEntryState.DistTxThinEntryState>> getDistTxEntryEventList() {
            return this.distTxEventList;
        }
    }

    public static class DistTxPrecommitExceptionCollectingException
    extends ReplyException {
        private static final long serialVersionUID = -2681117727592137893L;
        private final Set<InternalDistributedMember> cacheExceptions = new HashSet<InternalDistributedMember>();
        private final Map<String, Set<InternalDistributedMember>> regionExceptions = new HashMap<String, Set<InternalDistributedMember>>();
        private final Map fatalExceptions = new HashMap();
        private final TXId id;

        public DistTxPrecommitExceptionCollectingException(TXId txIdent) {
            this.id = txIdent;
        }

        public void handlePotentialCommitFailure(HashMap<DistributedMember, DistTXCoordinatorInterface> msgMap) {
            if (this.fatalExceptions.size() > 0) {
                StringBuffer errorMessage = new StringBuffer("Incomplete commit of transaction ").append(this.id).append(".  Caused by the following exceptions: ");
                for (Map.Entry me : this.fatalExceptions.entrySet()) {
                    DistributedMember mem = (DistributedMember)me.getKey();
                    errorMessage.append(" From member: ").append(mem).append(" ");
                    List exceptions = (List)me.getValue();
                    Iterator ei = exceptions.iterator();
                    while (ei.hasNext()) {
                        Exception e = (Exception)ei.next();
                        errorMessage.append(e);
                        for (StackTraceElement ste : e.getStackTrace()) {
                            errorMessage.append("\n\tat ").append(ste);
                        }
                        if (!ei.hasNext()) continue;
                        errorMessage.append("\nAND\n");
                    }
                    errorMessage.append(".");
                }
                throw new CommitIncompleteException(errorMessage.toString());
            }
        }

        public Set<InternalDistributedMember> getCacheClosedMembers() {
            return this.cacheExceptions;
        }

        public Set getRegionDestroyedMembers(String regionFullPath) {
            Set members = this.regionExceptions.get(regionFullPath);
            if (members == null) {
                members = Collections.EMPTY_SET;
            }
            return members;
        }

        public void addExceptionsFromMember(InternalDistributedMember member, Set exceptions) {
            for (Exception ex : exceptions) {
                if (ex instanceof CancelException) {
                    this.cacheExceptions.add(member);
                    continue;
                }
                if (ex instanceof RegionDestroyedException) {
                    String r = ((RegionDestroyedException)ex).getRegionFullPath();
                    Set<InternalDistributedMember> members = this.regionExceptions.get(r);
                    if (members == null) {
                        members = new HashSet<InternalDistributedMember>();
                        this.regionExceptions.put(r, members);
                    }
                    members.add(member);
                    continue;
                }
                ArrayList<Exception> el = (ArrayList<Exception>)this.fatalExceptions.get(member);
                if (el == null) {
                    el = new ArrayList<Exception>(2);
                    this.fatalExceptions.put(member, el);
                }
                el.add(ex);
            }
        }
    }

    public static class DistTxPrecommitReplyProcessor
    extends ReplyProcessor21 {
        private HashMap<DistributedMember, DistTXCoordinatorInterface> msgMap;
        private Map<DistributedMember, DistTxPrecommitResponse> commitResponseMap;
        private transient TXId txIdent = null;

        public DistTxPrecommitReplyProcessor(TXId txUniqId, DistributionManager dm, Set initMembers, HashMap<DistributedMember, DistTXCoordinatorInterface> msgMap) {
            super(dm, (Collection)initMembers);
            this.msgMap = msgMap;
            this.commitResponseMap = Collections.synchronizedMap(new HashMap());
            this.txIdent = txUniqId;
        }

        @Override
        public void process(DistributionMessage msg) {
            if (msg instanceof DistTXPrecommitReplyMessage) {
                DistTXPrecommitReplyMessage reply = (DistTXPrecommitReplyMessage)msg;
                this.commitResponseMap.put(reply.getSender(), reply.getCommitResponse());
            }
            super.process(msg);
        }

        public void waitForPrecommitCompletion() {
            try {
                this.waitForRepliesUninterruptibly();
            }
            catch (DistTxPrecommitExceptionCollectingException e) {
                e.handlePotentialCommitFailure(this.msgMap);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processException(DistributionMessage msg, ReplyException ex) {
            if (msg instanceof ReplyMessage) {
                DistTxPrecommitReplyProcessor distTxPrecommitReplyProcessor = this;
                synchronized (distTxPrecommitReplyProcessor) {
                    if (this.exception == null) {
                        this.exception = new DistTxPrecommitExceptionCollectingException(this.txIdent);
                    }
                    DistTxPrecommitExceptionCollectingException cce = (DistTxPrecommitExceptionCollectingException)this.exception;
                    if (ex instanceof CommitReplyException) {
                        CommitReplyException cre = (CommitReplyException)ex;
                        cce.addExceptionsFromMember(msg.getSender(), cre.getExceptions());
                    } else {
                        cce.addExceptionsFromMember(msg.getSender(), Collections.singleton(ex));
                    }
                }
            }
        }

        @Override
        protected boolean stopBecauseOfExceptions() {
            return false;
        }

        public Set getCacheClosedMembers() {
            if (this.exception != null) {
                DistTxPrecommitExceptionCollectingException cce = (DistTxPrecommitExceptionCollectingException)this.exception;
                return cce.getCacheClosedMembers();
            }
            return Collections.EMPTY_SET;
        }

        public Set getRegionDestroyedMembers(String regionFullPath) {
            if (this.exception != null) {
                DistTxPrecommitExceptionCollectingException cce = (DistTxPrecommitExceptionCollectingException)this.exception;
                return cce.getRegionDestroyedMembers(regionFullPath);
            }
            return Collections.EMPTY_SET;
        }

        public Map<DistributedMember, DistTxPrecommitResponse> getCommitResponseMap() {
            return this.commitResponseMap;
        }
    }

    public static class DistTXPrecommitReplyMessage
    extends ReplyMessage {
        private transient DistTxPrecommitResponse commitResponse;

        public DistTXPrecommitReplyMessage() {
        }

        public DistTXPrecommitReplyMessage(DataInput in) throws IOException, ClassNotFoundException {
            this.fromData(in);
        }

        private DistTXPrecommitReplyMessage(int processorId, DistTxPrecommitResponse val) {
            this.setProcessorId(processorId);
            this.commitResponse = val;
        }

        @Override
        public boolean getInlineProcess() {
            return true;
        }

        public static void send(InternalDistributedMember recipient, int processorId, DistTxPrecommitResponse val, ReplySender replySender) throws RemoteOperationException {
            Assert.assertTrue(recipient != null, "DistTXPhaseOneCommitReplyMessage NULL reply message");
            DistTXPrecommitReplyMessage m = new DistTXPrecommitReplyMessage(processorId, val);
            m.setRecipient(recipient);
            replySender.putOutgoing(m);
        }

        @Override
        public void process(DistributionManager dm, ReplyProcessor21 processor) {
            long startTime = this.getTimestamp();
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "DistTXPhaseOneCommitReplyMessage process invoking reply processor with processorId:{}", (Object)this.processorId);
            }
            if (processor == null) {
                if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                    logger.trace(LogMarker.DM_VERBOSE, "DistTXPhaseOneCommitReplyMessage processor not found");
                }
                return;
            }
            processor.process(this);
        }

        @Override
        public int getDSFID() {
            return -1;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeObject(this.commitResponse, out);
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.commitResponse = (DistTxPrecommitResponse)DataSerializer.readObject(in);
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("DistTXPhaseOneCommitReplyMessage").append("processorid=").append(this.processorId).append(" reply to sender ").append(this.getSender());
            return sb.toString();
        }

        public DistTxPrecommitResponse getCommitResponse() {
            return this.commitResponse;
        }
    }
}

