/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.function.BooleanSupplier;
import org.apache.geode.CancelCriterion;
import org.apache.geode.internal.cache.TXState;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class AfterCompletion {
    private static final Logger logger = LogService.getLogger();
    private boolean started;
    private boolean finished;
    private RuntimeException exception;
    private Action action;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void doOp(TXState txState, CancelCriterion cancelCriterion) {
        try {
            this.waitForExecuteOrCancel(cancelCriterion);
        }
        catch (Error | RuntimeException ignore) {
            this.action = Action.CANCEL;
        }
        this.started = true;
        logger.debug("executing afterCompletion notification");
        try {
            switch (this.action) {
                case CANCEL: {
                    txState.doCleanup();
                    return;
                }
                case COMMIT: {
                    txState.doAfterCompletionCommit();
                    return;
                }
                case ROLLBACK: {
                    txState.doAfterCompletionRollback();
                    return;
                }
            }
            return;
        }
        catch (RuntimeException exception) {
            this.exception = exception;
            return;
        }
        finally {
            logger.debug("afterCompletion notification completed");
            this.finished = true;
            this.notifyAll();
        }
    }

    private void waitForExecuteOrCancel(CancelCriterion cancelCriterion) {
        this.waitForCondition(cancelCriterion, () -> this.action != null);
    }

    private synchronized void waitForCondition(CancelCriterion cancelCriterion, BooleanSupplier condition) {
        while (!condition.getAsBoolean()) {
            if (cancelCriterion != null) {
                cancelCriterion.checkCancelInProgress(null);
            }
            try {
                logger.debug("waiting for notification");
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void executeCommit() {
        this.executeAction(Action.COMMIT);
    }

    public void executeRollback() {
        this.executeAction(Action.ROLLBACK);
    }

    private synchronized void executeAction(Action action) {
        this.action = action;
        this.signalAndWaitForDoOp();
        if (this.exception != null) {
            throw this.exception;
        }
    }

    private void signalAndWaitForDoOp() {
        this.notifyAll();
        this.waitUntilFinished();
    }

    private void waitUntilFinished() {
        this.waitForCondition(null, () -> this.finished);
    }

    public synchronized void cancel() {
        this.action = Action.CANCEL;
        this.signalAndWaitForDoOp();
    }

    public synchronized boolean isStarted() {
        return this.started;
    }

    private static enum Action {
        COMMIT,
        ROLLBACK,
        CANCEL;

    }
}

