/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.alerting;

import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.internal.alerting.AlertMessaging;
import org.apache.geode.internal.alerting.AlertingSessionListeners;

public class AlertingSession {
    private final AlertingSessionListeners alertingSessionListeners;
    private State state = State.STOPPED;

    public static AlertingSession create() {
        return AlertingSession.create(AlertingSessionListeners.get());
    }

    @VisibleForTesting
    static AlertingSession create(AlertingSessionListeners alertingSessionListeners) {
        return new AlertingSession(alertingSessionListeners);
    }

    private AlertingSession(AlertingSessionListeners alertingSessionListeners) {
        this.alertingSessionListeners = alertingSessionListeners;
    }

    public synchronized void createSession(AlertMessaging alertMessaging) {
        this.state = this.state.changeTo(State.CREATED);
        this.alertingSessionListeners.createSession(alertMessaging);
    }

    public synchronized void startSession() {
        this.state = this.state.changeTo(State.STARTED);
        this.alertingSessionListeners.startSession();
    }

    public synchronized void stopSession() {
        this.state = this.state.changeTo(State.STOPPED);
        this.alertingSessionListeners.stopSession();
    }

    public synchronized void shutdown() {
    }

    @VisibleForTesting
    AlertingSessionListeners getAlertingSessionListeners() {
        return this.alertingSessionListeners;
    }

    synchronized State getState() {
        return this.state;
    }

    static enum State {
        CREATED,
        STARTED,
        STOPPED;


        State changeTo(State newState) {
            switch (newState) {
                case CREATED: {
                    if (this != STOPPED) {
                        throw new IllegalStateException("Session must not exist before creating");
                    }
                    return CREATED;
                }
                case STARTED: {
                    if (this != CREATED) {
                        throw new IllegalStateException("Session must be created before starting");
                    }
                    return STARTED;
                }
                case STOPPED: {
                    if (this == STARTED) break;
                    throw new IllegalStateException("Session must be started before stopping");
                }
            }
            return STOPPED;
        }
    }
}

