/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.alerting;

import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.alerting.AlertLevel;
import org.apache.geode.internal.alerting.AlertingProviderRegistry;

public class AlertingService {
    private final AlertingProviderRegistry providerRegistry;

    public AlertingService() {
        this(AlertingProviderRegistry.get());
    }

    AlertingService(AlertingProviderRegistry providerRegistry) {
        this.providerRegistry = providerRegistry;
    }

    public void addAlertListener(DistributedMember member, AlertLevel alertLevel) {
        this.providerRegistry.getAlertingProvider().addAlertListener(member, alertLevel);
    }

    public boolean removeAlertListener(DistributedMember member) {
        return this.providerRegistry.getAlertingProvider().removeAlertListener(member);
    }

    public boolean hasAlertListener(DistributedMember member, AlertLevel alertLevel) {
        return this.providerRegistry.getAlertingProvider().hasAlertListener(member, alertLevel);
    }

    @VisibleForTesting
    AlertingProviderRegistry getAlertingProviderRegistry() {
        return this.providerRegistry;
    }
}

