/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.alerting;

import java.util.Date;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.remote.AlertListenerMessage;
import org.apache.geode.internal.alerting.AlertLevel;

class AlertListenerMessageFactory {
    AlertListenerMessageFactory() {
    }

    AlertListenerMessage createAlertListenerMessage(DistributedMember member, AlertLevel alertLevel, Date date, String connectionName, String threadName, String formattedMessage, String stackTrace) {
        this.verifyDistributedMemberCanReceiveMessage(member);
        return AlertListenerMessage.create(member, alertLevel.intLevel(), date, connectionName, threadName, Thread.currentThread().getId(), formattedMessage, stackTrace);
    }

    private void verifyDistributedMemberCanReceiveMessage(DistributedMember member) {
        if (!(member instanceof InternalDistributedMember)) {
            throw new IllegalArgumentException("Creation of AlertListenerMessage requires InternalDistributedMember instead of " + member.getClass().getSimpleName());
        }
    }
}

