/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Set;
import org.apache.geode.DataSerializable;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.ClientSession;
import org.apache.geode.cache.InterestRegistrationListener;
import org.apache.geode.cache.server.ClientSubscriptionConfig;
import org.apache.geode.cache.server.ServerLoad;
import org.apache.geode.cache.server.ServerLoadProbe;
import org.apache.geode.cache.server.ServerLoadProbeAdapter;
import org.apache.geode.cache.server.ServerMetrics;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.admin.AdminBridgeServer;
import org.apache.geode.internal.cache.AbstractCacheServer;
import org.apache.geode.internal.cache.CacheServerImpl;
import org.apache.geode.internal.cache.tier.Acceptor;

public class RemoteBridgeServer
extends AbstractCacheServer
implements AdminBridgeServer,
DataSerializable {
    private static final long serialVersionUID = 8417391824652384959L;
    private boolean isRunning;
    private int id;

    RemoteBridgeServer(CacheServerImpl impl) {
        super(null);
        this.port = impl.getPort();
        this.bindAddress = impl.getBindAddress();
        this.hostnameForClients = impl.getHostnameForClients();
        if (CacheServerImpl.ENABLE_NOTIFY_BY_SUBSCRIPTION_FALSE) {
            this.notifyBySubscription = impl.getNotifyBySubscription();
        }
        this.socketBufferSize = impl.getSocketBufferSize();
        this.maximumTimeBetweenPings = impl.getMaximumTimeBetweenPings();
        this.isRunning = impl.isRunning();
        this.maxConnections = impl.getMaxConnections();
        this.maxThreads = impl.getMaxThreads();
        this.id = System.identityHashCode(impl);
        this.maximumMessageCount = impl.getMaximumMessageCount();
        this.messageTimeToLive = impl.getMessageTimeToLive();
        this.groups = impl.getGroups();
        this.loadProbe = this.getProbe(impl.getLoadProbe());
        this.loadPollInterval = impl.getLoadPollInterval();
        this.tcpNoDelay = impl.getTcpNoDelay();
        ClientSubscriptionConfig cscimpl = impl.getClientSubscriptionConfig();
        this.clientSubscriptionConfig.setEvictionPolicy(cscimpl.getEvictionPolicy());
        this.clientSubscriptionConfig.setCapacity(cscimpl.getCapacity());
        String diskStoreName = cscimpl.getDiskStoreName();
        if (diskStoreName != null) {
            this.clientSubscriptionConfig.setDiskStoreName(diskStoreName);
        } else {
            this.clientSubscriptionConfig.setOverflowDirectory(cscimpl.getOverflowDirectory());
        }
    }

    private ServerLoadProbe getProbe(ServerLoadProbe probe) {
        if (probe == null) {
            return new RemoteLoadProbe("");
        }
        if (probe instanceof Serializable) {
            return probe;
        }
        return new RemoteLoadProbe(probe.toString());
    }

    public RemoteBridgeServer() {
        super(null);
    }

    @Override
    public void start() throws IOException {
        throw new UnsupportedOperationException("A remote BridgeServer cannot be started.");
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public void stop() {
        throw new UnsupportedOperationException("A remote BridgeServer cannot be stopped.");
    }

    @Override
    public Cache getCache() {
        throw new UnsupportedOperationException("Cannot get the Cache of a remote BridgeServer.");
    }

    @Override
    public ClientSession getClientSession(String durableClientId) {
        String s = "Cannot get a client session for a remote BridgeServer";
        throw new UnsupportedOperationException(s);
    }

    @Override
    public ClientSession getClientSession(DistributedMember member) {
        String s = "Cannot get a client session for a remote BridgeServer";
        throw new UnsupportedOperationException(s);
    }

    public Set getAllClientSessions() {
        String s = "Cannot get all client sessions for a remote BridgeServer";
        throw new UnsupportedOperationException(s);
    }

    @Override
    public ClientSubscriptionConfig getClientSubscriptionConfig() {
        return this.clientSubscriptionConfig;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeInt(this.port);
        out.writeBoolean(this.notifyBySubscription);
        out.writeBoolean(this.isRunning);
        out.writeInt(this.maxConnections);
        out.writeInt(this.id);
        out.writeInt(this.maximumTimeBetweenPings);
        out.writeInt(this.maximumMessageCount);
        out.writeInt(this.messageTimeToLive);
        out.writeInt(this.maxThreads);
        DataSerializer.writeString(this.bindAddress, out);
        DataSerializer.writeStringArray(this.groups, out);
        DataSerializer.writeString(this.hostnameForClients, out);
        DataSerializer.writeObject(this.loadProbe, out);
        DataSerializer.writePrimitiveLong(this.loadPollInterval, out);
        out.writeInt(this.socketBufferSize);
        out.writeBoolean(this.tcpNoDelay);
        out.writeInt(this.getClientSubscriptionConfig().getCapacity());
        DataSerializer.writeString(this.getClientSubscriptionConfig().getEvictionPolicy(), out);
        DataSerializer.writeString(this.getClientSubscriptionConfig().getDiskStoreName(), out);
        if (this.getClientSubscriptionConfig().getDiskStoreName() == null) {
            DataSerializer.writeString(this.getClientSubscriptionConfig().getOverflowDirectory(), out);
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.port = in.readInt();
        this.notifyBySubscription = in.readBoolean();
        this.isRunning = in.readBoolean();
        this.maxConnections = in.readInt();
        this.id = in.readInt();
        this.maximumTimeBetweenPings = in.readInt();
        this.maximumMessageCount = in.readInt();
        this.messageTimeToLive = in.readInt();
        this.maxThreads = in.readInt();
        this.setBindAddress(DataSerializer.readString(in));
        this.setGroups(DataSerializer.readStringArray(in));
        this.setHostnameForClients(DataSerializer.readString(in));
        this.setLoadProbe((ServerLoadProbe)DataSerializer.readObject(in));
        this.setLoadPollInterval(DataSerializer.readPrimitiveLong(in));
        this.socketBufferSize = in.readInt();
        this.tcpNoDelay = in.readBoolean();
        this.getClientSubscriptionConfig().setCapacity(in.readInt());
        this.getClientSubscriptionConfig().setEvictionPolicy(DataSerializer.readString(in));
        String diskStoreName = DataSerializer.readString(in);
        if (diskStoreName != null) {
            this.getClientSubscriptionConfig().setDiskStoreName(diskStoreName);
        } else {
            this.getClientSubscriptionConfig().setOverflowDirectory(DataSerializer.readString(in));
        }
    }

    @Override
    public Acceptor getAcceptor() {
        throw new UnsupportedOperationException("not implemented on " + this.getClass().getSimpleName());
    }

    @Override
    public void registerInterestRegistrationListener(InterestRegistrationListener listener) {
        String s = "InterestRegistrationListeners cannot be registered on a remote BridgeServer";
        throw new UnsupportedOperationException("InterestRegistrationListeners cannot be registered on a remote BridgeServer");
    }

    @Override
    public void unregisterInterestRegistrationListener(InterestRegistrationListener listener) {
        String s = "InterestRegistrationListeners cannot be unregistered from a remote BridgeServer";
        throw new UnsupportedOperationException("InterestRegistrationListeners cannot be unregistered from a remote BridgeServer");
    }

    public Set getInterestRegistrationListeners() {
        String s = "InterestRegistrationListeners cannot be retrieved from a remote BridgeServer";
        throw new UnsupportedOperationException("InterestRegistrationListeners cannot be retrieved from a remote BridgeServer");
    }

    private static class RemoteLoadProbe
    extends ServerLoadProbeAdapter {
        private final String desc;

        public RemoteLoadProbe(String desc) {
            this.desc = desc;
        }

        @Override
        public ServerLoad getLoad(ServerMetrics metrics) {
            return null;
        }

        public String toString() {
            return this.desc;
        }
    }
}

