/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.Cancellable;
import org.apache.geode.internal.admin.remote.CancellationRegistry;
import org.apache.geode.internal.admin.remote.ObjectNamesResponse;
import org.apache.geode.internal.admin.remote.RegionAdminRequest;

public class ObjectNamesRequest
extends RegionAdminRequest
implements Cancellable {
    private transient boolean cancelled;
    private transient ObjectNamesResponse resp;

    public static ObjectNamesRequest create() {
        ObjectNamesRequest m = new ObjectNamesRequest();
        return m;
    }

    public ObjectNamesRequest() {
        this.friendlyName = "List cached objects";
    }

    @Override
    protected AdminResponse createResponse(DistributionManager dm) {
        CancellationRegistry.getInstance().registerMessage(this);
        this.resp = ObjectNamesResponse.create(dm, this.getSender());
        if (this.cancelled) {
            return null;
        }
        this.resp.buildNames(this.getRegion(dm.getSystem()));
        if (this.cancelled) {
            return null;
        }
        CancellationRegistry.getInstance().deregisterMessage(this);
        return this.resp;
    }

    @Override
    public synchronized void cancel() {
        this.cancelled = true;
        if (this.resp != null) {
            this.resp.cancel();
        }
    }

    @Override
    public int getDSFID() {
        return 1039;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
    }

    @Override
    public String toString() {
        return "ObjectNamesRequest from " + this.getRecipient() + " region=" + this.getRegionName();
    }
}

