/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.admin.GemFireHealth;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.internal.admin.remote.AdminRequest;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.FetchHealthDiagnosisResponse;

public class FetchHealthDiagnosisRequest
extends AdminRequest {
    private int id = 0;
    private GemFireHealth.Health healthCode = null;

    public static FetchHealthDiagnosisRequest create(int id, GemFireHealth.Health healthCode) {
        FetchHealthDiagnosisRequest m = new FetchHealthDiagnosisRequest();
        m.init_(id, healthCode);
        return m;
    }

    public FetchHealthDiagnosisRequest() {
        this.init_(0, null);
    }

    @Override
    protected AdminResponse createResponse(DistributionManager dm) {
        return FetchHealthDiagnosisResponse.create(dm, this.getSender(), this.id, this.healthCode);
    }

    @Override
    public int getDSFID() {
        return 1023;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.id);
        DataSerializer.writeObject(this.healthCode, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        int i = in.readInt();
        GemFireHealth.Health oHC = (GemFireHealth.Health)DataSerializer.readObject(in);
        this.init_(i, oHC);
    }

    @Override
    public String toString() {
        return String.format("FetchHealthDiagnosisRequest from %s id=%s healthCode=%s", this.getRecipient(), this.id, this.healthCode);
    }

    private void init_(int i, GemFireHealth.Health oHC) {
        this.id = i;
        this.healthCode = oHC;
        this.friendlyName = String.format("fetch health diagnosis for health code %s", this.healthCode);
    }
}

