/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.PooledDistributionMessage;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.remote.CancellationRegistry;

public class CancellationMessage
extends PooledDistributionMessage {
    private int msgToCancel;

    public static CancellationMessage create(InternalDistributedMember recipient, int msgToCancel) {
        CancellationMessage m = new CancellationMessage();
        m.msgToCancel = msgToCancel;
        m.setRecipient(recipient);
        return m;
    }

    @Override
    public void process(ClusterDistributionManager dm) {
        CancellationRegistry.getInstance().cancelMessage(this.getSender(), this.msgToCancel);
    }

    @Override
    public int getDSFID() {
        return 1016;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.msgToCancel);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.msgToCancel = in.readInt();
    }

    @Override
    public String toString() {
        return String.format("CancellationMessage from %s for message id %s", this.getSender(), this.msgToCancel);
    }
}

