/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.internal.admin.Stat;
import org.apache.geode.internal.admin.StatResource;
import org.apache.geode.internal.admin.remote.AddStatListenerResponse;
import org.apache.geode.internal.admin.remote.AdminRequest;
import org.apache.geode.internal.admin.remote.AdminResponse;

public class AddStatListenerRequest
extends AdminRequest {
    private long resourceId;
    private String statName;

    public static AddStatListenerRequest create(StatResource observedResource, Stat observedStat) {
        AddStatListenerRequest m = new AddStatListenerRequest();
        m.resourceId = observedResource.getResourceUniqueID();
        m.statName = observedStat.getName();
        return m;
    }

    public AddStatListenerRequest() {
        this.friendlyName = "Add statistic resource listener";
    }

    @Override
    protected AdminResponse createResponse(DistributionManager dm) {
        return AddStatListenerResponse.create(dm, this.getSender(), this.resourceId, this.statName);
    }

    @Override
    public int getDSFID() {
        return 1002;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeLong(this.resourceId);
        out.writeUTF(this.statName);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.resourceId = in.readLong();
        this.statName = in.readUTF();
    }

    @Override
    public String toString() {
        return "AddStatListenerRequest from " + this.getRecipient() + " for " + this.resourceId + " " + this.statName;
    }
}

