/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.admin.GemFireHealthConfig;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.remote.AdminResponse;

public class AddHealthListenerResponse
extends AdminResponse {
    int listenerId;

    public static AddHealthListenerResponse create(DistributionManager dm, InternalDistributedMember recipient, GemFireHealthConfig cfg) {
        AddHealthListenerResponse m = new AddHealthListenerResponse();
        m.setRecipient(recipient);
        dm.createHealthMonitor(recipient, cfg);
        m.listenerId = dm.getHealthMonitor(recipient).getId();
        return m;
    }

    public int getHealthListenerId() {
        return this.listenerId;
    }

    @Override
    public int getDSFID() {
        return 1001;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.listenerId);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.listenerId = in.readInt();
    }

    @Override
    public String toString() {
        return "AddHealthListenerResponse from " + this.getRecipient() + " listenerId=" + this.listenerId;
    }
}

