/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal;

import java.lang.ref.WeakReference;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.geode.CancelException;
import org.apache.geode.SystemFailure;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class SystemTimer {
    private static final Logger logger = LogService.getLogger();
    private static final boolean isIBM = "IBM Corporation".equals(System.getProperty("java.vm.vendor"));
    static final boolean DEBUG = false;
    private final Timer timer;
    private boolean cancelled = false;
    private final Object swarm;
    @MakeNotStatic
    private static final HashMap allSwarms = new HashMap();
    @MakeNotStatic
    private static long lastSweepAllTime = 0L;
    private static final long SWEEP_ALL_INTERVAL = 120000L;

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("SystemTimer[");
        sb.append("swarm = " + this.swarm);
        sb.append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addToSwarm(Object swarm, SystemTimer t) {
        ArrayList<WeakReference<SystemTimer>> swarmSet;
        boolean isDebugEnabled = logger.isTraceEnabled();
        HashMap hashMap = allSwarms;
        synchronized (hashMap) {
            swarmSet = (ArrayList<WeakReference<SystemTimer>>)allSwarms.get(swarm);
            if (swarmSet == null) {
                if (isDebugEnabled) {
                    logger.trace("SystemTimer#addToSwarm: created swarm {}", swarm);
                }
                swarmSet = new ArrayList<WeakReference<SystemTimer>>();
                allSwarms.put(swarm, swarmSet);
            }
        }
        if (isDebugEnabled) {
            logger.trace("SystemTimer#addToSwarm: adding timer <{}>", (Object)t);
        }
        WeakReference<SystemTimer> wr = new WeakReference<SystemTimer>(t);
        ArrayList<WeakReference<SystemTimer>> arrayList = swarmSet;
        synchronized (arrayList) {
            swarmSet.add(wr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sweepAllSwarms() {
        if (System.currentTimeMillis() < lastSweepAllTime + 120000L) {
            return;
        }
        boolean isDebugEnabled = logger.isTraceEnabled();
        HashMap hashMap = allSwarms;
        synchronized (hashMap) {
            Iterator it = allSwarms.entrySet().iterator();
            while (it.hasNext()) {
                ArrayList swarm;
                Map.Entry entry = it.next();
                ArrayList arrayList = swarm = (ArrayList)entry.getValue();
                synchronized (arrayList) {
                    Iterator it2 = swarm.iterator();
                    while (it2.hasNext()) {
                        WeakReference wr = (WeakReference)it2.next();
                        SystemTimer st = (SystemTimer)wr.get();
                        if (st == null) {
                            it2.remove();
                            continue;
                        }
                        if (!st.cancelled) continue;
                        it2.remove();
                    }
                    if (swarm.size() == 0) {
                        it.remove();
                        if (isDebugEnabled) {
                            logger.trace("SystemTimer#sweepAllSwarms: removed unused swarm {}", entry.getKey());
                        }
                    }
                }
            }
        }
        lastSweepAllTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeFromSwarm(SystemTimer t) {
        boolean isDebugEnabled = logger.isTraceEnabled();
        HashMap hashMap = allSwarms;
        synchronized (hashMap) {
            ArrayList swarmSet = (ArrayList)allSwarms.get(t.swarm);
            if (swarmSet == null) {
                if (isDebugEnabled) {
                    logger.trace("SystemTimer#removeFromSwarm: timer already removed: {}", (Object)t);
                }
                return;
            }
            if (isDebugEnabled) {
                logger.trace("SystemTimer#removeFromSwarm: removing timer <{}>", (Object)t);
            }
            ArrayList arrayList = swarmSet;
            synchronized (arrayList) {
                Iterator it = swarmSet.iterator();
                while (it.hasNext()) {
                    WeakReference ref = (WeakReference)it.next();
                    SystemTimer t2 = (SystemTimer)ref.get();
                    if (t2 == null) {
                        it.remove();
                        continue;
                    }
                    if (t2 == t) {
                        it.remove();
                        break;
                    }
                    if (!t2.cancelled) continue;
                    it.remove();
                }
                if (swarmSet.size() == 0) {
                    allSwarms.remove(t.swarm);
                    if (isDebugEnabled) {
                        logger.trace("SystemTimer#removeFromSwarm: removed last reference to {}", t.swarm);
                    }
                }
            }
        }
        SystemTimer.sweepAllSwarms();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cancelSwarm(Object swarm) {
        ArrayList swarmSet;
        Assert.assertTrue(swarm instanceof InternalDistributedSystem);
        Cloneable cloneable = allSwarms;
        synchronized (cloneable) {
            swarmSet = (ArrayList)allSwarms.get(swarm);
            if (swarmSet == null) {
                return;
            }
            allSwarms.remove(swarmSet);
        }
        cloneable = swarmSet;
        synchronized (cloneable) {
            for (WeakReference wr : swarmSet) {
                SystemTimer st = (SystemTimer)wr.get();
                if (st == null) continue;
                st.cancelled = true;
                st.timer.cancel();
            }
        }
    }

    public int timerPurge() {
        if (logger.isTraceEnabled()) {
            logger.trace("SystemTimer#timerPurge of {}", (Object)this);
        }
        if (isIBM) {
            return 0;
        }
        return this.timer.purge();
    }

    public SystemTimer(Object swarm, boolean isDaemon) {
        Assert.assertTrue(isDaemon);
        Assert.assertTrue(swarm instanceof InternalDistributedSystem, "Attempt to create swarm on " + swarm);
        this.timer = new Timer(isDaemon);
        this.swarm = swarm;
        SystemTimer.addToSwarm(swarm, this);
    }

    public SystemTimer(String name, Object swarm, boolean isDaemon) {
        Assert.assertTrue(isDaemon);
        Assert.assertTrue(swarm instanceof InternalDistributedSystem, "Attempt to create swarm on " + swarm);
        this.timer = new Timer(name, isDaemon);
        this.swarm = swarm;
        SystemTimer.addToSwarm(swarm, this);
    }

    private void checkCancelled() throws IllegalStateException {
        if (this.cancelled) {
            throw new IllegalStateException("This timer has been cancelled.");
        }
    }

    public void schedule(SystemTimerTask task, long delay) {
        this.checkCancelled();
        if (logger.isTraceEnabled()) {
            Date tilt = new Date(System.currentTimeMillis() + delay);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            logger.trace("SystemTimer#schedule (long): {}: expect task {} to fire around {}", (Object)this, (Object)task, (Object)sdf.format(tilt));
        }
        this.timer.schedule((TimerTask)task, delay);
    }

    public void schedule(SystemTimerTask task, Date time) {
        this.checkCancelled();
        if (logger.isTraceEnabled()) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            logger.trace("SystemTimer#schedule (Date): {}: expect task {} to fire around {}", (Object)this, (Object)task, (Object)sdf.format(time));
        }
        this.timer.schedule((TimerTask)task, time);
    }

    public void scheduleAtFixedRate(SystemTimerTask task, long delay, long period) {
        this.checkCancelled();
        this.timer.scheduleAtFixedRate((TimerTask)task, delay, period);
    }

    public void schedule(SystemTimerTask task, long delay, long period) {
        this.checkCancelled();
        this.timer.schedule((TimerTask)task, delay, period);
    }

    public void cancel() {
        this.cancelled = true;
        this.timer.cancel();
        SystemTimer.removeFromSwarm(this);
    }

    public static abstract class SystemTimerTask
    extends TimerTask {
        protected static final Logger logger = LogService.getLogger();

        public abstract void run2();

        @Override
        public void run() {
            boolean isDebugEnabled = logger.isTraceEnabled();
            if (isDebugEnabled) {
                logger.trace("SystemTimer.MyTask: starting {}", (Object)this);
            }
            try {
                this.run2();
            }
            catch (CancelException cancelException) {
            }
            catch (VirtualMachineError e) {
                SystemFailure.initiateFailure(e);
                throw e;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                logger.warn(String.format("Timer task <%s> encountered exception", this), t);
            }
            if (isDebugEnabled) {
                logger.trace("SystemTimer.MyTask: finished {}", (Object)this);
            }
        }
    }
}

