/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.zip.GZIPOutputStream;
import org.apache.geode.SystemFailure;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.internal.PureJavaMode;
import org.apache.geode.internal.io.TeePrintStream;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.LoggingThread;
import org.apache.logging.log4j.Logger;

public class OSProcess {
    private static final Logger logger = LogService.getLogger();
    @Deprecated
    public static final String DISABLE_OUTPUT_REDIRECTION_PROPERTY = "gemfire.OSProcess.DISABLE_OUTPUT_REDIRECTION";
    @Deprecated
    public static final String ENABLE_OUTPUT_REDIRECTION_PROPERTY = "gemfire.OSProcess.ENABLE_OUTPUT_REDIRECTION";
    @Deprecated
    public static final String DISABLE_REDIRECTION_CONFIGURATION_PROPERTY = "gemfire.OSProcess.DISABLE_REDIRECTION_CONFIGURATION";
    @Deprecated
    private static final boolean ENABLE_OUTPUT_REDIRECTION = Boolean.getBoolean("gemfire.OSProcess.ENABLE_OUTPUT_REDIRECTION");
    @Deprecated
    private static final boolean DISABLE_OUTPUT_REDIRECTION = Boolean.getBoolean("gemfire.OSProcess.DISABLE_OUTPUT_REDIRECTION");
    @Deprecated
    private static final boolean DISABLE_REDIRECTION_CONFIGURATION = Boolean.getBoolean("gemfire.OSProcess.DISABLE_REDIRECTION_CONFIGURATION");
    static final boolean pureMode = PureJavaMode.isPure();
    static final int MAX_STACK_FRAMES = 75;
    @MakeNotStatic
    private static Thread reaperThread;
    @MakeNotStatic
    protected static Set pids;
    @MakeNotStatic
    static final int[] myPid;
    @MakeNotStatic
    static boolean reaperStarted;

    private static native int bgexecInternal(String[] var0, String var1, String var2, boolean var3) throws IOException;

    public static int bgexec(String[] cmdarray, File workdir, File logfile, boolean inheritLogfile, Map<String, String> env) throws IOException {
        String trace;
        String commandShell = System.getProperty("gemfire.commandShell", "bash");
        if (cmdarray.length == 0) {
            throw new IndexOutOfBoundsException();
        }
        boolean isWindows = false;
        String os = System.getProperty("os.name");
        if (os != null && os.indexOf("Windows") != -1) {
            isWindows = true;
        }
        for (int i = 0; i < cmdarray.length; ++i) {
            File cmd;
            if (cmdarray[i] == null) {
                throw new NullPointerException();
            }
            if (!isWindows) continue;
            if (i == 0 && !(cmd = new File(cmdarray[0])).exists() && (cmd = new File(cmdarray[0] + ".exe")).exists()) {
                cmdarray[0] = cmd.getPath();
            }
            String s = cmdarray[i];
            if (i == 0) continue;
            if (s.length() == 0) {
                cmdarray[i] = "\"\"";
                continue;
            }
            if (s.indexOf(32) < 0 && s.indexOf(9) < 0) continue;
            String unquotedS = s;
            if (s.indexOf(34) != -1) {
                StringBuffer b = new StringBuffer(s);
                int quoteIdx = s.lastIndexOf(34);
                while (quoteIdx != -1) {
                    b.deleteCharAt(quoteIdx);
                    quoteIdx = s.lastIndexOf(34, quoteIdx - 1);
                }
                unquotedS = b.toString();
            }
            cmdarray[i] = '\"' + unquotedS + '\"';
        }
        File cmd = new File(cmdarray[0]);
        if (!cmd.exists()) {
            throw new IOException(String.format("the executable %s does not exist", cmd.getPath()));
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkExec(cmdarray[0]);
        }
        if (workdir != null && !workdir.isDirectory()) {
            String curDir = new File("").getAbsolutePath();
            System.out.println(String.format("WARNING: %s is not a directory. Defaulting to current directory %s.", workdir, curDir));
            workdir = null;
        }
        if (workdir == null) {
            workdir = new File("").getAbsoluteFile();
        }
        if (logfile == null) {
            logfile = File.createTempFile("bgexec", ".log", workdir);
        }
        if (!logfile.isAbsolute()) {
            logfile = new File(workdir, logfile.getPath());
        }
        if (logfile.exists()) {
            if (!logfile.isFile()) {
                throw new IOException(String.format("The log file %s was not a normal file.", logfile.getPath()));
            }
            if (!logfile.canWrite()) {
                throw new IOException(String.format("Need write access for the log file %s.", logfile.getPath()));
            }
        } else {
            try {
                logfile.createNewFile();
            }
            catch (IOException io) {
                throw new IOException(String.format("Could not create log file %s because: %s.", logfile.getPath(), io.getMessage()));
            }
        }
        if ((trace = System.getProperty("org.apache.geode.internal.OSProcess.trace")) != null && trace.length() > 0) {
            for (int i = 0; i < cmdarray.length; ++i) {
                System.out.println("cmdarray[" + i + "] = " + cmdarray[i]);
            }
            System.out.println("workdir=" + workdir.getPath());
            System.out.println("logfile=" + logfile.getPath());
        }
        int result = 0;
        if (pureMode || env != null && env.size() > 0) {
            StringBuffer sb = new StringBuffer();
            Vector<String> cmdVec = new Vector<String>();
            if (isWindows) {
                cmdVec.add("cmd.exe");
                cmdVec.add("/c");
                sb.append("start /b \"\" ");
            } else if (commandShell.equals("bash")) {
                cmdVec.add("bash");
                cmdVec.add("--norc");
                cmdVec.add("-c");
            } else {
                cmdVec.add(commandShell);
            }
            for (int i = 0; i < cmdarray.length; ++i) {
                if (i != 0) {
                    sb.append(" ");
                }
                if (cmdarray[i].length() != 0 && cmdarray[i].charAt(0) == '\"') {
                    sb.append(cmdarray[i]);
                    continue;
                }
                sb.append("\"");
                sb.append(cmdarray[i]);
                sb.append("\"");
            }
            sb.append(" >> ");
            sb.append(logfile.getPath());
            sb.append(" 2>&1");
            if (isWindows) {
                sb.append(" <NUL");
            } else {
                sb.append(" </dev/null &");
            }
            cmdVec.add(sb.toString());
            String[] cmdStrings = cmdVec.toArray(new String[0]);
            if (trace != null && trace.length() > 0) {
                for (int i = 0; i < cmdStrings.length; ++i) {
                    System.out.println("cmdStrings[" + i + "] = " + cmdStrings[i]);
                }
                System.out.println("workdir=" + workdir.getPath());
                System.out.println("logfile=" + logfile.getPath());
            }
            ProcessBuilder procBuilder = new ProcessBuilder(cmdStrings);
            if (env != null && env.size() > 0) {
                procBuilder.environment().putAll(env);
            }
            procBuilder.directory(workdir);
            Process process = procBuilder.start();
            try {
                process.getInputStream().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                process.getOutputStream().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                process.getErrorStream().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                boolean processIsStillRunning = true;
                while (processIsStillRunning) {
                    Thread.sleep(10L);
                    try {
                        process.exitValue();
                        processIsStillRunning = false;
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {}
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        } else {
            result = OSProcess.bgexecInternal(cmdarray, workdir.getPath(), logfile.getPath(), inheritLogfile);
            if (result != -1 && pids != null) {
                pids.add(result);
                if (trace != null && trace.length() > 0) {
                    System.out.println("bgexec child pid is: " + result);
                }
            }
        }
        return result;
    }

    private static void checkPid(int pid) {
        if (pid <= 0) {
            throw new IllegalArgumentException(String.format("Should not send a signal to pid %s", pid));
        }
    }

    public static boolean shutdown(int pid) {
        if (pureMode) {
            throw new RuntimeException("shutdown not allowed in pure java mode");
        }
        OSProcess.checkPid(pid);
        return OSProcess._shutdown(pid);
    }

    private static native boolean _shutdown(int var0);

    public static boolean kill(int pid) {
        if (pureMode) {
            throw new RuntimeException("kill not allowed in pure java mode");
        }
        OSProcess.checkPid(pid);
        return OSProcess._kill(pid);
    }

    private static native boolean _kill(int var0);

    public static boolean printStacks(int pid) {
        return OSProcess.printStacks(pid, false);
    }

    public static boolean printStacks(int pid, boolean useNative) {
        if (pureMode || !useNative) {
            if (pid > 0 && pid != myPid[0]) {
                return false;
            }
            CharArrayWriter cw = new CharArrayWriter(50000);
            PrintWriter sb = new PrintWriter((Writer)cw, true);
            sb.append("\n******** full thread dump ********\n");
            ThreadMXBean bean = ManagementFactory.getThreadMXBean();
            long[] threadIds = bean.getAllThreadIds();
            ThreadInfo[] infos = bean.getThreadInfo(threadIds, true, true);
            long thisThread = Thread.currentThread().getId();
            for (int i = 0; i < infos.length; ++i) {
                if ((long)i == thisThread || infos[i] == null) continue;
                OSProcess.formatThreadInfo(infos[i], sb);
            }
            sb.flush();
            logger.warn(cw.toString());
            return true;
        }
        if (pid < 0) {
            OSProcess.checkPid(pid);
        }
        return OSProcess._printStacks(pid);
    }

    public static byte[] zipStacks() throws IOException {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        long[] threadIds = bean.getAllThreadIds();
        ThreadInfo[] infos = bean.getThreadInfo(threadIds, true, true);
        long thisThread = Thread.currentThread().getId();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(10000);
        GZIPOutputStream zipOut = new GZIPOutputStream((OutputStream)baos, 10000);
        PrintWriter pw = new PrintWriter(zipOut, true);
        for (int i = 0; i < infos.length; ++i) {
            if ((long)i == thisThread || infos[i] == null) continue;
            OSProcess.formatThreadInfo(infos[i], pw);
        }
        pw.flush();
        zipOut.close();
        byte[] result = baos.toByteArray();
        return result;
    }

    private static native boolean _printStacks(int var0);

    private static void formatThreadInfo(ThreadInfo t, PrintWriter pw) {
        LockInfo[] locks;
        int i;
        pw.append("\"" + t.getThreadName() + "\" tid=0x" + Long.toHexString(t.getThreadId()));
        if (t.isSuspended()) {
            pw.append(" (suspended)");
        }
        if (t.isInNative()) {
            pw.append(" (in native)");
        }
        if (t.getLockOwnerName() != null) {
            pw.append(" owned by \"" + t.getLockOwnerName() + "\" tid=0x" + Long.toHexString(t.getLockOwnerId()));
        }
        pw.append('\n');
        pw.append("    java.lang.Thread.State: " + (Object)((Object)t.getThreadState()) + "\n");
        StackTraceElement[] stackTrace = t.getStackTrace();
        for (i = 0; i < stackTrace.length && i < 75; ++i) {
            StackTraceElement ste = stackTrace[i];
            pw.append("\tat " + ste.toString());
            pw.append('\n');
            if (i == 0 && t.getLockInfo() != null) {
                Thread.State ts = t.getThreadState();
                switch (ts) {
                    case BLOCKED: {
                        pw.append("\t-  blocked on " + t.getLockInfo());
                        pw.append('\n');
                        break;
                    }
                    case WAITING: {
                        pw.append("\t-  waiting on " + t.getLockInfo());
                        pw.append('\n');
                        break;
                    }
                    case TIMED_WAITING: {
                        pw.append("\t-  waiting on " + t.getLockInfo());
                        pw.append('\n');
                        break;
                    }
                }
            }
            for (LockInfo lockInfo : t.getLockedMonitors()) {
                if (((MonitorInfo)lockInfo).getLockedStackDepth() != i) continue;
                pw.append("\t-  locked " + lockInfo);
                pw.append('\n');
            }
        }
        if (i < stackTrace.length) {
            pw.append("\t...");
            pw.append('\n');
        }
        if ((locks = t.getLockedSynchronizers()).length > 0) {
            pw.append("\n\tNumber of locked synchronizers = " + locks.length);
            pw.append('\n');
            for (LockInfo lockInfo : locks) {
                pw.append("\t- " + lockInfo);
                pw.append('\n');
            }
        }
        pw.append('\n');
    }

    public static boolean exists(int pid) {
        if (pureMode) {
            throw new RuntimeException("exists not allowed in pure java mode");
        }
        OSProcess.checkPid(pid);
        if (OSProcess.reapPid(pid)) {
            try {
                pids.remove(pid);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String trace = System.getProperty("org.apache.geode.internal.OSProcess.trace");
            if (trace != null && trace.length() > 0) {
                System.out.println("reaped pid: " + pid);
            }
        }
        return OSProcess.nativeExists(pid);
    }

    private static native boolean nativeExists(int var0);

    private static native void waitForPid(int var0);

    public static void waitForPidToExit(int pid) {
        if (pureMode) {
            throw new RuntimeException("waitForPidToExit not allowed in pure java mode");
        }
        OSProcess.checkPid(pid);
        OSProcess.waitForPid(pid);
    }

    public static boolean setCurrentDirectory(File curDir) {
        if (pureMode) {
            throw new RuntimeException("setCurrentDirectory not allowed in pure java mode");
        }
        return OSProcess.jniSetCurDir(curDir.getAbsolutePath());
    }

    private static native boolean jniSetCurDir(String var0);

    protected static native boolean reapPid(int var0);

    static native int getProcessId();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static int getId() {
        boolean done = false;
        int result = -1;
        while (true) {
            int[] nArray = myPid;
            // MONITORENTER : myPid
            done = reaperStarted;
            result = myPid[0];
            // MONITOREXIT : nArray
            if (done) {
                return result;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    public static PrintStream redirectOutput(File newOutput) throws IOException {
        return OSProcess.redirectOutput(newOutput, true);
    }

    public static PrintStream redirectOutput(File newOutput, boolean setOut) throws IOException {
        FileOutputStream newFileStream = null;
        try {
            newFileStream = new FileOutputStream(newOutput, true);
        }
        catch (FileNotFoundException e) {
            throw new IOException("File not found: " + newOutput, e);
        }
        PrintStream newPrintStream = new PrintStream(new BufferedOutputStream(newFileStream, 128), true);
        if ((DISABLE_REDIRECTION_CONFIGURATION || ENABLE_OUTPUT_REDIRECTION && !DISABLE_OUTPUT_REDIRECTION) && setOut) {
            System.setOut(newPrintStream);
            if (System.err instanceof TeePrintStream) {
                ((TeePrintStream)System.err).getTeeOutputStream().setBranchOutputStream(new BufferedOutputStream(newFileStream, 128));
            } else {
                System.setErr(newPrintStream);
            }
            if (!pureMode) {
                OSProcess.redirectCOutput(newOutput.getPath());
            }
        }
        return newPrintStream;
    }

    private static native void redirectCOutput(String var0);

    private static native void registerSigQuitHandler();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        if (!pureMode) {
            OSProcess.registerSigQuitHandler();
        }
        pids = null;
        myPid = new int[1];
        reaperStarted = false;
        if (pureMode) {
            int[] nArray = myPid;
            synchronized (myPid) {
                int pid = 0;
                String name = ManagementFactory.getRuntimeMXBean().getName();
                int idx = name.indexOf(64);
                try {
                    pid = Integer.parseInt(name.substring(0, idx));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                OSProcess.myPid[0] = pid;
                reaperStarted = true;
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }
        if (OSProcess.reapPid(-1)) {
            pids = Collections.synchronizedSet(new HashSet());
            reaperThread = new LoggingThread("osprocess reaper", () -> {
                int[] nArray = myPid;
                synchronized (myPid) {
                    OSProcess.myPid[0] = OSProcess.getProcessId();
                    reaperStarted = true;
                    // ** MonitorExit[var0] (shouldn't be in output)
                    String trace = System.getProperty("org.apache.geode.internal.OSProcess.trace");
                    int secondsToSleep = 60000;
                    if (trace != null && trace.length() > 0) {
                        secondsToSleep = 1000;
                    }
                    while (true) {
                        SystemFailure.checkFailure();
                        try {
                            Iterator it = pids.iterator();
                            while (it.hasNext()) {
                                Object o = it.next();
                                int pid = (Integer)o;
                                if (!OSProcess.reapPid(pid)) continue;
                                try {
                                    it.remove();
                                    if (trace == null || trace.length() <= 0) continue;
                                    System.out.println("reaped pid: " + pid);
                                }
                                catch (Exception e) {
                                    pids.remove(o);
                                    if (trace != null && trace.length() > 0) {
                                        System.out.println("reaped pid: " + pid);
                                    }
                                    throw e;
                                }
                            }
                            Thread.sleep(secondsToSleep);
                            continue;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        catch (Exception exception) {
                            continue;
                        }
                        break;
                    }
                    return;
                }
            });
            reaperThread.start();
            return;
        }
        int[] nArray = myPid;
        synchronized (myPid) {
            OSProcess.myPid[0] = OSProcess.getProcessId();
            reaperStarted = true;
            // ** MonitorExit[var0_1] (shouldn't be in output)
            return;
        }
    }
}

