/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms.auth;

import java.security.Principal;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.LogWriter;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.distributed.internal.membership.NetView;
import org.apache.geode.distributed.internal.membership.gms.Services;
import org.apache.geode.distributed.internal.membership.gms.interfaces.Authenticator;
import org.apache.geode.internal.cache.tier.sockets.Handshake;
import org.apache.geode.internal.logging.InternalLogWriter;
import org.apache.geode.internal.security.CallbackInstantiator;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.AuthenticationFailedException;
import org.apache.geode.security.ResourcePermission;

public class GMSAuthenticator
implements Authenticator {
    private Services services;
    private Properties securityProps;

    @Override
    public void init(Services s) {
        this.services = s;
        this.securityProps = this.services.getConfig().getDistributionConfig().getSecurityProps();
    }

    @Override
    public void start() {
    }

    @Override
    public void started() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void stopped() {
    }

    @Override
    public void installView(NetView v) {
    }

    @Override
    public void beSick() {
    }

    @Override
    public void playDead() {
    }

    @Override
    public void beHealthy() {
    }

    @Override
    public void memberSuspected(InternalDistributedMember initiator, InternalDistributedMember suspect, String reason) {
    }

    @Override
    public String authenticate(InternalDistributedMember member, Properties credentials) throws AuthenticationFailedException {
        return this.authenticate(member, credentials, this.securityProps);
    }

    String authenticate(DistributedMember member, Properties credentials, Properties secProps) throws AuthenticationFailedException {
        SecurityService securityService = this.services.getSecurityService();
        String authMethod = secProps.getProperty("security-peer-authenticator");
        if (!securityService.isPeerSecurityRequired() && StringUtils.isBlank((CharSequence)authMethod)) {
            return null;
        }
        InternalLogWriter securityLogWriter = (InternalLogWriter)this.services.getSecurityLogWriter();
        if (credentials == null) {
            securityLogWriter.warning(String.format("Failed to find credentials from [%s]", member));
            return String.format("Failed to find credentials from [%s]", member);
        }
        String failMsg = null;
        try {
            if (securityService.isIntegratedSecurity()) {
                securityService.login(credentials);
                securityService.authorize(ResourcePermission.Resource.CLUSTER, ResourcePermission.Operation.MANAGE);
            } else {
                this.invokeAuthenticator(secProps, member, credentials);
            }
        }
        catch (Exception ex) {
            securityLogWriter.warning(String.format("Security check failed for [%s]. %s", member, ex.getLocalizedMessage()), (Throwable)ex);
            failMsg = String.format("Security check failed. %s", ex.getLocalizedMessage());
        }
        return failMsg;
    }

    Principal invokeAuthenticator(Properties securityProps, DistributedMember member, Properties credentials) throws AuthenticationFailedException {
        String authMethod = securityProps.getProperty("security-peer-authenticator");
        try (org.apache.geode.security.Authenticator auth = null;){
            auth = CallbackInstantiator.getObjectOfType(authMethod, org.apache.geode.security.Authenticator.class);
            LogWriter logWriter = this.services.getLogWriter();
            LogWriter securityLogWriter = this.services.getSecurityLogWriter();
            auth.init(this.securityProps, logWriter, securityLogWriter);
            Principal principal = auth.authenticate(credentials, member);
            return principal;
        }
    }

    @Override
    public Properties getCredentials(InternalDistributedMember member) {
        try {
            return this.getCredentials(member, this.securityProps);
        }
        catch (Exception e) {
            String authMethod = this.securityProps.getProperty("security-peer-auth-init");
            this.services.getSecurityLogWriter().warning(String.format("Failed to obtain credentials using AuthInitialize [%s]. %s", authMethod, e.getLocalizedMessage()));
            return null;
        }
    }

    Properties getCredentials(DistributedMember member, Properties secProps) {
        String authMethod = secProps.getProperty("security-peer-auth-init");
        return Handshake.getCredentials(authMethod, secProps, member, true, (InternalLogWriter)this.services.getLogWriter(), (InternalLogWriter)this.services.getSecurityLogWriter());
    }

    Properties getSecurityProps() {
        return this.securityProps;
    }

    @Override
    public void emergencyClose() {
    }
}

