/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.locks;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.SystemFailure;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.HighPriorityDistributionMessage;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.locks.DLockGrantor;
import org.apache.geode.distributed.internal.locks.DLockService;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;

public class DLockReleaseProcessor
extends ReplyProcessor21 {
    private static final Logger logger = LogService.getLogger();
    private DLockReleaseReplyMessage reply;
    protected Object objectName;

    public DLockReleaseProcessor(DistributionManager dm, InternalDistributedMember member, String serviceName, Object objectName) {
        super(dm, member);
        this.objectName = objectName;
    }

    protected boolean release(InternalDistributedMember grantor, String serviceName, boolean lockBatch, int lockId) {
        DistributionManager dm = this.getDistributionManager();
        DLockReleaseMessage msg = new DLockReleaseMessage();
        msg.processorId = this.getProcessorId();
        msg.serviceName = serviceName;
        msg.objectName = this.objectName;
        msg.lockBatch = lockBatch;
        msg.lockId = lockId;
        msg.setRecipient(grantor);
        if (grantor.equals(dm.getId())) {
            msg.setSender(grantor);
            msg.processLocally(dm);
        } else {
            dm.putOutgoing(msg);
        }
        try {
            this.waitForRepliesUninterruptibly();
        }
        catch (ReplyException e) {
            e.handleCause();
        }
        if (this.reply == null) {
            return false;
        }
        return this.reply.replyCode == 1;
    }

    @Override
    protected boolean allowReplyFromSender() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(DistributionMessage msg) {
        try {
            Assert.assertTrue(msg instanceof DLockReleaseReplyMessage, "DLockReleaseProcessor is unable to process message of type " + msg.getClass());
            DLockReleaseReplyMessage myReply = (DLockReleaseReplyMessage)msg;
            boolean isDebugEnabled_DLS = logger.isTraceEnabled(LogMarker.DLS_VERBOSE);
            if (isDebugEnabled_DLS) {
                logger.trace(LogMarker.DLS_VERBOSE, "Handling: {}", (Object)myReply);
            }
            this.reply = myReply;
            if (isDebugEnabled_DLS) {
                if (myReply.replyCode == 1) {
                    logger.trace(LogMarker.DLS_VERBOSE, "Successfully released {} in {}", this.objectName, (Object)myReply.serviceName);
                } else if (myReply.replyCode == 0) {
                    logger.trace(LogMarker.DLS_VERBOSE, "{} has responded DLockReleaseReplyMessage.NOT_GRANTOR for {}", (Object)myReply.getSender(), (Object)myReply.serviceName);
                }
            }
        }
        finally {
            super.process(msg);
        }
    }

    public static class DLockReleaseReplyMessage
    extends ReplyMessage {
        static final int NOT_GRANTOR = 0;
        static final int OK = 1;
        protected String serviceName;
        protected int replyCode = 0;

        @Override
        public int getDSFID() {
            return 116;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.serviceName = DataSerializer.readString(in);
            this.replyCode = in.readInt();
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeString(this.serviceName, out);
            out.writeInt(this.replyCode);
        }

        @Override
        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append("DLockReleaseReplyMessage");
            buff.append(" (serviceName=");
            buff.append(this.serviceName);
            buff.append("; replyCode=");
            switch (this.replyCode) {
                case 0: {
                    buff.append("NOT_GRANTOR");
                    break;
                }
                case 1: {
                    buff.append("OK");
                    break;
                }
                default: {
                    buff.append(String.valueOf(this.replyCode));
                }
            }
            buff.append("; sender=");
            buff.append(this.getSender());
            buff.append("; processorId=");
            buff.append(this.processorId);
            buff.append(")");
            return buff.toString();
        }
    }

    public static class DLockReleaseMessage
    extends HighPriorityDistributionMessage
    implements MessageWithReply {
        protected String serviceName;
        protected Object objectName;
        protected boolean lockBatch;
        protected int processorId;
        protected int lockId;
        protected DLockService svc;
        protected DLockGrantor grantor;

        @Override
        public int getProcessorId() {
            return this.processorId;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected void process(ClusterDistributionManager dm) {
            boolean failed = true;
            ReplyException replyException = null;
            try {
                this.svc = DLockService.getInternalServiceNamed(this.serviceName);
                if (this.svc == null) {
                    failed = false;
                    this.basicProcess(dm, false);
                } else {
                    this.executeBasicProcess(dm);
                }
                failed = false;
                if (!failed) return;
            }
            catch (RuntimeException e) {
                try {
                    replyException = new ReplyException(e);
                    throw e;
                    catch (VirtualMachineError e2) {
                        SystemFailure.initiateFailure(e2);
                        replyException = new ReplyException(e2);
                        throw e2;
                    }
                    catch (Error e3) {
                        SystemFailure.checkFailure();
                        replyException = new ReplyException(e3);
                        throw e3;
                    }
                }
                catch (Throwable throwable) {
                    if (!failed) throw throwable;
                    if (logger.isTraceEnabled(LogMarker.DLS_VERBOSE)) {
                        logger.trace(LogMarker.DLS_VERBOSE, "DLockReleaseMessage.process failed for <{}>", (Object)this);
                    }
                    int replyCode = 0;
                    DLockReleaseReplyMessage replyMsg = new DLockReleaseReplyMessage();
                    replyMsg.serviceName = this.serviceName;
                    replyMsg.replyCode = replyCode;
                    replyMsg.setProcessorId(this.processorId);
                    replyMsg.setRecipient(this.getSender());
                    replyMsg.setException(replyException);
                    if (dm.getId().equals(this.getSender())) {
                        replyMsg.setSender(this.getSender());
                        replyMsg.dmProcess(dm);
                        throw throwable;
                    }
                    dm.putOutgoing(replyMsg);
                    throw throwable;
                }
            }
            if (logger.isTraceEnabled(LogMarker.DLS_VERBOSE)) {
                logger.trace(LogMarker.DLS_VERBOSE, "DLockReleaseMessage.process failed for <{}>", (Object)this);
            }
            int replyCode = 0;
            DLockReleaseReplyMessage replyMsg = new DLockReleaseReplyMessage();
            replyMsg.serviceName = this.serviceName;
            replyMsg.replyCode = replyCode;
            replyMsg.setProcessorId(this.processorId);
            replyMsg.setRecipient(this.getSender());
            replyMsg.setException(replyException);
            if (dm.getId().equals(this.getSender())) {
                replyMsg.setSender(this.getSender());
                replyMsg.dmProcess(dm);
                return;
            }
            dm.putOutgoing(replyMsg);
        }

        protected void processLocally(DistributionManager dm) {
            this.svc = DLockService.getInternalServiceNamed(this.serviceName);
            this.basicProcess(dm, true);
        }

        private void executeBasicProcess(final DistributionManager dm) {
            final DLockReleaseMessage msg = this;
            dm.getWaitingThreadPool().execute(new Runnable(){

                @Override
                public void run() {
                    if (logger.isTraceEnabled(LogMarker.DLS_VERBOSE)) {
                        logger.trace(LogMarker.DLS_VERBOSE, "[executeBasicProcess] waitForGrantor {}", (Object)msg);
                    }
                    this.basicProcess(dm, true);
                }
            });
        }

        /*
         * Exception decompiling
         */
        protected void basicProcess(DistributionManager dm, boolean waitForGrantor) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [42[CATCHBLOCK]], but top level block is 20[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public int getDSFID() {
            return 85;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeString(this.serviceName, out);
            DataSerializer.writeObject(this.objectName, out);
            out.writeBoolean(this.lockBatch);
            out.writeInt(this.processorId);
            out.writeInt(this.lockId);
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.serviceName = DataSerializer.readString(in);
            this.objectName = DataSerializer.readObject(in);
            this.lockBatch = in.readBoolean();
            this.processorId = in.readInt();
            this.lockId = in.readInt();
        }

        @Override
        public String toString() {
            return "DLockReleaseMessage for " + this.serviceName + ", " + this.objectName + "; processorId=" + this.processorId + "; lockBatch=" + this.lockBatch + "; lockId=" + this.lockId;
        }
    }
}

