/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import org.apache.geode.admin.GemFireHealth;
import org.apache.geode.admin.GemFireHealthConfig;
import org.apache.geode.admin.internal.GemFireHealthEvaluator;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.HealthMonitor;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.remote.HealthListenerMessage;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.LoggingThread;
import org.apache.logging.log4j.Logger;

public class HealthMonitorImpl
implements HealthMonitor,
Runnable {
    private static final Logger logger = LogService.getLogger();
    private final InternalDistributedMember owner;
    private final int id;
    private final ClusterDistributionManager dm;
    private final GemFireHealthEvaluator eval;
    private GemFireHealth.Health currentStatus;
    private final Thread t;
    private volatile boolean stopRequested = false;
    @MakeNotStatic
    private static int idCtr = 0;

    public HealthMonitorImpl(InternalDistributedMember owner, GemFireHealthConfig config, ClusterDistributionManager dm) {
        this.owner = owner;
        this.id = HealthMonitorImpl.getNewId();
        this.dm = dm;
        this.eval = new GemFireHealthEvaluator(config, dm);
        this.currentStatus = GemFireHealth.GOOD_HEALTH;
        String threadName = String.format("Health Monitor owned by %s", owner);
        this.t = new LoggingThread(threadName, (Runnable)this);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void resetStatus() {
        this.currentStatus = GemFireHealth.GOOD_HEALTH;
        this.eval.reset();
    }

    @Override
    public String[] getDiagnosis(GemFireHealth.Health healthCode) {
        return this.eval.getDiagnosis(healthCode);
    }

    @Override
    public void stop() {
        if (this.t.isAlive()) {
            this.stopRequested = true;
            this.t.interrupt();
        }
    }

    public void start() {
        if (this.stopRequested) {
            throw new RuntimeException("A health monitor can not be started once it has been stopped");
        }
        if (this.t.isAlive()) {
            return;
        }
        this.t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int sleepTime = this.eval.getEvaluationInterval() * 1000;
        if (logger.isDebugEnabled()) {
            logger.debug("Starting health monitor.  Health will be evaluated every {} seconds.", (Object)(sleepTime / 1000));
        }
        try {
            while (!this.stopRequested) {
                GemFireHealth.Health newStatus;
                this.dm.getCancelCriterion().checkCancelInProgress(null);
                Thread.sleep(sleepTime);
                if (this.stopRequested || (newStatus = this.eval.evaluate()) == this.currentStatus) continue;
                this.currentStatus = newStatus;
                HealthListenerMessage msg = HealthListenerMessage.create(this.getId(), newStatus);
                msg.setRecipient(this.owner);
                this.dm.putOutgoing(msg);
            }
        }
        catch (InterruptedException ex) {
            if (!this.stopRequested) {
                logger.warn("Unexpected stop of health monitor", (Throwable)ex);
            }
        }
        finally {
            this.eval.close();
            this.stopRequested = true;
            if (logger.isDebugEnabled()) {
                logger.debug("Stopping health monitor");
            }
        }
    }

    private static synchronized int getNewId() {
        return ++idCtr;
    }
}

