/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import org.apache.geode.DataSerializer;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.internal.Bag;
import org.apache.geode.cache.query.internal.Ordered;
import org.apache.geode.cache.query.internal.types.CollectionTypeImpl;
import org.apache.geode.cache.query.types.CollectionType;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.internal.DataSerializableFixedID;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.EntriesSet;

public class ResultsCollectionWrapper
implements SelectResults,
DataSerializableFixedID {
    private Collection base;
    private CollectionType collectionType;
    private boolean modifiable = true;
    final Object limitLock = new Object();
    private int limit;
    private final boolean hasLimitIterator;
    private final boolean limitImposed;

    public ResultsCollectionWrapper() {
        this.limit = -1;
        this.hasLimitIterator = false;
        this.limitImposed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultsCollectionWrapper(ObjectType constraint, Collection base, int limit) {
        this.validateConstraint(constraint);
        this.base = base;
        this.collectionType = new CollectionTypeImpl(this.getBaseClass(), constraint);
        this.limit = limit;
        if (this.limit > -1 && this.base.size() > this.limit) {
            if (this.collectionType.isOrdered()) {
                this.hasLimitIterator = true;
            } else {
                this.hasLimitIterator = false;
                int truncate = this.base.size() - limit;
                Collection collection = this.base;
                synchronized (collection) {
                    Iterator itr = this.base.iterator();
                    for (int i = 0; i < truncate; ++i) {
                        itr.next();
                        itr.remove();
                    }
                }
            }
        } else {
            this.hasLimitIterator = false;
        }
        this.limitImposed = this.limit > -1;
    }

    public ResultsCollectionWrapper(ObjectType constraint, Collection base) {
        this.validateConstraint(constraint);
        this.base = base;
        this.collectionType = new CollectionTypeImpl(this.getBaseClass(), constraint);
        this.limit = -1;
        this.hasLimitIterator = false;
        this.limitImposed = false;
    }

    private void validateConstraint(ObjectType constraint) {
        if (constraint == null) {
            throw new IllegalArgumentException("constraint cannot be null");
        }
        if (!Modifier.isPublic(constraint.resolveClass().getModifiers())) {
            throw new IllegalArgumentException("constraint class must be public");
        }
    }

    private void checkConstraint(Object obj) {
        ObjectType elementType = this.collectionType.getElementType();
        if (!elementType.resolveClass().isInstance(obj)) {
            throw new InternalGemFireError(String.format("Constraint Violation: %s is not a %s", obj.getClass().getName(), elementType));
        }
    }

    public String toString() {
        return this.base.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SelectResults)) {
            return false;
        }
        if (!this.collectionType.equals(((SelectResults)obj).getCollectionType())) {
            return false;
        }
        return this.base.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.base.hashCode();
    }

    @Override
    public boolean add(Object o) {
        if (this.limitImposed) {
            throw new UnsupportedOperationException("Addition to the SelectResults not allowed as the query result is constrained by LIMIT");
        }
        return this.base.add(o);
    }

    @Override
    public boolean addAll(Collection c) {
        if (this.limitImposed) {
            throw new UnsupportedOperationException("Addition to the SelectResults not allowed as  the query result is constrained by LIMIT");
        }
        return this.base.addAll(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        if (this.hasLimitIterator) {
            Object object = this.limitLock;
            synchronized (object) {
                return this.limit;
            }
        }
        return this.base.size();
    }

    @Override
    public Iterator iterator() {
        if (this.hasLimitIterator) {
            return new LimitIterator();
        }
        return this.base.iterator();
    }

    @Override
    public void clear() {
        this.base.clear();
    }

    @Override
    public boolean contains(Object obj) {
        if (this.hasLimitIterator) {
            boolean peak = this.base.contains(obj);
            if (!peak) {
                return false;
            }
            Iterator itr = this.iterator();
            boolean found = false;
            while (itr.hasNext()) {
                if (!itr.next().equals(obj)) continue;
                found = true;
                break;
            }
            return found;
        }
        return this.base.contains(obj);
    }

    @Override
    public boolean containsAll(Collection collection) {
        if (this.hasLimitIterator) {
            Iterator itr = collection.iterator();
            boolean containsAll = true;
            while (itr.hasNext() && containsAll) {
                containsAll = this.contains(itr.next());
            }
            return containsAll;
        }
        return this.base.containsAll(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        int size = -1;
        Object object = this.limitLock;
        synchronized (object) {
            size = this.limit;
        }
        return this.base.isEmpty() || size == 0;
    }

    @Override
    public boolean remove(Object obj) {
        if (this.hasLimitIterator) {
            Iterator itr = this.iterator();
            boolean removed = false;
            while (itr.hasNext()) {
                Object element = itr.next();
                if ((obj != null || element != null) && !obj.equals(element)) continue;
                itr.remove();
                removed = true;
                break;
            }
            return removed;
        }
        return this.base.remove(obj);
    }

    @Override
    public boolean removeAll(Collection collection) {
        if (this.hasLimitIterator) {
            Iterator itr = this.iterator();
            boolean removed = false;
            while (itr.hasNext()) {
                Object element = itr.next();
                if (!collection.contains(element)) continue;
                itr.remove();
                removed = true;
            }
            return removed;
        }
        return this.base.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection collection) {
        if (this.hasLimitIterator) {
            Iterator itr = this.iterator();
            boolean changed = false;
            while (itr.hasNext()) {
                Object element = itr.next();
                if (collection.contains(element)) continue;
                itr.remove();
                changed = true;
            }
            return changed;
        }
        return this.retainAll(collection);
    }

    public static Object[] collectionToArray(Collection c) {
        int len = c.size();
        Object[] arr = new Object[len];
        Iterator itr = c.iterator();
        int idx = 0;
        while (true) {
            if (idx < len && itr.hasNext()) {
                arr[idx++] = itr.next();
                continue;
            }
            if (!itr.hasNext()) {
                if (idx == len) {
                    return arr;
                }
                return Arrays.copyOf(arr, idx, Object[].class);
            }
            int newcap = (arr.length / 2 + 1) * 3;
            if (newcap < arr.length) {
                if (arr.length < Integer.MAX_VALUE) {
                    newcap = Integer.MAX_VALUE;
                } else {
                    throw new OutOfMemoryError("required array size too large");
                }
            }
            arr = Arrays.copyOf(arr, newcap, Object[].class);
            len = newcap;
        }
    }

    public static Object[] collectionToArray(Collection c, Object[] a) {
        Class<?> aType = a.getClass();
        int len = c.size();
        Object[] arr = a.length >= len ? a : (Object[])Array.newInstance(aType.getComponentType(), len);
        Iterator itr = c.iterator();
        int idx = 0;
        while (true) {
            if (idx < len && itr.hasNext()) {
                arr[idx++] = itr.next();
                continue;
            }
            if (!itr.hasNext()) {
                if (idx == len) {
                    return arr;
                }
                if (arr == a) {
                    a[idx] = null;
                    return a;
                }
                return Arrays.copyOf(arr, idx, aType);
            }
            int newcap = (arr.length / 2 + 1) * 3;
            if (newcap < arr.length) {
                if (arr.length < Integer.MAX_VALUE) {
                    newcap = Integer.MAX_VALUE;
                } else {
                    throw new OutOfMemoryError("required array size too large");
                }
            }
            arr = Arrays.copyOf(arr, newcap, aType);
            len = newcap;
        }
    }

    @Override
    public Object[] toArray() {
        if (this.hasLimitIterator) {
            return ResultsCollectionWrapper.collectionToArray(this);
        }
        return this.base.toArray();
    }

    @Override
    public Object[] toArray(Object[] obj) {
        if (this.hasLimitIterator) {
            return ResultsCollectionWrapper.collectionToArray(this, obj);
        }
        return this.base.toArray(obj);
    }

    public List asList() {
        if (this.hasLimitIterator) {
            List returnList = null;
            if (this.base instanceof List) {
                int truncate = this.base.size() - this.limit;
                if (truncate > this.limit) {
                    returnList = new ArrayList(this);
                } else {
                    ListIterator li = ((List)this.base).listIterator(this.base.size());
                    for (int j = 0; j < truncate; ++j) {
                        li.previous();
                        li.remove();
                    }
                    returnList = (List)this.base;
                }
            } else {
                returnList = new ArrayList(this);
            }
            return returnList;
        }
        return this.base instanceof List ? (List)this.base : new ArrayList(this.base);
    }

    public Set asSet() {
        if (this.hasLimitIterator) {
            Set returnSet = null;
            if (this.base instanceof Set) {
                Iterator itr = this.base.iterator();
                int j = 0;
                while (itr.hasNext()) {
                    itr.next();
                    if (++j <= this.limit) continue;
                    itr.remove();
                }
                returnSet = (Set)this.base;
            } else {
                returnSet = new HashSet(this);
            }
            return returnSet;
        }
        return this.base instanceof Set ? (Set)this.base : new HashSet(this.base);
    }

    @Override
    public void setElementType(ObjectType elementType) {
        this.collectionType = new CollectionTypeImpl(this.getBaseClass(), elementType);
    }

    @Override
    public CollectionType getCollectionType() {
        return this.collectionType;
    }

    @Override
    public boolean isModifiable() {
        return this.modifiable;
    }

    public void setModifiable(boolean modifiable) {
        this.modifiable = modifiable;
    }

    public int occurrences(Object element) {
        if (!this.getCollectionType().allowsDuplicates() && !this.hasLimitIterator) {
            return this.base.contains(element) ? 1 : 0;
        }
        int count = 0;
        for (Object v : this) {
            if (!(element == null ? v == null : element.equals(v))) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int getDSFID() {
        return 27;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        boolean isBagSetView = this.base instanceof Bag.SetView;
        out.writeBoolean(isBagSetView);
        if (isBagSetView) {
            InternalDataSerializer.writeSet((Set)this.base, out);
        } else {
            DataSerializer.writeObject(this.base, out);
        }
        DataSerializer.writeObject(this.collectionType, out);
        out.writeBoolean(this.modifiable);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        boolean isBagSetView = in.readBoolean();
        this.base = isBagSetView ? InternalDataSerializer.readSet(in) : (Collection)DataSerializer.readObject(in);
        this.collectionType = (CollectionType)DataSerializer.readObject(in);
        this.modifiable = in.readBoolean();
    }

    private Class getBaseClass() {
        if (this.base instanceof Ordered) {
            return Ordered.class;
        }
        if (this.base instanceof TreeSet) {
            return TreeSet.class;
        }
        if (this.base instanceof Set) {
            return Set.class;
        }
        return this.base.getClass();
    }

    public void setKeepSerialized(boolean keepSerialized) {
        if (this.base instanceof EntriesSet) {
            ((EntriesSet)this.base).setKeepSerialized(keepSerialized);
        }
    }

    public void setIgnoreCopyOnReadForQuery(boolean ignore) {
        if (this.base instanceof EntriesSet) {
            ((EntriesSet)this.base).setIgnoreCopyOnReadForQuery(ignore);
        }
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    class LimitIterator
    implements Iterator {
        private final Iterator iter;
        private int currPos = 0;
        private final int localLimit;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LimitIterator() {
            Object object = ResultsCollectionWrapper.this.limitLock;
            synchronized (object) {
                this.iter = ResultsCollectionWrapper.this.base.iterator();
                this.localLimit = ResultsCollectionWrapper.this.limit;
            }
        }

        @Override
        public boolean hasNext() {
            return this.currPos < this.localLimit;
        }

        public Object next() {
            if (this.currPos == this.localLimit) {
                throw new NoSuchElementException();
            }
            Object obj = this.iter.next();
            ++this.currPos;
            return obj;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            if (this.currPos == 0) {
                throw new IllegalStateException("next() must be called before remove()");
            }
            Object object = ResultsCollectionWrapper.this.limitLock;
            synchronized (object) {
                this.iter.remove();
                --ResultsCollectionWrapper.this.limit;
            }
        }
    }
}

