/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.DataSerializableFixedID;
import org.apache.geode.internal.Version;

public class PRQueryTraceInfo
implements DataSerializableFixedID {
    public String indexesUsed = "";
    private InternalDistributedMember sender;
    private float timeInMillis;
    private int numResults;

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeFloat(this.timeInMillis);
        out.writeInt(this.numResults);
        DataSerializer.writeString(this.indexesUsed, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.timeInMillis = in.readFloat();
        this.numResults = in.readInt();
        this.indexesUsed = DataSerializer.readString(in);
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    @Override
    public int getDSFID() {
        return 2162;
    }

    public int calculateNumberOfResults(Collection resultCollector) {
        int traceSize = 0;
        for (Collection collection : resultCollector) {
            traceSize += collection.size();
        }
        return traceSize;
    }

    public String createLogLine(DistributedMember me) {
        if (this.sender.equals(me)) {
            return String.format("Local %s took %sms and returned %s results; %s", this.sender, Float.valueOf(this.timeInMillis), this.numResults, this.indexesUsed);
        }
        return String.format("Remote %s took %sms and returned %s results; %s", this.sender, Float.valueOf(this.timeInMillis), this.numResults, this.indexesUsed);
    }

    public float getTimeInMillis() {
        return this.timeInMillis;
    }

    public void setTimeInMillis(float timeInMillis) {
        this.timeInMillis = timeInMillis;
    }

    public void setSender(InternalDistributedMember sender) {
        this.sender = sender;
    }

    public void setNumResults(int numResults) {
        this.numResults = numResults;
    }

    public void setIndexesUsed(String indexesUsed) {
        this.indexesUsed = indexesUsed;
    }
}

