/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.LongAdder;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.annotations.internal.MutableForTesting;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.client.internal.ProxyCache;
import org.apache.geode.cache.client.internal.ServerProxy;
import org.apache.geode.cache.client.internal.UserAttributes;
import org.apache.geode.cache.execute.RegionFunctionContext;
import org.apache.geode.cache.partition.PartitionRegionHelper;
import org.apache.geode.cache.persistence.PartitionOfflineException;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.QueryException;
import org.apache.geode.cache.query.QueryInvalidException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.QueryStatistics;
import org.apache.geode.cache.query.RegionNotFoundException;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.CompiledIteratorDef;
import org.apache.geode.cache.query.internal.CompiledSelect;
import org.apache.geode.cache.query.internal.CompiledSortCriterion;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.DefaultQueryService;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.IndexTrackingQueryObserver;
import org.apache.geode.cache.query.internal.QCompiler;
import org.apache.geode.cache.query.internal.QueryExecutionCanceledException;
import org.apache.geode.cache.query.internal.QueryExecutionContext;
import org.apache.geode.cache.query.internal.QueryExecutor;
import org.apache.geode.cache.query.internal.QueryMonitor;
import org.apache.geode.cache.query.internal.QueryObserver;
import org.apache.geode.cache.query.internal.QueryObserverHolder;
import org.apache.geode.cache.query.internal.ResultsCollectionCopyOnReadWrapper;
import org.apache.geode.cache.query.internal.ResultsCollectionPdxDeserializerWrapper;
import org.apache.geode.cache.query.internal.cq.InternalCqQuery;
import org.apache.geode.internal.NanoTimer;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.CachePerfStats;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.LocalDataSet;
import org.apache.geode.internal.cache.PRQueryProcessor;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.TXStateProxy;

public class DefaultQuery
implements Query {
    private final CompiledValue compiledQuery;
    private final String queryString;
    private final InternalCache cache;
    private ServerProxy serverProxy;
    private final LongAdder numExecutions = new LongAdder();
    private final LongAdder totalExecutionTime = new LongAdder();
    private final QueryStatistics stats;
    private boolean traceOn = false;
    @Immutable
    private static final Object[] EMPTY_ARRAY = new Object[0];
    @MutableForTesting
    public static boolean QUERY_VERBOSE = Boolean.getBoolean("gemfire.Query.VERBOSE");
    public static final int COMPILED_QUERY_CLEAR_TIME = Integer.getInteger("gemfire.Query.COMPILED_QUERY_CLEAR_TIME", 600000);
    @MutableForTesting
    public static int TEST_COMPILED_QUERY_CLEAR_TIME = -1;
    public static final Object NULL_RESULT = new Object();
    private ProxyCache proxyCache;
    private boolean isCqQuery = false;
    private boolean isQueryWithFunctionContext = false;
    private InternalCqQuery cqQuery = null;
    private volatile boolean lastUsed = true;
    @MakeNotStatic
    public static TestHook testHook;
    private boolean isRemoteQuery = false;
    private boolean keepSerialized = false;
    private static final ThreadLocal<Map<String, Set<String>>> pdxClassToFieldsMap;
    private static final ThreadLocal<Map<String, Set<String>>> pdxClassToMethodsMap;

    public static Map<String, Set<String>> getPdxClasstofieldsmap() {
        return pdxClassToFieldsMap.get();
    }

    public static void setPdxClasstoMethodsmap(Map<String, Set<String>> map) {
        pdxClassToMethodsMap.set(map);
    }

    public static Map<String, Set<String>> getPdxClasstoMethodsmap() {
        return pdxClassToMethodsMap.get();
    }

    public DefaultQuery(String queryString, InternalCache cache, boolean isForRemote) {
        this.queryString = queryString;
        QCompiler compiler = new QCompiler();
        this.compiledQuery = compiler.compileQuery(queryString);
        CompiledSelect cs = this.getSimpleSelect();
        if (cs != null && !isForRemote && (cs.isGroupBy() || cs.isOrderBy())) {
            QueryExecutionContext ctx = new QueryExecutionContext(null, cache);
            try {
                cs.computeDependencies(ctx);
            }
            catch (QueryException qe) {
                throw new QueryInvalidException("", qe);
            }
        }
        this.traceOn = compiler.isTraceRequested() || QUERY_VERBOSE;
        this.cache = cache;
        this.stats = new DefaultQueryStatistics();
    }

    @Override
    public QueryStatistics getStatistics() {
        return this.stats;
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public Object execute() throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        return this.execute(EMPTY_ARRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(Object[] params) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        Object object;
        QueryExecutionContext context;
        Boolean initialPdxReadSerialized;
        Object result;
        QueryMonitor queryMonitor;
        QueryObserver indexObserver;
        long startTime;
        block18: {
            if (params == null) {
                throw new IllegalArgumentException("'parameters' cannot be null");
            }
            if (this.serverProxy != null) {
                return this.executeOnServer(params);
            }
            startTime = 0L;
            if (this.traceOn && this.cache != null) {
                startTime = NanoTimer.getTime();
            }
            indexObserver = null;
            queryMonitor = null;
            QueryExecutor qe = this.checkQueryOnPR(params);
            result = null;
            initialPdxReadSerialized = this.cache.getPdxReadSerializedOverride();
            context = new QueryExecutionContext(params, this.cache, this);
            this.cache.setPdxReadSerializedOverride(true);
            indexObserver = this.startTrace();
            if (qe == null) break block18;
            if (testHook != null) {
                testHook.doTestHook(TestHook.SPOTS.BEFORE_QUERY_EXECUTION, this, context);
            }
            result = qe.executeQuery(this, context, params, null);
            if (this.needsPDXDeserializationWrapper(true) && result instanceof SelectResults) {
                result = new ResultsCollectionPdxDeserializerWrapper((SelectResults)result, false);
            }
            Object object2 = result;
            this.cache.setPdxReadSerializedOverride(initialPdxReadSerialized);
            if (queryMonitor != null) {
                queryMonitor.stopMonitoringQueryExecution(context);
            }
            this.endTrace(indexObserver, startTime, result);
            return object2;
        }
        try {
            boolean needsCopyOnReadWrapper;
            queryMonitor = this.cache.getQueryMonitor();
            if (queryMonitor != null) {
                queryMonitor.monitorQueryExecution(context);
            }
            result = this.executeUsingContext(context);
            boolean bl = needsCopyOnReadWrapper = this.cache.getCopyOnRead() && !DefaultQueryService.COPY_ON_READ_AT_ENTRY_LEVEL || context.isIndexUsed() && DefaultQueryService.COPY_ON_READ_AT_ENTRY_LEVEL;
            if (this.needsPDXDeserializationWrapper(false) && result instanceof SelectResults) {
                result = new ResultsCollectionPdxDeserializerWrapper((SelectResults)result, needsCopyOnReadWrapper);
            } else if (!this.isRemoteQuery() && this.cache.getCopyOnRead() && result instanceof SelectResults && needsCopyOnReadWrapper) {
                result = new ResultsCollectionCopyOnReadWrapper((SelectResults)result);
            }
            object = result;
        }
        catch (QueryExecutionCanceledException ignore) {
            try {
                Object object3 = context.reinterpretQueryExecutionCanceledException();
                this.cache.setPdxReadSerializedOverride(initialPdxReadSerialized);
                if (queryMonitor != null) {
                    queryMonitor.stopMonitoringQueryExecution(context);
                }
                this.endTrace(indexObserver, startTime, result);
                return object3;
            }
            catch (Throwable throwable) {
                this.cache.setPdxReadSerializedOverride(initialPdxReadSerialized);
                if (queryMonitor != null) {
                    queryMonitor.stopMonitoringQueryExecution(context);
                }
                this.endTrace(indexObserver, startTime, result);
                throw throwable;
            }
        }
        this.cache.setPdxReadSerializedOverride(initialPdxReadSerialized);
        if (queryMonitor != null) {
            queryMonitor.stopMonitoringQueryExecution(context);
        }
        this.endTrace(indexObserver, startTime, result);
        return object;
    }

    private boolean needsPDXDeserializationWrapper(boolean isQueryOnPR) {
        return !this.isRemoteQuery() && !this.cache.getPdxReadSerialized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeOnServer(Object[] parameters) {
        long startTime = CachePerfStats.getStatTime();
        SelectResults result = null;
        try {
            if (this.proxyCache != null) {
                if (this.proxyCache.isClosed()) {
                    throw this.proxyCache.getCacheClosedException("Cache is closed for this user.");
                }
                UserAttributes.userAttributes.set(this.proxyCache.getUserAttributes());
            }
            result = this.serverProxy.query(this.queryString, parameters);
        }
        finally {
            UserAttributes.userAttributes.set(null);
            long endTime = CachePerfStats.getStatTime();
            this.updateStatistics(endTime - startTime);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object prExecuteOnBucket(Object[] parameters, PartitionedRegion pr, BucketRegion bukRgn) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        if (parameters == null) {
            parameters = EMPTY_ARRAY;
        }
        long startTime = 0L;
        if (this.traceOn && this.cache != null) {
            startTime = NanoTimer.getTime();
        }
        IndexTrackingQueryObserver indexObserver = null;
        String otherObserver = null;
        if (this.traceOn) {
            QueryObserver qo = QueryObserverHolder.getInstance();
            if (qo instanceof IndexTrackingQueryObserver) {
                indexObserver = (IndexTrackingQueryObserver)qo;
            } else if (!QueryObserverHolder.hasObserver()) {
                indexObserver = new IndexTrackingQueryObserver();
                QueryObserverHolder.setInstance(indexObserver);
            } else {
                otherObserver = qo.getClass().getName();
            }
        }
        QueryExecutionContext context = new QueryExecutionContext(parameters, this.cache, this);
        context.setBucketRegion(pr, bukRgn);
        QueryMonitor queryMonitor = this.cache.getQueryMonitor();
        if (queryMonitor != null && PRQueryProcessor.NUM_THREADS > 1) {
            queryMonitor.monitorQueryExecution(context);
        }
        Object result = null;
        try {
            result = this.executeUsingContext(context);
        }
        finally {
            if (queryMonitor != null && PRQueryProcessor.NUM_THREADS > 1) {
                queryMonitor.stopMonitoringQueryExecution(context);
            }
            int resultSize = 0;
            if (this.traceOn && result instanceof Collection) {
                resultSize = ((Collection)result).size();
            }
            String queryVerboseMsg = DefaultQuery.getLogMessage(indexObserver, startTime, otherObserver, resultSize, this.queryString, bukRgn);
            if (this.traceOn && this.cache.getLogger().fineEnabled()) {
                this.cache.getLogger().fine(queryVerboseMsg);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeUsingContext(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        QueryObserver observer = QueryObserverHolder.getInstance();
        long startTime = CachePerfStats.getStatTime();
        TXStateProxy tx = ((TXManagerImpl)this.cache.getCacheTransactionManager()).pauseTransaction();
        try {
            observer.startQuery(this);
            observer.beforeQueryEvaluation(this.compiledQuery, context);
            if (testHook != null) {
                testHook.doTestHook(TestHook.SPOTS.BEFORE_QUERY_DEPENDENCY_COMPUTATION, this, context);
            }
            Object results = null;
            try {
                this.compiledQuery.computeDependencies(context);
                if (testHook != null) {
                    testHook.doTestHook(TestHook.SPOTS.BEFORE_QUERY_EXECUTION, this, context);
                }
                results = this.compiledQuery.evaluate(context);
                observer.afterQueryEvaluation(results);
            }
            catch (QueryExecutionCanceledException ignore) {
                context.reinterpretQueryExecutionCanceledException();
            }
            finally {
                observer.afterQueryEvaluation(results);
            }
            Object object = results;
            return object;
        }
        finally {
            observer.endQuery();
            long endTime = CachePerfStats.getStatTime();
            this.updateStatistics(endTime - startTime);
            pdxClassToFieldsMap.remove();
            pdxClassToMethodsMap.remove();
            ExecutionContext.isCanceled.remove();
            ((TXManagerImpl)this.cache.getCacheTransactionManager()).unpauseTransaction(tx);
        }
    }

    private QueryExecutor checkQueryOnPR(Object[] parameters) throws RegionNotFoundException, PartitionOfflineException {
        ArrayList<QueryExecutor> prs = new ArrayList<QueryExecutor>();
        for (String string : this.getRegionsInQuery(parameters)) {
            String regionPath = string;
            Region rgn = this.cache.getRegion(regionPath);
            if (rgn == null) {
                this.cache.getCancelCriterion().checkCancelInProgress(null);
                throw new RegionNotFoundException(String.format("Region not found: %s", regionPath));
            }
            if (!(rgn instanceof QueryExecutor)) continue;
            ((PartitionedRegion)rgn).checkPROffline();
            prs.add((QueryExecutor)((Object)rgn));
        }
        if (prs.size() == 1) {
            return (QueryExecutor)prs.get(0);
        }
        if (prs.size() > 1) {
            if (!this.isQueryWithFunctionContext()) {
                throw new UnsupportedOperationException(String.format("A query on a Partitioned Region ( %s ) may not reference any other region if query is NOT executed within a Function", ((QueryExecutor)prs.get(0)).getName()));
            }
            QueryExecutor other = null;
            for (QueryExecutor eachPR : prs) {
                boolean colocated = false;
                for (QueryExecutor allPRs : prs) {
                    if (eachPR == allPRs) continue;
                    other = allPRs;
                    if (!((PartitionedRegion)eachPR).getColocatedByList().contains(allPRs) && !((PartitionedRegion)allPRs).getColocatedByList().contains(eachPR)) continue;
                    colocated = true;
                    break;
                }
                if (colocated) continue;
                throw new UnsupportedOperationException(String.format("A query on a Partitioned Region ( %s ) may not reference any other region except Co-located Partitioned Region. PR region %s is not collocated with other PR region in the query.", eachPR.getName(), other.getName()));
            }
            CompiledSelect compiledSelect = this.getSimpleSelect();
            if (compiledSelect == null) {
                throw new UnsupportedOperationException("query must be a simple select when referencing a Partitioned Region");
            }
            HashSet regions = new HashSet();
            CompiledValue whereClause = compiledSelect.getWhereClause();
            if (whereClause != null) {
                whereClause.getRegionsInQuery(regions, parameters);
                if (!regions.isEmpty()) {
                    throw new UnsupportedOperationException("The WHERE clause cannot refer to a region when querying on a Partitioned Region");
                }
            }
            List fromClause = compiledSelect.getIterators();
            Iterator fromClauseIterator = fromClause.iterator();
            CompiledIteratorDef itrDef = (CompiledIteratorDef)fromClauseIterator.next();
            itrDef.visitNodes(new CompiledValue.NodeVisitor(){

                @Override
                public boolean visit(CompiledValue node) {
                    if (node instanceof CompiledSelect) {
                        throw new UnsupportedOperationException("When querying a PartitionedRegion, the first FROM clause iterator must not contain a subquery");
                    }
                    return true;
                }
            });
            if (!this.isQueryWithFunctionContext()) {
                List<CompiledSortCriterion> orderBys;
                while (fromClauseIterator.hasNext()) {
                    itrDef = (CompiledIteratorDef)fromClauseIterator.next();
                    itrDef.getRegionsInQuery(regions, parameters);
                    if (regions.isEmpty()) continue;
                    throw new UnsupportedOperationException("When querying a Partitioned Region, the FROM clause iterators other than the first one must not reference any regions");
                }
                List projs = compiledSelect.getProjectionAttributes();
                if (projs != null) {
                    for (Object proj1 : projs) {
                        Object[] rawProj = (Object[])proj1;
                        CompiledValue proj = (CompiledValue)rawProj[1];
                        proj.getRegionsInQuery(regions, parameters);
                        if (regions.isEmpty()) continue;
                        throw new UnsupportedOperationException("When querying a Partitioned Region, the projections must not reference any regions");
                    }
                }
                if ((orderBys = compiledSelect.getOrderByAttrs()) != null) {
                    for (CompiledSortCriterion orderBy : orderBys) {
                        orderBy.getRegionsInQuery(regions, parameters);
                        if (regions.isEmpty()) continue;
                        throw new UnsupportedOperationException("When querying a Partitioned Region, the order-by attributes must not reference any regions");
                    }
                }
            }
            return (QueryExecutor)prs.get(0);
        }
        return null;
    }

    private void updateStatistics(long executionTime) {
        this.numExecutions.increment();
        this.totalExecutionTime.add(executionTime);
        this.cache.getCachePerfStats().endQueryExecution(executionTime);
    }

    @Override
    public void compile() {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public boolean isCompiled() {
        return false;
    }

    public boolean isTraced() {
        return this.traceOn;
    }

    public Set<String> getRegionsInQuery(Object[] parameters) {
        HashSet regions = new HashSet();
        this.compiledQuery.getRegionsInQuery(regions, parameters);
        return Collections.unmodifiableSet(regions);
    }

    public CompiledSelect getSimpleSelect() {
        if (this.compiledQuery instanceof CompiledSelect) {
            return (CompiledSelect)this.compiledQuery;
        }
        return null;
    }

    public CompiledSelect getSelect() {
        return (CompiledSelect)this.compiledQuery;
    }

    public int getLimit(Object[] bindArguments) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        return this.compiledQuery instanceof CompiledSelect ? ((CompiledSelect)this.compiledQuery).getLimitValue(bindArguments) : -1;
    }

    void setServerProxy(ServerProxy serverProxy) {
        this.serverProxy = serverProxy;
    }

    public void setIsCqQuery(boolean isCqQuery) {
        this.isCqQuery = isCqQuery;
    }

    public boolean isCqQuery() {
        return this.isCqQuery;
    }

    public void setCqQuery(InternalCqQuery cqQuery) {
        this.cqQuery = cqQuery;
    }

    public void setLastUsed(boolean lastUsed) {
        this.lastUsed = lastUsed;
    }

    public boolean getLastUsed() {
        return this.lastUsed;
    }

    public InternalCqQuery getCqQuery() {
        return this.cqQuery;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Query String = ");
        sb.append(this.queryString);
        sb.append("; Total Executions = ");
        sb.append(this.numExecutions);
        sb.append("; Total Execution Time = ");
        sb.append(this.totalExecutionTime);
        return sb.toString();
    }

    void setProxyCache(ProxyCache proxyCache) {
        this.proxyCache = proxyCache;
    }

    public static void setTestCompiledQueryClearTime(int val) {
        TEST_COMPILED_QUERY_CLEAR_TIME = val;
    }

    private static String getLogMessage(QueryObserver observer, long startTime, int resultSize, String query) {
        float time = (float)(NanoTimer.getTime() - startTime) / 1000000.0f;
        String usedIndexesString = null;
        if (observer instanceof IndexTrackingQueryObserver) {
            IndexTrackingQueryObserver indexObserver = (IndexTrackingQueryObserver)observer;
            Map usedIndexes = indexObserver.getUsedIndexes();
            indexObserver.reset();
            StringBuilder sb = new StringBuilder();
            sb.append(" indexesUsed(");
            sb.append(usedIndexes.size());
            sb.append(')');
            if (usedIndexes.size() > 0) {
                sb.append(':');
                Iterator itr = usedIndexes.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry entry = itr.next();
                    sb.append(entry.getKey()).append(entry.getValue());
                    if (!itr.hasNext()) continue;
                    sb.append(',');
                }
            }
            usedIndexesString = sb.toString();
        } else if (QUERY_VERBOSE) {
            usedIndexesString = " indexesUsed(NA due to other observer in the way: " + observer.getClass().getName() + ')';
        }
        String rowCountString = null;
        if (resultSize != -1) {
            rowCountString = " rowCount = " + resultSize + ';';
        }
        return "Query Executed in " + time + " ms;" + (rowCountString != null ? rowCountString : "") + (usedIndexesString != null ? usedIndexesString : "") + " \"" + query + '\"';
    }

    private static String getLogMessage(IndexTrackingQueryObserver indexObserver, long startTime, String otherObserver, int resultSize, String query, BucketRegion bucket) {
        float time = 0.0f;
        if (startTime > 0L) {
            time = (float)(NanoTimer.getTime() - startTime) / 1000000.0f;
        }
        String usedIndexesString = null;
        if (indexObserver != null) {
            Map usedIndexes = indexObserver.getUsedIndexes(bucket.getFullPath());
            StringBuilder sb = new StringBuilder();
            sb.append(" indexesUsed(");
            sb.append(usedIndexes.size());
            sb.append(')');
            if (!usedIndexes.isEmpty()) {
                sb.append(':');
                Iterator itr = usedIndexes.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry entry = itr.next();
                    sb.append(entry.getKey()).append("(Results: ").append(entry.getValue()).append(", Bucket: ").append(bucket.getId()).append(")");
                    if (!itr.hasNext()) continue;
                    sb.append(',');
                }
            }
            usedIndexesString = sb.toString();
        } else if (QUERY_VERBOSE) {
            usedIndexesString = " indexesUsed(NA due to other observer in the way: " + otherObserver + ')';
        }
        String rowCountString = " rowCount = " + resultSize + ';';
        return "Query Executed" + (startTime > 0L ? " in " + time + " ms;" : ";") + rowCountString + (usedIndexesString != null ? usedIndexesString : "") + " \"" + query + '\"';
    }

    @Override
    public Object execute(RegionFunctionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        return this.execute(context, EMPTY_ARRAY);
    }

    @Override
    public Object execute(RegionFunctionContext context, Object[] params) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        block6: {
            if (context == null) {
                throw new IllegalArgumentException("'Function Context' cannot be null");
            }
            this.isQueryWithFunctionContext = true;
            if (params == null) {
                throw new IllegalArgumentException("'parameters' cannot be null");
            }
            long startTime = 0L;
            if (this.traceOn && this.cache != null) {
                startTime = NanoTimer.getTime();
            }
            QueryObserver indexObserver = null;
            QueryExecutor qe = this.checkQueryOnPR(params);
            Object result = null;
            try {
                indexObserver = this.startTrace();
                if (qe == null) break block6;
                LocalDataSet localDataSet = (LocalDataSet)PartitionRegionHelper.getLocalDataForContext(context);
                Set<Integer> buckets = localDataSet.getBucketSet();
                ExecutionContext executionContext = new ExecutionContext(null, this.cache);
                Object object = result = qe.executeQuery(this, executionContext, params, buckets);
                this.endTrace(indexObserver, startTime, result);
                return object;
            }
            catch (Throwable throwable) {
                this.endTrace(indexObserver, startTime, result);
                throw throwable;
            }
        }
        throw new IllegalArgumentException("This query API can only be used for Partition Region Queries.");
    }

    public boolean isQueryWithFunctionContext() {
        return this.isQueryWithFunctionContext;
    }

    public QueryObserver startTrace() {
        QueryObserver queryObserver = null;
        if (this.traceOn && this.cache != null) {
            QueryObserver qo = QueryObserverHolder.getInstance();
            if (qo instanceof IndexTrackingQueryObserver) {
                queryObserver = qo;
            } else if (!QueryObserverHolder.hasObserver()) {
                queryObserver = new IndexTrackingQueryObserver();
                QueryObserverHolder.setInstance(queryObserver);
            } else {
                queryObserver = qo;
            }
        }
        return queryObserver;
    }

    public void endTrace(QueryObserver indexObserver, long startTime, Object result) {
        if (this.traceOn && this.cache != null) {
            int resultSize = -1;
            if (result instanceof Collection) {
                resultSize = ((Collection)result).size();
            }
            String queryVerboseMsg = DefaultQuery.getLogMessage(indexObserver, startTime, resultSize, this.queryString);
            this.cache.getLogger().info(queryVerboseMsg);
        }
    }

    public void endTrace(QueryObserver indexObserver, long startTime, Collection<Collection> result) {
        if (this.cache != null && this.cache.getLogger().infoEnabled() && this.traceOn) {
            int resultSize = 0;
            for (Collection aResult : result) {
                resultSize += aResult.size();
            }
            String queryVerboseMsg = DefaultQuery.getLogMessage(indexObserver, startTime, resultSize, this.queryString);
            if (this.cache.getLogger().infoEnabled()) {
                this.cache.getLogger().info(queryVerboseMsg);
            }
        }
    }

    public boolean isRemoteQuery() {
        return this.isRemoteQuery;
    }

    public void setRemoteQuery(boolean isRemoteQuery) {
        this.isRemoteQuery = isRemoteQuery;
    }

    void keepResultsSerialized(CompiledSelect cs, ExecutionContext context) {
        if (this.isRemoteQuery() && cs.getIterators().size() == context.getAllIndependentIteratorsOfCurrentScope().size() && cs.getWhereClause() == null && cs.getProjectionAttributes() == null && !cs.isDistinct() && cs.getOrderByAttrs() == null) {
            this.setKeepSerialized();
        }
    }

    public boolean isKeepSerialized() {
        return this.keepSerialized;
    }

    private void setKeepSerialized() {
        this.keepSerialized = true;
    }

    static {
        pdxClassToFieldsMap = ThreadLocal.withInitial(HashMap::new);
        pdxClassToMethodsMap = ThreadLocal.withInitial(HashMap::new);
    }

    @FunctionalInterface
    public static interface TestHook {
        public void doTestHook(SPOTS var1, DefaultQuery var2, ExecutionContext var3);

        public static enum SPOTS {
            BEFORE_QUERY_EXECUTION,
            BEFORE_QUERY_DEPENDENCY_COMPUTATION,
            LOW_MEMORY_WHEN_DESERIALIZING_STREAMINGOPERATION,
            BEFORE_ADD_OR_UPDATE_MAPPING_OR_DESERIALIZING_NTH_STREAMINGOPERATION,
            BEFORE_BUILD_CUMULATIVE_RESULT,
            BEFORE_THROW_QUERY_CANCELED_EXCEPTION,
            BEGIN_TRANSITION_FROM_REGION_ENTRY_TO_ELEMARRAY,
            TRANSITIONED_FROM_REGION_ENTRY_TO_ELEMARRAY,
            COMPLETE_TRANSITION_FROM_REGION_ENTRY_TO_ELEMARRAY,
            BEGIN_TRANSITION_FROM_ELEMARRAY_TO_CONCURRENT_HASH_SET,
            TRANSITIONED_FROM_ELEMARRAY_TO_TOKEN,
            COMPLETE_TRANSITION_FROM_ELEMARRAY_TO_CONCURRENT_HASH_SET,
            ATTEMPT_REMOVE,
            ATTEMPT_RETRY,
            BEGIN_REMOVE_FROM_ELEM_ARRAY,
            REMOVE_CALLED_FROM_ELEM_ARRAY,
            COMPLETE_REMOVE_FROM_ELEM_ARRAY,
            PULL_OFF_PR_QUERY_TRACE_INFO,
            CREATE_PR_QUERY_TRACE_STRING,
            CREATE_PR_QUERY_TRACE_INFO_FROM_LOCAL_NODE,
            CREATE_PR_QUERY_TRACE_INFO_FOR_REMOTE_QUERY,
            POPULATING_TRACE_INFO_FOR_REMOTE_QUERY;

        }
    }

    class DefaultQueryStatistics
    implements QueryStatistics {
        DefaultQueryStatistics() {
        }

        @Override
        public long getTotalExecutionTime() {
            return DefaultQuery.this.totalExecutionTime.longValue();
        }

        @Override
        public long getNumExecutions() {
            return DefaultQuery.this.numExecutions.longValue();
        }
    }
}

