/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.util.regex.Pattern;
import org.apache.geode.cache.query.AmbiguousNameException;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.AbstractCompiledValue;
import org.apache.geode.cache.query.internal.CompiledComparison;
import org.apache.geode.cache.query.internal.CompiledLiteral;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.GroupJunction;
import org.apache.geode.cache.query.internal.IndexInfo;
import org.apache.geode.cache.query.internal.OrganizedOperands;
import org.apache.geode.cache.query.internal.PlanInfo;
import org.apache.geode.cache.query.internal.QueryUtils;
import org.apache.geode.cache.query.internal.RangeJunction;
import org.apache.geode.cache.query.internal.RuntimeIterator;
import org.apache.geode.cache.query.internal.index.IndexManager;
import org.apache.geode.cache.query.internal.index.IndexProtocol;
import org.apache.geode.cache.query.internal.index.PrimaryKeyIndex;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.pdx.internal.PdxString;
import org.apache.logging.log4j.Logger;

public class CompiledLike
extends CompiledComparison {
    private static final Logger logger = LogService.getLogger();
    private static final int WILDCARD_PERCENT = 0;
    private static final int WILDCARD_UNDERSCORE = 1;
    private final Object wildcardTypeKey = new Object();
    private final Object wildcardPositionKey = new Object();
    private final Object patternLengthKey = new Object();
    static final String LOWEST_STRING = "";
    private static final char BOUNDARY_CHAR = '\u00ff';
    private static final char UNDERSCORE = '_';
    private static final char PERCENT = '%';
    private static final char BACKSLASH = '\\';
    private final CompiledValue var;
    private final Object isIndexEvaluatedKey = new Object();
    private final CompiledValue bindArg;

    CompiledLike(CompiledValue var, CompiledValue pattern) {
        super(var, pattern, 13);
        this.var = var;
        this.bindArg = pattern;
    }

    private int getWildcardPosition(ExecutionContext context) {
        return (Integer)context.cacheGet(this.wildcardPositionKey, -1);
    }

    private int getWildcardType(ExecutionContext context) {
        return (Integer)context.cacheGet(this.wildcardTypeKey, -1);
    }

    private int getPatternLength(ExecutionContext context) {
        return (Integer)context.cacheGet(this.patternLengthKey, 0);
    }

    private boolean getIsIndexEvaluated(ExecutionContext context) {
        return (Boolean)context.cacheGet(this.isIndexEvaluatedKey, false);
    }

    OrganizedOperands organizeOperands(ExecutionContext context, boolean completeExpansionNeeded, RuntimeIterator[] indpndntItrs) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        CompiledValue[] cvs = this.getExpandedOperandsWithIndexInfoSetIfAny(context);
        AbstractCompiledValue filter = null;
        filter = cvs.length == 1 ? cvs[0] : (this.getOperator() == 20 && this.getWildcardPosition(context) == this.getPatternLength(context) - 1 && this.getWildcardType(context) == 0 ? new GroupJunction(89, indpndntItrs, completeExpansionNeeded, cvs) : new RangeJunction(91, indpndntItrs, completeExpansionNeeded, cvs));
        OrganizedOperands result = new OrganizedOperands();
        result.isSingleFilter = true;
        result.filterOperand = filter;
        return result;
    }

    CompiledComparison[] getExpandedOperandsWithIndexInfoSetIfAny(ExecutionContext context) throws AmbiguousNameException, TypeMismatchException, NameResolutionException, FunctionDomainException, QueryInvocationTargetException {
        CompiledComparison[] cvs;
        String pattern = (String)this.bindArg.evaluate(context);
        for (CompiledComparison cc : cvs = this.getRangeIfSargable(context, this.var, pattern)) {
            if (this.getOperator() == 20 && this.getWildcardPosition(context) == this.getPatternLength(context) - 1 && this.getWildcardType(context) == 0) {
                cc.negate();
            }
            cc.computeDependencies(context);
            IndexInfo[] thisIndexInfo = (IndexInfo[])context.cacheGet(this);
            if (thisIndexInfo == null || thisIndexInfo.length <= 0) continue;
            IndexInfo indexInfo = new IndexInfo(cc.getKey(context), thisIndexInfo[0]._path, thisIndexInfo[0]._index, thisIndexInfo[0]._matchLevel, thisIndexInfo[0].mapping, cc.getOperator());
            context.cachePut(cc, new IndexInfo[]{indexInfo});
        }
        if (IndexManager.testHook != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("IndexManager TestHook is set in getExpandedOperandsWithIndexInfoSetIfAny.");
            }
            IndexManager.testHook.hook(12);
        }
        return cvs;
    }

    @Override
    public SelectResults filterEvaluate(ExecutionContext context, SelectResults intermediateResults, boolean completeExpansionNeeded, CompiledValue iterOperands, RuntimeIterator[] indpndntItrs, boolean isIntersection, boolean conditioningNeeded, boolean evaluateProjection) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        OrganizedOperands newOperands = this.organizeOperands(context, completeExpansionNeeded, indpndntItrs);
        assert (newOperands.iterateOperand == null);
        SelectResults result = intermediateResults;
        result = newOperands.filterOperand.filterEvaluate(context, intermediateResults, completeExpansionNeeded, iterOperands, indpndntItrs, isIntersection, conditioningNeeded, evaluateProjection);
        return result;
    }

    @Override
    public SelectResults filterEvaluate(ExecutionContext context, SelectResults intermediateResults) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        RuntimeIterator grpItr = (RuntimeIterator)QueryUtils.getCurrentScopeUltimateRuntimeIteratorsIfAny(this, context).iterator().next();
        OrganizedOperands newOperands = this.organizeOperands(context, true, new RuntimeIterator[]{grpItr});
        assert (newOperands.iterateOperand == null);
        SelectResults result = intermediateResults;
        result = newOperands.filterOperand.filterEvaluate(context, intermediateResults);
        return result;
    }

    CompiledComparison[] getRangeIfSargable(ExecutionContext context, CompiledValue var, String pattern) {
        CompiledComparison[] cv = null;
        StringBuffer buffer = new StringBuffer(pattern);
        int wildcardPosition = this.checkIfSargableAndRemoveEscapeChars(context, buffer);
        context.cachePut(this.wildcardPositionKey, wildcardPosition);
        int patternLength = buffer.length();
        context.cachePut(this.patternLengthKey, patternLength);
        context.cachePut(this.isIndexEvaluatedKey, true);
        if (wildcardPosition >= 0) {
            int len = patternLength;
            if (wildcardPosition == 0) {
                cv = new CompiledComparison[]{new CompiledComparison(var, new CompiledLiteral(LOWEST_STRING), 19), this};
            } else {
                char upperBoundChar;
                for (int k = len - 1; k >= wildcardPosition; --k) {
                    buffer.deleteCharAt(k);
                    --len;
                }
                String lowerBound = buffer.toString();
                int upperBoundPosition = len - 1;
                while ((upperBoundChar = buffer.charAt(upperBoundPosition)) == '\u00ff') {
                    --upperBoundPosition;
                }
                upperBoundChar = (char)(buffer.charAt(upperBoundPosition) + '\u0001');
                buffer.delete(upperBoundPosition, len);
                buffer.append(upperBoundChar);
                String upperBound = buffer.toString();
                CompiledComparison c1 = new CompiledComparison(var, new CompiledLiteral(lowerBound), 19);
                CompiledComparison c2 = new CompiledComparison(var, new CompiledLiteral(upperBound), 22);
                cv = len < patternLength - 1 || this.getWildcardType(context) == 1 ? (this.getOperator() == 20 ? new CompiledComparison[]{new CompiledComparison(var, new CompiledLiteral(LOWEST_STRING), 19), this} : new CompiledComparison[]{c1, c2, this}) : new CompiledComparison[]{c1, c2};
            }
        } else {
            cv = new CompiledComparison[]{new CompiledComparison(var, new CompiledLiteral(buffer.toString()), this.getOperator())};
        }
        return cv;
    }

    private String getRegexPattern(String pattern) {
        StringBuilder sb = new StringBuilder();
        boolean prevMetaChar = false;
        int len = pattern.length();
        block4: for (int i = 0; i < len; ++i) {
            char ch = pattern.charAt(i);
            switch (ch) {
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    if (ch == '\\') {
                        if (i + 1 >= len || pattern.charAt(i + 1) != '\\') continue block4;
                        ++i;
                    }
                    if (!prevMetaChar) {
                        sb.append('\\');
                        sb.append('Q');
                        prevMetaChar = true;
                    }
                    sb.append(ch);
                    continue block4;
                }
                case '%': 
                case '_': {
                    if (prevMetaChar) {
                        sb.append('\\');
                        sb.append('E');
                        prevMetaChar = false;
                    }
                    int numConsecutiveBackSlash = 0;
                    for (int j = i - 1; j > -1 && pattern.charAt(j) == '\\'; --j) {
                        ++numConsecutiveBackSlash;
                    }
                    if (numConsecutiveBackSlash % 2 == 0) {
                        if (ch == '%') {
                            sb.append(".*");
                            while (i + 1 < len && pattern.charAt(i + 1) == '%') {
                                ++i;
                            }
                            continue block4;
                        }
                        sb.append(".");
                        continue block4;
                    }
                    sb.append(ch);
                    continue block4;
                }
                default: {
                    if (prevMetaChar) {
                        sb.append('\\');
                        sb.append('E');
                        prevMetaChar = false;
                    }
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    int checkIfSargableAndRemoveEscapeChars(ExecutionContext context, StringBuffer buffer) {
        int len = buffer.length();
        int wildcardPosition = -1;
        for (int i = 0; i < len; ++i) {
            char ch = buffer.charAt(i);
            if (ch == '_') {
                context.cachePut(this.wildcardTypeKey, 1);
                wildcardPosition = i;
                break;
            }
            if (ch == '%') {
                context.cachePut(this.wildcardTypeKey, 0);
                wildcardPosition = i;
                break;
            }
            if (ch != '\\' || i + 1 >= len) continue;
            if (buffer.charAt(i + 1) == '%' || buffer.charAt(i + 1) == '_') {
                wildcardPosition = -1;
            }
            buffer.deleteCharAt(i);
            --len;
        }
        return wildcardPosition;
    }

    @Override
    public Object evaluate(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        Object value;
        context.cachePut(this.isIndexEvaluatedKey, false);
        Pattern pattern = (Pattern)context.cacheGet(this.bindArg);
        if (pattern == null) {
            String strPattern = this.bindArg.evaluate(context).toString();
            if (strPattern == null) {
                throw new UnsupportedOperationException("Null values are not supported with LIKE predicate.");
            }
            pattern = Pattern.compile(this.getRegexPattern(strPattern), 40);
            context.cachePut(this.bindArg, pattern);
        }
        if ((value = this.var.evaluate(context)) == null) {
            return null;
        }
        if (!(value instanceof String) && !(value instanceof PdxString) && value != QueryService.UNDEFINED) {
            if (this.getOperator() == 20) {
                return true;
            }
            return false;
        }
        boolean isMatched = pattern.matcher(value.toString()).matches();
        if (this.getOperator() == 20) {
            isMatched = !isMatched;
        }
        return isMatched;
    }

    @Override
    protected PlanInfo protGetPlanInfo(ExecutionContext context) throws TypeMismatchException, AmbiguousNameException, NameResolutionException {
        PlanInfo result = null;
        if (this.getIsIndexEvaluated(context)) {
            result = new PlanInfo();
            result.evalAsFilter = false;
        } else {
            result = super.protGetPlanInfo(context);
            if (result.indexes.size() > 0 && result.indexes.get(0) instanceof PrimaryKeyIndex) {
                result.evalAsFilter = false;
            }
        }
        return result;
    }

    @Override
    public int getType() {
        return -15;
    }

    @Override
    public boolean isLimitApplicableAtIndexLevel(ExecutionContext context) {
        return true;
    }

    @Override
    public boolean isOrderByApplicableAtIndexLevel(ExecutionContext context, String canonicalizedOrderByClause) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        if (this.getPlanInfo((ExecutionContext)context).evalAsFilter) {
            IndexProtocol ip;
            PlanInfo pi = this.getPlanInfo(context);
            if (pi.indexes.size() == 1 && (ip = (IndexProtocol)pi.indexes.get(0)).getCanonicalizedIndexedExpression().equals(canonicalizedOrderByClause)) {
                return true;
            }
        }
        return false;
    }
}

