/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.cache.EntryDestroyedException;
import org.apache.geode.cache.query.NameNotFoundException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.internal.DefaultQuery;
import org.apache.geode.cache.query.internal.MethodInvocationAuthorizer;
import org.apache.geode.cache.query.internal.Support;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.util.JavaWorkarounds;
import org.apache.geode.pdx.PdxSerializationException;
import org.apache.geode.pdx.internal.InternalPdxInstance;
import org.apache.geode.pdx.internal.PdxType;
import org.apache.geode.pdx.internal.TypeRegistry;

public class AttributeDescriptor {
    private final String _name;
    private final MethodInvocationAuthorizer _methodInvocationAuthorizer;
    private final TypeRegistry _pdxRegistry;
    @MakeNotStatic
    private static final ConcurrentMap<List, Member> _localCache = new ConcurrentHashMap<List, Member>();

    public AttributeDescriptor(TypeRegistry pdxRegistry, MethodInvocationAuthorizer methodInvocationAuthorizer, String name) {
        this._pdxRegistry = pdxRegistry;
        this._methodInvocationAuthorizer = methodInvocationAuthorizer;
        this._name = name;
    }

    public boolean validateReadType(Class targetType) {
        try {
            this.getReadMember(targetType);
            return true;
        }
        catch (NameNotFoundException e) {
            return false;
        }
    }

    public Object read(Object target) throws NameNotFoundException, QueryInvocationTargetException {
        if (target == null || target == QueryService.UNDEFINED) {
            return QueryService.UNDEFINED;
        }
        if (target instanceof InternalPdxInstance) {
            return this.readPdx((InternalPdxInstance)target);
        }
        return this.readReflection(target);
    }

    private Object readReflection(Object target) throws NameNotFoundException, QueryInvocationTargetException {
        Support.Assert(target != null);
        Support.Assert(target != QueryService.UNDEFINED);
        if (target instanceof Token) {
            return QueryService.UNDEFINED;
        }
        Class<?> resolutionClass = target.getClass();
        Member m = this.getReadMember(resolutionClass);
        try {
            if (m instanceof Method) {
                try {
                    this._methodInvocationAuthorizer.authorizeMethodInvocation((Method)m, target);
                    return ((Method)m).invoke(target, (Object[])null);
                }
                catch (EntryDestroyedException e) {
                    return QueryService.UNDEFINED;
                }
                catch (IllegalAccessException e) {
                    throw new NameNotFoundException(String.format("Method ' %s ' in class ' %s ' is not accessible to the query processor", m.getName(), target.getClass().getName()), e);
                }
                catch (InvocationTargetException e) {
                    Throwable t = e.getTargetException();
                    if (t instanceof EntryDestroyedException) {
                        return QueryService.UNDEFINED;
                    }
                    if (t instanceof Exception) {
                        throw new QueryInvocationTargetException(t);
                    }
                    throw new QueryInvocationTargetException(e);
                }
            }
            try {
                return ((Field)m).get(target);
            }
            catch (IllegalAccessException e) {
                throw new NameNotFoundException(String.format("Field ' %s ' in class ' %s ' is not accessible to the query processor", m.getName(), target.getClass().getName()), e);
            }
            catch (EntryDestroyedException e) {
                return QueryService.UNDEFINED;
            }
        }
        catch (EntryDestroyedException e) {
            return QueryService.UNDEFINED;
        }
    }

    Member getReadMember(Class targetClass) throws NameNotFoundException {
        ArrayList<Object> key = new ArrayList<Object>();
        key.add(targetClass);
        key.add(this._name);
        Member m = JavaWorkarounds.computeIfAbsent(_localCache, key, k -> {
            Field member = this.getReadField(targetClass);
            return member == null ? this.getReadMethod(targetClass) : member;
        });
        if (m == null) {
            throw new NameNotFoundException(String.format("No public attribute named ' %s ' was found in class %s", this._name, targetClass.getName()));
        }
        ((AccessibleObject)((Object)m)).setAccessible(true);
        return m;
    }

    private Field getReadField(Class targetType) {
        try {
            return targetType.getField(this._name);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    private Method getReadMethod(Class targetType) {
        String beanMethod = "get" + this._name.substring(0, 1).toUpperCase() + this._name.substring(1);
        Method m = this.getReadMethod(targetType, beanMethod);
        if (m != null) {
            return m;
        }
        return this.getReadMethod(targetType, this._name);
    }

    private Method getReadMethod(Class targetType, String methodName) {
        try {
            return targetType.getMethod(methodName, null);
        }
        catch (NoSuchMethodException e) {
            this.updateClassToMethodsMap(targetType.getCanonicalName(), this._name);
            return null;
        }
    }

    private Object readPdx(InternalPdxInstance pdxInstance) throws NameNotFoundException, QueryInvocationTargetException {
        if (pdxInstance.hasField(this._name)) {
            return pdxInstance.getRawField(this._name);
        }
        String className = pdxInstance.getClassName();
        if (className.equals("__GEMFIRE_JSON")) {
            return QueryService.UNDEFINED;
        }
        if (!this.isFieldAlreadySearchedAndNotFound(className, this._name)) {
            PdxType pdxType = this._pdxRegistry.getPdxTypeForField(this._name, className);
            if (pdxType == null) {
                this.updateClassToFieldsMap(className, this._name);
            } else {
                return pdxType.getPdxField(this._name).getFieldType().getDefaultValue();
            }
        }
        if (!this.isMethodAlreadySearchedAndNotFound(className, this._name)) {
            try {
                return this.readFieldFromDeserializedObject(pdxInstance);
            }
            catch (NameNotFoundException ex) {
                this.updateClassToMethodsMap(pdxInstance.getClassName(), this._name);
                throw ex;
            }
        }
        return QueryService.UNDEFINED;
    }

    private Object readFieldFromDeserializedObject(InternalPdxInstance pdxInstance) throws NameNotFoundException, QueryInvocationTargetException {
        Object obj = null;
        try {
            obj = pdxInstance.getCachedObject();
        }
        catch (PdxSerializationException e) {
            throw new NameNotFoundException(String.format("Field '%s' is not accessible to the query processor because: %s", this._name, e.getMessage()));
        }
        return this.readReflection(obj);
    }

    private void updateClassToFieldsMap(String className, String field) {
        Map<String, Set<String>> map = DefaultQuery.getPdxClasstofieldsmap();
        Set<String> fields = map.get(className);
        if (fields == null) {
            fields = new HashSet<String>();
            map.put(className, fields);
        }
        fields.add(field);
    }

    private boolean isFieldAlreadySearchedAndNotFound(String className, String field) {
        Set<String> fields = DefaultQuery.getPdxClasstofieldsmap().get(className);
        if (fields != null) {
            return fields.contains(field);
        }
        return false;
    }

    private void updateClassToMethodsMap(String className, String field) {
        Map<String, Set<String>> map = DefaultQuery.getPdxClasstoMethodsmap();
        Set<String> fields = map.get(className);
        if (fields == null) {
            fields = new HashSet<String>();
            map.put(className, fields);
        }
        fields.add(field);
    }

    private boolean isMethodAlreadySearchedAndNotFound(String className, String field) {
        Set<String> fields = DefaultQuery.getPdxClasstoMethodsmap().get(className);
        if (fields != null) {
            return fields.contains(field);
        }
        return false;
    }
}

