/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal.pooling;

import java.net.SocketException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SplittableRandom;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.geode.CancelCriterion;
import org.apache.geode.CancelException;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.GatewayConfigurationException;
import org.apache.geode.cache.client.AllConnectionsInUseException;
import org.apache.geode.cache.client.NoAvailableServersException;
import org.apache.geode.cache.client.ServerConnectivityException;
import org.apache.geode.cache.client.ServerOperationException;
import org.apache.geode.cache.client.ServerRefusedConnectionException;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.cache.client.internal.ConnectionFactory;
import org.apache.geode.cache.client.internal.Endpoint;
import org.apache.geode.cache.client.internal.EndpointManager;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.client.internal.QueueConnectionImpl;
import org.apache.geode.cache.client.internal.pooling.ConnectionDestroyedException;
import org.apache.geode.cache.client.internal.pooling.ConnectionManager;
import org.apache.geode.cache.client.internal.pooling.PooledConnection;
import org.apache.geode.distributed.PoolCancelledException;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.i18n.StringId;
import org.apache.geode.internal.cache.PoolManagerImpl;
import org.apache.geode.internal.cache.PoolStats;
import org.apache.geode.internal.logging.InternalLogWriter;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.LoggingExecutors;
import org.apache.geode.security.GemFireSecurityException;
import org.apache.logging.log4j.Logger;

public class ConnectionManagerImpl
implements ConnectionManager {
    private static final Logger logger = LogService.getLogger();
    private final String poolName;
    private final PoolStats poolStats;
    protected final long prefillRetry;
    private final ArrayDeque<PooledConnection> availableConnections = new ArrayDeque();
    protected final ConnectionMap allConnectionsMap = new ConnectionMap();
    private final EndpointManager endpointManager;
    private final int maxConnections;
    protected final int minConnections;
    private final long idleTimeout;
    protected final long idleTimeoutNanos;
    final int lifetimeTimeout;
    final long lifetimeTimeoutNanos;
    private final InternalLogWriter securityLogWriter;
    protected final CancelCriterion cancelCriterion;
    protected volatile int connectionCount;
    protected ScheduledExecutorService backgroundProcessor;
    protected ScheduledExecutorService loadConditioningProcessor;
    protected ReentrantLock lock = new ReentrantLock();
    protected Condition freeConnection = this.lock.newCondition();
    private ConnectionFactory connectionFactory;
    protected boolean haveIdleExpireConnectionsTask;
    protected boolean havePrefillTask;
    private boolean keepAlive = false;
    protected volatile boolean shuttingDown;
    private EndpointManager.EndpointListenerAdapter endpointListener;
    private static final long NANOS_PER_MS = 1000000L;

    static int addVarianceToInterval(int interval) {
        if (1 <= interval) {
            SplittableRandom random = new SplittableRandom();
            int variance = interval < 10 ? 1 : 1 + random.nextInt(interval / 10 - 1);
            int sign = random.nextBoolean() ? 1 : -1;
            return interval + sign * variance;
        }
        return interval;
    }

    public ConnectionManagerImpl(String poolName, ConnectionFactory factory, EndpointManager endpointManager, int maxConnections, int minConnections, long idleTimeout, int lifetimeTimeout, InternalLogWriter securityLogger, long pingInterval, CancelCriterion cancelCriterion, PoolStats poolStats) {
        this.poolName = poolName;
        this.poolStats = poolStats;
        if (maxConnections < minConnections && maxConnections != -1) {
            throw new IllegalArgumentException("Max connections " + maxConnections + " is less than minConnections " + minConnections);
        }
        if (maxConnections <= 0 && maxConnections != -1) {
            throw new IllegalArgumentException("Max connections " + maxConnections + " must be greater than 0");
        }
        if (minConnections < 0) {
            throw new IllegalArgumentException("Min connections " + minConnections + " must be greater than or equals to 0");
        }
        this.connectionFactory = factory;
        this.endpointManager = endpointManager;
        this.maxConnections = maxConnections == -1 ? Integer.MAX_VALUE : maxConnections;
        this.minConnections = minConnections;
        this.lifetimeTimeout = ConnectionManagerImpl.addVarianceToInterval(lifetimeTimeout);
        this.lifetimeTimeoutNanos = (long)this.lifetimeTimeout * 1000000L;
        if (this.lifetimeTimeout != -1 && (idleTimeout > (long)this.lifetimeTimeout || idleTimeout == -1L)) {
            idleTimeout = this.lifetimeTimeout;
        }
        this.idleTimeout = idleTimeout;
        this.idleTimeoutNanos = this.idleTimeout * 1000000L;
        this.securityLogWriter = securityLogger;
        this.prefillRetry = pingInterval;
        this.cancelCriterion = cancelCriterion;
        this.endpointListener = new EndpointManager.EndpointListenerAdapter(){

            @Override
            public void endpointCrashed(Endpoint endpoint) {
                ConnectionManagerImpl.this.invalidateServer(endpoint);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection borrowConnection(long acquireTimeout) throws AllConnectionsInUseException, NoAvailableServersException {
        long startTime = System.currentTimeMillis();
        long remainingTime = acquireTimeout;
        this.lock.lock();
        try {
            while (this.connectionCount >= this.maxConnections && this.availableConnections.isEmpty() && remainingTime > 0L && !this.shuttingDown) {
                long start = this.getPoolStats().beginConnectionWait();
                boolean interrupted = false;
                try {
                    this.freeConnection.await(remainingTime, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    this.cancelCriterion.checkCancelInProgress(e);
                    throw new AllConnectionsInUseException();
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                    this.getPoolStats().endConnectionWait(start);
                }
                remainingTime = acquireTimeout - (System.currentTimeMillis() - startTime);
            }
            if (this.shuttingDown) {
                throw new PoolCancelledException();
            }
            while (!this.availableConnections.isEmpty()) {
                PooledConnection connection = this.availableConnections.removeFirst();
                try {
                    connection.activate();
                    PooledConnection pooledConnection = connection;
                    return pooledConnection;
                }
                catch (ConnectionDestroyedException connectionDestroyedException) {
                }
            }
            if (this.connectionCount >= this.maxConnections) {
                throw new AllConnectionsInUseException();
            }
            ++this.connectionCount;
        }
        finally {
            this.lock.unlock();
        }
        PooledConnection connection = null;
        try {
            Connection plainConnection = this.connectionFactory.createClientToServerConnection(Collections.EMPTY_SET);
            connection = this.addConnection(plainConnection);
        }
        catch (GemFireSecurityException e) {
            throw new ServerOperationException(e);
        }
        catch (GatewayConfigurationException e) {
            throw new ServerOperationException(e);
        }
        catch (ServerRefusedConnectionException srce) {
            throw new NoAvailableServersException(srce);
        }
        finally {
            if (connection == null) {
                this.lock.lock();
                try {
                    --this.connectionCount;
                    if (this.connectionCount < this.minConnections) {
                        this.startBackgroundPrefill();
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
        if (connection == null) {
            this.cancelCriterion.checkCancelInProgress(null);
            throw new NoAvailableServersException();
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection borrowConnection(ServerLocation server, long acquireTimeout, boolean onlyUseExistingCnx) throws AllConnectionsInUseException, NoAvailableServersException {
        this.lock.lock();
        try {
            if (this.shuttingDown) {
                throw new PoolCancelledException();
            }
            Iterator<PooledConnection> itr = this.availableConnections.iterator();
            while (itr.hasNext()) {
                PooledConnection nextConnection;
                block23: {
                    nextConnection = itr.next();
                    nextConnection.activate();
                    if (!nextConnection.getServer().equals(server)) break block23;
                    itr.remove();
                    PooledConnection pooledConnection = nextConnection;
                    return pooledConnection;
                }
                try {
                    nextConnection.passivate(false);
                }
                catch (ConnectionDestroyedException connectionDestroyedException) {
                    // empty catch block
                }
                if (!nextConnection.shouldDestroy()) continue;
                itr.remove();
            }
            if (onlyUseExistingCnx) {
                throw new AllConnectionsInUseException();
            }
            ++this.connectionCount;
        }
        finally {
            this.lock.unlock();
        }
        PooledConnection connection = null;
        try {
            Connection plainConnection = this.connectionFactory.createClientToServerConnection(server, false);
            connection = this.addConnection(plainConnection);
        }
        catch (GemFireSecurityException e) {
            throw new ServerOperationException(e);
        }
        finally {
            if (connection == null) {
                this.lock.lock();
                try {
                    --this.connectionCount;
                    if (this.connectionCount < this.minConnections) {
                        this.startBackgroundPrefill();
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
        if (connection == null) {
            throw new ServerConnectivityException("Could not create a new connection to server " + server);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection exchangeConnection(Connection oldConnection, Set excludedServers, long acquireTimeout) throws AllConnectionsInUseException {
        assert (oldConnection instanceof PooledConnection);
        PooledConnection newConnection = null;
        PooledConnection oldPC = (PooledConnection)oldConnection;
        boolean needToUndoEstimate = false;
        this.lock.lock();
        try {
            if (this.shuttingDown) {
                throw new PoolCancelledException();
            }
            Iterator<PooledConnection> itr = this.availableConnections.iterator();
            while (itr.hasNext()) {
                PooledConnection nextConnection = itr.next();
                if (excludedServers.contains(nextConnection.getServer())) continue;
                itr.remove();
                try {
                    nextConnection.activate();
                    newConnection = nextConnection;
                    if (!this.allConnectionsMap.removeConnection(oldPC)) break;
                    --this.connectionCount;
                    if (this.connectionCount >= this.minConnections) break;
                    this.startBackgroundPrefill();
                    break;
                }
                catch (ConnectionDestroyedException connectionDestroyedException) {
                }
            }
            if (newConnection == null && !this.allConnectionsMap.removeConnection(oldPC)) {
                needToUndoEstimate = true;
                ++this.connectionCount;
            }
        }
        finally {
            this.lock.unlock();
        }
        if (newConnection == null) {
            try {
                Connection plainConnection = this.connectionFactory.createClientToServerConnection(excludedServers);
                newConnection = this.addConnection(plainConnection);
            }
            catch (GemFireSecurityException e) {
                throw new ServerOperationException(e);
            }
            catch (ServerRefusedConnectionException srce) {
                throw new NoAvailableServersException(srce);
            }
            finally {
                if (needToUndoEstimate && newConnection == null) {
                    this.lock.lock();
                    try {
                        --this.connectionCount;
                        if (this.connectionCount < this.minConnections) {
                            this.startBackgroundPrefill();
                        }
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
            }
        }
        if (newConnection == null) {
            throw new NoAvailableServersException();
        }
        oldPC.internalDestroy();
        return newConnection;
    }

    protected String getPoolName() {
        return this.poolName;
    }

    private PooledConnection addConnection(Connection conn) {
        if (conn == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Unable to create a connection in the allowed time");
            }
            return null;
        }
        PooledConnection pooledConn = new PooledConnection(this, conn);
        this.allConnectionsMap.addConnection(pooledConn);
        if (logger.isDebugEnabled()) {
            logger.debug("Created a new connection. {} Connection count is now {}", (Object)pooledConn, (Object)this.connectionCount);
        }
        return pooledConn;
    }

    private void destroyConnection(PooledConnection connection) {
        this.lock.lock();
        try {
            if (this.allConnectionsMap.removeConnection(connection)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Invalidating connection {} connection count is now {}", (Object)connection, (Object)this.connectionCount);
                }
                if (this.connectionCount < this.minConnections) {
                    this.startBackgroundPrefill();
                }
                this.freeConnection.signalAll();
            }
            --this.connectionCount;
        }
        finally {
            this.lock.unlock();
        }
        connection.internalDestroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidateServer(Endpoint endpoint) {
        Set badConnections = this.allConnectionsMap.removeEndpoint(endpoint);
        if (badConnections == null) {
            return;
        }
        this.lock.lock();
        try {
            if (this.shuttingDown) {
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Invalidating {} connections to server {}", (Object)badConnections.size(), (Object)endpoint);
            }
            for (PooledConnection conn : badConnections) {
                if (conn.setShouldDestroy()) continue;
            }
            this.availableConnections.removeIf(badConnections::contains);
            this.connectionCount -= badConnections.size();
            if (this.connectionCount < this.minConnections) {
                this.startBackgroundPrefill();
            }
            for (PooledConnection conn : badConnections) {
                conn.internalDestroy();
            }
            if (this.connectionCount < this.maxConnections) {
                this.freeConnection.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void returnConnection(Connection connection) {
        this.returnConnection(connection, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnConnection(Connection connection, boolean accessed) {
        assert (connection instanceof PooledConnection);
        PooledConnection pooledConn = (PooledConnection)connection;
        boolean shouldClose = false;
        this.lock.lock();
        try {
            if (pooledConn.isDestroyed()) {
                return;
            }
            if (pooledConn.shouldDestroy()) {
                this.destroyConnection(pooledConn);
            } else {
                if (pooledConn.isActive()) {
                    pooledConn.passivate(accessed);
                }
                if (this.connectionCount > this.maxConnections) {
                    if (this.allConnectionsMap.removeConnection(pooledConn)) {
                        shouldClose = true;
                        --this.connectionCount;
                    }
                } else {
                    this.availableConnections.addFirst(pooledConn);
                    this.freeConnection.signalAll();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        if (shouldClose) {
            try {
                PoolImpl localpool = (PoolImpl)PoolManagerImpl.getPMI().find(this.poolName);
                boolean durable = false;
                if (localpool != null) {
                    durable = localpool.isDurableClient();
                }
                pooledConn.internalClose(durable || this.keepAlive);
            }
            catch (Exception e) {
                logger.warn(String.format("Error closing connection %s", pooledConn), (Throwable)e);
            }
        }
    }

    @Override
    public void start(ScheduledExecutorService backgroundProcessor) {
        this.backgroundProcessor = backgroundProcessor;
        String name = "poolLoadConditioningMonitor-" + this.getPoolName();
        this.loadConditioningProcessor = LoggingExecutors.newScheduledThreadPool(name, 1, false);
        this.endpointManager.addListener(this.endpointListener);
        this.lock.lock();
        try {
            this.startBackgroundPrefill();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close(boolean keepAlive) {
        if (logger.isDebugEnabled()) {
            logger.debug("Shutting down connection manager with keepAlive {}", (Object)keepAlive);
        }
        this.keepAlive = keepAlive;
        this.endpointManager.removeListener(this.endpointListener);
        this.lock.lock();
        try {
            if (this.shuttingDown) {
                return;
            }
            this.shuttingDown = true;
        }
        finally {
            this.lock.unlock();
        }
        try {
            if (this.loadConditioningProcessor != null) {
                this.loadConditioningProcessor.shutdown();
                if (!this.loadConditioningProcessor.awaitTermination(PoolImpl.SHUTDOWN_TIMEOUT, TimeUnit.MILLISECONDS)) {
                    logger.warn("Timeout waiting for load conditioning tasks to complete");
                }
            }
        }
        catch (RuntimeException e) {
            logger.error("Error stopping loadConditioningProcessor", (Throwable)e);
        }
        catch (InterruptedException e) {
            logger.error("Interrupted stopping loadConditioningProcessor", (Throwable)e);
        }
        this.allConnectionsMap.close(keepAlive);
    }

    @Override
    public void emergencyClose() {
        this.shuttingDown = true;
        if (this.loadConditioningProcessor != null) {
            this.loadConditioningProcessor.shutdown();
        }
        this.allConnectionsMap.emergencyClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startBackgroundExpiration() {
        if (this.idleTimeout >= 0L) {
            ConnectionMap connectionMap = this.allConnectionsMap;
            synchronized (connectionMap) {
                if (!this.haveIdleExpireConnectionsTask) {
                    this.haveIdleExpireConnectionsTask = true;
                    try {
                        this.backgroundProcessor.schedule(new IdleExpireConnectionsTask(), this.idleTimeout, TimeUnit.MILLISECONDS);
                    }
                    catch (RejectedExecutionException rejectedExecutionException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    protected void startBackgroundPrefill() {
        if (!this.havePrefillTask) {
            this.havePrefillTask = true;
            try {
                this.backgroundProcessor.execute(new PrefillConnectionsTask());
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    protected boolean prefill() {
        try {
            while (this.connectionCount < this.minConnections) {
                if (this.cancelCriterion.isCancelInProgress()) {
                    return true;
                }
                boolean createdConnection = this.prefillConnection();
                if (createdConnection) continue;
                return false;
            }
        }
        catch (Throwable t) {
            this.cancelCriterion.checkCancelInProgress(t);
            if (t.getCause() != null) {
                t = t.getCause();
            }
            this.logInfo("Error prefilling connections", t);
            return false;
        }
        return true;
    }

    @Override
    public int getConnectionCount() {
        return this.connectionCount;
    }

    protected PoolStats getPoolStats() {
        return this.poolStats;
    }

    @Override
    public Connection getConnection(Connection conn) {
        if (conn instanceof PooledConnection) {
            return ((PooledConnection)conn).getConnection();
        }
        if (conn instanceof QueueConnectionImpl) {
            return ((QueueConnectionImpl)conn).getConnection();
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean prefillConnection() {
        boolean createConnection = false;
        this.lock.lock();
        try {
            if (this.shuttingDown) {
                boolean bl = false;
                return bl;
            }
            if (this.connectionCount < this.minConnections) {
                ++this.connectionCount;
                createConnection = true;
            }
        }
        finally {
            this.lock.unlock();
        }
        if (createConnection) {
            PooledConnection connection = null;
            try {
                Connection plainConnection = this.connectionFactory.createClientToServerConnection(Collections.EMPTY_SET);
                if (plainConnection == null) {
                    boolean bl = false;
                    return bl;
                }
                connection = this.addConnection(plainConnection);
                connection.passivate(false);
                this.getPoolStats().incPrefillConnect();
            }
            catch (ServerConnectivityException ex) {
                logger.info(String.format("Unable to prefill pool to minimum because: %s", ex.getMessage()));
                boolean bl = false;
                return bl;
            }
            finally {
                this.lock.lock();
                try {
                    if (connection == null) {
                        --this.connectionCount;
                        if (logger.isDebugEnabled()) {
                            logger.debug("Unable to prefill pool to minimum, connection count is now {}", (Object)this.connectionCount);
                        }
                    } else {
                        this.availableConnections.addFirst(connection);
                        this.freeConnection.signalAll();
                        if (logger.isDebugEnabled()) {
                            logger.debug("Prefilled connection {} connection count is now {}", (Object)connection, (Object)this.connectionCount);
                        }
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
        return true;
    }

    public static void loadEmergencyClasses() {
        PooledConnection.loadEmergencyClasses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean offerReplacementConnection(Connection con, ServerLocation currentServer) {
        boolean retry;
        do {
            retry = false;
            PooledConnection target = this.allConnectionsMap.findReplacementTarget(currentServer);
            if (target == null) continue;
            Endpoint targetEP = target.getEndpoint();
            boolean interrupted = false;
            try {
                if (target.switchConnection(con)) {
                    this.getPoolStats().incLoadConditioningDisconnect();
                    this.allConnectionsMap.addReplacedCnx(target, targetEP);
                    boolean bl = true;
                    return bl;
                }
                retry = true;
            }
            catch (InterruptedException e) {
                interrupted = true;
                this.cancelCriterion.checkCancelInProgress(e);
                retry = false;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        } while (retry);
        this.getPoolStats().incLoadConditioningReplaceTimeouts();
        con.destroy();
        return false;
    }

    public boolean createLifetimeReplacementConnection(ServerLocation currentServer, boolean idlePossible) {
        HashSet<ServerLocation> excludedServers = new HashSet<ServerLocation>();
        ServerLocation sl = this.connectionFactory.findBestServer(currentServer, excludedServers);
        while (sl != null) {
            if (sl.equals(currentServer)) {
                this.allConnectionsMap.extendLifeOfCnxToServer(currentServer);
                break;
            }
            if (!this.allConnectionsMap.hasExpiredCnxToServer(currentServer)) break;
            Connection con = null;
            try {
                con = this.connectionFactory.createClientToServerConnection(sl, false);
            }
            catch (GemFireSecurityException e) {
                this.securityLogWriter.warning(String.format("Security exception connecting to server '%s': %s", sl, e));
            }
            catch (ServerRefusedConnectionException srce) {
                logger.warn("Server '{}' refused new connection: {}", new Object[]{sl, srce});
            }
            if (con == null) {
                excludedServers.add(sl);
                sl = this.connectionFactory.findBestServer(currentServer, excludedServers);
                continue;
            }
            this.getPoolStats().incLoadConditioningConnect();
            if (!this.allConnectionsMap.hasExpiredCnxToServer(currentServer)) {
                this.getPoolStats().incLoadConditioningReplaceTimeouts();
                con.destroy();
                break;
            }
            this.offerReplacementConnection(con, currentServer);
            break;
        }
        if (sl == null) {
            this.allConnectionsMap.extendLifeOfCnxToServer(currentServer);
        }
        return this.allConnectionsMap.checkForReschedule(true);
    }

    private void logInfo(String message, Throwable t) {
        if (t instanceof GemFireSecurityException) {
            this.securityLogWriter.info(String.format("%s : %s", message, t), t);
        } else {
            logger.info(String.format("%s : %s", message, t), t);
        }
    }

    private void logError(StringId message, Throwable t) {
        if (t instanceof GemFireSecurityException) {
            this.securityLogWriter.error(message, t);
        } else {
            logger.error((Object)message, t);
        }
    }

    @Override
    public void activate(Connection conn) {
        assert (conn instanceof PooledConnection);
        ((PooledConnection)conn).activate();
    }

    @Override
    public void passivate(Connection conn, boolean accessed) {
        assert (conn instanceof PooledConnection);
        ((PooledConnection)conn).passivate(accessed);
    }

    private static class ClosedPoolConnectionList
    extends ArrayList {
        private ClosedPoolConnectionList() {
        }

        @Override
        public Object set(int index, Object element) {
            throw new CacheClosedException("This pool has been closed");
        }

        @Override
        public boolean add(Object element) {
            throw new CacheClosedException("This pool has been closed");
        }

        @Override
        public void add(int index, Object element) {
            throw new CacheClosedException("This pool has been closed");
        }

        @Override
        public Object remove(int index) {
            throw new CacheClosedException("This pool has been closed");
        }

        @Override
        public boolean addAll(Collection c) {
            throw new CacheClosedException("This pool has been closed");
        }

        @Override
        public boolean addAll(int index, Collection c) {
            throw new CacheClosedException("This pool has been closed");
        }
    }

    protected class ConnectionMap {
        private final HashMap map = new HashMap();
        private List allConnections = new LinkedList();
        private boolean haveLifetimeExpireConnectionsTask;
        volatile boolean closing;

        protected ConnectionMap() {
        }

        public synchronized boolean isIdleExpirePossible() {
            return this.allConnections.size() > ConnectionManagerImpl.this.minConnections;
        }

        public synchronized String toString() {
            long now = System.nanoTime();
            StringBuffer sb = new StringBuffer();
            sb.append("<");
            Iterator it = this.allConnections.iterator();
            while (it.hasNext()) {
                PooledConnection pc = (PooledConnection)it.next();
                sb.append(pc.getServer());
                if (pc.shouldDestroy()) {
                    sb.append("-DESTROYED");
                } else if (pc.hasIdleExpired(now, ConnectionManagerImpl.this.idleTimeoutNanos)) {
                    sb.append("-IDLE");
                } else if (pc.remainingLife(now, ConnectionManagerImpl.this.lifetimeTimeoutNanos) <= 0L) {
                    sb.append("-EOL");
                }
                if (!it.hasNext()) continue;
                sb.append(",");
            }
            sb.append(">");
            return sb.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void addConnection(PooledConnection connection) {
            if (this.closing) {
                throw new CacheClosedException("This pool is closing");
            }
            ConnectionMap connectionMap = this;
            synchronized (connectionMap) {
                ConnectionManagerImpl.this.getPoolStats().incPoolConnections(1);
                this.allConnections.add(connection);
                this.addToEndpointMap(connection);
                if (this.isIdleExpirePossible()) {
                    ConnectionManagerImpl.this.startBackgroundExpiration();
                }
                if (ConnectionManagerImpl.this.lifetimeTimeout != -1 && !this.haveLifetimeExpireConnectionsTask && this.checkForReschedule(true)) {
                    this.startBackgroundLifetimeExpiration(0L);
                }
            }
        }

        public synchronized void addReplacedCnx(PooledConnection con, Endpoint oldEndpoint) {
            if (this.closing) {
                throw new CacheClosedException("This pool is closing");
            }
            if (this.allConnections.remove(con)) {
                this.removeFromEndpointMap(oldEndpoint, con);
                this.addToEndpointMap(con);
                this.allConnections.add(con);
                if (this.isIdleExpirePossible()) {
                    ConnectionManagerImpl.this.startBackgroundExpiration();
                }
            }
        }

        public synchronized Set removeEndpoint(Endpoint endpoint) {
            Set endpointConnections = (Set)this.map.remove(endpoint);
            if (endpointConnections != null) {
                int count = 0;
                Iterator it = this.allConnections.iterator();
                while (it.hasNext()) {
                    if (!endpointConnections.contains(it.next())) continue;
                    ++count;
                    it.remove();
                }
                if (count != 0) {
                    ConnectionManagerImpl.this.getPoolStats().incPoolConnections(-count);
                }
            }
            return endpointConnections;
        }

        public synchronized boolean containsConnection(PooledConnection connection) {
            return this.allConnections.contains(connection);
        }

        public synchronized boolean removeConnection(PooledConnection connection) {
            boolean result = this.allConnections.remove(connection);
            if (result) {
                ConnectionManagerImpl.this.getPoolStats().incPoolConnections(-1);
            }
            this.removeFromEndpointMap(connection);
            return result;
        }

        private synchronized void addToEndpointMap(PooledConnection connection) {
            HashSet<PooledConnection> endpointConnections = (HashSet<PooledConnection>)this.map.get(connection.getEndpoint());
            if (endpointConnections == null) {
                endpointConnections = new HashSet<PooledConnection>();
                this.map.put(connection.getEndpoint(), endpointConnections);
            }
            endpointConnections.add(connection);
        }

        private void removeFromEndpointMap(PooledConnection connection) {
            this.removeFromEndpointMap(connection.getEndpoint(), connection);
        }

        private synchronized void removeFromEndpointMap(Endpoint endpoint, PooledConnection connection) {
            Set endpointConnections = (Set)this.map.get(endpoint);
            if (endpointConnections != null) {
                endpointConnections.remove(connection);
                if (endpointConnections.size() == 0) {
                    this.map.remove(endpoint);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close(boolean keepAlive) {
            List connections;
            int count = 0;
            ConnectionMap connectionMap = this;
            synchronized (connectionMap) {
                if (this.closing) {
                    return;
                }
                this.closing = true;
                this.map.clear();
                connections = this.allConnections;
                this.allConnections = new ClosedPoolConnectionList();
            }
            for (PooledConnection pc : connections) {
                ++count;
                if (pc.isDestroyed()) continue;
                try {
                    pc.internalClose(keepAlive);
                }
                catch (SocketException se) {
                    logger.info("Error closing connection to server " + pc.getServer(), (Throwable)se);
                }
                catch (Exception e) {
                    logger.warn("Error closing connection to server " + pc.getServer(), (Throwable)e);
                }
            }
            if (count != 0) {
                ConnectionManagerImpl.this.getPoolStats().incPoolConnections(-count);
            }
        }

        public synchronized void emergencyClose() {
            this.closing = true;
            this.map.clear();
            while (!this.allConnections.isEmpty()) {
                PooledConnection pc = (PooledConnection)this.allConnections.remove(0);
                pc.emergencyClose();
            }
        }

        public synchronized PooledConnection findReplacementTarget(ServerLocation currentServer) {
            long now = System.nanoTime();
            for (PooledConnection pc : this.allConnections) {
                if (!currentServer.equals(pc.getServer()) || pc.shouldDestroy() || pc.remainingLife(now, ConnectionManagerImpl.this.lifetimeTimeoutNanos) > 0L) continue;
                this.removeFromEndpointMap(pc);
                return pc;
            }
            return null;
        }

        public synchronized boolean hasExpiredCnxToServer(ServerLocation currentServer) {
            if (!this.allConnections.isEmpty()) {
                long now = System.nanoTime();
                for (PooledConnection pc : this.allConnections) {
                    long life;
                    if (pc.shouldDestroy() || !currentServer.equals(pc.getServer()) || (life = pc.remainingLife(now, ConnectionManagerImpl.this.lifetimeTimeoutNanos)) > 0L) continue;
                    return true;
                }
            }
            return false;
        }

        public synchronized boolean checkForReschedule(boolean rescheduleOk) {
            if (!this.allConnections.isEmpty()) {
                long now = System.nanoTime();
                for (PooledConnection pc : this.allConnections) {
                    if (pc.hasIdleExpired(now, ConnectionManagerImpl.this.idleTimeoutNanos) || pc.shouldDestroy()) continue;
                    long life = pc.remainingLife(now, ConnectionManagerImpl.this.lifetimeTimeoutNanos);
                    if (life > 0L) {
                        if (rescheduleOk) {
                            this.startBackgroundLifetimeExpiration(life);
                            return false;
                        }
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }

        public synchronized void extendLifeOfCnxToServer(ServerLocation sl) {
            if (!this.allConnections.isEmpty()) {
                PooledConnection pc;
                long now = System.nanoTime();
                Iterator it = this.allConnections.iterator();
                while (it.hasNext() && (pc = (PooledConnection)it.next()).remainingLife(now, ConnectionManagerImpl.this.lifetimeTimeoutNanos) <= 0L) {
                    if (pc.shouldDestroy() || !sl.equals(pc.getEndpoint().getLocation())) continue;
                    it.remove();
                    pc.setBirthDate(now);
                    ConnectionManagerImpl.this.getPoolStats().incLoadConditioningExtensions();
                    this.allConnections.add(pc);
                    break;
                }
            }
        }

        public synchronized void startBackgroundLifetimeExpiration(long delay) {
            if (!this.haveLifetimeExpireConnectionsTask) {
                this.haveLifetimeExpireConnectionsTask = true;
                try {
                    LifetimeExpireConnectionsTask task = new LifetimeExpireConnectionsTask();
                    ConnectionManagerImpl.this.loadConditioningProcessor.schedule(task, delay, TimeUnit.NANOSECONDS);
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void checkIdleExpiration() {
            int expireCount = 0;
            ArrayList<PooledConnection> toClose = null;
            ConnectionMap connectionMap = this;
            synchronized (connectionMap) {
                int conCount;
                ConnectionManagerImpl.this.haveIdleExpireConnectionsTask = false;
                if (ConnectionManagerImpl.this.shuttingDown) {
                    return;
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("Looking for connections to expire");
                }
                if ((conCount = this.allConnections.size()) <= ConnectionManagerImpl.this.minConnections) {
                    return;
                }
                long now = System.nanoTime();
                long minRemainingIdle = Long.MAX_VALUE;
                toClose = new ArrayList<PooledConnection>(conCount - ConnectionManagerImpl.this.minConnections);
                Iterator it = this.allConnections.iterator();
                while (it.hasNext() && conCount > ConnectionManagerImpl.this.minConnections) {
                    PooledConnection pc = (PooledConnection)it.next();
                    if (pc.shouldDestroy()) {
                        --conCount;
                        continue;
                    }
                    long remainingIdle = pc.doIdleTimeout(now, ConnectionManagerImpl.this.idleTimeoutNanos);
                    if (remainingIdle >= 0L) {
                        if (remainingIdle == 0L) {
                            --conCount;
                            continue;
                        }
                        if (remainingIdle >= minRemainingIdle) continue;
                        minRemainingIdle = remainingIdle;
                        continue;
                    }
                    ++expireCount;
                    --conCount;
                    this.removeFromEndpointMap(pc);
                    toClose.add(pc);
                    it.remove();
                }
                if (conCount > ConnectionManagerImpl.this.minConnections && minRemainingIdle < Long.MAX_VALUE) {
                    try {
                        ConnectionManagerImpl.this.backgroundProcessor.schedule(new IdleExpireConnectionsTask(), minRemainingIdle, TimeUnit.NANOSECONDS);
                    }
                    catch (RejectedExecutionException rejectedExecutionException) {
                        // empty catch block
                    }
                    ConnectionManagerImpl.this.haveIdleExpireConnectionsTask = true;
                }
            }
            if (expireCount > 0) {
                ConnectionManagerImpl.this.getPoolStats().incIdleExpire(expireCount);
                ConnectionManagerImpl.this.getPoolStats().incPoolConnections(-expireCount);
                ConnectionManagerImpl.this.lock.lock();
                try {
                    ConnectionManagerImpl.this.connectionCount -= expireCount;
                    ConnectionManagerImpl.this.freeConnection.signalAll();
                    if (ConnectionManagerImpl.this.connectionCount < ConnectionManagerImpl.this.minConnections) {
                        ConnectionManagerImpl.this.startBackgroundPrefill();
                    }
                }
                finally {
                    ConnectionManagerImpl.this.lock.unlock();
                }
            }
            boolean isDebugEnabled = logger.isDebugEnabled();
            for (PooledConnection connection : toClose) {
                if (isDebugEnabled) {
                    logger.debug("Idle connection detected. Expiring connection {}", (Object)connection);
                }
                try {
                    connection.internalClose(false);
                }
                catch (Exception e) {
                    logger.warn("Error expiring connection {}", (Object)connection);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void checkLifetimes() {
            boolean done;
            ConnectionMap connectionMap = this;
            synchronized (connectionMap) {
                this.haveLifetimeExpireConnectionsTask = false;
                if (ConnectionManagerImpl.this.shuttingDown) {
                    return;
                }
            }
            do {
                ConnectionManagerImpl.this.getPoolStats().incLoadConditioningCheck();
                long firstLife = -1L;
                done = true;
                ServerLocation candidate = null;
                boolean idlePossible = true;
                ConnectionMap connectionMap2 = this;
                synchronized (connectionMap2) {
                    if (ConnectionManagerImpl.this.shuttingDown) {
                        return;
                    }
                    long now = System.nanoTime();
                    long life = 0L;
                    idlePossible = this.isIdleExpirePossible();
                    Iterator it = this.allConnections.iterator();
                    while (it.hasNext() && life <= 0L && candidate == null) {
                        PooledConnection pc = (PooledConnection)it.next();
                        life = pc.remainingLife(now, ConnectionManagerImpl.this.lifetimeTimeoutNanos);
                        if (life <= 0L) {
                            boolean idleTimedOut = idlePossible ? pc.hasIdleExpired(now, ConnectionManagerImpl.this.idleTimeoutNanos) : false;
                            boolean destroyed = pc.shouldDestroy();
                            if (idleTimedOut || destroyed) continue;
                            candidate = pc.getServer();
                            continue;
                        }
                        if (firstLife != -1L) continue;
                        firstLife = life;
                    }
                }
                if (candidate != null) {
                    done = !ConnectionManagerImpl.this.createLifetimeReplacementConnection(candidate, idlePossible);
                    continue;
                }
                if (firstLife >= 0L) {
                    this.startBackgroundLifetimeExpiration(firstLife);
                }
                done = true;
            } while (!done);
            this.startBackgroundLifetimeExpiration(ConnectionManagerImpl.this.lifetimeTimeoutNanos);
        }
    }

    protected class PrefillConnectionsTask
    extends PoolImpl.PoolTask {
        protected PrefillConnectionsTask() {
        }

        @Override
        public void run2() {
            if (logger.isTraceEnabled()) {
                logger.trace("Prefill Connections task running");
            }
            ConnectionManagerImpl.this.prefill();
            ConnectionManagerImpl.this.lock.lock();
            try {
                if (ConnectionManagerImpl.this.connectionCount < ConnectionManagerImpl.this.minConnections && !ConnectionManagerImpl.this.cancelCriterion.isCancelInProgress()) {
                    try {
                        ConnectionManagerImpl.this.backgroundProcessor.schedule(new PrefillConnectionsTask(), ConnectionManagerImpl.this.prefillRetry, TimeUnit.MILLISECONDS);
                    }
                    catch (RejectedExecutionException rejectedExecutionException) {}
                } else {
                    ConnectionManagerImpl.this.havePrefillTask = false;
                }
            }
            finally {
                ConnectionManagerImpl.this.lock.unlock();
            }
        }
    }

    protected class IdleExpireConnectionsTask
    implements Runnable {
        protected IdleExpireConnectionsTask() {
        }

        @Override
        public void run() {
            try {
                ConnectionManagerImpl.this.getPoolStats().incIdleCheck();
                ConnectionManagerImpl.this.allConnectionsMap.checkIdleExpiration();
            }
            catch (CancelException cancelException) {
            }
            catch (VirtualMachineError e) {
                SystemFailure.initiateFailure(e);
                throw e;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                logger.warn(String.format("IdleExpireConnectionsTask <%s> encountered exception", this), t);
            }
        }
    }

    protected class LifetimeExpireConnectionsTask
    implements Runnable {
        protected LifetimeExpireConnectionsTask() {
        }

        @Override
        public void run() {
            try {
                ConnectionManagerImpl.this.allConnectionsMap.checkLifetimes();
            }
            catch (CancelException cancelException) {
            }
            catch (VirtualMachineError e) {
                SystemFailure.initiateFailure(e);
                throw e;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                logger.warn(String.format("LoadConditioningTask <%s> encountered exception", this), t);
            }
        }
    }
}

