/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal.locator;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.client.internal.locator.ServerLocationResponse;
import org.apache.geode.distributed.internal.ServerLocation;

public class ClientConnectionResponse
extends ServerLocationResponse {
    private ServerLocation server;
    private boolean serverFound = false;

    public ClientConnectionResponse() {
    }

    public ClientConnectionResponse(ServerLocation server) {
        this.server = server;
        if (server != null) {
            this.serverFound = true;
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.serverFound = DataSerializer.readPrimitiveBoolean(in);
        if (this.serverFound) {
            this.server = new ServerLocation();
            this.server.fromData(in);
        }
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        boolean serverFound = this.server != null;
        DataSerializer.writePrimitiveBoolean(serverFound, out);
        if (serverFound) {
            this.server.toData(out);
        }
    }

    public ServerLocation getServer() {
        return this.server;
    }

    public String toString() {
        return "ClientConnectionResponse{server=" + this.getServer() + "}";
    }

    @Override
    public int getDSFID() {
        return -50;
    }

    @Override
    public boolean hasResult() {
        return this.serverFound;
    }
}

