/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.cache.client.internal.ConnectionSource;
import org.apache.geode.cache.client.internal.InternalPool;
import org.apache.geode.cache.client.internal.Op;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.ServerQueueStatus;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.security.GemFireSecurityException;
import org.apache.logging.log4j.Logger;

public class ExplicitConnectionSourceImpl
implements ConnectionSource {
    private static final Logger logger = LogService.getLogger();
    private List serverList;
    private int nextServerIndex = 0;
    private int nextQueueIndex = 0;
    private InternalPool pool;
    private boolean DISABLE_SHUFFLING = Boolean.getBoolean("gemfire.bridge.disableShufflingOfEndpoints");

    public ExplicitConnectionSourceImpl(List contacts) {
        ArrayList<ServerLocation> serverList = new ArrayList<ServerLocation>(contacts.size());
        for (int i = 0; i < contacts.size(); ++i) {
            InetSocketAddress addr = (InetSocketAddress)contacts.get(i);
            serverList.add(new ServerLocation(addr.getHostName(), addr.getPort()));
        }
        this.shuffle(serverList);
        this.serverList = Collections.unmodifiableList(serverList);
    }

    @Override
    public synchronized void start(InternalPool pool) {
        this.pool = pool;
        pool.getStats().setInitialContacts(this.serverList.size());
    }

    @Override
    public void stop() {
    }

    @Override
    public ServerLocation findReplacementServer(ServerLocation currentServer, Set excludedServers) {
        HashSet<ServerLocation> excludedPlusCurrent = new HashSet<ServerLocation>(excludedServers);
        excludedPlusCurrent.add(currentServer);
        return this.findServer(excludedPlusCurrent);
    }

    @Override
    public synchronized ServerLocation findServer(Set excludedServers) {
        if (PoolImpl.TEST_DURABLE_IS_NET_DOWN) {
            return null;
        }
        int startIndex = this.nextServerIndex;
        do {
            ServerLocation nextServer = (ServerLocation)this.serverList.get(this.nextServerIndex);
            if (++this.nextServerIndex >= this.serverList.size()) {
                this.nextServerIndex = 0;
            }
            if (excludedServers.contains(nextServer)) continue;
            return nextServer;
        } while (this.nextServerIndex != startIndex);
        return null;
    }

    @Override
    public synchronized List findServersForQueue(Set excludedServers, int numServers, ClientProxyMembershipID proxyId, boolean findDurableQueue) {
        if (PoolImpl.TEST_DURABLE_IS_NET_DOWN) {
            return new ArrayList();
        }
        if (numServers == -1) {
            numServers = Integer.MAX_VALUE;
        }
        if (findDurableQueue && proxyId.isDurable()) {
            return this.findDurableQueues(excludedServers, numServers);
        }
        return this.pickQueueServers(excludedServers, numServers);
    }

    @Override
    public boolean isBalanced() {
        return false;
    }

    private List pickQueueServers(Set excludedServers, int numServers) {
        ArrayList<ServerLocation> result = new ArrayList<ServerLocation>();
        int startIndex = this.nextQueueIndex;
        do {
            ServerLocation nextQueue = (ServerLocation)this.serverList.get(this.nextQueueIndex);
            if (++this.nextQueueIndex >= this.serverList.size()) {
                this.nextQueueIndex = 0;
            }
            if (excludedServers.contains(nextQueue)) continue;
            result.add(nextQueue);
        } while (this.nextQueueIndex != startIndex && result.size() < numServers);
        return result;
    }

    private List findDurableQueues(Set excludedServers, int numServers) {
        ArrayList<ServerLocation> durableServers = new ArrayList<ServerLocation>();
        ArrayList<ServerLocation> otherServers = new ArrayList<ServerLocation>();
        logger.debug("ExplicitConnectionSource - looking for durable queue");
        for (ServerLocation server : this.serverList) {
            Boolean hasQueue;
            if (excludedServers.contains(server)) continue;
            try {
                hasQueue = (Boolean)this.pool.executeOn(server, (Op)HasQueueOp.SINGLETON);
            }
            catch (GemFireSecurityException e) {
                throw e;
            }
            catch (Exception e) {
                if (e.getCause() instanceof GemFireSecurityException) {
                    throw (GemFireSecurityException)e.getCause();
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Unabled to check for durable queue on server {}: {}", (Object)server, (Object)e);
                continue;
            }
            if (hasQueue == null) continue;
            if (hasQueue.booleanValue()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Durable queue found on {}", (Object)server);
                }
                durableServers.add(server);
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Durable queue was not found on {}", (Object)server);
            }
            otherServers.add(server);
        }
        int remainingServers = numServers - durableServers.size();
        if (remainingServers > otherServers.size()) {
            remainingServers = otherServers.size();
        }
        if (remainingServers > 0) {
            durableServers.addAll(otherServers.subList(0, remainingServers));
            this.nextQueueIndex = remainingServers % this.serverList.size();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("found {} servers out of {}", (Object)durableServers.size(), (Object)numServers);
        }
        return durableServers;
    }

    private void shuffle(List endpoints) {
        if (endpoints.size() < 2 || this.DISABLE_SHUFFLING) {
            return;
        }
        Collections.shuffle(endpoints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("EndPoints[");
        ExplicitConnectionSourceImpl explicitConnectionSourceImpl = this;
        synchronized (explicitConnectionSourceImpl) {
            Iterator it = this.serverList.iterator();
            while (it.hasNext()) {
                ServerLocation loc = (ServerLocation)it.next();
                sb.append(loc.getHostName() + ":" + loc.getPort());
                if (!it.hasNext()) continue;
                sb.append(",");
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public ArrayList<ServerLocation> getAllServers() {
        ArrayList<ServerLocation> list = new ArrayList<ServerLocation>();
        list.addAll(this.serverList);
        return list;
    }

    @Override
    public List<InetSocketAddress> getOnlineLocators() {
        return Collections.emptyList();
    }

    private static class HasQueueOp
    implements Op {
        @Immutable
        public static final HasQueueOp SINGLETON = new HasQueueOp();

        private HasQueueOp() {
        }

        @Override
        public Object attempt(Connection cnx) throws Exception {
            ServerQueueStatus status = cnx.getQueueStatus();
            return status.isNonRedundant() ? Boolean.FALSE : Boolean.TRUE;
        }

        @Override
        public boolean useThreadLocalConnection() {
            return false;
        }
    }
}

