/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.util.Set;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.cache.client.internal.AbstractOp;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.cache.client.internal.ExecuteFunctionHelper;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.execute.AbstractExecution;
import org.apache.geode.internal.cache.execute.MemberMappedArgument;
import org.apache.geode.internal.cache.execute.ServerRegionFunctionExecutor;
import org.apache.geode.internal.cache.tier.MessageType;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class ExecuteRegionFunctionNoAckOp {
    private static final Logger logger = LogService.getLogger();

    private ExecuteRegionFunctionNoAckOp() {
    }

    public static void execute(ExecutablePool pool, String region, Function function, ServerRegionFunctionExecutor serverRegionExecutor, byte hasResult) {
        ExecuteRegionFunctionNoAckOpImpl op = new ExecuteRegionFunctionNoAckOpImpl(region, function, serverRegionExecutor, hasResult);
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("ExecuteRegionFunctionNoAckOp#execute : Sending Function Execution Message: {} to Server using pool: {}", (Object)op.getMessage(), (Object)pool);
            }
            pool.execute(op);
        }
        catch (Exception ex) {
            if (logger.isDebugEnabled()) {
                logger.debug("ExecuteRegionFunctionNoAckOp#execute : Exception occurred while Sending Function Execution Message: {} to server using pool: {}", (Object)op.getMessage(), (Object)pool, (Object)ex);
            }
            if (ex.getMessage() != null) {
                throw new FunctionException(ex.getMessage(), ex);
            }
            throw new FunctionException("Unexpected exception during function execution:", ex);
        }
    }

    public static void execute(ExecutablePool pool, String region, String functionId, ServerRegionFunctionExecutor serverRegionExecutor, byte hasResult, boolean isHA, boolean optimizeForWrite) {
        ExecuteRegionFunctionNoAckOpImpl op = new ExecuteRegionFunctionNoAckOpImpl(region, functionId, serverRegionExecutor, hasResult, isHA, optimizeForWrite);
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("ExecuteRegionFunctionNoAckOp#execute : Sending Function Execution Message: {} to Server using pool: {}", (Object)op.getMessage(), (Object)pool);
            }
            pool.execute(op);
        }
        catch (Exception ex) {
            if (logger.isDebugEnabled()) {
                logger.debug("ExecuteRegionFunctionNoAckOp#execute : Exception occurred while Sending Function Execution Message: {} to server using pool: {}", (Object)op.getMessage(), (Object)pool, (Object)ex);
            }
            if (ex.getMessage() != null) {
                throw new FunctionException(ex.getMessage(), ex);
            }
            throw new FunctionException("Unexpected exception during function execution:", ex);
        }
    }

    private static class ExecuteRegionFunctionNoAckOpImpl
    extends AbstractOp {
        private final boolean executeOnBucketSet;

        public ExecuteRegionFunctionNoAckOpImpl(String region, Function function, ServerRegionFunctionExecutor serverRegionExecutor, byte hasResult) {
            super(59, 8 + serverRegionExecutor.getFilter().size());
            byte isReExecute = 0;
            int removedNodesSize = 0;
            byte functionState = AbstractExecution.getFunctionState(function.isHA(), function.hasResult(), function.optimizeForWrite());
            Set routingObjects = serverRegionExecutor.getFilter();
            Object args = serverRegionExecutor.getArguments();
            MemberMappedArgument memberMappedArg = serverRegionExecutor.getMemberMappedArgument();
            this.getMessage().addBytesPart(new byte[]{functionState});
            this.getMessage().addStringPart(region);
            if (serverRegionExecutor.isFnSerializationReqd()) {
                this.getMessage().addStringOrObjPart(function);
            } else {
                this.getMessage().addStringOrObjPart(function.getId());
            }
            this.getMessage().addObjPart(args);
            this.getMessage().addObjPart(memberMappedArg);
            this.executeOnBucketSet = serverRegionExecutor.getExecuteOnBucketSetFlag();
            byte flags = ExecuteFunctionHelper.createFlags(this.executeOnBucketSet, isReExecute);
            this.getMessage().addBytesPart(new byte[]{flags});
            this.getMessage().addIntPart(routingObjects.size());
            for (Object key : routingObjects) {
                this.getMessage().addStringOrObjPart(key);
            }
            this.getMessage().addIntPart(removedNodesSize);
        }

        public ExecuteRegionFunctionNoAckOpImpl(String region, String functionId, ServerRegionFunctionExecutor serverRegionExecutor, byte hasResult, boolean isHA, boolean optimizeForWrite) {
            super(59, 8 + serverRegionExecutor.getFilter().size());
            byte isReExecute = 0;
            int removedNodesSize = 0;
            byte functionState = AbstractExecution.getFunctionState(isHA, hasResult == 1, optimizeForWrite);
            Set routingObjects = serverRegionExecutor.getFilter();
            Object args = serverRegionExecutor.getArguments();
            MemberMappedArgument memberMappedArg = serverRegionExecutor.getMemberMappedArgument();
            this.getMessage().addBytesPart(new byte[]{functionState});
            this.getMessage().addStringPart(region);
            this.getMessage().addStringOrObjPart(functionId);
            this.getMessage().addObjPart(args);
            this.getMessage().addObjPart(memberMappedArg);
            this.executeOnBucketSet = serverRegionExecutor.getExecuteOnBucketSetFlag();
            byte flags = ExecuteFunctionHelper.createFlags(this.executeOnBucketSet, isReExecute);
            this.getMessage().addBytesPart(new byte[]{flags});
            this.getMessage().addIntPart(routingObjects.size());
            for (Object key : routingObjects) {
                this.getMessage().addStringOrObjPart(key);
            }
            this.getMessage().addIntPart(removedNodesSize);
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            int msgType = msg.getMessageType();
            if (msgType == 6) {
                return null;
            }
            Part part = msg.getPart(0);
            if (msgType == 2) {
                Throwable t = (Throwable)part.getObject();
                logger.warn("Function execution without result encountered an Exception on server.", t);
            } else if (this.isErrorResponse(msgType)) {
                logger.warn("Function execution without result encountered an Exception on server.");
            } else {
                throw new InternalGemFireError("Unexpected message type " + MessageType.getString(msgType));
            }
            return null;
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return msgType == 61;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startExecuteFunction();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endExecuteFunctionSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endExecuteFunction(start, this.hasTimedOut(), this.hasFailed());
        }

        @Override
        protected Message createResponseMessage() {
            return new Message(1, Version.CURRENT);
        }
    }
}

