/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache;

import java.util.Properties;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheExistsException;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.GatewayException;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.internal.GemFireVersion;
import org.apache.geode.internal.cache.CacheFactoryStatics;
import org.apache.geode.internal.cache.InternalCacheBuilder;
import org.apache.geode.pdx.PdxSerializer;
import org.apache.geode.security.PostProcessor;
import org.apache.geode.security.SecurityManager;

public class CacheFactory {
    private final InternalCacheBuilder internalCacheBuilder;

    public CacheFactory() {
        this(null);
    }

    public CacheFactory(Properties props) {
        this.internalCacheBuilder = new InternalCacheBuilder(props);
    }

    public Cache create() throws TimeoutException, CacheWriterException, GatewayException, RegionExistsException {
        return this.internalCacheBuilder.create();
    }

    public CacheFactory set(String name, String value) {
        this.internalCacheBuilder.set(name, value);
        return this;
    }

    public CacheFactory setPdxReadSerialized(boolean readSerialized) {
        this.internalCacheBuilder.setPdxReadSerialized(readSerialized);
        return this;
    }

    public CacheFactory setSecurityManager(SecurityManager securityManager) {
        this.internalCacheBuilder.setSecurityManager(securityManager);
        return this;
    }

    public CacheFactory setPostProcessor(PostProcessor postProcessor) {
        this.internalCacheBuilder.setPostProcessor(postProcessor);
        return this;
    }

    public CacheFactory setPdxSerializer(PdxSerializer serializer) {
        this.internalCacheBuilder.setPdxSerializer(serializer);
        return this;
    }

    public CacheFactory setPdxDiskStore(String diskStoreName) {
        this.internalCacheBuilder.setPdxDiskStore(diskStoreName);
        return this;
    }

    public CacheFactory setPdxPersistent(boolean isPersistent) {
        this.internalCacheBuilder.setPdxPersistent(isPersistent);
        return this;
    }

    public CacheFactory setPdxIgnoreUnreadFields(boolean ignore) {
        this.internalCacheBuilder.setPdxIgnoreUnreadFields(ignore);
        return this;
    }

    @Deprecated
    public static Cache create(DistributedSystem system) throws CacheExistsException, TimeoutException, CacheWriterException, GatewayException, RegionExistsException {
        return CacheFactoryStatics.create(system);
    }

    public static Cache getInstance(DistributedSystem system) {
        return CacheFactoryStatics.getInstance(system);
    }

    public static Cache getInstanceCloseOk(DistributedSystem system) {
        return CacheFactoryStatics.getInstanceCloseOk(system);
    }

    public static Cache getAnyInstance() {
        return CacheFactoryStatics.getAnyInstance();
    }

    public static String getVersion() {
        return GemFireVersion.getGemFireVersion();
    }
}

