/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.jmx.internal;

import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.timer.Timer;
import javax.management.timer.TimerMBean;
import org.apache.commons.modeler.ManagedBean;
import org.apache.commons.modeler.Registry;
import org.apache.geode.SystemFailure;
import org.apache.geode.admin.RuntimeAdminException;
import org.apache.geode.admin.jmx.internal.DynamicManagedBean;
import org.apache.geode.admin.jmx.internal.ManagedResource;
import org.apache.geode.admin.jmx.internal.RefreshNotificationType;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class MBeanUtil {
    private static final Logger logger = LogService.getLogger();
    private static final String DEFAULT_DOMAIN = "GemFire";
    private static final String REFRESH_TIMER_NAME = "GemFire:type=RefreshTimer";
    @MakeNotStatic
    private static boolean isStarted;
    @MakeNotStatic
    private static Registry registry;
    @MakeNotStatic
    private static MBeanServer mbeanServer;
    @MakeNotStatic
    private static ObjectName refreshTimerObjectName;
    @MakeNotStatic
    private static TimerMBean refreshTimer;
    @MakeNotStatic
    private static final Map<NotificationListener, Map<RefreshNotificationType, Integer>> refreshClients;
    @MakeNotStatic
    private static final Map<ObjectName, ManagedResource> managedResources;

    static MBeanServer start() {
        if (!isStarted) {
            mbeanServer = MBeanUtil.createMBeanServer();
            registry = MBeanUtil.createRegistry();
            MBeanUtil.registerServerNotificationListener();
            MBeanUtil.createRefreshTimer();
            isStarted = true;
        }
        return mbeanServer;
    }

    static void stop() {
        if (isStarted) {
            MBeanUtil.stopRefreshTimer();
            registry.stop();
            registry = null;
            MBeanUtil.releaseMBeanServer();
            isStarted = false;
        }
    }

    static synchronized MBeanServer createMBeanServer() {
        if (mbeanServer == null) {
            mbeanServer = MBeanServerFactory.createMBeanServer(DEFAULT_DOMAIN);
        }
        return mbeanServer;
    }

    static synchronized Registry createRegistry() {
        if (registry == null) {
            try {
                registry = Registry.getRegistry(null, null);
                if (mbeanServer == null) {
                    throw new IllegalStateException("MBean Server is not initialized yet.");
                }
                registry.setMBeanServer(mbeanServer);
                String mbeansResource = MBeanUtil.getOSPath("/org/apache/geode/admin/jmx/mbeans-descriptors.xml");
                URL url = ClassPathLoader.getLatest().getResource(MBeanUtil.class, mbeansResource);
                MBeanUtil.raiseOnFailure(url != null, String.format("Failed to find %s", mbeansResource));
                registry.loadMetadata((Object)url);
                String[] test = registry.findManagedBeans();
                MBeanUtil.raiseOnFailure(test != null && test.length > 0, String.format("Failed to load metadata from %s", mbeansResource));
            }
            catch (Exception e) {
                MBeanUtil.logStackTrace(Level.WARN, e);
                throw new RuntimeAdminException("Failed to get MBean Registry", e);
            }
        }
        return registry;
    }

    static ObjectName createMBean(ManagedResource resource) {
        return MBeanUtil.createMBean(resource, MBeanUtil.lookupManagedBean(resource));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ObjectName createMBean(ManagedResource resource, ManagedBean managed) {
        try {
            ObjectName objName;
            DynamicManagedBean mb = new DynamicManagedBean(managed);
            resource.setModelMBean(mb.createMBean(resource));
            try {
                objName = ObjectName.getInstance(resource.getMBeanName());
            }
            catch (MalformedObjectNameException e) {
                throw new MalformedObjectNameException(String.format("%s in '%s'", e.getMessage(), resource.getMBeanName()));
            }
            Class<MBeanUtil> clazz = MBeanUtil.class;
            synchronized (MBeanUtil.class) {
                if (mbeanServer != null && !mbeanServer.isRegistered(objName)) {
                    mbeanServer.registerMBean(resource.getModelMBean(), objName);
                    Map<ObjectName, ManagedResource> map = managedResources;
                    synchronized (map) {
                        managedResources.put(objName, resource);
                    }
                }
                // ** MonitorExit[var4_6] (shouldn't be in output)
                return objName;
            }
        }
        catch (Exception e) {
            throw new RuntimeAdminException(String.format("Failed to create MBean representation for resource %s.", resource.getMBeanName()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ObjectName ensureMBeanIsRegistered(ManagedResource resource) {
        try {
            ObjectName objName = ObjectName.getInstance(resource.getMBeanName());
            Class<MBeanUtil> clazz = MBeanUtil.class;
            synchronized (MBeanUtil.class) {
                if (mbeanServer != null && !mbeanServer.isRegistered(objName)) {
                    // ** MonitorExit[var2_3] (shouldn't be in output)
                    return MBeanUtil.createMBean(resource);
                }
                // ** MonitorExit[var2_3] (shouldn't be in output)
                MBeanUtil.raiseOnFailure(mbeanServer.isRegistered(objName), String.format("Could not find a MBean registered with ObjectName: %s.", objName.toString()));
                return objName;
            }
        }
        catch (Exception e) {
            throw new RuntimeAdminException(e);
        }
    }

    static ManagedBean lookupManagedBean(ManagedResource resource) {
        ManagedBean managed = null;
        if (registry == null) {
            throw new IllegalArgumentException("ManagedBean is null");
        }
        managed = registry.findManagedBean(resource.getManagedResourceType().getClassTypeName());
        if (managed == null) {
            throw new IllegalArgumentException("ManagedBean is null");
        }
        managed.setClassName("org.apache.geode.admin.jmx.internal.MX4JModelMBean");
        return managed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void registerRefreshNotification(NotificationListener client, Object userData, RefreshNotificationType type, long refreshInterval) {
        if (client == null) {
            throw new IllegalArgumentException("NotificationListener is required");
        }
        if (type == null) {
            throw new IllegalArgumentException("RefreshNotificationType is required");
        }
        if (refreshTimerObjectName == null || refreshTimer == null) {
            throw new IllegalStateException("RefreshTimer has not been properly initialized.");
        }
        try {
            Integer timerNotificationId;
            Map<RefreshNotificationType, Integer> notifications = null;
            Map<NotificationListener, Map<RefreshNotificationType, Integer>> map = refreshClients;
            synchronized (map) {
                notifications = refreshClients.get(client);
            }
            if (notifications == null) {
                if (refreshInterval <= 0L) {
                    return;
                }
                notifications = new HashMap<RefreshNotificationType, Integer>();
                map = refreshClients;
                synchronized (map) {
                    refreshClients.put(client, notifications);
                }
                MBeanUtil.validateRefreshTimer();
                try {
                    mbeanServer.addNotificationListener(refreshTimerObjectName, client, null, new Object());
                }
                catch (InstanceNotFoundException e) {
                    MBeanUtil.logStackTrace(Level.WARN, e, "Could not find registered RefreshTimer instance.");
                }
            }
            if ((timerNotificationId = notifications.get(type)) != null) {
                try {
                    refreshTimer.removeNotification(timerNotificationId);
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                }
                finally {
                    notifications.put(type, null);
                }
            }
            if (refreshInterval > 0L) {
                timerNotificationId = refreshTimer.addNotification(type.getType(), type.getMessage(), userData, new Date(System.currentTimeMillis() + refreshInterval * 1000L), refreshInterval * 1000L);
                notifications.put(type, timerNotificationId);
            }
        }
        catch (RuntimeException e) {
            MBeanUtil.logStackTrace(Level.WARN, e);
            throw e;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Error e) {
            SystemFailure.checkFailure();
            MBeanUtil.logStackTrace(Level.ERROR, e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isRefreshNotificationRegistered(NotificationListener client, RefreshNotificationType type) {
        Integer timerNotificationId;
        boolean isRegistered = false;
        Map<RefreshNotificationType, Integer> notifications = null;
        Map<NotificationListener, Map<RefreshNotificationType, Integer>> map = refreshClients;
        synchronized (map) {
            notifications = refreshClients.get(client);
        }
        if (notifications != null && (timerNotificationId = notifications.get(type)) != null) {
            isRegistered = true;
        }
        return isRegistered;
    }

    static void validateRefreshTimer() {
        if (refreshTimerObjectName == null || refreshTimer == null) {
            MBeanUtil.createRefreshTimer();
        }
        MBeanUtil.raiseOnFailure(refreshTimer != null, "Failed to validate Refresh Timer");
        if (mbeanServer != null && !mbeanServer.isRegistered(refreshTimerObjectName)) {
            try {
                mbeanServer.registerMBean(refreshTimer, refreshTimerObjectName);
            }
            catch (JMException e) {
                MBeanUtil.logStackTrace(Level.WARN, e);
            }
            catch (JMRuntimeException e) {
                MBeanUtil.logStackTrace(Level.WARN, e);
            }
        }
    }

    static void createRefreshTimer() {
        try {
            refreshTimer = new Timer();
            mbeanServer.registerMBean(refreshTimer, refreshTimerObjectName);
            refreshTimer.start();
        }
        catch (JMException e) {
            MBeanUtil.logStackTrace(Level.WARN, e, "Failed to create/register/start refresh timer.");
        }
        catch (JMRuntimeException e) {
            MBeanUtil.logStackTrace(Level.WARN, e, "Failed to create/register/start refresh timer.");
        }
        catch (Exception e) {
            MBeanUtil.logStackTrace(Level.WARN, e, "Failed to create/register/start refresh timer.");
        }
    }

    static void stopRefreshTimer() {
        try {
            if (refreshTimer != null && mbeanServer != null) {
                mbeanServer.unregisterMBean(refreshTimerObjectName);
                refreshTimer.stop();
            }
        }
        catch (JMException e) {
            MBeanUtil.logStackTrace(Level.WARN, e);
        }
        catch (JMRuntimeException e) {
            MBeanUtil.logStackTrace(Level.WARN, e);
        }
        catch (Exception e) {
            MBeanUtil.logStackTrace(Level.DEBUG, e, "Failed to stop refresh timer for MBeanUtil");
        }
    }

    public static String makeCompliantMBeanNameProperty(String value) {
        value = value.replace(':', '-');
        value = value.replace(',', '-');
        value = value.replace('=', '-');
        value = value.replace('*', '-');
        if ((value = value.replace('?', '-')).length() < 1) {
            value = "nothing";
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void releaseMBeanServer() {
        try {
            for (ObjectName name : mbeanServer.queryNames(null, null)) {
                if (!name.getDomain().startsWith(DEFAULT_DOMAIN)) continue;
                MBeanUtil.unregisterMBean(name);
            }
            MBeanServerFactory.releaseMBeanServer(mbeanServer);
            mbeanServer = null;
        }
        catch (JMRuntimeException e) {
            MBeanUtil.logStackTrace(Level.WARN, e);
        }
        Map<Object, Object> map = managedResources;
        synchronized (map) {
            managedResources.clear();
        }
        map = refreshClients;
        synchronized (map) {
            refreshClients.clear();
        }
        map = managedResources;
        synchronized (map) {
            managedResources.clear();
        }
        map = refreshClients;
        synchronized (map) {
            refreshClients.clear();
        }
    }

    static boolean isRegistered(ObjectName objectName) {
        return mbeanServer != null && mbeanServer.isRegistered(objectName);
    }

    static void unregisterMBean(ObjectName objectName) {
        try {
            if (mbeanServer != null && mbeanServer.isRegistered(objectName)) {
                mbeanServer.unregisterMBean(objectName);
            }
        }
        catch (MBeanRegistrationException e) {
            MBeanUtil.logStackTrace(Level.WARN, null, String.format("Failed while unregistering MBean with ObjectName : %s", objectName));
        }
        catch (InstanceNotFoundException e) {
            MBeanUtil.logStackTrace(Level.WARN, null, String.format("While unregistering, could not find MBean with ObjectName : %s", objectName));
        }
        catch (JMRuntimeException e) {
            MBeanUtil.logStackTrace(Level.WARN, null, String.format("Could not un-register MBean with ObjectName : %s", objectName));
        }
    }

    static void unregisterMBean(ManagedResource resource) {
        if (resource != null) {
            MBeanUtil.unregisterMBean(resource.getObjectName());
            MBeanUtil.cleanupResource(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanupResource(ManagedResource resource) {
        Map<ObjectName, ManagedResource> map = managedResources;
        synchronized (map) {
            managedResources.remove(resource.getObjectName());
        }
        resource.cleanupResource();
        Map<RefreshNotificationType, Integer> notifications = null;
        Map<NotificationListener, Map<RefreshNotificationType, Integer>> map2 = refreshClients;
        synchronized (map2) {
            notifications = refreshClients.remove(resource);
        }
        if (notifications != null) {
            Set<Map.Entry<RefreshNotificationType, Integer>> entries = notifications.entrySet();
            for (Map.Entry<RefreshNotificationType, Integer> e : entries) {
                Integer timerNotificationId = e.getValue();
                if (null == timerNotificationId) continue;
                try {
                    refreshTimer.removeNotification(timerNotificationId);
                }
                catch (InstanceNotFoundException xptn) {
                    MBeanUtil.logStackTrace(Level.DEBUG, xptn);
                }
            }
            try {
                if (mbeanServer != null && mbeanServer.isRegistered(refreshTimerObjectName)) {
                    mbeanServer.removeNotificationListener(refreshTimerObjectName, (NotificationListener)((Object)resource));
                }
            }
            catch (ListenerNotFoundException xptn) {
                MBeanUtil.logStackTrace(Level.WARN, null, xptn.getMessage());
            }
            catch (InstanceNotFoundException xptn) {
                MBeanUtil.logStackTrace(Level.WARN, null, String.format("While unregistering, could not find MBean with ObjectName : %s", refreshTimerObjectName));
            }
        }
    }

    static String getOSPath(String path) {
        if (MBeanUtil.pathIsWindows(path)) {
            return path.replace('/', '\\');
        }
        return path.replace('\\', '/');
    }

    static boolean pathIsWindows(String path) {
        if (path != null && path.length() > 1) {
            return Character.isLetter(path.charAt(0)) && path.charAt(1) == ':' || path.startsWith("//") || path.startsWith("\\\\");
        }
        return false;
    }

    static void registerServerNotificationListener() {
        if (mbeanServer == null) {
            return;
        }
        try {
            ObjectName delegate = ObjectName.getInstance("JMImplementation:type=MBeanServerDelegate");
            mbeanServer.addNotificationListener(delegate, new NotificationListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void handleNotification(Notification notification, Object handback) {
                    MBeanServerNotification serverNotification = (MBeanServerNotification)notification;
                    if ("JMX.mbean.unregistered".equals(serverNotification.getType())) {
                        ObjectName objectName = serverNotification.getMBeanName();
                        Map map = managedResources;
                        synchronized (map) {
                            Object entry = managedResources.get(objectName);
                            if (entry == null) {
                                return;
                            }
                            if (!(entry instanceof ManagedResource)) {
                                throw new ClassCastException(String.format("%s is not a ManagedResource", entry.getClass().getName()));
                            }
                            ManagedResource resource = (ManagedResource)entry;
                            MBeanUtil.cleanupResource(resource);
                        }
                    }
                }
            }, null, null);
        }
        catch (JMException e) {
            MBeanUtil.logStackTrace(Level.WARN, e, "Failed to register ServerNotificationListener.");
        }
        catch (JMRuntimeException e) {
            MBeanUtil.logStackTrace(Level.WARN, e, "Failed to register ServerNotificationListener.");
        }
    }

    public static void logStackTrace(Level level, Throwable throwable) {
        MBeanUtil.logStackTrace(level, throwable, null);
    }

    public static void logStackTrace(Level level, Throwable throwable, String message) {
        logger.log(level, message, throwable);
    }

    private static void raiseOnFailure(boolean condition, String message) {
        if (!condition) {
            throw new RuntimeAdminException(message);
        }
    }

    static {
        refreshClients = new HashMap<NotificationListener, Map<RefreshNotificationType, Integer>>();
        managedResources = new HashMap<ObjectName, ManagedResource>();
        try {
            refreshTimerObjectName = ObjectName.getInstance(REFRESH_TIMER_NAME);
        }
        catch (Exception e) {
            MBeanUtil.logStackTrace(Level.ERROR, e);
        }
    }
}

