/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.jmx.internal;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBean;
import org.apache.geode.SystemFailure;
import org.apache.geode.admin.AdminException;
import org.apache.geode.admin.DistributedSystemHealthConfig;
import org.apache.geode.admin.GemFireHealthConfig;
import org.apache.geode.admin.RuntimeAdminException;
import org.apache.geode.admin.internal.GemFireHealthImpl;
import org.apache.geode.admin.jmx.internal.AdminDistributedSystemJmxImpl;
import org.apache.geode.admin.jmx.internal.DistributedSystemHealthConfigJmxImpl;
import org.apache.geode.admin.jmx.internal.GemFireHealthConfigJmxImpl;
import org.apache.geode.admin.jmx.internal.MBeanUtil;
import org.apache.geode.admin.jmx.internal.ManagedResource;
import org.apache.geode.admin.jmx.internal.ManagedResourceType;
import org.apache.geode.internal.admin.GfManagerAgent;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class GemFireHealthJmxImpl
extends GemFireHealthImpl
implements ManagedResource {
    private static final Logger logger = LogService.getLogger();
    private String mbeanName;
    private ModelMBean modelMBean;
    private final ObjectName objectName;

    GemFireHealthJmxImpl(GfManagerAgent agent, AdminDistributedSystemJmxImpl system) throws AdminException {
        super(agent, system);
        this.mbeanName = new StringBuffer().append("GemFire:type=").append("GemFireHealth,id=").append(MBeanUtil.makeCompliantMBeanNameProperty(system.getId())).toString();
        this.objectName = MBeanUtil.createMBean(this);
    }

    public String getHealthStatus() {
        return this.getHealth().toString();
    }

    public ObjectName manageGemFireHealthConfig(String hostName) throws MalformedObjectNameException {
        try {
            GemFireHealthConfig config = this.getGemFireHealthConfig(hostName);
            GemFireHealthConfigJmxImpl jmx = (GemFireHealthConfigJmxImpl)config;
            return new ObjectName(jmx.getMBeanName());
        }
        catch (RuntimeException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Error e) {
            SystemFailure.checkFailure();
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    protected DistributedSystemHealthConfig createDistributedSystemHealthConfig() {
        try {
            return new DistributedSystemHealthConfigJmxImpl(this);
        }
        catch (AdminException ex) {
            throw new RuntimeAdminException("While getting the DistributedSystemHealthConfig", ex);
        }
    }

    @Override
    protected GemFireHealthConfig createGemFireHealthConfig(String hostName) {
        try {
            return new GemFireHealthConfigJmxImpl(this, hostName);
        }
        catch (AdminException ex) {
            throw new RuntimeAdminException("While getting the GemFireHealthConfig", ex);
        }
    }

    protected void ensureMBeansAreRegistered() {
        MBeanUtil.ensureMBeanIsRegistered(this);
        MBeanUtil.ensureMBeanIsRegistered((ManagedResource)((Object)this.defaultConfig));
        MBeanUtil.ensureMBeanIsRegistered((ManagedResource)((Object)this.dsHealthConfig));
    }

    @Override
    public String getMBeanName() {
        return this.mbeanName;
    }

    @Override
    public ModelMBean getModelMBean() {
        return this.modelMBean;
    }

    @Override
    public void setModelMBean(ModelMBean modelMBean) {
        this.modelMBean = modelMBean;
    }

    @Override
    public ManagedResourceType getManagedResourceType() {
        return ManagedResourceType.GEMFIRE_HEALTH;
    }

    @Override
    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Override
    public void cleanupResource() {
        this.close();
    }
}

