/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.geode.internal.admin.ApplicationVM;
import org.apache.geode.internal.admin.GemFireVM;
import org.apache.geode.internal.admin.GfManagerAgent;
import org.apache.geode.internal.logging.MergeLogFiles;

public class LogCollator {
    private GfManagerAgent system;
    private List logTails;

    public String collateLogs(GfManagerAgent system) {
        try {
            if (system == null) {
                String string = "";
                return string;
            }
            this.system = system;
            this.logTails = new ArrayList();
            this.gatherActiveLogs();
            this.gatherInactiveLogs();
            String string = this.mergeLogs();
            return string;
        }
        finally {
            this.system = null;
            this.logTails = null;
        }
    }

    private String mergeLogs() {
        HashMap<String, InputStream> logFiles = new HashMap<String, InputStream>();
        for (int i = 0; i < this.logTails.size(); ++i) {
            Loglet loglet = (Loglet)this.logTails.get(i);
            logFiles.put(loglet.name, new ByteArrayInputStream(loglet.tail.getBytes()));
        }
        StringWriter writer = new StringWriter();
        PrintWriter mergedLog = new PrintWriter(writer);
        if (!MergeLogFiles.mergeLogFiles(logFiles, mergedLog)) {
            return writer.toString();
        }
        return "";
    }

    private void gatherActiveLogs() {
        ApplicationVM[] runningsApps = this.system.listApplications();
        for (int i = 0; i < runningsApps.length; ++i) {
            this.addLogFrom(runningsApps[i]);
        }
    }

    private void gatherInactiveLogs() {
    }

    private void addLogFrom(GemFireVM vm) {
        String name = null;
        name = vm.toString();
        String[] logs = vm.getSystemLogs();
        this.addTail(name, logs);
    }

    private void addTail(String logName, String[] logs) {
        if (logs.length > 0) {
            String tail = logs.length > 1 ? logs[1] : logs[0];
            this.logTails.add(new Loglet(logName, tail));
        }
    }

    private static class Loglet {
        String name;
        String tail;

        Loglet(String name, String tail) {
            this.name = name;
            this.tail = tail;
        }
    }
}

